/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader;

import com.sun.javafx.runtime.FXObject;

public final class ElementCache {
    private FXObject[] m_elements;

    public ElementCache(int n) {
        this.m_elements = new FXObject[n];
    }

    public synchronized void put(int n, FXObject fXObject) {
        if (fXObject == null) {
            throw new IllegalArgumentException("Null element is not allowed.");
        }
        if (n >= this.m_elements.length) {
            int n2 = this.m_elements.length * 2 + 8;
            if (n >= n2) {
                n2 = n + 8;
            }
            FXObject[] fXObjectArray = new FXObject[n2];
            System.arraycopy(this.m_elements, 0, fXObjectArray, 0, this.m_elements.length);
            this.m_elements = fXObjectArray;
        }
        if (this.m_elements[n] != null) {
            throw new IllegalArgumentException("Element at index " + n + " is already set.");
        }
        this.m_elements[n] = fXObject;
    }

    public synchronized FXObject get(int n) {
        if (n < this.m_elements.length) {
            return this.m_elements[n];
        }
        return null;
    }
}

