/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmcimpl.FileCacheImageInputStreamEx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import sun.net.www.protocol.file.FileURLConnection;

public class MediaNetworkProvider {
    public URL url;
    public URLConnection connection;
    static String FilePrefix1 = "file:/";
    static String FilePrefix2 = "file://";
    static String FilePrefix3 = "file:///";
    static String FilePrefix4 = "file:////";
    ImageInputStreamImpl data;

    public static void activate() {
        MediaNetworkProvider.onload(ImageInputStreamImpl.class);
    }

    protected static native void onload(Object var0);

    protected void init(URL uRL, String string) throws IOException {
        this.url = uRL;
        this.connection = this.url.openConnection();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setRequestMethod(string);
        }
    }

    public MediaNetworkProvider(URL uRL, String string) throws IOException {
        this.init(uRL, string);
    }

    public MediaNetworkProvider(String string, String string2) throws MalformedURLException, IOException {
        String string3;
        String string4 = URLDecoder.decode(string, "UTF-8");
        if (!string4.startsWith(FilePrefix4) && string4.startsWith(FilePrefix3)) {
            string4 = string4.substring(8).replace("|", ":");
        }
        if ((string3 = string4.substring(1)).startsWith(":/") || string3.startsWith(":\\")) {
            string4 = FilePrefix1 + string4;
        }
        this.init(new URL(string4), string2);
    }

    public boolean isFileMoniker() {
        return "file".equals(this.url.getProtocol());
    }

    public boolean isHttpMoniker() {
        return "http".equals(this.url.getProtocol()) || "ftp".equals(this.url.getProtocol()) || "jar".equals(this.url.getProtocol());
    }

    public boolean isSessionRequired() {
        return this.isHttpMoniker();
    }

    public String getRequestHeaders() {
        String string = "";
        if (null != this.connection) {
            Map<String, List<String>> map = this.connection.getRequestProperties();
            for (String string2 : map.keySet()) {
                string = string + string2 + ": " + map.get(string2) + "\r\n";
            }
        }
        return string;
    }

    public void addRequestHeaders(String string) {
        if (null != string && this.connection instanceof HttpURLConnection) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\r\n")) {
                String[] stringArray2 = string2.split(": ");
                if (stringArray2[0].startsWith("Range")) {
                    this.connection.setUseCaches(false);
                }
                ((HttpURLConnection)this.connection).setRequestProperty(stringArray2[0], stringArray2[1]);
            }
        }
    }

    public void connect() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).connect();
        }
    }

    public String getHostName() {
        return this.url.getHost();
    }

    public void disconnect() {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
    }

    public int getResponseCode() throws IOException {
        return this.connection instanceof HttpURLConnection ? ((HttpURLConnection)this.connection).getResponseCode() : 200;
    }

    public String getResponse() {
        String string = "";
        if (this.connection instanceof HttpURLConnection) {
            String string2;
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
            string = httpURLConnection.getHeaderField(0);
            int n = 1;
            while (null != (string2 = httpURLConnection.getHeaderFieldKey(n))) {
                string = string + "\r\n" + string2 + ": " + httpURLConnection.getHeaderField(n);
                ++n;
            }
        }
        return string;
    }

    public String getRedirectedURL() {
        return null == this.connection ? this.url.toString() : this.connection.getURL().toExternalForm();
    }

    public String getContentType() {
        return null == this.connection ? "" : this.connection.getContentType();
    }

    public boolean isURLCached() {
        return this.connection instanceof HttpURLConnection ? ((FileCacheImageInputStreamEx)this.data).isURLCached() : this.connection instanceof FileURLConnection;
    }

    public String getCacheFileURL() throws IllegalAccessException, URISyntaxException {
        return this.connection instanceof HttpURLConnection ? ((FileCacheImageInputStreamEx)this.data).getCacheFile().getPath() : (this.connection instanceof FileURLConnection ? new File(this.url.toURI()).getAbsolutePath() : "");
    }

    public long getContentSize() {
        String string;
        if (null != this.connection && null != (string = this.connection.getHeaderField("Content-Length"))) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    public ImageInputStreamImpl getContentStream() throws FileNotFoundException, IOException, URISyntaxException {
        if (this.isSessionRequired()) {
            IOException iOException = AccessController.doPrivileged(new PrivilegedAction<IOException>(){

                @Override
                public IOException run() {
                    try {
                        MediaNetworkProvider.this.data = new FileCacheImageInputStreamEx(MediaNetworkProvider.this.connection);
                        return null;
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                }
            });
            if (iOException != null) {
                throw iOException;
            }
        } else {
            this.data = new FileImageInputStream(new File(this.url.toURI()));
        }
        return this.data;
    }

    public Object seekClone(long l) throws IOException {
        String string = null;
        if (this.connection instanceof HttpURLConnection) {
            string = ((HttpURLConnection)this.connection).getRequestMethod();
        } else if (this.connection instanceof JarURLConnection) {
            string = "GET";
        } else {
            throw new IllegalStateException("connectino is neither HttpURLConnection nor JarURLConnection");
        }
        MediaNetworkProvider mediaNetworkProvider = new MediaNetworkProvider(this.url, string);
        String string2 = this.getRequestHeaders();
        if (string2.length() != 0) {
            string2 = string2 + "\r\n";
        }
        mediaNetworkProvider.addRequestHeaders(string2 + "Range: bytes=" + l + "-");
        return mediaNetworkProvider;
    }
}

