/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.spi.MediaPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import com.sun.media.jmcimpl.spi.ProviderRegistry;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerManager {
    private static ProviderRegistry<PlayerPeerProvider> peerProviders = new ProviderRegistry<PlayerPeerProvider>(PlayerPeerProvider.class);
    private static ProviderRegistry<MediaPeerProvider> mediaProviders = new ProviderRegistry<MediaPeerProvider>(MediaPeerProvider.class);

    private PeerManager() {
    }

    private static void throwMediaException(URI uRI, MediaException mediaException) throws MediaException {
        if (mediaException != null) {
            throw mediaException;
        }
        final URI uRI2 = uRI;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    uRI2.toURL().openStream();
                }
                catch (IOException iOException) {
                    throw new MediaUnavailableException("Media unavailable: " + uRI2, iOException);
                }
                throw new MediaUnsupportedException("Unsupported media: " + uRI2);
            }
        });
    }

    public static PlayerPeer getPlayerPeer(URI uRI) throws MediaException {
        return PeerManager.getPlayerPeer(uRI, false, null);
    }

    public static PlayerPeer getPlayerPeer(URI uRI, boolean bl, VideoDataBuffer.Format[] formatArray) throws MediaException {
        PlayerPeerProvider[] playerPeerProviderArray = peerProviders.getProviderArray();
        PlayerPeerProvider.PlaybackMode[] playbackModeArray = new PlayerPeerProvider.PlaybackMode[playerPeerProviderArray.length];
        MediaException mediaException = null;
        for (int i = 0; i < playerPeerProviderArray.length; ++i) {
            playbackModeArray[i] = playerPeerProviderArray[i].canPlay(uRI, formatArray);
            if (playbackModeArray[i] != PlayerPeerProvider.PlaybackMode.Lightweight) continue;
            try {
                PlayerPeer playerPeer = playerPeerProviderArray[i].createPlayerPeer(uRI, formatArray);
                return playerPeer;
            }
            catch (MediaException mediaException2) {
                if (mediaException != null) continue;
                mediaException = mediaException2;
            }
        }
        PlayerPeerProvider.PlaybackMode playbackMode = PlayerPeerProvider.PlaybackMode.Unknown;
        while (true) {
            for (int i = 0; i < playerPeerProviderArray.length; ++i) {
                if (playbackModeArray[i] != playbackMode) continue;
                try {
                    PlayerPeer playerPeer = playerPeerProviderArray[i].createPlayerPeer(uRI, formatArray);
                    if (!bl || playerPeer.getCapabilities().contains((Object)PlayerPeer.Capabilities.isLightweight)) {
                        return playerPeer;
                    }
                    playerPeer.dispose();
                    continue;
                }
                catch (MediaException mediaException3) {
                    if (mediaException != null) continue;
                    mediaException = mediaException3;
                }
            }
            if (playbackMode != PlayerPeerProvider.PlaybackMode.Unknown || bl) break;
            playbackMode = PlayerPeerProvider.PlaybackMode.Heavyweight;
        }
        PeerManager.throwMediaException(uRI, mediaException);
        return null;
    }

    public static List<ContainerType> getSupportedContainerTypes() {
        LinkedList<ContainerType> linkedList = new LinkedList<ContainerType>();
        Iterator<PlayerPeerProvider> iterator = peerProviders.getProviders();
        while (iterator.hasNext()) {
            PlayerPeerProvider playerPeerProvider = iterator.next();
            ContainerType[] containerTypeArray = playerPeerProvider.getContainerTypes();
            if (containerTypeArray == null) continue;
            for (int i = 0; i < containerTypeArray.length; ++i) {
                if (linkedList.indexOf(containerTypeArray[i]) != -1) continue;
                linkedList.add(containerTypeArray[i]);
            }
        }
        return linkedList;
    }

    public static boolean isPeerClassForURI(URI uRI, Class<? extends PlayerPeer> clazz, VideoDataBuffer.Format[] formatArray) {
        PlayerPeerProvider[] playerPeerProviderArray = peerProviders.getProviderArray();
        for (int i = 0; i < playerPeerProviderArray.length; ++i) {
            if (playerPeerProviderArray[i].getPlayerPeerClass() != clazz) continue;
            return playerPeerProviderArray[i].canPlay(uRI, formatArray) != PlayerPeerProvider.PlaybackMode.None;
        }
        System.err.println("Orphan Peer:" + clazz);
        return false;
    }

    public static MediaPeer getMediaPeer(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        Iterator<MediaPeerProvider> iterator = mediaProviders.getProviders();
        MediaException mediaException = null;
        while (iterator.hasNext()) {
            MediaPeerProvider mediaPeerProvider = iterator.next();
            if (!mediaPeerProvider.canDecode(uRI, formatArray)) continue;
            try {
                MediaPeer mediaPeer = mediaPeerProvider.createMediaPeer(uRI, formatArray);
                return mediaPeer;
            }
            catch (MediaException mediaException2) {
                if (mediaException != null) continue;
                mediaException = mediaException2;
            }
        }
        PeerManager.throwMediaException(uRI, mediaException);
        return null;
    }
}

