/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.type.EncodingType;
import java.util.Locale;

class DShowEncodings {
    DShowEncodings() {
    }

    private static ACMEnc getWaveFormatEncType(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(0, 8), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        switch (n) {
            case 1: {
                return new ACMEnc(string, n, EncodingType.Encoding.PCM, "PCM audio");
            }
            case 2: {
                return new ACMEnc(string, n, EncodingType.Encoding.ADPCM, "ADPCM audio");
            }
            case 3: {
                return new ACMEnc(string, n, EncodingType.Encoding.IEEE_FLOAT, "IEEE FLOAT audio");
            }
            case 6: {
                return new ACMEnc(string, n, EncodingType.Encoding.ALAW, "aLaw audio");
            }
            case 7: {
                return new ACMEnc(string, n, EncodingType.Encoding.MULAW, "muLaw audio");
            }
            case 8: {
                return new ACMEnc(string, n, EncodingType.Encoding.DTS, "Digital Theater Systems (DTS) audio");
            }
            case 9: {
                return new ACMEnc(string, n, EncodingType.Encoding.DRM, "DRM audio");
            }
            case 10: {
                return new ACMEnc(string, n, EncodingType.Encoding.WMSP1, "Windows Media Audio 9 Voice");
            }
            case 17: {
                return new ACMEnc(string, n, EncodingType.Encoding.IMA_ADPCM, "IMA ADPCM audio");
            }
            case 34: {
                return new ACMEnc(string, n, EncodingType.Encoding.TRUESPEECH, "DSP Group TrueSpeech audio");
            }
            case 48: {
                return new ACMEnc(string, n, EncodingType.Encoding.DOLBY_AC2, "Dolby AC2 audio");
            }
            case 49: {
                return new ACMEnc(string, n, EncodingType.Encoding.GSM610, "GSM610 audio");
            }
            case 50: {
                return new ACMEnc(string, n, EncodingType.Encoding.MNSAUDIO, "MNS Audio");
            }
            case 80: {
                return new ACMEnc(string, n, EncodingType.Encoding.MPEG1AUDIO, "MPEG1 audio (MP1/MP2)");
            }
            case 85: {
                return new ACMEnc(string, n, EncodingType.Encoding.MPEG1LAYER3, "MPEG1 Layer3 audio (MP3)");
            }
            case 98: 
            case 105: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 129: {
                return new ACMEnc(string, n, EncodingType.Encoding.VOXWARE, "Voxware audio");
            }
            case 146: 
            case 304: {
                return new ACMEnc(string, n, EncodingType.Encoding.ACELPnet, "Sipro Labs ACELP (voice) audio");
            }
            case 352: {
                return new ACMEnc(string, n, EncodingType.Encoding.MSAUDIO1, "MSAudio1");
            }
            case 353: {
                return new ACMEnc(string, n, EncodingType.Encoding.WMAUDIO8, "WindowsMedia Audio 7/8");
            }
            case 354: {
                return new ACMEnc(string, n, EncodingType.Encoding.WMAUDIO9, "WindowsMedia Audio 9");
            }
            case 355: {
                return new ACMEnc(string, n, EncodingType.Encoding.WMAUDIO_LOSSLESS, "WindowsMedia 9 Lossless audio");
            }
            case 576: 
            case 577: {
                return new ACMEnc(string, n, EncodingType.Encoding.DOLBY_AC3_SPDIF, "DOLBY AC3 over SPDIF audio");
            }
            case 8192: {
                return new ACMEnc(string, n, EncodingType.Encoding.DOLBY_AC3, "Dolby AC3 audio");
            }
            case 26447: 
            case 26448: 
            case 26449: 
            case 26479: 
            case 26480: 
            case 26481: {
                return new ACMEnc(string, n, EncodingType.Encoding.VORBIS, "Vorbis audio");
            }
            case 1935960429: {
                return new ACMEnc(string, n, EncodingType.Encoding.MIDI, "MIDI");
            }
        }
        return new ACMEnc(string, n, EncodingType.Encoding.CUSTOM, "Unknown audio encoding, formatTag: 0x" + Integer.toHexString(n).toUpperCase());
    }

    static AudioEnc getAudioEncType(String string, String string2) {
        String string3;
        if (string == null) {
            String string4 = "unknown audio encoding";
            if (string2 != null) {
                string4 = string4 + ", filter: " + string2;
            }
            return new AudioEnc(string, EncodingType.Encoding.CUSTOM, string4);
        }
        AudioEnc audioEnc = null;
        if (string.endsWith("0000-0010-8000-00AA00389B71")) {
            audioEnc = DShowEncodings.getWaveFormatEncType(string);
        } else if (string.endsWith("524F-11CE-9F53-0020AF0BA770")) {
            string3 = string.substring(0, 8);
            if (string3.equals("E436EB80") || string3.equals("E436EB81")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.MPEG1AUDIO, "MPEG1 audio (MP1/MP2)");
            }
        } else if (string.endsWith("DB46-11CF-B4D1-00805F6CBBEA")) {
            string3 = string.substring(0, 8);
            if (string3.equals("E06D802B")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.MPEG2AUDIO, "MPEG2 audio");
            } else if (string3.equals("E06D802C")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.DOLBY_AC3, "Dolby AC3 audio");
            } else if (string3.equals("E06D8032")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.DVD_LPCM_AUDIO, "DVD LPCM audio");
            } else if (string3.equals("E06D8033")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.DTS, "Digital Theater Systems (DTS) audio");
            } else if (string3.equals("E06D8034")) {
                audioEnc = new AudioEnc(string, EncodingType.Encoding.SDDS, "Sony Dynamic Digital Sound (SDDS) audio");
            }
        } else if (string.equals("CDDCA2D5-6D75-4F98-840E-737BEDD5C63B")) {
            audioEnc = new AudioEnc(string, EncodingType.Encoding.VORBIS, "Vorbis audio");
        }
        if (audioEnc == null) {
            string3 = "unknown encoding, filter: " + (string2 == null ? "unknown" : string2) + ", type: Audio, subtype: " + string;
            audioEnc = new AudioEnc(string, EncodingType.Encoding.CUSTOM, string3);
        }
        return audioEnc;
    }

    private static FourCCEnc getFourCCEncType(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string.substring(0, 8), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (l <= Integer.MAX_VALUE) {
            switch ((int)l) {
                case 1: 
                case 541214546: 
                case 541215044: 
                case 541412434: 
                case 542263106: 
                case 825307737: 
                case 825308249: 
                case 842094169: 
                case 844715353: 
                case 876956754: 
                case 877417055: 
                case 944065618: 
                case 944525919: 
                case 961893977: 
                case 1094862674: 
                case 1111970399: 
                case 1345401945: 
                case 1413629778: 
                case 1414087263: 
                case 0x55595659: 
                case 0x56595559: 
                case 1463898719: 
                case 0x59565955: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.RAWVIDEO, "Uncompressed video");
                }
                case 842289229: 
                case 844515652: 
                case 859066445: 
                case 877088845: 
                case 1983008845: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.MSMPEG4, "MS MPEG 4 video");
                }
                case 844313677: 
                case 877677894: 
                case 877677906: 
                case 878199880: 
                case 1395937357: 
                case 1446269005: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.ISOMPEG4, "ISO MPEG 4 video");
                }
                case 827544397: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMSCREEN, "Windows Media Screen video");
                }
                case 844321613: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMSCREEN2, "Windows Media Video 9 Screen");
                }
                case 1347833175: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMIMAGE, "Windows Media Video 9 Image");
                }
                case 844125783: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMIMAGE2, "Windows Media Video 9 Image v2");
                }
                case 827739479: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMVIDEO7, "Windows Media Video 7");
                }
                case 844516695: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMVIDEO8, "Windows Media Video 8");
                }
                case 861293911: 
                case 961957207: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMVIDEO9, "Windows Media Video 9");
                }
                case 1096174935: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.WMVIDEO9ADV, "Windows Media Video 9 Advanced Profile");
                }
                case 826496599: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.VC1, "SMPTE 421M standard video (VC-1)");
                }
                case 827738419: 
                case 844515635: 
                case 1482049843: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.THREEIVX, "3IVX video");
                }
                case 827738436: 
                case 861292868: 
                case 878070084: 
                case 894847300: 
                case 911624516: 
                case 1482049860: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.DIVX, "DivX video");
                }
                case 808802372: 
                case 1446268228: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.DIVX5, "DivX5 video");
                }
                case 859189828: 
                case 859189832: 
                case 859189833: 
                case 859189836: 
                case 859189837: 
                case 859189843: 
                case 859189845: 
                case 859189848: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.H263, "H.263 video");
                }
                case 826496577: 
                case 875967048: 
                case 875967064: 
                case 1129726276: 
                case 1213420374: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.H264, "H.264 video");
                }
                case 825381449: 
                case 825381970: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.INDEO2, "Indeo2 video (Real-Time Video 2)");
                }
                case 808670793: 
                case 825448009: 
                case 842225225: 
                case 859002441: 
                case 875779657: 
                case 892556873: 
                case 909334089: 
                case 926111305: 
                case 942888521: 
                case 959665737: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.INDEO3, "Indeo3 video");
                }
                case 541999433: 
                case 808736329: 
                case 825513545: 
                case 842290761: 
                case 859067977: 
                case 875845193: 
                case 892622409: 
                case 909399625: 
                case 926176841: 
                case 942954057: 
                case 959731273: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.INDEO4, "Indeo4 video");
                }
                case 808801865: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.INDEO5, "Indeo video");
                }
                case 1145656920: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.XVID, "XviD video");
                }
                case 1196445016: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.MPEG1VIDEO, "XING MPEG video");
                }
                case 808800342: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.VP5, "On2 VP5 video");
                }
                case 808865878: 
                case 825643094: 
                case 842420310: 
                case 878070854: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.VP6, "On2 VP6 video");
                }
                case 808931414: 
                case 825708630: 
                case 842485846: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.VP7, "On2 VP7 video");
                }
                case 828534116: 
                case 1145656897: 
                case 1196444237: 
                case 1245992513: 
                case 1634757229: 
                case 1651534445: 
                case 1850889793: {
                    return new FourCCEnc(string, l, EncodingType.Encoding.MJPEG, "Motion JPEG video");
                }
            }
        }
        return new FourCCEnc(string, l, EncodingType.Encoding.CUSTOM, "Unknown video encoding, fourCC: '" + DShowEncodings.get4CCStr(l) + "'");
    }

    private static String get4CCStr(long l) {
        String string = "";
        for (int i = 0; i < 32; i += 8) {
            string = string + (char)(l >> i & 0xFFL);
        }
        return string;
    }

    static VideoEnc getVideoEncType(String string, String string2) {
        if (string == null) {
            String string3 = "unknown video encoding";
            if (string2 != null) {
                string3 = string3 + ", filter: " + string2;
            }
            return new VideoEnc(string, EncodingType.Encoding.CUSTOM, string3);
        }
        VideoEnc videoEnc = null;
        if (string.endsWith("0000-0010-8000-00AA00389B71")) {
            videoEnc = DShowEncodings.getFourCCEncType(string);
        } else if (string.equals("E06D8026-DB46-11CF-B4D1-00805F6CBBEA")) {
            videoEnc = new VideoEnc(string, EncodingType.Encoding.MPEG2VIDEO, "MPEG2 video");
        } else if (string.endsWith("524F-11CE-9F53-0020AF0BA770")) {
            long l = -1L;
            try {
                l = Long.parseLong(string.substring(0, 8), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l == 3828804480L || l == 3828804481L) {
                videoEnc = new VideoEnc(string, EncodingType.Encoding.MPEG1VIDEO, "MPEG1 video");
            } else if (l >= 3828804472L && l <= 3828804478L) {
                videoEnc = new VideoEnc(string, EncodingType.Encoding.RAWVIDEO, "Uncompressed video");
            }
        }
        if (videoEnc == null) {
            String string4 = "unknown encoding, filter: " + (string2 == null ? "unknown" : string2) + ", type: Video, subtype: " + string;
            videoEnc = new VideoEnc(string, EncodingType.Encoding.CUSTOM, string4);
        }
        return videoEnc;
    }

    static TextEnc getTextEncType(String string, String string2) {
        TextEnc textEnc = new TextEnc(string, EncodingType.Encoding.ANSITEXT, "ANSI plain text");
        return textEnc;
    }

    static Locale getLocale(String string) {
        Locale locale = string == null ? null : new Locale(string.toLowerCase());
        return locale;
    }

    static class ACMEnc
    extends AudioEnc {
        private final int formatTag;

        ACMEnc(String string, int n, EncodingType.Encoding encoding, String string2) {
            super(string, encoding, string2);
            this.formatTag = n;
        }

        int getFormatTag() {
            return this.formatTag;
        }
    }

    static class AudioEnc
    extends EncodingType {
        private String guid;

        AudioEnc(String string, EncodingType.Encoding encoding, String string2) {
            super(encoding, string2);
            this.guid = string;
        }

        String getEncGUID() {
            return this.guid;
        }
    }

    static class FourCCEnc
    extends VideoEnc {
        private final long fourCC;

        FourCCEnc(String string, long l, EncodingType.Encoding encoding, String string2) {
            super(string, encoding, string2);
            this.fourCC = l;
        }

        long getFourCC() {
            return this.fourCC;
        }

        String getFourCCString() {
            return DShowEncodings.get4CCStr(this.fourCC);
        }
    }

    static class TextEnc
    extends EncodingType {
        private String guid;

        TextEnc(String string, EncodingType.Encoding encoding, String string2) {
            super(encoding, string2);
            this.guid = string;
        }

        String getEncGUID() {
            return this.guid;
        }
    }

    static class VideoEnc
    extends EncodingType {
        private String guid;

        VideoEnc(String string, EncodingType.Encoding encoding, String string2) {
            super(encoding, string2);
            this.guid = string;
        }

        String getEncGUID() {
            return this.guid;
        }
    }
}

