/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.SubtitleTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmcimpl.Logger;
import com.sun.media.jmcimpl.plugins.directshow.DShowEncodings;
import com.sun.media.jmcimpl.plugins.directshow.DShowMedia;
import com.sun.media.jmcimpl.plugins.directshow.DShowPlayer;
import java.awt.Component;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class DShowEngine {
    static final boolean trace = false;
    static final Logger log = null;
    static final Logger log2 = null;
    static final Logger log3 = null;
    protected static final int eventDurationChanged = 111;
    protected static final int eventMediaError = 112;
    protected static final int eventEndOfMedia = 104;
    protected static final int eventStopped = 114;
    protected static final int eventRepeat = 115;
    protected static final int eventStarted = 103;
    protected static final int eventStopTime = 117;
    protected static final int eventMediaAvailable = 100;
    protected static final int eventMediaFormatChanged = 119;
    protected static final int eventPrerollComplete = 101;
    protected static final int eventMediaStream = 121;
    protected static final int eventStartTimeChanged = 122;
    protected static final int eventStopTimeChanged = 123;
    protected static final int eventMediaTimeStamp = 124;
    protected static final int eventSizeChanged = 102;
    protected static final int eventVideoRendered = 126;
    protected static final int eventVolumeChanged = 127;
    protected static final int eventBufferProgress = 128;
    private static final int eventContentUpdated = 121;
    private static final int TYPE_VIDEO = 0;
    private static final int TYPE_AUDIO = 1;
    private static final int TYPE_TEXT = 2;
    private static final int TYPE_OTHER = 3;
    private static final int RENDER_NOT_RENDERED = 0;
    private static final int RENDER_LIGHTWEIGHT = 1;
    private static final int RENDER_HEAVYWEIGHT = 2;
    private static final int METATYPE_INT = 0;
    private static final int METATYPE_LONG = 1;
    private static final int METATYPE_BOOL = 2;
    private static final int METATYPE_STRING = 3;
    private static final int CONTAINER_AVI = 1;
    private static final int CONTAINER_ASF = 2;
    private static final int CONTAINER_MPEG1AUDIO = 3;
    private static final int CONTAINER_MPEG1VIDEO = 4;
    private static final int CONTAINER_MPEG1VIDEOCD = 5;
    private static final int CONTAINER_MOV = 6;
    private static final int CONTAINER_WAV = 7;
    private static final int CONTAINER_AIFF = 8;
    private static final int CONTAINER_AU = 9;
    private static final int CONTAINER_MIDI = 10;
    private static final int CONTAINER_OGG = 11;
    private static final int CONTAINER_FLV = 12;
    private static final int CONTAINER_UNKNOWN = -1;
    private static final int CONTAINER_NOT_SET = 0;
    private static final int AM_SEEKING_CanSeekAbsolute = 1;
    private static final int AM_SEEKING_CanSeekForwards = 2;
    private static final int AM_SEEKING_CanSeekBackwards = 4;
    private static final int AM_SEEKING_CanGetCurrentPos = 8;
    private static final int AM_SEEKING_CanGetStopPos = 16;
    private static final int AM_SEEKING_CanGetDuration = 32;
    private static final int AM_SEEKING_CanPlayBackwards = 64;
    private static final int AM_SEEKING_CanDoSegments = 128;
    private static final int AM_SEEKING_Source = 256;
    DShowPlayer playerPeer = null;
    long id = 0L;
    boolean newFrame = false;
    Object frameData = null;
    protected final Object tracksLock = new Object();
    protected List<MediaTrack> trackList = null;
    protected MediaTrack[] mediaTracks = null;
    protected int firstVideoTrackIndex = -1;
    protected DShowVideoTrack videoTrack = null;
    private static VideoDataBuffer.Format videoFormat;

    private DShowEngine(DShowPlayer dShowPlayer) {
        this.playerPeer = dShowPlayer;
    }

    private DShowEngine() {
        this.playerPeer = null;
    }

    protected void finalize() {
        if (this.id != 0L) {
            this.nFinalize(this.id);
            this.id = 0L;
        }
    }

    public void ReleaseResources() {
        this.finalize();
    }

    static VideoDataBuffer.Format getVideoFormat() {
        return videoFormat;
    }

    protected static native boolean ndsInit(int var0);

    protected native long ndsCreate();

    protected native void ndsFinalize(long var1);

    protected native boolean ndsIsLightweight(long var1);

    protected native int ndsGetCaps(long var1);

    protected native void ndsSetParent(long var1, Component var3, int var4, int var5, int var6, int var7);

    protected native void ndsSetBounds(long var1, int var3, int var4, int var5, int var6);

    protected native void ndsSetVisible(long var1, boolean var3);

    protected native boolean ndsSetSource(long var1, String var3, String var4, int var5);

    protected native void ndsStart(long var1);

    protected native void ndsPause(long var1);

    protected native void ndsStop(long var1);

    protected native void ndsSetMediaTime(long var1, long var3);

    protected native long ndsGetMediaTime(long var1);

    protected native void ndsSetStartTime(long var1, long var3);

    protected native long ndsGetStartTime(long var1);

    protected native void ndsSetStopTime(long var1, long var3);

    protected native long ndsGetStopTime(long var1);

    protected native long ndsGetDuration(long var1);

    protected native long ndsGetBufferProgress(long var1);

    protected native void ndsSetRate(long var1, double var3);

    protected native double ndsGetRate(long var1);

    protected native void ndsSetVolume(long var1, float var3);

    protected native float ndsGetVolume(long var1);

    protected native void ndsSetBalance(long var1, float var3);

    protected native float ndsGetBalance(long var1);

    protected native void ndsSetAutoRepeat(long var1, boolean var3);

    protected native int ndsFillTracks(long var1, Object var3);

    protected native int ndsGetContainerType(long var1);

    protected native String ndsGetContainerDescr(long var1);

    protected native boolean ndsFillMetadata(long var1, Object var3);

    protected native boolean ndsTransferFrame(long var1, int[] var3, int var4, int var5);

    protected static boolean nInit(VideoDataBuffer.Format format) {
        videoFormat = format;
        boolean bl = DShowEngine.ndsInit(videoFormat.ordinal());
        return bl;
    }

    protected long nCreate() {
        long l = this.ndsCreate();
        return l;
    }

    protected boolean nIsLightweight(long l) {
        boolean bl = this.ndsIsLightweight(l);
        return bl;
    }

    protected int nGetCaps(long l) {
        int n = this.ndsGetCaps(l);
        return n;
    }

    protected void nFinalize(long l) {
        this.ndsFinalize(l);
    }

    protected void nSetParent(long l, Component component, int n, int n2, int n3, int n4) {
        this.ndsSetParent(l, component, n, n2, n3, n4);
    }

    protected void nSetBounds(long l, int n, int n2, int n3, int n4) {
        this.ndsSetBounds(l, n, n2, n3, n4);
    }

    protected void nSetVisible(long l, boolean bl) {
        this.ndsSetVisible(l, bl);
    }

    protected boolean nSetSource(long l, String string, String string2, int n) {
        boolean bl = false;
        bl = this.ndsSetSource(l, string, string2, n);
        return bl;
    }

    protected void nStart(long l) {
        this.ndsStart(l);
    }

    protected void nPause(long l) {
        this.ndsPause(l);
    }

    protected void nStop(long l) {
        this.ndsStop(l);
    }

    protected void nSetMediaTime(long l, long l2) {
        this.ndsSetMediaTime(l, l2);
    }

    protected long nGetMediaTime(long l) {
        long l2 = this.ndsGetMediaTime(l);
        return l2;
    }

    protected void nSetStartTime(long l, long l2) {
        this.ndsSetStartTime(l, l2);
    }

    protected long nGetStartTime(long l) {
        long l2 = this.ndsGetStartTime(l);
        return l2;
    }

    protected void nSetStopTime(long l, long l2) {
        this.ndsSetStopTime(l, l2);
    }

    protected long nGetStopTime(long l) {
        long l2 = this.ndsGetStopTime(l);
        return l2;
    }

    protected long nGetDuration(long l) {
        long l2 = this.ndsGetDuration(l);
        return l2;
    }

    protected void nSetRate(long l, double d) {
        this.ndsSetRate(l, d);
    }

    protected double nGetRate(long l) {
        double d = this.ndsGetRate(l);
        return d;
    }

    protected void nSetVolume(long l, float f) {
        this.ndsSetVolume(l, f);
    }

    protected float nGetVolume(long l) {
        float f = this.ndsGetVolume(l);
        return f;
    }

    protected void nSetBalance(long l, float f) {
        this.ndsSetBalance(l, f);
    }

    protected float nGetBalance(long l) {
        float f = this.ndsGetBalance(l);
        return f;
    }

    protected void nSetAutoRepeat(long l, boolean bl) {
        this.ndsSetAutoRepeat(l, bl);
    }

    protected int nFillTracks(long l, Object object) {
        int n = this.ndsFillTracks(l, object);
        return n;
    }

    protected int nGetContainerType(long l) {
        int n = this.ndsGetContainerType(l);
        return n;
    }

    protected String nGetContainerDescr(long l) {
        String string = this.ndsGetContainerDescr(l);
        return string;
    }

    protected boolean nFillMetadata(long l, Object object) {
        boolean bl = this.ndsFillMetadata(l, object);
        return bl;
    }

    protected boolean nTransferFrame(int[] nArray, int n, int n2) {
        Thread.dumpStack();
        return true;
    }

    protected long time2pos(double d) {
        return (long)(d * 1.0E7);
    }

    protected double pos2time(long l) {
        return (double)l / 1.0E7;
    }

    public static DShowEngine canPlay(URI uRI, boolean bl) {
        return DShowEngine.canPlay(uRI, bl, null);
    }

    public static DShowEngine canPlay(URI uRI, boolean bl, DShowPlayer dShowPlayer) {
        boolean bl2 = false;
        DShowEngine dShowEngine = new DShowEngine();
        dShowEngine.playerPeer = dShowPlayer;
        dShowEngine.id = dShowEngine.nCreate();
        if (dShowEngine.loadMedia(uRI, 1)) {
            bl2 = true;
        }
        if (!bl2 || !bl) {
            dShowEngine.nFinalize(dShowEngine.id);
            dShowEngine = null;
        }
        return dShowEngine;
    }

    boolean loadMedia(URI uRI, int n) {
        boolean bl = false;
        String string = "";
        uRI.normalize();
        if (uRI.getScheme().equalsIgnoreCase("file")) {
            String string2 = uRI.getSchemeSpecificPart();
            if (string2.startsWith("///")) {
                string = string2.substring(3);
            } else if (string2.startsWith("/")) {
                string = string2.substring(1);
            } else if (string2.startsWith(".") && !string2.startsWith("..")) {
                string = string2.substring(1);
            }
        }
        if (bl = this.nSetSource(this.id, uRI.toASCIIString(), string, n)) {
            this.processTrackList(null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTrackLock(int n) {
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks == null || n >= this.mediaTracks.length) {
                return null;
            }
            return this.mediaTracks[n];
        }
    }

    private void sendMediaEvent(int n, long l, long l2, String string) {
        if (this.playerPeer != null) {
            this.playerPeer.sendMediaEvent(n, 0L);
        }
    }

    private void sendTrackEvent(int n, long l, int n2, Object object, int[] nArray) {
        double d = l < 0L ? Double.NEGATIVE_INFINITY : this.pos2time(l);
        this.frameData = object;
        this.newFrame = true;
    }

    private long nGetBufferProgress(long l) {
        return this.ndsGetBufferProgress(l);
    }

    private void addTrack(Object object, int n, String string, String string2, boolean bl, int n2, int n3, String string3, int n4, double d, int n5, int n6, boolean bl2) {
        List list = (List)object;
        MediaTrack mediaTrack = null;
        switch (n2) {
            case 0: {
                mediaTrack = new DShowVideoTrack(n, string, string2, bl, n3, n5, n6, d, bl2);
                break;
            }
            case 1: {
                mediaTrack = new DShowAudioTrack(n, string, string2, bl, n3, n4, string3, d);
                break;
            }
            case 2: {
                mediaTrack = new DShowTextTrack(n, string, string2, bl, n3, string3);
            }
        }
        list.add(mediaTrack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTrackList(DShowMedia dShowMedia) {
        Iterator iterator;
        if (this.trackList != null) {
            return;
        }
        LinkedList<MediaTrack> linkedList = new LinkedList<MediaTrack>();
        MediaTrack[] mediaTrackArray = new MediaTrack[]{};
        DShowVideoTrack dShowVideoTrack = null;
        int n = this.nFillTracks(this.id, linkedList);
        boolean bl = true;
        int n2 = -1;
        if (n > 0) {
            mediaTrackArray = new MediaTrack[n];
            iterator = linkedList.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                mediaTrackArray[n3] = (MediaTrack)iterator.next();
                if (bl && mediaTrackArray[n3] instanceof DShowVideoTrack) {
                    bl = false;
                    n2 = n3;
                    dShowVideoTrack = (DShowVideoTrack)mediaTrackArray[n3];
                }
                ++n3;
            }
        }
        iterator = this.tracksLock;
        synchronized (iterator) {
            this.trackList = linkedList;
            this.mediaTracks = mediaTrackArray;
            this.firstVideoTrackIndex = n2;
            this.videoTrack = dShowVideoTrack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMovieProperties(DShowMedia dShowMedia) {
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.videoTrack != null) {
                dShowMedia.width = this.videoTrack.getFrameWidth();
                dShowMedia.height = this.videoTrack.getFrameHeight();
                dShowMedia.fps = this.videoTrack.getFrameRate();
            }
        }
        dShowMedia.duration = this.pos2time(this.nGetDuration(this.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTracks(DShowMedia dShowMedia) {
        int n = 0;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            n = this.mediaTracks.length;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackType(DShowMedia dShowMedia, int n) {
        int n2 = 3;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[n] instanceof DShowVideoTrack) {
                n2 = 0;
            } else if (this.mediaTracks[n] instanceof DShowAudioTrack) {
                n2 = 1;
            } else if (this.mediaTracks[n] instanceof DShowTextTrack) {
                n2 = 2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackFormat(DShowMedia dShowMedia, int n) {
        String string = "Unknown";
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            string = this.mediaTracks[n].getEncodingType().toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTrackIsEnabled(DShowMedia dShowMedia, int n) {
        boolean bl = false;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            bl = this.mediaTracks[n] != null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannels(DShowMedia dShowMedia, int n) {
        int n2 = 1;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[n] instanceof DShowAudioTrack) {
                DShowAudioTrack dShowAudioTrack = (DShowAudioTrack)this.mediaTracks[n];
                n2 = dShowAudioTrack.getChannels();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampleRate(DShowMedia dShowMedia, int n) {
        long l = 0L;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[n] instanceof DShowVideoTrack) {
                DShowVideoTrack dShowVideoTrack = (DShowVideoTrack)this.mediaTracks[n];
                l = (long)dShowVideoTrack.getFrameRate();
            } else if (this.mediaTracks[n] instanceof DShowAudioTrack) {
                DShowAudioTrack dShowAudioTrack = (DShowAudioTrack)this.mediaTracks[n];
                l = (long)dShowAudioTrack.getSampleRate();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMovieProperties(DShowPlayer dShowPlayer) {
        this.processTrackList(null);
        int n = 0;
        int n2 = 0;
        Object object = this.tracksLock;
        synchronized (object) {
            this.playerPeer = dShowPlayer;
            if (this.videoTrack != null) {
                n = this.videoTrack.getFrameWidth();
                n2 = this.videoTrack.getFrameHeight();
            }
        }
        double d = this.pos2time(this.nGetDuration(this.id));
        double d2 = this.nGetRate(this.id);
        double d3 = this.pos2time(this.nGetBufferProgress(this.id));
        double d4 = this.pos2time(this.nGetMediaTime(this.id));
        float f = this.nGetVolume(this.id);
        float f2 = this.nGetBalance(this.id);
        float f3 = 0.0f;
        dShowPlayer.syncMovieProperties(n, n2, d, d2, d3, d4, f, f2, f3);
    }

    public double getMediaTime(DShowPlayer dShowPlayer) {
        double d = this.pos2time(this.nGetMediaTime(this.id));
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newFrame(DShowPlayer dShowPlayer) {
        boolean bl = false;
        Object object = this.tracksLock;
        synchronized (object) {
            bl = this.newFrame;
        }
        return bl;
    }

    public void play() {
        this.nStart(this.id);
    }

    public void stop() {
        this.nStop(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferFrame(VideoDataBuffer videoDataBuffer) {
        int n;
        int n2;
        Object object;
        Object object2 = this.tracksLock;
        synchronized (object2) {
            object = this.frameData;
            if (this.videoTrack != null) {
                n2 = Math.abs(this.videoTrack.getFrameWidth());
                n = Math.abs(this.videoTrack.getFrameHeight());
            } else {
                n2 = 0;
                n = 0;
            }
            this.newFrame = false;
        }
        if (object instanceof byte[]) {
            videoDataBuffer.setBuffer(ByteBuffer.wrap((byte[])this.frameData));
            if (videoFormat == VideoDataBuffer.Format.XBGR || videoFormat == VideoDataBuffer.Format.XRGB) {
                System.out.println("WARNING: Wrong format: " + (Object)((Object)videoFormat));
            }
        } else if (object instanceof int[]) {
            videoDataBuffer.setBuffer(IntBuffer.wrap((int[])this.frameData));
            if (videoFormat != VideoDataBuffer.Format.XBGR && videoFormat != VideoDataBuffer.Format.XRGB) {
                System.out.println("WARNING: Wrong format: " + (Object)((Object)videoFormat));
            }
        } else {
            videoDataBuffer.setBuffer(null);
        }
        videoDataBuffer.setFormat(videoFormat);
        videoDataBuffer.setWidth(n2);
        videoDataBuffer.setHeight(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFrame(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        Object object = this.tracksLock;
        synchronized (object) {
            nArray2 = (int[])this.frameData;
            this.newFrame = false;
        }
        try {
            if (nArray.length != nArray2.length) {
                Thread.dumpStack();
            }
            System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
        }
        catch (Exception exception) {
            System.err.println("framepixels : " + nArray2);
            System.err.println("pixels : " + nArray);
            exception.printStackTrace();
        }
    }

    public void preroll() {
    }

    public void setBalance(float f) {
        this.nSetBalance(this.id, f);
    }

    public void setAutoRepeat(boolean bl) {
        this.nSetAutoRepeat(this.id, bl);
    }

    public void setRate(double d) {
        this.nSetRate(this.id, d);
    }

    public long getCurrentPosition(DShowPlayer dShowPlayer) {
        return (long)this.pos2time(this.nGetMediaTime(this.id));
    }

    public float setVolume(float f) {
        this.nSetVolume(this.id, f);
        return f;
    }

    public void setStopTime(double d) {
        this.nSetStopTime(this.id, this.time2pos(d));
    }

    public void setStartTime(double d) {
        this.nSetStartTime(this.id, this.time2pos(d));
    }

    public void initMovie() {
        this.id = this.nCreate();
        this.playerPeer = null;
    }

    public boolean open(URI uRI, String string, String string2, DShowPlayer dShowPlayer) {
        boolean bl = this.loadMedia(uRI, 1);
        if (bl) {
            this.getMovieProperties(dShowPlayer);
        }
        return bl;
    }

    public void setMediaTime(double d) {
        this.nSetMediaTime(this.id, this.time2pos(d));
    }

    public boolean eom(DShowPlayer dShowPlayer) {
        double d;
        double d2 = this.nGetMediaTime(this.id);
        return d2 - (d = (double)this.nGetStopTime(this.id)) > -0.02;
    }

    public void pause() {
        this.nPause(this.id);
    }

    private class DShowAudioTrack
    extends AudioTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowAudioTrack(int n, String string, String string2, boolean bl, int n2, int n3, String string3, double d) {
            super(DShowEncodings.getAudioEncType(string, string2), "Audio Track", n3, DShowEncodings.getLocale(string3), (float)d);
            this.trackEnabled = false;
            this.trackEnabled = bl;
            this.trackID = n;
            this.renderType = n2;
        }
    }

    private class DShowTextTrack
    extends SubtitleTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowTextTrack(int n, String string, String string2, boolean bl, int n2, String string3) {
            super(DShowEncodings.getTextEncType(string, string2), "Text Track", DShowEncodings.getLocale(string3));
            this.trackEnabled = false;
            this.trackEnabled = bl;
            this.trackID = n;
            this.renderType = n2;
        }
    }

    private class DShowVideoTrack
    extends VideoTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowVideoTrack(int n, String string, String string2, boolean bl, int n2, int n3, int n4, double d, boolean bl2) {
            super(DShowEncodings.getVideoEncType(string, string2), "Video Track", n3, n4, (float)d, bl2);
            this.trackEnabled = false;
            this.trackEnabled = bl;
            this.trackID = n;
            this.renderType = n2;
        }
    }
}

