/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.directshow.DShowEngine;
import com.sun.media.jmcimpl.plugins.directshow.DShowPlayer;
import com.sun.media.jmcimpl.plugins.directshow.DShowProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DShowMedia
implements MediaPeer {
    private static final int UNKNOWN_TRACK_TYPE = 0;
    private static final int AUDIO_TRACK_TYPE = 1;
    private static final int VIDEO_TRACK_TYPE = 2;
    private static final int TEXT_TRACK_TYPE = 3;
    private static final int MPEG_TRACK_TYPE = 4;
    private static final int MUSIC_TRACK_TYPE = 5;
    private static final int TIME_CODE_TRACK_TYPE = 6;
    protected int width = 0;
    protected int height = 0;
    protected double duration = 0.0;
    protected float fps = 0.0f;
    private URI uri = null;
    private DShowEngine e = null;
    private DShowPlayer p = null;
    private int totalTracks = 0;
    private List<MediaTrack> mediaTracks = null;

    private DShowMedia() {
    }

    public DShowMedia(URI uRI) throws MediaException {
        this();
        this.uri = uRI;
        this.e = DShowEngine.canPlay(this.uri, true);
        this.loadProperties();
    }

    public DShowMedia(DShowPlayer dShowPlayer, DShowEngine dShowEngine) {
        this();
        this.e = dShowEngine;
        this.p = dShowPlayer;
        this.loadProperties();
        if (null != this.p) {
            this.e = null;
        }
    }

    public DShowMedia(DShowEngine dShowEngine, URI uRI) {
        this(null, dShowEngine);
        this.uri = uRI;
    }

    private void loadProperties() {
        if (null == this.e) {
            throw new MediaException("DirectShow does not support this movie format.");
        }
        this.e.getMovieProperties(this);
        this.totalTracks = this.e.getNumTracks(this);
        this.mediaTracks = new ArrayList<MediaTrack>(this.totalTracks);
        for (int i = 0; i < this.totalTracks; ++i) {
            EncodingType encodingType;
            int n = this.e.getTrackType(this, i);
            String string = this.e.getTrackFormat(this, i);
            boolean bl = this.e.getTrackIsEnabled(this, i);
            if (n == 2) {
                encodingType = string.contains("H.263") ? new EncodingType(EncodingType.Encoding.H263, string) : (string.startsWith("H.264") ? new EncodingType(EncodingType.Encoding.H264, string) : (string.startsWith("Windows Media Video 9") ? new EncodingType(EncodingType.Encoding.WMVIDEO9, string) : (string.contains("Theora") ? new EncodingType(EncodingType.Encoding.THEORA, string) : (string.contains("JPEG") ? new EncodingType(EncodingType.Encoding.MJPEG, string) : new EncodingType(EncodingType.Encoding.CUSTOM, string)))));
                VideoTrack videoTrack = new VideoTrack(encodingType, "Video Track", this.getFrameWidth(), this.getFrameHeight(), this.fps, false);
                this.mediaTracks.add(videoTrack);
                continue;
            }
            if (n == 1) {
                encodingType = string.equals("mp4a") ? new EncodingType(EncodingType.Encoding.MPEG4AUDIO, "MPEG-4 Audio") : (string.contains("Vorbis") ? new EncodingType(EncodingType.Encoding.VORBIS, string) : (string.contains("AAC") ? new EncodingType(EncodingType.Encoding.AAC, string) : (string.contains("mp3") || string.contains("MPEG Layer 3") ? new EncodingType(EncodingType.Encoding.MPEG1LAYER3, string) : (string.equals("WMA2") ? new EncodingType(EncodingType.Encoding.WMAUDIO8, string) : (string.contains("Windows Media Audio 9") ? new EncodingType(EncodingType.Encoding.WMAUDIO9, string) : (string.contains("16-bit Integer (Little Endian)") ? new EncodingType(EncodingType.Encoding.PCM, string) : new EncodingType(EncodingType.Encoding.CUSTOM, string)))))));
                int n2 = this.e.getChannels(this, i);
                long l = this.e.getSampleRate(this, i);
                AudioTrack audioTrack = new AudioTrack(encodingType, "Audio Track", n2, Locale.US, l);
                this.mediaTracks.add(audioTrack);
                continue;
            }
            if (n != 3 && n != 4 && n != 5 && n != 6) continue;
        }
    }

    @Override
    public ContainerType getContainerType() {
        ContainerType[] containerTypeArray = DShowProvider.getSupportedContainerTypes();
        String string = this.uri.toASCIIString();
        for (int i = 0; i < containerTypeArray.length; ++i) {
            String[] stringArray = containerTypeArray[i].getExtensions();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.endsWith(stringArray[j])) continue;
                return containerTypeArray[i];
            }
        }
        return null;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public int getFrameWidth() {
        return this.width;
    }

    @Override
    public int getFrameHeight() {
        return this.height;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return null;
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.mediaTracks;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        this.p = null;
        try {
            if (null != this.e) {
                this.p = new DShowPlayer(this, this.e, this.uri);
                this.e = null;
            } else {
                this.p = new DShowPlayer(this.uri);
            }
        }
        catch (MediaException mediaException) {
            if (this.p != null) {
                this.p.dispose();
                this.p = null;
            }
            throw mediaException;
        }
        return this.p;
    }
}

