/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.directshow.DShowEngine;
import com.sun.media.jmcimpl.plugins.directshow.DShowMedia;
import java.net.URI;

class DShowPlayer
extends AbstractPlayerPeer
implements PlayerPeer {
    private DShowEngine e = null;
    private DShowMedia mediaPeer = null;
    float g_fader = 0.0f;

    private DShowPlayer() throws MediaException {
        VideoDataBuffer.Format format = DShowEngine.getVideoFormat();
        this.platformCoordinatesYFlipped = format != VideoDataBuffer.Format.YV12 && format != VideoDataBuffer.Format.YUV_442 && format != VideoDataBuffer.Format.YUV_444;
        this.earlyTaskLoop = true;
    }

    public DShowPlayer(DShowEngine dShowEngine, URI uRI) throws MediaException {
        this();
        this.e = dShowEngine;
        this.uri = uRI.normalize();
        this.setSource(uRI);
    }

    public DShowPlayer(URI uRI) throws MediaException {
        this();
        this.setSource(uRI);
    }

    public DShowPlayer(DShowMedia dShowMedia, DShowEngine dShowEngine, URI uRI) throws MediaException {
        this(dShowEngine, uRI);
        this.mediaPeer = dShowMedia;
    }

    public synchronized MediaPeer getMediaPeer() {
        if (this.mediaPeer == null && this.e != null) {
            this.mediaPeer = new DShowMedia(this, this.e);
        }
        return this.mediaPeer;
    }

    public void finalize() {
        this.dispose();
    }

    protected synchronized double plugin_getMediaTime() {
        return this.e.getMediaTime(this);
    }

    protected synchronized boolean plugin_newFrame() {
        return this.e.newFrame(this);
    }

    protected synchronized void plugin_pause() {
        this.e.pause();
    }

    protected synchronized void plugin_start() {
        this.e.play();
    }

    protected synchronized void plugin_stop() {
        this.e.stop();
    }

    protected synchronized void plugin_provideCleanContext() {
        if (null != this.e) {
            this.e.ReleaseResources();
        }
        this.e = null;
    }

    synchronized void sendMediaEvent(int n, long l) {
        this.getExecutor().execute(new AbstractPlayerPeer.Execute_mediaEvent(this, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void plugin_prerollMovie() {
        if (this.e != null) {
            DShowPlayer dShowPlayer = this;
            synchronized (dShowPlayer) {
                this.e.preroll();
            }
        }
    }

    protected synchronized void plugin_setBalance(float f) {
        this.e.setBalance(f);
    }

    protected synchronized void plugin_setFader(float f) {
        this.g_fader = f;
    }

    protected synchronized void plugin_setRate(double d) {
        this.e.setRate(d);
    }

    protected synchronized void plugin_setSource(URI uRI) {
        if (null == uRI) {
            if (null != this.e) {
                this.e.ReleaseResources();
            }
            this.e = null;
            return;
        }
        if (null == this.e) {
            this.e = DShowEngine.canPlay(uRI, true, this);
        }
        if (null != this.e) {
            this.earlyTaskLoop = true;
        }
    }

    protected synchronized void plugin_setMediaTime(double d) {
        this.e.setMediaTime(d);
    }

    protected synchronized void plugin_setStopTime(double d) {
        this.e.setStopTime(d);
    }

    protected synchronized void plugin_setStartTime(double d) {
        this.e.setStartTime(d);
    }

    protected boolean plugin_endOfMedia() {
        return this.e.eom(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void plugin_getMovieProperties() {
        DShowPlayer dShowPlayer = this;
        synchronized (dShowPlayer) {
            this.e.getMovieProperties(this);
        }
    }

    protected synchronized void plugin_setVolume(float f) {
        f = this.e.setVolume(f);
    }

    protected void plugin_transferFrame(VideoDataBuffer videoDataBuffer) {
        this.e.transferFrame(videoDataBuffer);
    }

    protected void plugin_transferFrame(int[] nArray, int n, int n2) {
        this.e.transferFrame(nArray, n, n2);
    }

    void syncMovieProperties(int n, int n2, double d, double d2, double d3, double d4, float f, float f2, float f3) {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = new AbstractPlayerPeer.NativePlayerPeerProperties(this);
        nativePlayerPeerProperties.imageWidth = n;
        nativePlayerPeerProperties.imageHeight = n2;
        nativePlayerPeerProperties.duration = d;
        nativePlayerPeerProperties.rate = d2;
        nativePlayerPeerProperties.bufferProgressTime = d3;
        nativePlayerPeerProperties.mediaTime = d4;
        nativePlayerPeerProperties.volume = f;
        nativePlayerPeerProperties.balance = f2;
        nativePlayerPeerProperties.fader = this.g_fader;
        super.syncMovieProperties(nativePlayerPeerProperties);
    }
}

