/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.flash;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class BitStream {
    InputStream in;
    int curByte;
    int unreadBits;

    BitStream(InputStream inputStream) {
        this.in = inputStream;
        this.curByte = 0;
        this.unreadBits = 0;
    }

    int read8() throws IOException {
        this.unreadBits = 0;
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    int read16LE() throws IOException {
        int n = this.read8();
        int n2 = this.read8();
        return n + (n2 << 8);
    }

    long read32LE() throws IOException {
        long l = this.read8();
        long l2 = this.read8();
        long l3 = this.read8();
        long l4 = this.read8();
        return l + (l2 << 8) + (l3 << 16) + (l4 << 24);
    }

    int read16BE() throws IOException {
        int n = this.read8();
        int n2 = this.read8();
        return (n << 8) + n2;
    }

    long read32() throws IOException {
        long l = this.read8();
        long l2 = this.read8();
        long l3 = this.read8();
        long l4 = this.read8();
        return (l << 24) + (l2 << 16) + (l3 << 8) + l4;
    }

    private void readNextByte() throws IOException {
        this.curByte = this.read8();
        this.unreadBits = 8;
    }

    boolean readBit() throws IOException {
        if (this.unreadBits <= 0) {
            this.readNextByte();
        }
        --this.unreadBits;
        return 0 != (this.curByte & 1 << this.unreadBits);
    }

    long readBits(int n, boolean bl) throws IOException {
        long l;
        if (n <= 0) {
            return 0L;
        }
        long l2 = (1L << n) - 1L;
        if (this.unreadBits <= 0) {
            this.readNextByte();
        }
        long l3 = this.curByte;
        n -= this.unreadBits;
        while (n > 0) {
            this.readNextByte();
            l3 <<= 8;
            l3 |= (long)this.curByte;
            n -= 8;
        }
        this.unreadBits = -n;
        l3 >>= this.unreadBits;
        if (bl && ((l3 &= l2) & (l = l2 + 1L >> 1)) != 0L) {
            l3 |= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l3;
    }
}

