/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.flash;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.NativeLibLoader;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.flash.FlashMedia;
import com.sun.media.jmcimpl.plugins.flash.FlashPlayer;
import com.sun.media.jmcimpl.spi.MediaPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashProvider
implements PlayerPeerProvider,
MediaPeerProvider {
    static final ContainerType SWFContainer = new ContainerType(ContainerType.Container.SWF, "Flash (SWF)", new String[]{"swf"}, new String[]{"application/x-shockwave-flash"});
    static final ContainerType FLVContainer = new ContainerType(ContainerType.Container.FLV, "Flash Video (FLV)", new String[]{"flv"}, new String[]{"video/x-flv"});
    static final ContainerType[] myMediaFileTypes = new ContainerType[]{SWFContainer};
    static Boolean isPlatformOK = null;
    private static boolean librariesLoaded = false;

    private String getSysProp(String string) {
        final String string2 = string;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2, "");
            }
        });
    }

    private synchronized boolean init() {
        SecurityManager securityManager = System.getSecurityManager();
        if (isPlatformOK == null) {
            isPlatformOK = this.getSysProp("os.name").toLowerCase().startsWith("windows");
        }
        if (!isPlatformOK.booleanValue()) {
            return false;
        }
        if (librariesLoaded) {
            return true;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    NativeLibLoader.loadLibrary("jawt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                try {
                    NativeLibLoader.loadLibrary("jmc");
                    librariesLoaded = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    librariesLoaded = false;
                }
                return null;
            }
        });
        return librariesLoaded;
    }

    @Override
    public ContainerType[] getContainerTypes() {
        if (!this.init()) {
            return new ContainerType[0];
        }
        return myMediaFileTypes;
    }

    @Override
    public PlayerPeerProvider.PlaybackMode canPlay(URI uRI, VideoDataBuffer.Format[] formatArray) {
        if (!this.init()) {
            return PlayerPeerProvider.PlaybackMode.None;
        }
        try {
            this.createMediaPeer(uRI, null);
        }
        catch (MediaException mediaException) {
            return PlayerPeerProvider.PlaybackMode.None;
        }
        return PlayerPeerProvider.PlaybackMode.Lightweight;
    }

    @Override
    public PlayerPeer createPlayerPeer(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        if (!this.init()) {
            throw new MediaException("Flash peers are not initialized.");
        }
        FlashPlayer flashPlayer = new FlashPlayer();
        flashPlayer.setSource(uRI);
        return flashPlayer;
    }

    @Override
    public Class<? extends PlayerPeer> getPlayerPeerClass() {
        return FlashPlayer.class;
    }

    @Override
    public boolean canDecode(URI uRI, VideoDataBuffer.Format[] formatArray) {
        if (!this.init()) {
            return false;
        }
        try {
            this.createMediaPeer(uRI, null);
            return true;
        }
        catch (MediaException mediaException) {
            return false;
        }
    }

    @Override
    public MediaPeer createMediaPeer(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        if (!this.init()) {
            throw new MediaException("Flash peers are not initialized.");
        }
        return new FlashMedia(uRI);
    }
}

