/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTPlayerProvider;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTStreamInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTUtils;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSTMediaPeer
implements MediaPeer {
    private static final Map<URI, GSTMediaPeer> cache = new MediaInfoCache();
    private List<MediaTrack> trackInfo;
    private Map<String, Object> metadata;
    private double duration = Double.POSITIVE_INFINITY;
    private int videoWidth;
    private int videoHeight;
    private ContainerType containerType;

    private static native GSTMediaInfo nativeGetMediaInfo(String var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GSTMediaPeer getMediaPeer(URI uRI) {
        Object object = cache;
        synchronized (object) {
            if (cache.containsKey(uRI)) {
                return cache.get(uRI);
            }
        }
        object = GSTMediaPeer.nativeGetMediaInfo(GSTUtils.normalize(uRI).toString(), 10);
        return GSTMediaPeer.createMediaPeer(uRI, (GSTMediaInfo)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GSTMediaPeer createMediaPeer(URI uRI, GSTMediaInfo gSTMediaInfo) {
        GSTMediaPeer gSTMediaPeer = null;
        if (gSTMediaInfo != null) {
            gSTMediaPeer = new GSTMediaPeer(gSTMediaInfo);
            Map<URI, GSTMediaPeer> map = cache;
            synchronized (map) {
                cache.put(uRI, gSTMediaPeer);
            }
        }
        return gSTMediaPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasBeenCached(URI uRI) {
        Map<URI, GSTMediaPeer> map = cache;
        synchronized (map) {
            return cache.containsKey(uRI);
        }
    }

    private GSTMediaPeer(GSTMediaInfo gSTMediaInfo) {
        this.initInstance(gSTMediaInfo);
    }

    private void initInstance(GSTMediaInfo gSTMediaInfo) {
        this.trackInfo = new LinkedList<MediaTrack>();
        block4: for (GSTStreamInfo gSTStreamInfo : gSTMediaInfo.getStreamInfo()) {
            switch (gSTStreamInfo.getStreamType()) {
                case AUDIO: {
                    GSTStreamInfo gSTStreamInfo2 = (GSTStreamInfo.Audio)gSTStreamInfo;
                    EncodingType encodingType = new EncodingType(GSTUtils.getEncoding(gSTStreamInfo), "GStreamer encoding type: " + gSTStreamInfo2.getMimeType());
                    MediaTrack mediaTrack = new AudioTrack(encodingType, "Audio Track", ((GSTStreamInfo.Audio)gSTStreamInfo2).getChannels(), Locale.US, ((GSTStreamInfo.Audio)gSTStreamInfo2).getRate());
                    this.trackInfo.add(mediaTrack);
                    continue block4;
                }
                case VIDEO: {
                    GSTStreamInfo gSTStreamInfo2 = (GSTStreamInfo.Video)gSTStreamInfo;
                    EncodingType encodingType = new EncodingType(GSTUtils.getEncoding(gSTStreamInfo), "GStreamer encoding type: " + gSTStreamInfo2.getMimeType());
                    MediaTrack mediaTrack = new VideoTrack(encodingType, "Video Track", ((GSTStreamInfo.Video)gSTStreamInfo2).getWidth(), ((GSTStreamInfo.Video)gSTStreamInfo2).getHeight(), (float)((GSTStreamInfo.Video)gSTStreamInfo2).getFramerate(), false);
                    this.trackInfo.add(mediaTrack);
                    if (((GSTStreamInfo.Video)gSTStreamInfo2).isSizeValid()) {
                        this.videoWidth = ((GSTStreamInfo.Video)gSTStreamInfo2).getWidth();
                        this.videoHeight = ((GSTStreamInfo.Video)gSTStreamInfo2).getHeight();
                        continue block4;
                    }
                    this.videoHeight = 0;
                    this.videoWidth = 0;
                    continue block4;
                }
            }
        }
        this.metadata = gSTMediaInfo.getMetadata();
        this.containerType = new ContainerType(GSTUtils.getContainer(gSTMediaInfo.getMimeType()), "GStreamer container type: " + gSTMediaInfo.getMimeType(), GSTPlayerProvider.getTypesList().get(gSTMediaInfo.getMimeType()), new String[]{gSTMediaInfo.getMimeType()});
        this.duration = GSTUtils.toSeconds(gSTMediaInfo.getDuration());
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.trackInfo;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata == null ? null : Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public int getFrameWidth() {
        return this.videoWidth;
    }

    @Override
    public int getFrameHeight() {
        return this.videoHeight;
    }

    @Override
    public PlayerPeer getPlayerPeer() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaInfoCache
    extends LinkedHashMap<URI, GSTMediaPeer> {
        private static final int CACHE_SIZE = 50;

        MediaInfoCache() {
            super(20, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<URI, GSTMediaPeer> entry) {
            return this.size() > 50;
        }
    }
}

