/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTStreamInfo;
import java.net.URI;
import java.net.URISyntaxException;

class GSTUtils {
    static final long GST_SECOND = 1000000000L;
    static final long GST_CLOCK_TIME_NONE = -1L;

    GSTUtils() {
    }

    static long toNanoseconds(double d) {
        return d != Double.POSITIVE_INFINITY ? (long)(d * 1.0E9) : -1L;
    }

    static double toSeconds(long l) {
        return l != -1L ? (double)l / 1.0E9 : Double.POSITIVE_INFINITY;
    }

    static EncodingType.Encoding getEncoding(GSTStreamInfo gSTStreamInfo) {
        String string = gSTStreamInfo.getMimeType();
        if (string.startsWith("audio")) {
            if (string.startsWith("audio/x-raw")) {
                return EncodingType.Encoding.PCM;
            }
            if ("audio/x-vorbis".equals(string)) {
                return EncodingType.Encoding.VORBIS;
            }
            if ("audio/x-adpcm".equals(string)) {
                return EncodingType.Encoding.ADPCM;
            }
            if ("audio/x-alaw".equals(string)) {
                return EncodingType.Encoding.ALAW;
            }
            if ("audio/x-mulaw".equals(string)) {
                return EncodingType.Encoding.MULAW;
            }
            if ("audio/ms-gsm".equals(string)) {
                return EncodingType.Encoding.GSM610;
            }
            if ("audio/mpeg".equals(string)) {
                switch (gSTStreamInfo.getVersion()) {
                    case 1: {
                        return gSTStreamInfo.getLayer() == 3 ? EncodingType.Encoding.MPEG1LAYER3 : EncodingType.Encoding.MPEG1AUDIO;
                    }
                    case 2: {
                        return EncodingType.Encoding.MPEG2AUDIO;
                    }
                    case 4: {
                        return EncodingType.Encoding.AAC;
                    }
                }
            } else {
                if ("audio/x-voxware".equals(string)) {
                    return EncodingType.Encoding.VOXWARE;
                }
                if ("audio/x-wma".equals(string)) {
                    switch (gSTStreamInfo.getVersion()) {
                        case 1: {
                            return EncodingType.Encoding.MSAUDIO1;
                        }
                        case 2: {
                            return EncodingType.Encoding.WMAUDIO8;
                        }
                        case 3: {
                            return EncodingType.Encoding.WMAUDIO9;
                        }
                    }
                } else {
                    if ("audio/x-lpcm".equals(string)) {
                        return EncodingType.Encoding.DVD_LPCM_AUDIO;
                    }
                    if ("audio/x-lpcm".equals(string)) {
                        return EncodingType.Encoding.DVD_LPCM_AUDIO;
                    }
                    if ("audio/x-ac3".equals(string)) {
                        return EncodingType.Encoding.DOLBY_AC3;
                    }
                    if ("audio/x-dts".equals(string)) {
                        return EncodingType.Encoding.DTS;
                    }
                }
            }
        } else if (string.startsWith("video") || string.startsWith("image")) {
            if (string.startsWith("video/x-raw")) {
                return EncodingType.Encoding.RAWVIDEO;
            }
            if ("video/x-theora".equals(string)) {
                return EncodingType.Encoding.THEORA;
            }
            if ("video/mpeg".equals(string) || "video/ms-mpeg".equals(string)) {
                switch (gSTStreamInfo.getVersion()) {
                    case 1: {
                        return EncodingType.Encoding.MPEG1VIDEO;
                    }
                    case 2: {
                        return EncodingType.Encoding.MPEG2VIDEO;
                    }
                    case 4: {
                        return EncodingType.Encoding.MSMPEG4;
                    }
                }
            } else if ("video/x-wmv".equals(string)) {
                switch (gSTStreamInfo.getVersion()) {
                    case 1: {
                        return EncodingType.Encoding.WMVIDEO7;
                    }
                    case 2: {
                        return EncodingType.Encoding.WMVIDEO8;
                    }
                    case 3: {
                        return EncodingType.Encoding.WMVIDEO9;
                    }
                }
            } else if ("video/x-divx".equals(string)) {
                switch (gSTStreamInfo.getVersion()) {
                    case 3: 
                    case 4: {
                        return EncodingType.Encoding.DIVX;
                    }
                    case 5: {
                        return EncodingType.Encoding.DIVX5;
                    }
                }
            } else {
                if ("video/x-h263".equals(string)) {
                    return EncodingType.Encoding.H263;
                }
                if ("video/x-h264".equals(string)) {
                    return EncodingType.Encoding.H264;
                }
                if ("video/x-vp5".equals(string)) {
                    return EncodingType.Encoding.VP5;
                }
                if ("video/x-vp6".equals(string) || "video/x-vp6-flash".equals(string)) {
                    return EncodingType.Encoding.VP6;
                }
                if ("image/jpeg".equals(string)) {
                    return EncodingType.Encoding.MJPEG;
                }
                if ("video/x-indeo".equals(string)) {
                    switch (gSTStreamInfo.getVersion()) {
                        case 2: {
                            return EncodingType.Encoding.INDEO2;
                        }
                        case 3: {
                            return EncodingType.Encoding.INDEO3;
                        }
                        case 4: {
                            return EncodingType.Encoding.INDEO4;
                        }
                        case 5: {
                            return EncodingType.Encoding.INDEO5;
                        }
                    }
                }
            }
        }
        return EncodingType.Encoding.CUSTOM;
    }

    static ContainerType.Container getContainer(String string) {
        if ("video/x-msvideo".equals(string)) {
            return ContainerType.Container.AVI;
        }
        if ("application/x-shockwave-flash".equals(string)) {
            return ContainerType.Container.SWF;
        }
        if ("video/quicktime".equals(string)) {
            return ContainerType.Container.MOV;
        }
        if ("application/ogg".equals(string)) {
            return ContainerType.Container.OGG;
        }
        if ("video/x-ms-asf".equals(string)) {
            return ContainerType.Container.ASF;
        }
        if ("video/x-flv".equals(string)) {
            return ContainerType.Container.FLV;
        }
        if ("video/mpeg".equals(string) || "audio/mpeg".equals(string) || "application/x-id3".equals(string)) {
            return ContainerType.Container.MPEG1;
        }
        if ("audio/x-wav".equals(string)) {
            return ContainerType.Container.WAVE;
        }
        if ("audio/x-m4a".equals(string)) {
            return ContainerType.Container.MP4;
        }
        if ("application/x-3gp".equals(string)) {
            return ContainerType.Container.THREEGP;
        }
        return ContainerType.Container.CUSTOM;
    }

    static URI normalize(URI uRI) {
        try {
            String string = uRI.getHost() != null ? uRI.getHost() : "";
            return new URI(uRI.getScheme(), uRI.getUserInfo(), string, uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRI;
        }
    }
}

