/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.ToolkitAccessor;
import com.sun.scenario.animation.Animation;
import com.sun.scenario.animation.Clip;
import com.sun.scenario.animation.FrameJob;
import com.sun.scenario.animation.RunQueue;
import java.util.ArrayList;

public abstract class AbstractMasterTimer {
    protected final boolean useNanoTime = this.shouldUseNanoTime();
    protected static final String NOGAPS_PROP = "com.sun.scenario.animation.nogaps";
    protected static boolean nogaps = false;
    protected static final String FULLSPEED_PROP = "com.sun.scenario.animation.fullspeed";
    protected static boolean fullspeed = false;
    protected static final String HIRES_PROP = "com.sun.scenario.animation.hires";
    protected static boolean hires = true;
    protected static final String ADAPTIVE_PULSE_PROP = "com.sun.scenario.animation.adaptivepulse";
    protected static boolean useAdaptivePulse = false;
    protected static final String PULSE_PROP = "com.sun.scenario.animation.pulse";
    protected static final String FRAMERATE_PROP = "javafx.animation.framerate";
    protected static final String ANIMATION_MBEAN_ENABLED = "com.sun.scenario.animation.AnimationMBean.enabled";
    protected static final boolean enableAnimationMBean = false;
    protected final int PULSE_DURATION = this.getPulseDuration(1000);
    protected final int PULSE_DURATION_NS = this.getPulseDuration(1000000000);
    private static final FrameJob[] emptyJobs = new FrameJob[0];
    private final MainLoop theMaster = new MainLoop();
    private final RunQueue waitList = new RunQueue();
    private final RunQueue pauseWaitList = new RunQueue();
    private final ArrayList<FrameJob> frameJobList = new ArrayList();
    private FrameJob[] frameJobs = emptyJobs;
    private final RunQueue runList = new RunQueue();

    protected abstract boolean shouldUseNanoTime();

    protected AbstractMasterTimer() {
    }

    protected long milliTimeImpl() {
        if (this.useNanoTime) {
            return System.nanoTime() / 1000L / 1000L;
        }
        return System.currentTimeMillis();
    }

    protected long nanoTimeImpl() {
        if (this.useNanoTime) {
            return System.nanoTime();
        }
        return System.currentTimeMillis() * 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isIdleImpl() {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            return this.runList.isEmpty() && this.waitList.isEmpty() && this.pauseWaitList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRunQueueImpl(Clip clip, long l) {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            this.waitList.remove(clip);
            this.pauseWaitList.remove(clip);
            this.waitList.insert(clip, l);
            this.theMaster.setClipsReady(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromRunQueueImpl(Clip clip) {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            this.waitList.remove(clip);
            this.pauseWaitList.remove(clip);
        }
    }

    protected synchronized void addFrameJobImpl(FrameJob frameJob) {
        this.frameJobList.add(frameJob);
        this.updateFrameJobs();
    }

    private void updateFrameJobs() {
        this.frameJobs = new FrameJob[this.frameJobList.size()];
        System.arraycopy(this.frameJobList.toArray(), 0, this.frameJobs, 0, this.frameJobs.length);
    }

    protected synchronized void removeFrameJobImpl(FrameJob frameJob) {
        if (this.frameJobList.remove(frameJob)) {
            this.updateFrameJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopImpl(Clip clip) {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            RunQueue runQueue2 = (RunQueue)this.pauseWaitList.remove(clip);
            if (runQueue2 != null) {
                runQueue2.stop(this.milliTimeImpl());
                this.waitList.insert(runQueue2);
                this.theMaster.setClipsReady(true);
            } else {
                runQueue2 = (RunQueue)this.runList.find(clip);
                if (runQueue2 != null) {
                    runQueue2.stop(this.milliTimeImpl());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pauseImpl(Clip clip) {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            RunQueue runQueue2 = (RunQueue)this.waitList.find(clip);
            if (runQueue2 != null && runQueue2.getStatus() == Animation.Status.SCHEDULED) {
                runQueue2.pause(this.milliTimeImpl());
                return false;
            }
            runQueue2 = (RunQueue)this.waitList.remove(clip);
            if (runQueue2 != null) {
                this.pauseWaitList.prepend(runQueue2);
            } else {
                runQueue2 = (RunQueue)this.runList.find(clip);
            }
            if (runQueue2 != null) {
                if (runQueue2.getStatus() == Animation.Status.SCHEDULEPAUSED) {
                    Animation.Status status = runQueue2.began();
                    return true;
                }
                Animation.Status status = runQueue2.getStatus();
                runQueue2.pause(this.milliTimeImpl());
                return runQueue2.getStatus() != status;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resumeImpl(Clip clip) {
        RunQueue runQueue = this.waitList;
        synchronized (runQueue) {
            RunQueue runQueue2 = (RunQueue)this.waitList.find(clip);
            if (runQueue2 != null && runQueue2.getStatus() == Animation.Status.SCHEDULEPAUSED) {
                runQueue2.resume(this.milliTimeImpl());
                return false;
            }
            runQueue2 = (RunQueue)this.pauseWaitList.remove(clip);
            if (runQueue2 != null) {
                Animation.Status status = runQueue2.getStatus();
                runQueue2.resume(this.milliTimeImpl());
                this.waitList.insert(runQueue2);
                this.theMaster.setClipsReady(true);
                return runQueue2.getStatus() != status;
            }
            runQueue2 = (RunQueue)this.runList.find(clip);
            if (runQueue2 != null) {
                Animation.Status status = runQueue2.getStatus();
                runQueue2.resume(this.milliTimeImpl());
                return runQueue2.getStatus() != status;
            }
            return false;
        }
    }

    protected void notifyJobsReadyImpl() {
        this.theMaster.setJobsReady(true);
    }

    protected void recordStart(long l) {
    }

    protected void recordEnd() {
    }

    protected void recordAnimationEnd() {
    }

    protected abstract void postUpdateAnimationRunnable(DelayedRunnable var1);

    protected abstract int getPulseDuration(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timePulseImpl(long l) {
        RunQueue runQueue;
        if (this.runList.isEmpty()) {
            runQueue = this.waitList;
            synchronized (runQueue) {
                long l2;
                if (this.waitList.isEmpty()) {
                    this.theMaster.setClipsReady(false);
                } else if (nogaps && l < (l2 = ((RunQueue)this.waitList.next).getTime())) {
                    long l3 = l - l2;
                    for (FrameJob[] frameJobArray : this.waitList) {
                        frameJobArray.adjustStartTime(l3);
                    }
                }
            }
        }
        runQueue = this.runList;
        RunQueue runQueue2 = (RunQueue)runQueue.next;
        while (true) {
            if (runQueue2 != null) {
                if (AbstractMasterTimer.process(runQueue2, l)) {
                    runQueue.next = runQueue2.next;
                } else {
                    runQueue = runQueue2;
                }
                runQueue2 = (RunQueue)runQueue.next;
                continue;
            }
            if (this.waitList.next != null) {
                this.appendStartingClips(runQueue, l);
                runQueue2 = (RunQueue)runQueue.next;
            }
            if (runQueue2 == null) break;
        }
        this.recordAnimationEnd();
        this.theMaster.setJobsReady(false);
        FrameJob[] frameJobArray = this.frameJobs;
        for (int i = 0; i < frameJobArray.length; ++i) {
            FrameJob frameJob = frameJobArray[i];
            try {
                frameJob.run();
                continue;
            }
            catch (Error error) {
                if ("com.sun.javafx.runtime.FXExit".equals(error.getClass().getName())) {
                    for (FrameJob frameJob2 : frameJobArray) {
                        this.removeFrameJobImpl(frameJob2);
                    }
                    break;
                }
                System.err.println("Unexpected exception caught in MasterTimer.timePulse():");
                error.printStackTrace();
                this.removeFrameJobImpl(frameJob);
                continue;
            }
            catch (Throwable throwable) {
                System.err.println("Unexpected exception caught in MasterTimer.timePulse():");
                throwable.printStackTrace();
                this.removeFrameJobImpl(frameJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendStartingClips(RunQueue runQueue, long l) {
        RunQueue runQueue2 = this.waitList;
        synchronized (runQueue2) {
            RunQueue runQueue3 = null;
            RunQueue runQueue4 = (RunQueue)this.waitList.next;
            while (runQueue4 != null && runQueue4.getTime() <= l) {
                runQueue3 = runQueue4;
                runQueue4 = (RunQueue)runQueue4.next;
            }
            if (runQueue3 != null) {
                runQueue3.next = null;
                runQueue.next = this.waitList.next;
                this.waitList.next = runQueue4;
            }
        }
    }

    private static boolean process(RunQueue runQueue, long l) {
        Clip clip = (Clip)runQueue.getAnimation();
        Animation.Status status = runQueue.getStatus();
        try {
            while (true) {
                switch (status) {
                    case RUNNING: {
                        long l2 = l - runQueue.getTime();
                        int n = (int)(l2 - clip.getLastPulse());
                        int n2 = clip.getResolution();
                        int n3 = ToolkitAccessor.getMasterTimer().PULSE_DURATION;
                        if (n2 == n3 || n >= n2) {
                            status = clip.timePulse(l2);
                        }
                        if (status != Animation.Status.RUNNING) break;
                        return false;
                    }
                    case SCHEDULED: {
                        clip.begin();
                        clip.scheduleBeginAnimations(runQueue.getTime());
                        status = runQueue.began();
                        break;
                    }
                    case SCHEDULEPAUSED: {
                        clip.begin();
                        clip.scheduleBeginAnimations(runQueue.getTime());
                        clip.pause();
                        status = runQueue.getStatus();
                        return false;
                    }
                    case PAUSED: {
                        return false;
                    }
                    case STOPPED: {
                        clip.end();
                        clip.scheduleEndAnimations(l);
                    }
                    case CANCELED: {
                        return true;
                    }
                }
            }
        }
        catch (Error error) {
            if (!"com.sun.javafx.runtime.FXExit".equals(error.getClass().getName())) {
                System.err.println("Unexpected exception caught in MasterTimer.process():");
                error.printStackTrace();
            }
            return true;
        }
        catch (Throwable throwable) {
            System.err.println("Unexpected exception caught in MasterTimer.process():");
            throwable.printStackTrace();
            return true;
        }
    }

    static long milliTime() {
        return ToolkitAccessor.getMasterTimer().milliTimeImpl();
    }

    static long nanoTime() {
        return ToolkitAccessor.getMasterTimer().nanoTimeImpl();
    }

    static boolean isIdle() {
        return ToolkitAccessor.getMasterTimer().isIdleImpl();
    }

    static void addFrameJob(FrameJob frameJob) {
        ToolkitAccessor.getMasterTimer().addFrameJobImpl(frameJob);
    }

    static void removeFrameJob(FrameJob frameJob) {
        ToolkitAccessor.getMasterTimer().removeFrameJobImpl(frameJob);
    }

    static void notifyJobsReady() {
        ToolkitAccessor.getMasterTimer().notifyJobsReadyImpl();
    }

    static void addToRunQueue(Clip clip, long l) {
        ToolkitAccessor.getMasterTimer().addToRunQueueImpl(clip, l);
    }

    static void removeFromRunQueue(Clip clip) {
        ToolkitAccessor.getMasterTimer().removeFromRunQueueImpl(clip);
    }

    static void stop(Clip clip) {
        ToolkitAccessor.getMasterTimer().stopImpl(clip);
    }

    static boolean pause(Clip clip) {
        return ToolkitAccessor.getMasterTimer().pauseImpl(clip);
    }

    static boolean resume(Clip clip) {
        return ToolkitAccessor.getMasterTimer().resumeImpl(clip);
    }

    static {
        nogaps = Settings.getBoolean(NOGAPS_PROP);
        fullspeed = Settings.getBoolean(FULLSPEED_PROP);
        useAdaptivePulse = Settings.getBoolean(ADAPTIVE_PULSE_PROP, useAdaptivePulse);
        int n = Settings.getInt(PULSE_PROP, -1);
        if (n != -1) {
            System.err.println("Setting PULSE_DURATION to " + n + " hz");
        }
    }

    private final class MainLoop
    implements DelayedRunnable {
        private boolean clipsReady;
        private boolean jobsReady;
        private long nextPulseTime = Integer.MIN_VALUE;
        private long lastPulseDuration = Integer.MIN_VALUE;

        private MainLoop() {
        }

        public void run() {
            long l = AbstractMasterTimer.this.nanoTimeImpl();
            AbstractMasterTimer.this.recordStart(this.nextPulseTime - AbstractMasterTimer.this.milliTimeImpl());
            AbstractMasterTimer.this.timePulseImpl(AbstractMasterTimer.this.milliTimeImpl());
            AbstractMasterTimer.this.recordEnd();
            this.updateNextPulseTime(l);
            this.updateAnimationRunnable();
        }

        public long getDelay() {
            if (this.nextPulseTime == Integer.MIN_VALUE) {
                this.updateNextPulseTime(AbstractMasterTimer.this.nanoTimeImpl());
            }
            long l = this.nextPulseTime - AbstractMasterTimer.this.milliTimeImpl();
            return Math.max(0L, l);
        }

        private void updateNextPulseTime(long l) {
            this.nextPulseTime = AbstractMasterTimer.this.milliTimeImpl();
            if (!fullspeed) {
                if (useAdaptivePulse) {
                    this.nextPulseTime += (long)AbstractMasterTimer.this.PULSE_DURATION;
                    long l2 = AbstractMasterTimer.this.nanoTimeImpl() - l;
                    if (l2 - this.lastPulseDuration > 500000L) {
                        l2 /= 2L;
                    }
                    if (l2 < 2000000L) {
                        l2 = 2000000L;
                    }
                    if (l2 >= (long)AbstractMasterTimer.this.PULSE_DURATION_NS) {
                        l2 = 3 * AbstractMasterTimer.this.PULSE_DURATION_NS / 4;
                    }
                    this.lastPulseDuration = l2;
                    this.nextPulseTime -= l2 / 1000000L;
                } else {
                    this.nextPulseTime = (this.nextPulseTime + (long)AbstractMasterTimer.this.PULSE_DURATION) / (long)AbstractMasterTimer.this.PULSE_DURATION * (long)AbstractMasterTimer.this.PULSE_DURATION;
                }
            }
        }

        synchronized void setClipsReady(boolean bl) {
            if (this.clipsReady != bl) {
                this.clipsReady = bl;
                this.updateAnimationRunnable();
            }
        }

        synchronized void setJobsReady(boolean bl) {
            if (this.jobsReady != bl) {
                this.jobsReady = bl;
                this.updateAnimationRunnable();
            }
        }

        private synchronized void updateAnimationRunnable() {
            MainLoop mainLoop = null;
            if (this.jobsReady || this.clipsReady) {
                mainLoop = this;
            }
            AbstractMasterTimer.this.postUpdateAnimationRunnable(mainLoop);
        }
    }
}

