/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.AbstractShadow;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.GaussianShadow;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxShadowState;

public class BoxShadow
extends AbstractShadow {
    private final BoxShadowState state = new BoxShadowState();

    public BoxShadow() {
        this(1, 1);
    }

    public BoxShadow(int n, int n2) {
        this(n, n2, 1, DefaultInput);
    }

    public BoxShadow(int n, int n2, int n3) {
        this(n, n2, n3, DefaultInput);
    }

    public BoxShadow(int n, int n2, int n3, Effect effect) {
        super(effect);
        this.setHorizontalSize(n);
        this.setVerticalSize(n2);
        this.setPasses(n3);
        this.setColor(Color4f.BLACK);
        this.setSpread(0.0f);
    }

    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    public int getHorizontalSize() {
        return this.state.getHsize();
    }

    public void setHorizontalSize(int n) {
        int n2 = this.state.getHsize();
        this.state.setHsize(n);
        this.firePropertyChange("hsize", n2, n);
    }

    public int getVerticalSize() {
        return this.state.getVsize();
    }

    public void setVerticalSize(int n) {
        int n2 = this.state.getVsize();
        this.state.setVsize(n);
        this.firePropertyChange("vsize", n2, n);
    }

    public int getPasses() {
        return this.state.getBlurPasses();
    }

    public void setPasses(int n) {
        int n2 = this.state.getBlurPasses();
        this.state.setBlurPasses(n);
        this.firePropertyChange("passes", n2, n);
    }

    public Color4f getColor() {
        return this.state.getShadowColor();
    }

    public void setColor(Color4f color4f) {
        Color4f color4f2 = this.state.getShadowColor();
        this.state.setShadowColor(color4f);
        this.firePropertyChange("color", color4f2, color4f);
    }

    public float getSpread() {
        return this.state.getSpread();
    }

    public void setSpread(float f) {
        float f2 = this.state.getSpread();
        this.state.setSpread(f);
        this.firePropertyChange("spread", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getGaussianRadius() {
        float f = (float)(this.getHorizontalSize() + this.getVerticalSize()) / 2.0f;
        return (f *= 3.0f) < 1.0f ? 0.0f : (f - 1.0f) / 2.0f;
    }

    public float getGaussianWidth() {
        return (float)this.getHorizontalSize() * 3.0f;
    }

    public float getGaussianHeight() {
        return (float)this.getVerticalSize() * 3.0f;
    }

    public void setGaussianRadius(float f) {
        float f2 = f * 2.0f + 1.0f;
        this.setGaussianWidth(f2);
        this.setGaussianHeight(f2);
    }

    public void setGaussianWidth(float f) {
        this.setHorizontalSize(Math.round(f /= 3.0f));
    }

    public void setGaussianHeight(float f) {
        this.setVerticalSize(Math.round(f /= 3.0f));
    }

    public AbstractShadow.ShadowMode getMode() {
        switch (this.getPasses()) {
            case 1: {
                return AbstractShadow.ShadowMode.ONE_PASS_BOX;
            }
            case 2: {
                return AbstractShadow.ShadowMode.TWO_PASS_BOX;
            }
        }
        return AbstractShadow.ShadowMode.THREE_PASS_BOX;
    }

    public AbstractShadow implFor(AbstractShadow.ShadowMode shadowMode) {
        switch (shadowMode) {
            case GAUSSIAN: {
                GaussianShadow gaussianShadow = new GaussianShadow();
                gaussianShadow.setInput(this.getInput());
                gaussianShadow.setGaussianWidth(this.getGaussianWidth());
                gaussianShadow.setGaussianHeight(this.getGaussianHeight());
                gaussianShadow.setColor(this.getColor());
                gaussianShadow.setSpread(this.getSpread());
                return gaussianShadow;
            }
            case ONE_PASS_BOX: {
                this.setPasses(1);
                break;
            }
            case TWO_PASS_BOX: {
                this.setPasses(2);
                break;
            }
            case THREE_PASS_BOX: {
                this.setPasses(3);
            }
        }
        return this;
    }

    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Renderer.getRenderer(filterContext).getAccelType();
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        Bounds2D bounds2D = super.getBounds(null, effect);
        int n = this.state.getKernelSize(0) / 2;
        int n2 = this.state.getKernelSize(1) / 2;
        Bounds2D bounds2D2 = new Bounds2D(bounds2D);
        bounds2D2.grow(n, n2);
        return BoxShadow.transformBounds(baseTransform, bounds2D2);
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        Rectangle rectangle = imageDataArray[0].getBounds();
        rectangle = this.state.getResultBounds(rectangle, 0);
        rectangle = this.state.getResultBounds(rectangle, 1);
        return rectangle;
    }

    public ImageData filterImageDatas(FilterContext filterContext, BaseTransform baseTransform, ImageData ... imageDataArray) {
        return this.state.filterImageDatas(this, filterContext, baseTransform, imageDataArray);
    }

    public boolean operatesInUserSpace() {
        return true;
    }
}

