/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.AbstractShadow;
import com.sun.scenario.effect.BoxShadow;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.GaussianShadowState;

public class GaussianShadow
extends AbstractShadow {
    private GaussianShadowState state = new GaussianShadowState();

    public GaussianShadow() {
        this(10.0f);
    }

    public GaussianShadow(float f) {
        this(f, Color4f.BLACK);
    }

    public GaussianShadow(float f, Color4f color4f) {
        this(f, color4f, DefaultInput);
    }

    public GaussianShadow(float f, Color4f color4f, Effect effect) {
        super(effect);
        this.state.setRadius(f);
        this.state.setShadowColor(color4f);
    }

    Object getState() {
        return this.state;
    }

    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Renderer.getRenderer(filterContext).getAccelType();
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    public float getRadius() {
        return this.state.getRadius();
    }

    public void setRadius(float f) {
        float f2 = this.state.getRadius();
        this.state.setRadius(f);
        this.firePropertyChange("radius", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getHRadius() {
        return this.state.getHRadius();
    }

    public void setHRadius(float f) {
        float f2 = this.state.getHRadius();
        this.state.setHRadius(f);
        this.firePropertyChange("hradius", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getVRadius() {
        return this.state.getVRadius();
    }

    public void setVRadius(float f) {
        float f2 = this.state.getVRadius();
        this.state.setVRadius(f);
        this.firePropertyChange("vradius", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getSpread() {
        return this.state.getSpread();
    }

    public void setSpread(float f) {
        float f2 = this.state.getSpread();
        this.state.setSpread(f);
        this.firePropertyChange("spread", Float.valueOf(f2), Float.valueOf(f));
    }

    public Color4f getColor() {
        return this.state.getShadowColor();
    }

    public void setColor(Color4f color4f) {
        Color4f color4f2 = this.state.getShadowColor();
        this.state.setShadowColor(color4f);
        this.firePropertyChange("color", color4f2, color4f);
    }

    public float getGaussianRadius() {
        return this.getRadius();
    }

    public float getGaussianWidth() {
        return this.getHRadius() * 2.0f + 1.0f;
    }

    public float getGaussianHeight() {
        return this.getVRadius() * 2.0f + 1.0f;
    }

    public void setGaussianRadius(float f) {
        this.setRadius(f);
    }

    public void setGaussianWidth(float f) {
        this.setHRadius(f < 1.0f ? 0.0f : (f - 1.0f) / 2.0f);
    }

    public void setGaussianHeight(float f) {
        this.setVRadius(f < 1.0f ? 0.0f : (f - 1.0f) / 2.0f);
    }

    public AbstractShadow.ShadowMode getMode() {
        return AbstractShadow.ShadowMode.GAUSSIAN;
    }

    public AbstractShadow implFor(AbstractShadow.ShadowMode shadowMode) {
        int n = 0;
        switch (shadowMode) {
            case GAUSSIAN: {
                return this;
            }
            case ONE_PASS_BOX: {
                n = 1;
                break;
            }
            case TWO_PASS_BOX: {
                n = 2;
                break;
            }
            case THREE_PASS_BOX: {
                n = 3;
            }
        }
        BoxShadow boxShadow = new BoxShadow();
        boxShadow.setInput(this.getInput());
        boxShadow.setGaussianWidth(this.getGaussianWidth());
        boxShadow.setGaussianHeight(this.getGaussianHeight());
        boxShadow.setColor(this.getColor());
        boxShadow.setPasses(n);
        boxShadow.setSpread(this.getSpread());
        return boxShadow;
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        Bounds2D bounds2D = super.getBounds(null, effect);
        int n = this.state.getPad(0);
        int n2 = this.state.getPad(1);
        Bounds2D bounds2D2 = new Bounds2D(bounds2D);
        bounds2D2.grow(n, n2);
        return GaussianShadow.transformBounds(baseTransform, bounds2D2);
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        Rectangle rectangle = super.getResultBounds(baseTransform, imageDataArray);
        int n = this.state.getPad(0);
        int n2 = this.state.getPad(1);
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(n, n2);
        return rectangle2;
    }

    public ImageData filterImageDatas(FilterContext filterContext, BaseTransform baseTransform, ImageData ... imageDataArray) {
        return this.state.filterImageDatas(this, filterContext, baseTransform, imageDataArray);
    }

    public boolean operatesInUserSpace() {
        return true;
    }
}

