/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.GaussianShadow;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.light.Light;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PhongLighting
extends CoreEffect {
    private float surfaceScale = 1.0f;
    private float diffuseConstant = 1.0f;
    private float specularConstant = 1.0f;
    private float specularExponent = 1.0f;
    private Light light;
    private final PropertyChangeListener lightListener = new LightChangeListener();

    public PhongLighting(Light light) {
        this(light, new GaussianShadow(10.0f), DefaultInput);
    }

    public PhongLighting(Light light, Effect effect, Effect effect2) {
        super(effect, effect2);
        this.setLight(light);
    }

    public final Effect getBumpInput() {
        return this.getInputs().get(0);
    }

    public void setBumpInput(Effect effect) {
        this.setInput(0, effect);
    }

    public final Effect getContentInput() {
        return this.getInputs().get(1);
    }

    private Effect getContentInput(Effect effect) {
        return this.getDefaultedInput(1, effect);
    }

    public void setContentInput(Effect effect) {
        this.setInput(1, effect);
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        if (light == null) {
            throw new IllegalArgumentException("Light must be non-null");
        }
        Light light2 = this.light;
        if (light2 != null) {
            light2.removePropertyChangeListener(this.lightListener);
        }
        this.light = light;
        this.light.addPropertyChangeListener(this.lightListener);
        this.updatePeerKey("PhongLighting_" + light.getType().name());
        this.firePropertyChange("light", light2, light);
    }

    public float getDiffuseConstant() {
        return this.diffuseConstant;
    }

    public void setDiffuseConstant(float f) {
        if (f < 0.0f || f > 2.0f) {
            throw new IllegalArgumentException("Diffuse constant must be in the range [0,2]");
        }
        float f2 = this.diffuseConstant;
        this.diffuseConstant = f;
        this.firePropertyChange("diffuseConstant", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getSpecularConstant() {
        return this.specularConstant;
    }

    public void setSpecularConstant(float f) {
        if (f < 0.0f || f > 2.0f) {
            throw new IllegalArgumentException("Specular constant must be in the range [0,2]");
        }
        float f2 = this.specularConstant;
        this.specularConstant = f;
        this.firePropertyChange("specularConstant", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(float f) {
        if (f < 0.0f || f > 40.0f) {
            throw new IllegalArgumentException("Specular exponent must be in the range [0,40]");
        }
        float f2 = this.specularExponent;
        this.specularExponent = f;
        this.firePropertyChange("specularExponent", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getSurfaceScale() {
        return this.surfaceScale;
    }

    public void setSurfaceScale(float f) {
        if (f < 0.0f || f > 10.0f) {
            throw new IllegalArgumentException("Surface scale must be in the range [0,10]");
        }
        float f2 = this.surfaceScale;
        this.surfaceScale = f;
        this.firePropertyChange("surfaceScale", Float.valueOf(f2), Float.valueOf(f));
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        return this.getContentInput(effect).getBounds(baseTransform, effect);
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        return super.getResultBounds(baseTransform, imageDataArray[1]);
    }

    public Point2D transform(Point2D point2D, Effect effect) {
        return this.getContentInput(effect).transform(point2D, effect);
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return this.getContentInput(effect).untransform(point2D, effect);
    }

    private class LightChangeListener
    implements PropertyChangeListener {
        private LightChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhongLighting.this.firePropertyChange("light", null, PhongLighting.this.light);
        }
    }
}

