/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d.rsl;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.hw.RendererDelegate;
import com.sun.scenario.effect.impl.j2d.J2DRenderer;
import com.sun.scenario.effect.impl.j2d.rsl.RSLEffectPeer;
import com.sun.scenario.effect.impl.j2d.rsl.RSLImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.AppContext;
import sun.java2d.DestSurfaceProvider;
import sun.java2d.Surface;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelGraphicsConfig;
import sun.java2d.pipe.hw.AccelSurface;

public class RSLRenderer
extends J2DRenderer {
    private final GraphicsConfiguration config;
    private final RendererDelegate delegate;
    private Renderer.RendererState state;
    private Renderer backupRenderer;
    private final AccelDeviceEventListener listener = new AccelDeviceEventListener(){

        public void onDeviceReset() {
            RSLRenderer.this.dispose();
        }

        public void onDeviceDispose() {
            RSLRenderer.this.dispose();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSLRenderer(final GraphicsConfiguration graphicsConfiguration, RendererDelegate rendererDelegate) {
        this.config = graphicsConfiguration;
        this.delegate = rendererDelegate;
        this.delegate.setListener(new RendererDelegate.Listener(){

            public void markLost() {
                RSLRenderer.this.markLost();
            }
        });
        RSLRenderer rSLRenderer = this;
        synchronized (rSLRenderer) {
            this.state = Renderer.RendererState.OK;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                final AppContext appContext = AppContext.getAppContext();
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        final 1 var2_2 = this;
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    RSLRenderer.this.dispose();
                                    appContext.removePropertyChangeListener("disposed", var2_2);
                                    return null;
                                }
                            });
                        }
                    }
                };
                appContext.addPropertyChangeListener("disposed", propertyChangeListener);
                AccelGraphicsConfig accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration);
                accelGraphicsConfig.addDeviceEventListener(RSLRenderer.this.listener);
                return null;
            }
        });
    }

    public Effect.AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    public RendererDelegate getDelegate() {
        return this.delegate;
    }

    public synchronized Renderer.RendererState getRendererState() {
        return this.state;
    }

    protected Renderer getBackupRenderer() {
        if (this.backupRenderer == null) {
            this.backupRenderer = RSLRenderer.getSoftwareRenderer();
        }
        return this.backupRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.delegate.dispose();
        for (EffectPeer effectPeer : this.getPeers()) {
            effectPeer.dispose();
        }
        Object object = this;
        synchronized (object) {
            this.state = Renderer.RendererState.DISPOSED;
        }
        object = (AccelGraphicsConfig)((Object)this.config);
        object.removeDeviceEventListener(this.listener);
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer.RendererState.OK) {
            this.state = Renderer.RendererState.LOST;
        }
    }

    public final RSLImage createCompatibleImage(final int n, final int n2) {
        return AccessController.doPrivileged(new PrivilegedAction<RSLImage>(){

            @Override
            public RSLImage run() {
                AccelGraphicsConfig accelGraphicsConfig = (AccelGraphicsConfig)((Object)RSLRenderer.this.config);
                VolatileImage volatileImage = null;
                try {
                    volatileImage = accelGraphicsConfig.createCompatibleVolatileImage(n, n2, 3, 5);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (volatileImage != null) {
                    int n3 = volatileImage.validate(RSLRenderer.this.config);
                    if (n3 == 0 || n3 == 1) {
                        Graphics2D graphics2D = volatileImage.createGraphics();
                        graphics2D.setComposite(AlphaComposite.Clear);
                        graphics2D.fillRect(0, 0, n, n2);
                        graphics2D.dispose();
                        return RSLImage.create(volatileImage);
                    }
                    volatileImage.flush();
                    volatileImage = null;
                }
                return null;
            }
        });
    }

    public RSLImage getCompatibleImage(int n, int n2) {
        RSLImage rSLImage = (RSLImage)super.getCompatibleImage(n, n2);
        if (rSLImage == null) {
            this.markLost();
        }
        return rSLImage;
    }

    public Object createFloatTexture(int n, int n2) {
        return this.delegate.createFloatTexture(n, n2);
    }

    public void updateFloatTexture(Object object, FloatMap floatMap) {
        this.delegate.updateFloatTexture(object, floatMap);
    }

    private static String getHwPrefix(GraphicsConfiguration graphicsConfiguration) {
        String string = graphicsConfiguration.getClass().getSimpleName();
        if (string.startsWith("WGL") || string.startsWith("GLX")) {
            return "com.sun.scenario.effect.impl.hw.ogl.OGL";
        }
        if (string.startsWith("D3D")) {
            return "com.sun.scenario.effect.impl.hw.d3d.D3D";
        }
        return null;
    }

    private static boolean isHwValid(final GraphicsConfiguration graphicsConfiguration) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (graphicsConfiguration instanceof AccelGraphicsConfig) {
                    AccelGraphicsConfig accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration);
                    int n = accelGraphicsConfig.getContextCapabilities().getCaps();
                    return (n & 0x100) != 0;
                }
                return false;
            }
        });
    }

    private static RendererDelegate createOGLDelegate(GraphicsConfiguration graphicsConfiguration) {
        block6: {
            GenericDeclaration genericDeclaration;
            Object object;
            try {
                object = Class.forName("com.sun.opengl.impl.awt.Java2D");
                genericDeclaration = ((Class)object).getMethod("getShareContext", GraphicsDevice.class);
                ((Method)genericDeclaration).invoke(null, graphicsConfiguration.getDevice());
            }
            catch (Throwable throwable) {
                if (verbose) {
                    System.err.println("Error initializing Java2D/JOGL bridge:");
                    throwable.printStackTrace();
                }
                return null;
            }
            object = RSLRenderer.getHwPrefix(graphicsConfiguration);
            try {
                genericDeclaration = Class.forName((String)object + "RendererDelegate");
                return (RendererDelegate)((Class)genericDeclaration).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println((String)object + "RendererDelegate class not found");
            }
            catch (Throwable throwable) {
                if (!verbose) break block6;
                System.err.println("Error loading renderer:");
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private static RendererDelegate createD3DDelegate(String string, long l) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string + "RendererDelegate");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(string + "RendererDelegate class not found");
            return null;
        }
        catch (Throwable throwable) {
            if (verbose) {
                System.err.println("Error loading renderer:");
                throwable.printStackTrace();
            }
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
            return (RendererDelegate)constructor.newInstance(l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RendererDelegate createD3DDelegate(GraphicsConfiguration graphicsConfiguration) {
        AccelGraphicsConfig accelGraphicsConfig;
        VolatileImage volatileImage;
        Object object;
        int n = 0;
        try {
            Class<?> clazz = Class.forName("sun.java2d.d3d.D3DSurfaceData", true, null);
            object = clazz.getField("D3D_DEVICE_RESOURCE");
            n = ((Field)object).getInt(null);
        }
        catch (Throwable throwable) {
            return null;
        }
        final int n2 = n;
        object = RSLRenderer.getHwPrefix(graphicsConfiguration);
        RendererDelegate rendererDelegate = null;
        if (graphicsConfiguration instanceof AccelGraphicsConfig && (volatileImage = (accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration)).createCompatibleVolatileImage(8, 8, 1, 3)) instanceof DestSurfaceProvider) {
            volatileImage.validate(graphicsConfiguration);
            DestSurfaceProvider destSurfaceProvider = (DestSurfaceProvider)((Object)volatileImage);
            Surface surface = destSurfaceProvider.getDestSurface();
            if (surface instanceof AccelSurface) {
                final BufferedContext bufferedContext = accelGraphicsConfig.getContext();
                RenderQueue renderQueue = bufferedContext.getRenderQueue();
                final AccelSurface accelSurface = (AccelSurface)surface;
                renderQueue.lock();
                try {
                    final RendererDelegate[] rendererDelegateArray = new RendererDelegate[]{null};
                    renderQueue.flushAndInvokeNow(new Runnable((String)object){
                        final /* synthetic */ String val$prefix;
                        {
                            this.val$prefix = string;
                        }

                        public void run() {
                            RSLEffectPeer.saveState(bufferedContext);
                            long l = accelSurface.getNativeResource(n2);
                            rendererDelegateArray[0] = RSLRenderer.createD3DDelegate(this.val$prefix, l);
                            RSLEffectPeer.restoreState(bufferedContext);
                        }
                    });
                    rendererDelegate = rendererDelegateArray[0];
                }
                finally {
                    renderQueue.unlock();
                }
            }
            volatileImage.flush();
            volatileImage = null;
        }
        return rendererDelegate;
    }

    public static RSLRenderer createRenderer(FilterContext filterContext) {
        final GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)filterContext.getReferent();
        final String string = RSLRenderer.getHwPrefix(graphicsConfiguration);
        if (string == null || !RSLRenderer.isHwValid(graphicsConfiguration)) {
            return null;
        }
        RendererDelegate rendererDelegate = AccessController.doPrivileged(new PrivilegedAction<RendererDelegate>(){

            @Override
            public RendererDelegate run() {
                if (string.endsWith("D3D")) {
                    return RSLRenderer.createD3DDelegate(graphicsConfiguration);
                }
                return RSLRenderer.createOGLDelegate(graphicsConfiguration);
            }
        });
        if (rendererDelegate == null) {
            return null;
        }
        return new RSLRenderer(graphicsConfiguration, rendererDelegate);
    }

    protected EffectPeer createPlatformPeer(FilterContext filterContext, String string, int n) {
        EffectPeer effectPeer;
        String string2 = string;
        if (n > 0) {
            string2 = string2 + "_" + n;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.j2d.rsl.RSL" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string2);
        }
        catch (Exception exception) {
            System.err.println("Error: hardware peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return effectPeer;
    }

    public boolean isImageDataCompatible(final ImageData imageData) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Image image = (Image)imageData.getImage().getData();
                return RSLRenderer.this.getRendererState() == Renderer.RendererState.OK && image instanceof VolatileImage && ((VolatileImage)image).validate(RSLRenderer.this.config) == 0 && image instanceof DestSurfaceProvider;
            }
        });
    }
}

