/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.scenegraph.SGNode;
import java.awt.Image;

class NodeEffectInput
extends Effect {
    private static final Bounds2D TEMP_BOUNDS = new Bounds2D();
    private SGNode node;
    private Bounds2D tempBounds = new Bounds2D();
    private ImageData cachedIdentityImageData;
    private ImageData cachedTransformedImageData;
    private BaseTransform cachedTransform;

    public NodeEffectInput() {
        this((SGNode)null);
    }

    public NodeEffectInput(SGNode sGNode) {
        this.setNode(sGNode);
    }

    public SGNode getNode() {
        return this.node;
    }

    public void setNode(SGNode sGNode) {
        if (this.node != sGNode) {
            this.node = sGNode;
            this.flush();
        }
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        Bounds2D bounds2D = new Bounds2D();
        this.node.getContentBounds(this.tempBounds, baseTransform);
        bounds2D.setBounds(this.tempBounds);
        return bounds2D;
    }

    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Effect effect) {
        if (baseTransform.isIdentity()) {
            if (this.cachedIdentityImageData != null && this.cachedIdentityImageData.validate(filterContext)) {
                this.cachedIdentityImageData.addref();
                return this.cachedIdentityImageData;
            }
        } else if (this.cachedTransformedImageData != null && this.cachedTransformedImageData.validate(filterContext) && this.cachedTransform.equals(baseTransform)) {
            this.cachedTransformedImageData.addref();
            return this.cachedTransformedImageData;
        }
        ImageData imageData = NodeEffectInput.getImageDataForNode(filterContext, this.node, true, baseTransform);
        if (baseTransform.isIdentity()) {
            this.flushIdentityImage();
            this.cachedIdentityImageData = imageData;
            this.cachedIdentityImageData.addref();
        } else {
            this.flushTransformedImage();
            this.cachedTransform = baseTransform.copy();
            this.cachedTransformedImageData = imageData;
            this.cachedTransformedImageData.addref();
        }
        return imageData;
    }

    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Effect.AccelType.INTRINSIC;
    }

    public void flushIdentityImage() {
        if (this.cachedIdentityImageData != null) {
            this.cachedIdentityImageData.unref();
            this.cachedIdentityImageData = null;
        }
    }

    public void flushTransformedImage() {
        if (this.cachedTransformedImageData != null) {
            this.cachedTransformedImageData.unref();
            this.cachedTransformedImageData = null;
        }
        this.cachedTransform = null;
    }

    public void flush() {
        this.flushIdentityImage();
        this.flushTransformedImage();
    }

    static ImageData getImageDataForNode(FilterContext filterContext, SGNode sGNode, boolean bl, BaseTransform baseTransform) {
        int n;
        Bounds2D bounds2D = bl ? sGNode.getContentBounds(TEMP_BOUNDS, baseTransform) : sGNode.getCompleteBounds(TEMP_BOUNDS, baseTransform);
        int n2 = (int)Math.floor(bounds2D.x1);
        int n3 = (int)Math.floor(bounds2D.y1);
        int n4 = (int)Math.ceil(bounds2D.x2) - n2;
        Filterable filterable = Effect.getCompatibleImage(filterContext, n4, n = (int)Math.ceil(bounds2D.y2) - n3);
        if (filterable == null) {
            return null;
        }
        Image image = (Image)filterable.getData();
        byte by = bl ? (byte)0 : 15;
        SGNode.renderToImage(sGNode, new Bounds2D(), baseTransform, n2, n3, n4, n, image, by);
        return new ImageData(filterContext, filterable, new Rectangle(n2, n3, n4, n));
    }
}

