/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGShape;
import com.sun.scenario.scenegraph.SGAbstractShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;

public abstract class SGAbstractGeometry
extends SGAbstractShape
implements PGShape {
    private Object antialiasingHint = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
    Shape cachedStrokeShape;

    protected void geomChanged(boolean bl) {
        this.cachedStrokeShape = null;
        super.geomChanged(bl);
    }

    protected void strokeChanged() {
        this.cachedStrokeShape = null;
        super.strokeChanged();
    }

    public Object getAntialiasingHint() {
        return this.antialiasingHint;
    }

    public void setAntialiasingHint(Object object) {
        if (!RenderingHints.KEY_ANTIALIASING.isCompatibleValue(object)) {
            throw new IllegalArgumentException("invalid hint");
        }
        if (this.antialiasingHint != object) {
            this.antialiasingHint = object;
            this.visualsChanged(true);
        }
    }

    public void setAntialiased(boolean bl) {
        if (bl) {
            this.setAntialiasingHint(RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.setAntialiasingHint(RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private static final boolean canSkipRendering(Paint paint) {
        if (paint instanceof Color) {
            return ((Color)paint).getAlpha() == 0;
        }
        return paint == null;
    }

    protected boolean isAARequiredForRendering(Graphics2D graphics2D, BaseTransform baseTransform) {
        return this.antialiasingHint == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void paint(Graphics2D graphics2D, BaseTransform baseTransform) {
        Shape shape = this.getShape();
        if (shape == null || this.mode == PGShape.Mode.EMPTY) {
            return;
        }
        if (this.isAARequiredForRendering(graphics2D, baseTransform)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.mode != PGShape.Mode.STROKE && !SGAbstractGeometry.canSkipRendering(this.fillPaint)) {
            graphics2D.setPaint(this.getFillPaint());
            this.fillShape(graphics2D, shape);
        }
        if (this.mode != PGShape.Mode.FILL && !SGAbstractGeometry.canSkipRendering(this.drawPaint)) {
            graphics2D.setPaint(this.getDrawPaint());
            graphics2D.setStroke(this.drawStroke);
            try {
                this.drawShape(graphics2D, shape);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void fillShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.fill(shape);
    }

    void drawShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.draw(shape);
    }

    Shape getStrokeShape() {
        if (this.cachedStrokeShape == null) {
            this.cachedStrokeShape = this.getDrawStroke().createStrokedShape(this.getShape());
        }
        return this.cachedStrokeShape;
    }
}

