/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.BaseNode;
import com.sun.javafx.sg.PGNode;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.j2d.J2DFilterContext;
import com.sun.scenario.scenegraph.EffectFilter;
import com.sun.scenario.scenegraph.JSGPanel;
import com.sun.scenario.scenegraph.SGCacheFilter;
import com.sun.scenario.scenegraph.SGGroup;
import com.sun.scenario.scenegraph.SGRectangle;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public abstract class SGNode
extends BaseNode {
    private static final AffineTransform TEMP_AT = new AffineTransform();
    private static final Affine2D TEMP_FXTX = new Affine2D();
    private static final double[] TMP_DARR = new double[8];
    static boolean CLEAR_DIRTY = true;
    String id;
    Object parent;
    Filters filters;
    static boolean warned3D;
    static final byte R_CONTENT = 0;
    static final byte R_EFFECT = 1;
    static final byte R_CACHE = 2;
    static final byte R_OPACITY = 4;
    static final byte R_CLIP = 8;
    static final byte R_EFFECT_AND_DOWN = 1;
    static final byte R_CACHE_AND_DOWN = 3;
    static final byte R_OPACITY_AND_DOWN = 7;
    static final byte R_CLIP_AND_DOWN = 15;
    static final byte R_ALL = 15;

    public final Bounds2D getCompleteBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (baseTransform.isIdentity()) {
            this.updateTxBounds();
            bounds2D.setBounds(this.cachedTxBounds);
            return bounds2D;
        }
        if (this.tx.isIdentity()) {
            return this.getClippedBounds(bounds2D, baseTransform);
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMyx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyy();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyt();
        BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.tx);
        this.getClippedBounds(bounds2D, baseTransform);
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6);
        }
        return bounds2D;
    }

    public final Bounds2D getClippedBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        bounds2D = this.filters != null ? this.filters.getBounds(this, bounds2D, baseTransform) : this.getContentBounds(bounds2D, baseTransform);
        return bounds2D;
    }

    public final Bounds2D getEffectBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.filters != null && this.filters.effectFilter != null) {
            return this.filters.effectFilter.getBounds(bounds2D, baseTransform);
        }
        return this.getContentBounds(bounds2D, baseTransform);
    }

    public final Bounds2D getContentBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            this.updateBounds();
            bounds2D.setBounds(this.cachedBounds);
            if (!baseTransform.isIdentity()) {
                float f = (float)baseTransform.getMxt();
                float f2 = (float)baseTransform.getMyt();
                bounds2D.x1 += f;
                bounds2D.x2 += f;
                bounds2D.y1 += f2;
                bounds2D.y2 += f2;
            }
            return bounds2D;
        }
        return this.computeBounds(bounds2D, baseTransform);
    }

    public final boolean contains(float f, float f2) {
        if (this.filters != null) {
            return this.filters.contains(this, f, f2);
        }
        return this.computeContains(f, f2);
    }

    public final boolean intersects(float f, float f2, float f3, float f4) {
        if (this.filters != null) {
            return this.filters.intersects(this, f, f2, f3, f4);
        }
        return this.computeIntersects(f, f2, f3, f4);
    }

    public final boolean getBoundsHaveChanged() {
        return this.boundsChanged;
    }

    public final void setBoundsHaveChanged(boolean bl) {
        this.boundsChanged = bl;
    }

    public final void setClipNode(PGNode pGNode) {
        if (this.filters != null) {
            this.filters.setClipNode((SGNode)pGNode, this);
            this.completeBoundsChanged(true);
        } else if (pGNode != null) {
            this.filters = new Filters();
            this.filters.setClipNode((SGNode)pGNode, this);
            this.completeBoundsChanged(true);
        }
    }

    public final void setCachedAsBitmap(boolean bl, PGNode.CacheHint cacheHint) {
        if (this.filters != null) {
            this.filters.setCached(bl, this, cacheHint);
            this.completeBoundsChanged(true);
        } else if (bl) {
            this.filters = new Filters();
            this.filters.setCached(bl, this, cacheHint);
            this.completeBoundsChanged(true);
        }
    }

    public final void setEffect(Object object) {
        if (this.filters != null) {
            this.filters.setEffect((Effect)object, this);
            this.completeBoundsChanged(true);
        } else if (object != null) {
            this.filters = new Filters();
            this.filters.setEffect((Effect)object, this);
            this.completeBoundsChanged(true);
        }
        this.invalidateCache();
    }

    public final void setOpacity(float f) {
        if (this.filters != null) {
            if (f == 0.0f && this.filters.opacity > 0.0f) {
                this.visualsChanged(true);
                this.filters.setOpacity(f);
            } else {
                this.filters.setOpacity(f);
                this.visualsChanged(true);
            }
        } else if (f < 1.0f) {
            this.visualsChanged(true);
            this.filters = new Filters();
            this.filters.setOpacity(f);
        }
    }

    public final void setTransformMatrix(BaseTransform baseTransform) {
        if (baseTransform.is2D()) {
            this.tx = this.tx.deriveWithNewTransform(baseTransform);
        } else {
            if (!warned3D) {
                System.out.println("WARNING: 3D transforms are not supported with Swing toolkit");
                warned3D = true;
            }
            this.tx.setToIdentity();
            this.tx = this.tx.deriveWithConcatenation(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
        }
        this.completeBoundsChanged(true);
    }

    public final BaseTransform getTransformMatrix(BaseTransform baseTransform) {
        baseTransform.setTransform(this.tx);
        return baseTransform;
    }

    public boolean intersects(PickRay pickRay) {
        return false;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            if (bl) {
                this.visible = true;
                this.completeBoundsChanged(true);
            } else {
                this.visible = false;
                if (this.parent instanceof SGGroup) {
                    ((SGGroup)this.parent).childBoundsInvisible(this);
                } else if (this.parent instanceof JSGPanel) {
                    ((JSGPanel)this.parent).markDirty();
                } else if (this.parent instanceof SGNode) {
                    ((SGNode)this.parent).completeBoundsChanged(true);
                }
            }
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final SGGroup getParent() {
        SGNode sGNode = this.getClipParent();
        if (sGNode != null) {
            return null;
        }
        return this.parent instanceof JSGPanel ? null : (SGGroup)this.parent;
    }

    private SGNode getSGParent() {
        if (this.parent instanceof SGNode) {
            return (SGNode)this.parent;
        }
        return null;
    }

    public final SGNode getClipParent() {
        if (this.parent instanceof SGNode) {
            SGNode sGNode = (SGNode)this.parent;
            if (sGNode.filters != null && sGNode.filters.clipNode == this) {
                return sGNode;
            }
        }
        return null;
    }

    void setParent(Object object) {
        this.parent = object;
    }

    protected abstract Bounds2D computeBounds(Bounds2D var1, BaseTransform var2);

    protected boolean computeContains(float f, float f2) {
        this.updateBounds();
        return this.cachedBounds.contains(f, f2);
    }

    protected boolean computeIntersects(float f, float f2, float f3, float f4) {
        this.updateBounds();
        return this.cachedBounds.intersects(f, f2, f3, f4);
    }

    protected final void markParentsDirty() {
        if (this.parent instanceof SGGroup) {
            ((SGGroup)this.parent).childBoundsChanged();
        } else if (this.parent instanceof JSGPanel) {
            ((JSGPanel)this.parent).markDirty();
        } else if (this.parent instanceof SGNode) {
            ((SGNode)this.parent).completeBoundsChanged(true);
        }
    }

    protected final void visualsChanged(boolean bl) {
        if (bl) {
            this.dirty = true;
        }
        this.invalidateCache();
        if (this.visible) {
            if (this.parent instanceof SGGroup) {
                ((SGGroup)this.parent).childVisualsChanged();
            } else if (this.parent instanceof JSGPanel) {
                ((JSGPanel)this.parent).markDirty();
            } else if (this.parent instanceof SGNode) {
                ((SGNode)this.parent).completeBoundsChanged(true);
            }
        }
    }

    final void updateBounds() {
        if (this.cachedBounds.isInvalid()) {
            this.computeBounds(this.cachedBounds, BaseTransform.IDENTITY_TRANSFORM);
        }
    }

    protected final void invalidateCache() {
        if (this.filters != null && this.filters.cacheFilter != null) {
            this.filters.cacheFilter.invalidate();
        }
    }

    public final void render(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        if (CLEAR_DIRTY) {
            this.clearDirty();
        }
        this.updateTxBounds();
        if (!this.visible || this.filters != null && this.filters.opacity == 0.0f) {
            return;
        }
        if (this.cull(bounds2D, baseTransform)) {
            return;
        }
        boolean bl = this.tx.isIdentity();
        if (bl && this.filters == null) {
            this.doRender(graphics2D, bounds2D, baseTransform);
        } else {
            double d = baseTransform.getMxx();
            double d2 = baseTransform.getMyx();
            double d3 = baseTransform.getMxy();
            double d4 = baseTransform.getMyy();
            double d5 = baseTransform.getMxt();
            double d6 = baseTransform.getMyt();
            BaseTransform baseTransform2 = baseTransform;
            if (!bl) {
                baseTransform2 = baseTransform2.deriveWithConcatenation(this.tx);
            }
            graphics2D.setTransform(SGNode.toAWTTransform(baseTransform2, TEMP_AT));
            this.doRender(graphics2D, bounds2D, baseTransform2);
            TEMP_AT.setTransform(d, d2, d3, d4, d5, d6);
            graphics2D.setTransform(TEMP_AT);
            if (baseTransform2 == baseTransform) {
                baseTransform.restoreTransform(d, d2, d3, d4, d5, d6);
            }
        }
    }

    private void doRender(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.filters != null) {
            if (this.filters.clipNode != null) {
                this.renderClip(graphics2D, bounds2D, baseTransform);
            } else if (this.filters.opacity < 1.0f) {
                this.renderOpacity(graphics2D, bounds2D, baseTransform);
            } else if (this.filters.cacheFilter != null) {
                this.renderCached(graphics2D, bounds2D, baseTransform);
            } else if (this.filters.effectFilter != null) {
                this.renderEffect(graphics2D, bounds2D, baseTransform);
            } else {
                this.renderContent(graphics2D, bounds2D, baseTransform);
            }
        } else {
            this.renderContent(graphics2D, bounds2D, baseTransform);
        }
    }

    void renderClip(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        int n;
        Object object;
        if (this.filters.clipNode.filters != null && (double)this.filters.clipNode.filters.opacity == 0.0) {
            return;
        }
        if (this.filters.clipNode instanceof SGRectangle && ((SGRectangle)(object = (SGRectangle)this.filters.clipNode)).isRectClip(baseTransform)) {
            this.renderRectClip(graphics2D, bounds2D, baseTransform);
            return;
        }
        object = this.getFilterContext(graphics2D);
        Bounds2D bounds2D2 = this.getClippedBounds(TEMP_BOUNDS, baseTransform);
        int n2 = (int)bounds2D2.x1;
        int n3 = (int)bounds2D2.y1;
        int n4 = (int)Math.ceil(bounds2D2.getWidth());
        Filterable filterable = Effect.getCompatibleImage((FilterContext)object, n4, n = (int)Math.ceil(bounds2D2.getHeight()));
        if (filterable == null) {
            return;
        }
        Image image = (Image)filterable.getData();
        SGNode.renderToImage(this, bounds2D, baseTransform, n2, n3, n4, n, image, (byte)7);
        Filterable filterable2 = Effect.getCompatibleImage((FilterContext)object, n4, n);
        if (filterable2 == null) {
            Effect.releaseCompatibleImage((FilterContext)object, filterable);
            return;
        }
        Image image2 = (Image)filterable2.getData();
        SGNode.renderToImage(this.filters.clipNode, bounds2D, baseTransform, n2, n3, n4, n, image2, (byte)15);
        Graphics2D graphics2D2 = (Graphics2D)image2.getGraphics();
        graphics2D2.setComposite(AlphaComposite.SrcIn);
        graphics2D2.drawImage(image, 0, 0, null);
        TEMP_AT.setToIdentity();
        graphics2D.setTransform(TEMP_AT);
        graphics2D.drawImage(image2, n2, n3, n2 + n4, n3 + n, 0, 0, n4, n, null);
        Effect.releaseCompatibleImage((FilterContext)object, filterable);
        Effect.releaseCompatibleImage((FilterContext)object, filterable2);
    }

    private void renderRectClip(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        Rectangle2D rectangle2D;
        SGRectangle sGRectangle = (SGRectangle)this.filters.clipNode;
        RoundRectangle2D.Float float_ = (RoundRectangle2D.Float)sGRectangle.getShape();
        if (this.filters.clipNode.tx != null && !this.filters.clipNode.tx.isIdentity()) {
            SGNode.TMP_ARR[0] = float_.x;
            SGNode.TMP_ARR[1] = float_.y;
            SGNode.TMP_ARR[2] = float_.x + float_.width;
            SGNode.TMP_ARR[3] = float_.y + float_.height;
            SGNode.transform(TMP_ARR, this.filters.clipNode.tx);
            float f = Math.min(TMP_ARR[0], TMP_ARR[2]);
            float f2 = Math.max(TMP_ARR[0], TMP_ARR[2]);
            float f3 = Math.min(TMP_ARR[1], TMP_ARR[3]);
            float f4 = Math.max(TMP_ARR[1], TMP_ARR[3]);
            rectangle2D = new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        } else {
            rectangle2D = new Rectangle2D.Float(float_.x, float_.y, float_.width, float_.height);
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null && (rectangle2D = rectangle2D.createIntersection(rectangle)).isEmpty()) {
            return;
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMyx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyy();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyt();
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        double d9 = Math.floor(d7);
        double d10 = Math.floor(d8);
        double d11 = Math.ceil(d7 + rectangle2D.getWidth());
        double d12 = Math.ceil(d8 + rectangle2D.getHeight());
        graphics2D.clipRect((int)d9, (int)d10, (int)(d11 - d9), (int)(d12 - d10));
        if (this.filters.opacity < 1.0f) {
            this.renderOpacity(graphics2D, bounds2D, baseTransform);
        } else if (this.filters.cacheFilter != null) {
            this.renderCached(graphics2D, bounds2D, baseTransform);
        } else if (this.filters.effectFilter != null) {
            this.renderEffect(graphics2D, bounds2D, baseTransform);
        } else {
            this.renderContent(graphics2D, bounds2D, baseTransform);
        }
        if (rectangle == null) {
            graphics2D.setClip(null);
        } else {
            TEMP_AT.setTransform(d, d2, d3, d4, d5, d6);
            graphics2D.setTransform(TEMP_AT);
            graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void renderOpacity(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.filters.effectFilter != null || this.filters.cacheFilter != null || !this.hasOverlappingContents()) {
            AlphaComposite alphaComposite = (AlphaComposite)graphics2D.getComposite();
            if (alphaComposite.getRule() != 3) {
                throw new InternalError("Only SRC_OVER mode is supported");
            }
            float f = this.filters.opacity * alphaComposite.getAlpha();
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            if (this.filters.cacheFilter != null) {
                this.renderCached(graphics2D, bounds2D, baseTransform);
            } else if (this.filters.effectFilter != null) {
                this.renderEffect(graphics2D, bounds2D, baseTransform);
            } else {
                this.renderContent(graphics2D, bounds2D, baseTransform);
            }
            graphics2D.setComposite(alphaComposite);
            return;
        }
        Bounds2D bounds2D2 = this.getEffectBounds(TEMP_BOUNDS, baseTransform);
        int n = (int)bounds2D2.x1;
        int n2 = (int)bounds2D2.y1;
        int n3 = (int)Math.ceil(bounds2D2.getWidth());
        int n4 = (int)Math.ceil(bounds2D2.getHeight());
        FilterContext filterContext = this.getFilterContext(graphics2D);
        Filterable filterable = Effect.getCompatibleImage(filterContext, n3, n4);
        if (filterable == null) {
            return;
        }
        Image image = (Image)filterable.getData();
        SGNode.renderToImage(this, bounds2D, baseTransform, n, n2, n3, n4, image, (byte)0);
        TEMP_AT.setToIdentity();
        graphics2D.setTransform(TEMP_AT);
        AlphaComposite alphaComposite = null;
        alphaComposite = (AlphaComposite)graphics2D.getComposite();
        if (alphaComposite.getRule() != 3) {
            throw new InternalError("Only SRC_OVER mode is supported");
        }
        float f = this.filters.opacity * alphaComposite.getAlpha();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, null);
        graphics2D.setComposite(alphaComposite);
        Effect.releaseCompatibleImage(filterContext, filterable);
    }

    void renderCached(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        this.filters.cacheFilter.render(graphics2D, bounds2D, baseTransform);
    }

    void renderEffect(Graphics2D graphics2D, Bounds2D bounds2D, BaseTransform baseTransform) {
        this.filters.effectFilter.render(graphics2D, bounds2D, baseTransform);
    }

    static void renderToImage(SGNode sGNode, Bounds2D bounds2D, BaseTransform baseTransform, int n, int n2, int n3, int n4, Image image, byte by) {
        BaseTransform baseTransform2 = baseTransform.deriveWithPreTranslation(-n, -n2);
        float f = bounds2D.x1;
        float f2 = bounds2D.x2;
        float f3 = bounds2D.y1;
        float f4 = bounds2D.y2;
        bounds2D.setBounds(0.0f, 0.0f, n3, n4);
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setTransform(SGNode.toAWTTransform(baseTransform2, TEMP_AT));
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (by == 15) {
            sGNode.render(graphics2D, bounds2D, baseTransform2);
        } else if (sGNode.filters != null) {
            if ((by & 8) != 0 && sGNode.filters.clipNode != null) {
                sGNode.renderClip(graphics2D, bounds2D, baseTransform2);
            } else if ((by & 4) != 0 && sGNode.filters.opacity < 1.0f) {
                sGNode.renderOpacity(graphics2D, bounds2D, baseTransform2);
            } else if ((by & 2) != 0 && sGNode.filters.cacheFilter != null) {
                sGNode.renderCached(graphics2D, bounds2D, baseTransform2);
            } else if ((by & 1) != 0 && sGNode.filters.effectFilter != null) {
                sGNode.renderEffect(graphics2D, bounds2D, baseTransform2);
            } else {
                sGNode.renderContent(graphics2D, bounds2D, baseTransform2);
            }
        } else {
            sGNode.renderContent(graphics2D, bounds2D, baseTransform2);
        }
        bounds2D.setBounds(f, f3, f2, f4);
        if (baseTransform == baseTransform2) {
            baseTransform.deriveWithPreTranslation(n, n2);
        }
        graphics2D.dispose();
    }

    abstract void renderContent(Graphics2D var1, Bounds2D var2, BaseTransform var3);

    boolean hasOverlappingContents() {
        return true;
    }

    protected boolean cull(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.cachedTxBounds.isEmpty()) {
            return true;
        }
        TEMP_BOUNDS.setBounds(this.cachedTxBounds);
        SGNode.transform(TEMP_BOUNDS, baseTransform);
        return bounds2D.disjoint(TEMP_BOUNDS);
    }

    static AffineTransform toAWTTransform(BaseTransform baseTransform, AffineTransform affineTransform) {
        affineTransform.setTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
        return affineTransform;
    }

    static BaseTransform toFXTransform(AffineTransform affineTransform, Affine2D affine2D) {
        if (affineTransform == null || affineTransform.isIdentity()) {
            return BaseTransform.IDENTITY_TRANSFORM;
        }
        affine2D.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
        return affine2D;
    }

    Affine2D getCumulativeTransform(Affine2D affine2D) {
        affine2D.setToIdentity();
        SGNode sGNode = this;
        do {
            if (sGNode.tx == null) continue;
            affine2D.preConcatenate(sGNode.tx);
        } while ((sGNode = sGNode.getSGParent()) != null);
        return affine2D;
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String string) {
        this.id = string;
    }

    public SGNode lookup(String string) {
        if (string.equals(this.id)) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.id + " " + super.toString();
    }

    public JSGPanel getPanel() {
        Object object = this.parent;
        while (object != null) {
            if (object instanceof JSGPanel) {
                return (JSGPanel)object;
            }
            object = ((SGNode)object).parent;
        }
        return null;
    }

    public final Point2D globalToLocal(Point2D point2D, Point2D point2D2) {
        try {
            return this.getCumulativeTransform(TEMP_FXTX).inverseTransform(point2D, point2D2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            SGNode sGNode = this;
            do {
                if (sGNode.tx == null || sGNode.tx.isIdentity()) continue;
                try {
                    point2D = sGNode.tx.inverseTransform(point2D, point2D2);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException2) {
                    // empty catch block
                }
                point2D2 = point2D;
            } while ((sGNode = sGNode.getSGParent()) != null);
            if (point2D2 != point2D) {
                if (point2D2 == null) {
                    point2D2 = new Point2D();
                }
                point2D2.setLocation(point2D);
            }
            return point2D2;
        }
    }

    FilterContext getFilterContext(Graphics2D graphics2D) {
        FilterContext filterContext = this.filters.fctx;
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (filterContext == null || filterContext.getReferent() != graphicsConfiguration) {
            this.filters.fctx = filterContext = J2DFilterContext.getInstance(graphicsConfiguration);
        }
        return filterContext;
    }

    static final class Filters {
        SGNode clipNode;
        float opacity = 1.0f;
        SGCacheFilter cacheFilter;
        EffectFilter effectFilter;
        FilterContext fctx;

        Filters() {
        }

        void setClipNode(SGNode sGNode, SGNode sGNode2) {
            if (sGNode != this.clipNode) {
                if (this.clipNode != null) {
                    this.clipNode.setParent(null);
                }
                if (sGNode != null) {
                    sGNode.setParent(sGNode2);
                }
                this.clipNode = sGNode;
            }
        }

        void setOpacity(float f) {
            this.opacity = f;
        }

        void setCached(boolean bl, SGNode sGNode, PGNode.CacheHint cacheHint) {
            if (bl) {
                if (this.cacheFilter == null) {
                    this.cacheFilter = new SGCacheFilter(sGNode, cacheHint);
                } else {
                    this.cacheFilter.setHint(cacheHint);
                }
            } else if (this.cacheFilter != null) {
                this.cacheFilter.dispose();
                this.cacheFilter = null;
            }
        }

        void setEffect(Effect effect, SGNode sGNode) {
            if (this.effectFilter != null) {
                this.effectFilter.dispose();
            }
            this.effectFilter = effect != null ? new EffectFilter(effect, sGNode) : null;
        }

        Bounds2D getBounds(SGNode sGNode, Bounds2D bounds2D, BaseTransform baseTransform) {
            if (this.effectFilter != null) {
                this.effectFilter.getBounds(bounds2D, baseTransform);
            } else {
                sGNode.getContentBounds(bounds2D, baseTransform);
            }
            if (this.clipNode == null) {
                return bounds2D;
            }
            float f = bounds2D.x1;
            float f2 = bounds2D.y1;
            float f3 = bounds2D.x2;
            float f4 = bounds2D.y2;
            this.clipNode.getCompleteBounds(bounds2D, baseTransform);
            bounds2D.intersectWith(f, f2, f3, f4);
            return bounds2D;
        }

        boolean contains(SGNode sGNode, float f, float f2) {
            boolean bl = sGNode.computeContains(f, f2);
            boolean bl2 = true;
            boolean bl3 = true;
            if (bl && this.clipNode != null) {
                BaseTransform baseTransform = this.clipNode.tx;
                if (baseTransform != null) {
                    try {
                        TMP_DARR[0] = f;
                        TMP_DARR[1] = f2;
                        baseTransform.inverseTransform(TMP_DARR, 0, TMP_DARR, 0, 1);
                        bl2 = this.clipNode.contains((float)TMP_DARR[0], (float)TMP_DARR[1]);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        bl2 = false;
                    }
                } else {
                    bl2 = this.clipNode.contains(f, f2);
                }
            }
            return bl && bl2 && bl3;
        }

        boolean intersects(SGNode sGNode, float f, float f2, float f3, float f4) {
            return false;
        }
    }
}

