/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import java.util.AbstractList;
import java.util.List;
import javafx.reflect.FXContext;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXMember;
import javafx.reflect.FXMemberFilter;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXType;
import javafx.reflect.FXVarMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FXClassType
extends FXType
implements FXMember {
    String name;
    FXContext context;
    protected int modifiers;
    protected static final int FX_MIXIN = 1;
    protected static final int FX_CLASS = 2;
    public static final String SEQUENCE_CLASSNAME = "com.sun.javafx.runtime.sequence.Sequence";
    public static final String OBJECT_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.ObjectVariable";
    public static final String SEQUENCE_VARIABLE_CLASSNAME = "com.sun.javafx.runtime.location.SequenceVariable";
    public static final String FUNCTION_CLASSNAME_PREFIX = "com.sun.javafx.functions.Function";
    public static final String GETTER_PREFIX = "get$";
    public static final String SETTER_PREFIX = "set$";
    public static final String LOCATION_GETTER_PREFIX = "loc$";

    protected FXClassType(FXContext fXContext, int n) {
        this.context = fXContext;
        this.modifiers = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = "<anonymous>";
        }
        return "class " + string;
    }

    public boolean equals(FXClassType fXClassType) {
        return this.context.equals(fXClassType.context) && this.name.equals(fXClassType.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public abstract List<FXClassType> getSuperClasses(boolean var1);

    public boolean isMixin() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public boolean isJfxType() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isAssignableFrom(FXClassType fXClassType) {
        if (this.equals(fXClassType)) {
            return true;
        }
        List<FXClassType> list = fXClassType.getSuperClasses(false);
        for (FXClassType fXClassType2 : list) {
            if (!this.isAssignableFrom(fXClassType2)) continue;
            return true;
        }
        return false;
    }

    public List<FXMember> getMembers(FXMemberFilter fXMemberFilter, boolean bl) {
        SortedMemberArray<FXMember> sortedMemberArray = new SortedMemberArray<FXMember>();
        if (bl) {
            List<FXClassType> list = this.getSuperClasses(bl);
            for (FXClassType fXClassType : list) {
                fXClassType.getMembers(fXMemberFilter, sortedMemberArray);
            }
        } else {
            this.getMembers(fXMemberFilter, sortedMemberArray);
        }
        return sortedMemberArray;
    }

    public List<FXMember> getMembers(boolean bl) {
        return this.getMembers(new FXMemberFilter(), bl);
    }

    protected void getMembers(FXMemberFilter fXMemberFilter, SortedMemberArray<FXMember> sortedMemberArray) {
        this.getVariables(fXMemberFilter, sortedMemberArray);
        this.getFunctions(fXMemberFilter, sortedMemberArray);
    }

    public List<FXFunctionMember> getFunctions(FXMemberFilter fXMemberFilter, boolean bl) {
        SortedMemberArray<FXFunctionMember> sortedMemberArray = new SortedMemberArray<FXFunctionMember>();
        if (bl) {
            List<FXClassType> list = this.getSuperClasses(bl);
            for (FXClassType fXClassType : list) {
                fXClassType.getFunctions(fXMemberFilter, sortedMemberArray);
            }
        } else {
            this.getFunctions(fXMemberFilter, sortedMemberArray);
        }
        return sortedMemberArray;
    }

    public List<FXFunctionMember> getFunctions(boolean bl) {
        return this.getFunctions(FXMemberFilter.acceptMethods(), bl);
    }

    protected abstract void getFunctions(FXMemberFilter var1, SortedMemberArray<? super FXFunctionMember> var2);

    public List<FXVarMember> getVariables(FXMemberFilter fXMemberFilter, boolean bl) {
        SortedMemberArray<FXVarMember> sortedMemberArray = new SortedMemberArray<FXVarMember>();
        if (bl) {
            List<FXClassType> list = this.getSuperClasses(bl);
            boolean bl2 = this.isMixin();
            for (FXClassType fXClassType : list) {
                if (!bl2 && fXClassType.isMixin()) continue;
                fXClassType.getVariables(fXMemberFilter, sortedMemberArray);
            }
        } else {
            this.getVariables(fXMemberFilter, sortedMemberArray);
        }
        return sortedMemberArray;
    }

    public List<FXVarMember> getVariables(boolean bl) {
        return this.getVariables(FXMemberFilter.acceptAttributes(), bl);
    }

    protected abstract void getVariables(FXMemberFilter var1, SortedMemberArray<? super FXVarMember> var2);

    public FXMember getMember(String string, FXType fXType) {
        throw new UnsupportedOperationException("getMember not implemented yet.");
    }

    public FXVarMember getVariable(String string) {
        FXMemberFilter fXMemberFilter = new FXMemberFilter();
        fXMemberFilter.setAttributesAccepted(true);
        fXMemberFilter.setRequiredName(string);
        List<FXVarMember> list = this.getVariables(fXMemberFilter, true);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    public abstract FXFunctionMember getFunction(String var1, FXType ... var2);

    public FXContext getReflectionContext() {
        return this.context;
    }

    public abstract FXObjectValue allocate();

    public FXObjectValue newInstance() {
        return this.allocate().initialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortedMemberArray<T extends FXMember>
    extends AbstractList<T> {
        FXMember[] buffer = new FXMember[4];
        int sz;

        SortedMemberArray() {
        }

        @Override
        public T get(int n) {
            if (n >= this.sz) {
                throw new IndexOutOfBoundsException();
            }
            return (T)this.buffer[n];
        }

        @Override
        public int size() {
            return this.sz;
        }

        boolean insert(T t) {
            FXMember[] fXMemberArray;
            int n;
            String string = t.getName();
            for (n = 0; n < this.sz; ++n) {
                fXMemberArray = this.buffer[n];
                int n2 = fXMemberArray.getName().compareToIgnoreCase(string);
                if (n2 == 0) {
                    n2 = fXMemberArray.getName().compareTo(string);
                }
                if (n2 > 0) break;
                if (n2 < 0) continue;
                FXClassType fXClassType = t.getDeclaringClass();
                FXClassType fXClassType2 = fXMemberArray.getDeclaringClass();
                boolean bl = fXClassType.isAssignableFrom(fXClassType2);
                boolean bl2 = fXClassType2.isAssignableFrom(fXClassType);
                if (bl && !bl2) break;
                if (bl2 && !bl) continue;
                String string2 = fXClassType.getName();
                String string3 = fXClassType2.getName();
                n2 = string3.compareToIgnoreCase(string2);
                if (n2 == 0) {
                    n2 = string3.compareTo(string2);
                }
                if (n2 > 0) break;
                if (n2 < 0) continue;
                if (t instanceof FXClassType) break;
                if (fXMemberArray instanceof FXClassType) continue;
                if (t instanceof FXVarMember) break;
                if (fXMemberArray instanceof FXVarMember) continue;
                if (!(t instanceof FXFunctionMember) || !(fXMemberArray instanceof FXFunctionMember)) break;
                String string4 = ((FXFunctionMember)t).getType().toString();
                String string5 = ((FXFunctionMember)fXMemberArray).getType().toString();
                n2 = string5.compareToIgnoreCase(string4);
                if (n2 == 0) {
                    n2 = string5.compareTo(string4);
                }
                if (n2 >= 0) break;
            }
            if (this.sz == this.buffer.length) {
                fXMemberArray = new FXMember[2 * this.sz];
                System.arraycopy(this.buffer, 0, fXMemberArray, 0, this.sz);
                this.buffer = fXMemberArray;
            }
            System.arraycopy(this.buffer, n, this.buffer, n + 1, this.sz - n);
            this.buffer[n] = t;
            ++this.sz;
            return true;
        }
    }
}

