/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SerializedGrammar {
    public static final String COOKIE = "$ANTLR";
    public static final int FORMAT_VERSION = 1;
    public String name;
    public char type;
    public List rules;

    public SerializedGrammar(String string) throws IOException {
        System.out.println("loading " + string);
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.readFile(dataInputStream);
        dataInputStream.close();
    }

    protected void readFile(DataInputStream dataInputStream) throws IOException {
        String string;
        char c;
        String string2 = this.readString(dataInputStream);
        if (!string2.equals(COOKIE)) {
            throw new IOException("not a serialized grammar file");
        }
        byte by = dataInputStream.readByte();
        this.type = c = (char)dataInputStream.readByte();
        this.name = string = this.readString(dataInputStream);
        System.out.println(c + " grammar " + string);
        short s = dataInputStream.readShort();
        System.out.println("num rules = " + s);
        this.rules = this.readRules(dataInputStream, s);
    }

    protected List readRules(DataInputStream dataInputStream, int n) throws IOException {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (int i = 0; i < n; ++i) {
            Rule rule = this.readRule(dataInputStream);
            arrayList.add(rule);
        }
        return arrayList;
    }

    protected Rule readRule(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by != 82) {
            throw new IOException("missing R on start of rule");
        }
        String string = this.readString(dataInputStream);
        System.out.println("rule: " + string);
        byte by2 = dataInputStream.readByte();
        Block block = this.readBlock(dataInputStream);
        byte by3 = dataInputStream.readByte();
        if (by3 != 46) {
            throw new IOException("missing . on end of rule");
        }
        return new Rule(string, block);
    }

    protected Block readBlock(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        List[] listArray = new List[n];
        for (int i = 0; i < n; ++i) {
            List list;
            listArray[i] = list = this.readAlt(dataInputStream);
        }
        return new Block(listArray);
    }

    protected List readAlt(DataInputStream dataInputStream) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        byte by = dataInputStream.readByte();
        if (by != 65) {
            throw new IOException("missing A on start of alt");
        }
        byte by2 = dataInputStream.readByte();
        while (by2 != 59) {
            switch (by2) {
                case 116: {
                    short s = dataInputStream.readShort();
                    arrayList.add(new TokenRef(s));
                    break;
                }
                case 114: {
                    short s = dataInputStream.readShort();
                    arrayList.add(new RuleRef(s));
                    break;
                }
                case 46: {
                    break;
                }
                case 45: {
                    char c = dataInputStream.readChar();
                    char c2 = dataInputStream.readChar();
                    break;
                }
                case 126: {
                    short s = dataInputStream.readShort();
                    break;
                }
                case 66: {
                    Block block = this.readBlock(dataInputStream);
                    arrayList.add(block);
                }
            }
            by2 = dataInputStream.readByte();
        }
        return arrayList;
    }

    protected String readString(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        StringBuffer stringBuffer = new StringBuffer();
        while (by != 59) {
            stringBuffer.append((char)by);
            by = dataInputStream.readByte();
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type + " grammar " + this.name);
        stringBuffer.append(this.rules);
        return stringBuffer.toString();
    }

    class Block {
        List[] alts;

        public Block(List[] listArray) {
            this.alts = listArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            for (int i = 0; i < this.alts.length; ++i) {
                List list = this.alts[i];
                if (i > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(list.toString());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    class Rule {
        String name;
        Block block;

        public Rule(String string, Block block) {
            this.name = string;
            this.block = block;
        }

        public String toString() {
            return this.name + ":" + this.block;
        }
    }

    class RuleRef {
        int ruleIndex;

        public RuleRef(int n) {
            this.ruleIndex = n;
        }

        public String toString() {
            return String.valueOf(this.ruleIndex);
        }
    }

    class TokenRef {
        int ttype;

        public TokenRef(int n) {
            this.ttype = n;
        }

        public String toString() {
            return String.valueOf(this.ttype);
        }
    }
}

