/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.progressbar;

public class Logger {
    public static boolean logEnabled = false;

    public static void info(String string) {
        Logger.log(MessageType.INFO, string, null);
    }

    public static void error(String string) {
        Logger.log(MessageType.ERROR, string, null);
    }

    public static void error(Throwable throwable) {
        Logger.log(MessageType.ERROR, "Unexpected error", throwable);
    }

    public static void error(String string, Throwable throwable) {
        Logger.log(MessageType.ERROR, string, throwable);
    }

    private static void log(MessageType messageType, String string, Throwable throwable) {
        if (logEnabled) {
            StringBuilder stringBuilder = new StringBuilder();
            switch (messageType) {
                case INFO: {
                    stringBuilder.append("[INFO]");
                    break;
                }
                case ERROR: {
                    stringBuilder.append("[ERROR]");
                }
            }
            stringBuilder.append(": ");
            stringBuilder.append(string);
            if (throwable != null) {
                stringBuilder.append(". ");
                stringBuilder.append(throwable.getMessage());
            }
            if (messageType == MessageType.ERROR) {
                System.err.println(stringBuilder.toString());
            } else {
                System.out.println(stringBuilder.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MessageType {
        INFO,
        ERROR;

    }
}

