/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.progressbar;

import com.javafx.progressbar.Callback;
import com.javafx.progressbar.GradientPaintUtils;
import com.javafx.progressbar.Logger;
import java.applet.AppletStub;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;

public class ProgressBar
extends JPanel {
    private final int CLOSE_WIDTH = 10;
    private final int CLOSE_X_FROM_RIGHT = 22;
    private final int CLOSE_Y = 8;
    private final Color CLOSE_BTN_CLR = new Color(0xB9B9B9);
    private final String PROGRESS_BG_COLOR = "progress.background.color";
    private final String PROGRESS_BG_URL = "progress.background.url";
    private final String PROGRESS_BAR_X = "progress.bar.x";
    private final String PROGRESS_BAR_Y = "progress.bar.y";
    private final String PROGRESS_BAR_WIDTH = "progress.bar.width";
    private final String PROGRESS_BAR_HEIGHT = "progress.bar.height";
    private final String PROGRESS_ICON_URL = "progress.icon.url";
    private final String PROGRESS_ICON_X = "progress.icon.x";
    private final String PROGRESS_ICON_Y = "progress.icon.y";
    private final String PROGRESS_LOG_ENABLED = "progress.log.enabled";
    private final String JNLP_PREFIX = "jnlp.";
    private final int DEFAULT_WIDTH = 400;
    private final int DEFAULT_HEIGHT = 130;
    private final int DEFAULT_BAR_HEIGHT = 12;
    private final int BAR_INTERVAL = 14;
    private final double WIDTH_FACTOR = 0.7;
    private final Color STROKE_COLOR = new Color(184, 184, 184, 140);
    private final Color SEGMENT_COLOR = new Color(184, 184, 184, 77);
    private final Color WS_BACKGROUND = new Color(0xF4F4F4);
    private final Color WS_BORDER = new Color(0xC7C7C7);
    private final Color FEATHER_COLOR = new Color(255, 255, 255, 23);
    private final Font font = new Font("Arial", 1, 11);
    private final Color BC1 = new Color(127, 127, 127, 255);
    private final Color BC2 = new Color(0, 0, 0, 0);
    private final Color BC3 = new Color(66, 66, 66, 133);
    private final Color BC4 = new Color(189, 189, 189, 214);
    private final float[] BG_POS = new float[]{0.0f, 0.5f, 0.59f, 1.0f};
    private final Color[] BG_COLORS = new Color[]{this.BC1, this.BC2, this.BC3, this.BC4};
    private final Color FC1 = new Color(209790);
    private final Color FC2 = new Color(347064);
    private final Color FC4 = new Color(418027);
    private final float[] FG_POS = new float[]{0.0f, 0.1f, 0.39f, 0.47f, 0.53f, 0.61f, 0.9f, 1.0f};
    private final Color[] FG_COLORS = new Color[]{this.FC1, this.FC2, this.FC2, this.FC4, this.FC4, this.FC2, this.FC2, this.FC1};
    private final Color GLOW_OPAQUE = new Color(255, 255, 255, 230);
    private final Color GLOW_TRANSPARENT = new Color(255, 255, 255, 0);
    private final float[] GLOW_POS = new float[]{0.0f, 0.3f, 0.98f};
    private final Color[] GLOW_COLORS = new Color[]{this.GLOW_OPAQUE, this.GLOW_OPAQUE, this.GLOW_TRANSPARENT};
    private final Color LABEL_COLOR = new Color(0x555659);
    private final BasicStroke STROKE = new BasicStroke(1.0f);
    private AppletStub stub = null;
    private boolean isApplet = true;
    private volatile int lastProgressPercentage = -1;
    private int width = 430;
    private int height = 130;
    private int barWidth = (int)((double)this.width * 0.7);
    private int barHeight = 12;
    private int barX = 0;
    private int barY = 0;
    private int progressWidth = 0;
    private Color background = Color.WHITE;
    private boolean showTimeLeft = false;
    private boolean showCompletion = true;
    private boolean showProgressBar = true;
    private BufferedImage buffer = null;
    private Callback callback = null;
    private Image backgroundImage;
    private Image iconImage;
    private int bgColor;
    private URL bgURL;
    private URL iconURL;
    private int iconX;
    private int iconY;

    public ProgressBar(Callback callback) {
        this.isApplet = false;
        this.callback = callback;
        this.getParams(this.stub);
        this.setSize(this.width, this.height);
    }

    public ProgressBar(AppletStub appletStub, Callback callback) {
        this.callback = callback;
        this.stub = appletStub;
        this.getParams(this.stub);
    }

    private void getParams(AppletStub appletStub) {
        Logger.logEnabled = "true".equals(this.getString(appletStub, "progress.log.enabled"));
        this.width = this.getValue(appletStub, "width");
        this.height = this.getValue(appletStub, "height");
        this.bgColor = this.getValue(appletStub, "progress.background.color");
        this.background = this.bgColor == -1 ? (this.isApplet ? Color.WHITE : this.WS_BACKGROUND) : new Color(this.bgColor);
        Logger.info("Background = " + this.background);
        this.bgURL = this.getURL(appletStub, "progress.background.url");
        this.barWidth = this.getValue(appletStub, "progress.bar.width");
        this.barHeight = this.getValue(appletStub, "progress.bar.height") - 2;
        this.barX = this.getValue(appletStub, "progress.bar.x");
        this.barY = this.getValue(appletStub, "progress.bar.y");
        this.iconURL = this.getURL(appletStub, "progress.icon.url");
        this.iconX = this.getValue(appletStub, "progress.icon.x");
        this.iconY = this.getValue(appletStub, "progress.icon.y");
        if (this.width < 0) {
            this.width = 430;
        }
        if (this.height < 0) {
            this.height = 130;
        }
        if (this.barWidth < 0) {
            this.barWidth = (int)((double)this.width * 0.7);
        }
        this.barWidth -= this.barWidth % 14;
        if (this.barHeight < 0) {
            this.barHeight = 12;
        }
        if (this.barX < 0) {
            this.barX = (this.width - this.barWidth) / 2;
        }
        if (this.barY < 0) {
            this.barY = this.height / 2 - this.barHeight;
        }
        if (this.bgURL != null) {
            this.backgroundImage = Toolkit.getDefaultToolkit().getImage(this.bgURL);
            this.prepareImage(this.backgroundImage, this);
        }
        if (this.iconURL != null) {
            this.iconImage = Toolkit.getDefaultToolkit().getImage(this.iconURL);
            this.prepareImage(this.iconImage, this);
            if (this.iconX < 0) {
                this.iconX = 0;
            }
            if (this.iconY < 0) {
                this.iconY = 0;
            }
        }
        if (this.width < 50) {
            this.showProgressBar = false;
        }
    }

    private int getValue(AppletStub appletStub, String string) {
        String string2 = null;
        string2 = appletStub != null ? appletStub.getParameter(string) : System.getProperty("jnlp." + string);
        Logger.info("Parameter: " + string + " = " + string2);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.error("Error parsing " + string2);
            }
        }
        return -1;
    }

    private String getString(AppletStub appletStub, String string) {
        String string2 = null;
        string2 = appletStub != null ? appletStub.getParameter(string) : System.getProperty("jnlp." + string);
        Logger.info("Parameter: " + string + " = " + string2);
        return string2;
    }

    private URL getURL(AppletStub appletStub, String string) {
        String string2 = null;
        string2 = appletStub != null ? appletStub.getParameter(string) : System.getProperty("jnlp." + string);
        Logger.info("Parameter: " + string + " = " + string2);
        if (string2 != null) {
            try {
                if (this.isApplet) {
                    return new URL(appletStub.getCodeBase(), string2);
                }
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.error("Invalid Image URL");
            }
        }
        return null;
    }

    public void progress(int n) {
        Logger.info("Progress %: " + n);
        if (n > this.lastProgressPercentage) {
            this.lastProgressPercentage = n;
            this.progressWidth = n * this.barWidth / 100;
            this.repaint();
        }
        if (n >= 100 && this.callback != null) {
            this.callback.done();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private BufferedImage createGlowMask() {
        BufferedImage bufferedImage = new BufferedImage(this.progressWidth, this.progressWidth, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Paint paint = GradientPaintUtils.createRadialGradientPaint((float)this.progressWidth / 2.0f, (float)this.progressWidth / 2.0f, (float)this.progressWidth / 2.0f, this.GLOW_POS, this.GLOW_COLORS);
        graphics2D.setPaint(paint);
        graphics2D.scale(1.0, (double)this.barHeight * 1.5 / (double)this.progressWidth);
        graphics2D.fillOval(0, 0, this.progressWidth, this.progressWidth);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        if (this.buffer == null || this.buffer.getWidth() != this.width || this.buffer.getHeight() != this.height) {
            this.buffer = new BufferedImage(this.width, this.height, 1);
        }
        Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(this.STROKE);
        if (this.isApplet) {
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, this.width, this.height);
        } else {
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.setColor(this.WS_BORDER);
            graphics2D.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        if (this.lastProgressPercentage > 0 && this.lastProgressPercentage < 100) {
            Object object2;
            if (this.backgroundImage != null) {
                graphics2D.drawImage(this.backgroundImage, 0, 0, this);
            }
            if (this.iconImage != null) {
                graphics2D.drawImage(this.iconImage, this.iconX, this.iconY, this);
            }
            if (this.showProgressBar) {
                object = (AlphaComposite)graphics2D.getComposite();
                object2 = AlphaComposite.getInstance(3, 0.3f);
                graphics2D.setComposite((Composite)object2);
                graphics2D.setPaint(GradientPaintUtils.createLinearGradientPaint(this.barX, this.barY, this.barX, this.barY + this.barHeight, this.BG_POS, this.BG_COLORS));
                graphics2D.fillRect(this.barX, this.barY, this.barWidth, this.barHeight);
                graphics2D.setComposite((Composite)object);
                graphics2D.setColor(this.STROKE_COLOR);
                graphics2D.drawRect(this.barX - 1, this.barY - 1, this.barWidth + 1, this.barHeight + 1);
                graphics2D.setPaint(GradientPaintUtils.createLinearGradientPaint(this.barX - 1, this.barY, this.barX + this.progressWidth, this.barY, this.FG_POS, this.FG_COLORS));
                graphics2D.fillRect(this.barX - 1, this.barY - 1, this.progressWidth, this.barHeight + 2);
                graphics2D.setPaint(GradientPaintUtils.createRadialGradientPaint((float)this.progressWidth / 2.0f, (float)this.barHeight / 2.0f, (float)this.barHeight / 2.0f, new float[]{0.5f, 1.0f}, new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 0)}));
                graphics2D.fillRoundRect(this.barX, this.barY, this.progressWidth, this.barHeight + 2, 4, 4);
                Shape shape = graphics2D.getClip();
                graphics2D.setClip(this.barX, this.barY, this.progressWidth, this.barHeight);
                BufferedImage bufferedImage = this.createGlowMask();
                graphics2D.drawImage((Image)bufferedImage, this.barX - 1, this.barY - this.barHeight, this);
                graphics2D.drawImage((Image)bufferedImage, this.barX + 3, (int)((double)this.barY + (double)this.barHeight * 0.5), this);
                graphics2D.setClip(shape);
                graphics2D.setColor(this.SEGMENT_COLOR);
                for (int i = 14; i < this.barWidth; i += 14) {
                    graphics2D.drawLine(this.barX + i, this.barY, this.barX + i, this.barY + this.barHeight - 1);
                }
            }
            object = Integer.toString(this.lastProgressPercentage) + "%";
            graphics2D.setFont(this.font);
            object2 = graphics2D.getFontMetrics();
            int n = ((FontMetrics)object2).stringWidth((String)object);
            int n2 = ((FontMetrics)object2).getHeight();
            graphics2D.setColor(this.LABEL_COLOR);
            if (this.showProgressBar) {
                graphics2D.drawString((String)object, this.barX + this.barWidth - n, this.barY + this.barHeight + n2);
            } else {
                graphics2D.drawString((String)object, (this.barWidth - n) / 2, this.barY + this.barHeight + n2);
            }
        }
        if (!this.isApplet) {
            graphics2D.setColor(this.CLOSE_BTN_CLR);
            object = new BasicStroke(3.0f, 1, 1);
            graphics2D.setStroke((Stroke)object);
            graphics2D.drawLine(this.getWidth() - 22, 8, this.getWidth() - 22 + 10, 18);
            graphics2D.drawLine(this.getWidth() - 22, 18, this.getWidth() - 22 + 10, 8);
        }
        this.paintChildren(graphics2D);
        graphics.drawImage(this.buffer, 0, 0, this);
        graphics.dispose();
    }
}

