/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

import tno.geoenergy.doubletcalc.TnoPipe;

public class ResultSet {
    public float[] pumpCasePumpPowers;
    public float[] pumpCaseQvolPumps;
    public float[] pumpCaseGeoThermalPowers;
    public float[] pumpCasePressureDrawdowns;
    public float[] pumpCaseCops;
    public TnoPipe baseCaseProducerPipe;
    public TnoPipe baseCaseInjectorPipe;
    public String[] doubletNodes;
    public static double[] pressureAlongDoublet;
    public static double[] temperatureAlongDoublet;

    public static String[] getStochGeoInputProperties() {
        String[] list = new String[]{"aquifer permeability", "aquifer net to gross", "aquifer gross thickness", "aquifer top at producer", "aquifer top at injector", "aquifer water salinity"};
        return list;
    }

    public static String[] getSingularGeoInputProperties() {
        String[] list = new String[]{"number of simulation runs", "aquifer kh/kv ratio", "surface temperature", "geothermal gradient", "mid aquifer temperature producer", "aquifer pressure at producer", "aquifer pressure at injector", "exit temperature heat exchanger", "distance wells at aquifer level", "pump system efficiency", "production pump depth", "pump pressure difference", "outer diameter producer", "skin producer", "skin due to penetration angle p", "tubing segment sections p", "tubing segment depth p", "tubing inner diameter p", "tubing roughness p", "outer diameter injector", "skin injector", "skin due to penetration angle i", "tubing segment sections i", "tubing segment depth i", "tubing inner diameter i ", "tubing roughness i"};
        return list;
    }

    public static String[] getStochGeoOutputProperties() {
        String[] list = new String[]{"aquifer kH net", "mass flow", "pump volume flow", "required pump power", "geothermal power", "COP"};
        return list;
    }

    public static String[] getBaseGeoOutputProperties() {
        String[] list = new String[]{"aquifer kH net", "mass flow", "pump volume flow", "required pump power", "geothermal power", "COP"};
        return list;
    }

    public static Object[][] getBaseCaseWellProperties() {
        Object[][] list = new Object[][]{{"Aquifer Pressure at producer (bar)", pressureAlongDoublet[0] * 1.0E-5}, {"Aquifer Pressure at Injector (bar)", pressureAlongDoublet[5] * 1.0E-5}, {"Pressure difference at producer (bar)", (pressureAlongDoublet[0] - pressureAlongDoublet[1]) * 1.0E-5}, {"Pressure difference at Injector (bar)", (pressureAlongDoublet[4] - pressureAlongDoublet[5]) * 1.0E-5}, {"Aquifer temperature at producer (\u00b0C) *", temperatureAlongDoublet[1]}, {"Temperature at heat exchanger (\u00b0C)", temperatureAlongDoublet[2]}};
        return list;
    }

    public void conditionPumpCaseArrays(int maxIndex) {
        this.pumpCasePumpPowers = new float[maxIndex];
        this.pumpCaseQvolPumps = new float[maxIndex];
        this.pumpCaseGeoThermalPowers = new float[maxIndex];
        this.pumpCasePressureDrawdowns = new float[maxIndex];
        this.pumpCaseCops = new float[maxIndex];
    }
}

