/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import tno.geoenergy.doubletcalc.ResultSet;
import tno.geoenergy.doubletcalc.TnoDoublet;
import tno.geoenergy.doubletcalc.TnoInputWindowData;
import tno.geoenergy.doubletcalc.stochastic.TnoRunControl;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerTS;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnoGeoThermalProject {
    TnoInputWindowData input = new TnoInputWindowData();
    public TnoDoublet doublet = new TnoDoublet();
    public static float progress;
    public String Name;
    public static boolean notConverging;

    public TnoGeoThermalProject() {
        this.Name = this.input.name;
        this.doublet.LoadDataFromInput(this.input);
    }

    public TnoGeoThermalProject(TnoInputWindowData inputSpecified) {
        this.input = inputSpecified;
        this.Name = this.input.name;
        this.doublet.LoadDataFromInput(this.input);
    }

    private static double[] cloneDoubleArray(double[] inputList) {
        int length = inputList.length;
        double[] outputList = new double[length];
        for (int i = 0; i < length; ++i) {
            outputList[i] = inputList[i];
        }
        return outputList;
    }

    private static String[] cloneStringArray(String[] inputList) {
        int length = inputList.length;
        String[] outputList = new String[length];
        for (int i = 0; i < length; ++i) {
            outputList[i] = inputList[i];
        }
        return outputList;
    }

    public static void getWarning() {
        if (!TnoRunControl.BATCH) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, "Iteration is not converging. Please choose other input values!", "Warning", 2);
        } else {
            System.out.println("Iteration is not converging. Please choose other input values! ");
        }
    }

    public ResultSet calculate() {
        notConverging = false;
        TnoRunControl.numSamples = this.input.numberOfSimulations;
        TnoStochasticContainerTS.initializeRunAllStochastics(TnoRunControl.numSamples, TnoRunControl.numYears);
        TnoStochasticContainerVar.initializeRunAllStochastics(TnoRunControl.numSamples);
        this.doublet.geothermalPowerYears = new double[TnoRunControl.numYears];
        TnoStochasticVariable AquiferK_Stoch = this.input.aquiferK;
        TnoStochasticVariable AquiferThickness_Stoch = this.input.aquiferThickness;
        TnoStochasticVariable AquiferNtG_Stoch = this.input.aquiferNtG;
        TnoStochasticVariable AquiferTopAtProd_Stoch = this.input.aquiferTopDepthAtProd;
        TnoStochasticVariable AquiferTopAtInj_Stoch = this.input.aquiferTopDepthAtInj;
        TnoStochasticVariable AquiferSalinity_Stoch = this.input.aquiferSalinity;
        this.doublet.aquiferK = AquiferK_Stoch.getDistribution().getMedian();
        this.doublet.aquiferThickness = AquiferThickness_Stoch.getDistribution().getMedian();
        this.doublet.aquiferNtG = AquiferNtG_Stoch.getDistribution().getMedian();
        this.doublet.aquiferTopDepthAtProd = AquiferTopAtProd_Stoch.getDistribution().getMedian();
        this.doublet.aquiferTopDepthAtInj = AquiferTopAtInj_Stoch.getDistribution().getMedian();
        this.doublet.aquiferSalinity = AquiferSalinity_Stoch.getDistribution().getMedian();
        this.doublet.aquiferTopDepthAtProdBaseCase = AquiferTopAtProd_Stoch.getDistribution().getMedian();
        this.doublet.aquiferTopDepthAtInjBaseCase = AquiferTopAtInj_Stoch.getDistribution().getMedian();
        this.doublet.name = "Base Case";
        this.doublet.idnumber = -1;
        this.doublet.Build();
        if (notConverging) {
            TnoGeoThermalProject.getWarning();
            return null;
        }
        this.doublet.CalcMassRate(this.doublet.pumpPressureDrawDown);
        if (notConverging) {
            TnoGeoThermalProject.getWarning();
            return null;
        }
        this.doublet.CalcPowerData();
        TnoDoublet baseCase = this.doublet.Clone();
        ResultSet resultSet = new ResultSet();
        TnoSingularContainer.find("aquifer kH net").setValue((float)(AquiferK_Stoch.getDistribution().getMedian() * AquiferThickness_Stoch.getDistribution().getMedian() * AquiferNtG_Stoch.getDistribution().getMedian() * 1.01325E12));
        resultSet.baseCaseProducerPipe = baseCase.producer.wellTubing;
        resultSet.baseCaseInjectorPipe = baseCase.injector.wellTubing;
        resultSet.doubletNodes = TnoGeoThermalProject.cloneStringArray(baseCase.nodeNamesAlongDoublet);
        ResultSet.temperatureAlongDoublet = TnoGeoThermalProject.cloneDoubleArray(baseCase.tempAlongDoublet);
        ResultSet.pressureAlongDoublet = TnoGeoThermalProject.cloneDoubleArray(baseCase.presAlongDoublet);
        TnoSingularContainer.find("mass flow").setValue((float)baseCase.qmass);
        TnoSingularContainer.find("pump volume flow").setValue((float)(-baseCase.getQvolPump() * 3600.0));
        TnoSingularContainer.find("required pump power").setValue((float)(baseCase.getPumpPower() / 1000.0));
        TnoSingularContainer.find("geothermal power").setValue((float)(baseCase.getGeoThermalPower() / 1000000.0));
        TnoSingularContainer.find("COP").setValue((float)baseCase.coP);
        if (TnoRunControl.runMCetc) {
            int monteCarloSimulations;
            int mcCasesCount = monteCarloSimulations = this.input.numberOfSimulations;
            ArrayList<TnoDoublet> mcCases = new ArrayList<TnoDoublet>();
            int iCase = 0;
            while (iCase < mcCasesCount) {
                this.doublet.aquiferK = AquiferK_Stoch.NextValue(iCase);
                this.doublet.aquiferThickness = AquiferThickness_Stoch.NextValue(iCase);
                this.doublet.aquiferNtG = AquiferNtG_Stoch.NextValue(iCase);
                this.doublet.aquiferTopDepthAtProd = AquiferTopAtProd_Stoch.NextValue(iCase);
                this.doublet.aquiferTopDepthAtInj = AquiferTopAtInj_Stoch.NextValue(iCase);
                this.doublet.aquiferSalinity = AquiferSalinity_Stoch.NextValue(iCase);
                this.doublet.name = String.format("Monte Carlo Case {0}: K={" + iCase + "} T={2}, NtG={3}, ProdDepth={4}, InjDepth={5}, Salinity={6}", this.doublet.aquiferK, this.doublet.aquiferThickness, this.doublet.aquiferNtG, this.doublet.aquiferTopDepthAtProd, this.doublet.aquiferTopDepthAtInj, this.doublet.aquiferSalinity);
                this.doublet.idnumber = iCase++;
                this.doublet.Build();
                if (notConverging) {
                    TnoGeoThermalProject.getWarning();
                    return null;
                }
                this.doublet.CalcMassRate(this.doublet.pumpPressureDrawDown);
                if (notConverging) {
                    TnoGeoThermalProject.getWarning();
                    return null;
                }
                this.doublet.CalcPowerData();
                mcCases.add(this.doublet.Clone());
            }
            this.saveMcCases(mcCasesCount, mcCases);
            if (TnoRunControl.runFingerPrinting) {
                double pumpPressureEnd;
                double pumpPressureStart = this.input.getPumpPressureDrawDown() * 0.33;
                if (pumpPressureStart < 1000000.0) {
                    pumpPressureStart = 1000000.0;
                }
                if ((pumpPressureEnd = this.input.getPumpPressureDrawDown() * 1.5) < 1500000.0) {
                    pumpPressureEnd = 1500000.0;
                }
                double pumpPressureStep = (pumpPressureEnd - pumpPressureStart) / 100.0;
                int pumpCasesCount = (int)Math.round((pumpPressureEnd - pumpPressureStart) / pumpPressureStep) + 1;
                pumpPressureStep = (pumpPressureEnd - pumpPressureStart) / (double)(pumpCasesCount - 1);
                ArrayList<TnoDoublet> pumpCases = new ArrayList<TnoDoublet>();
                this.doublet = baseCase.Clone();
                int iCase2 = 0;
                while (iCase2 < pumpCasesCount) {
                    this.doublet.pumpPressureDrawDown = pumpPressureStart + (double)iCase2 * pumpPressureStep;
                    this.doublet.name = String.format("Pump Case {0}: P={1}", iCase2, this.doublet.pumpPressureDrawDown * 1.0E-5);
                    this.doublet.idnumber = iCase2++;
                    this.doublet.Build();
                    this.doublet.CalcMassRate(this.doublet.pumpPressureDrawDown);
                    this.doublet.CalcPowerData();
                    pumpCases.add(this.doublet.Clone());
                }
                int maxIndex = pumpCases.size();
                resultSet.conditionPumpCaseArrays(maxIndex);
                for (int index = 0; index < maxIndex; ++index) {
                    resultSet.pumpCasePumpPowers[index] = (float)((TnoDoublet)pumpCases.get(index)).getPumpPower() * 0.001f;
                    resultSet.pumpCaseQvolPumps[index] = -((float)((TnoDoublet)pumpCases.get(index)).getQvolPump()) * 3600.0f;
                    resultSet.pumpCaseGeoThermalPowers[index] = (float)((TnoDoublet)pumpCases.get(index)).getGeoThermalPower() * 1.0E-6f;
                    resultSet.pumpCasePressureDrawdowns[index] = (float)(((TnoDoublet)pumpCases.get(index)).getPumpPressureDrawDown() * 1.0E-5);
                    resultSet.pumpCaseCops[index] = (float)((TnoDoublet)pumpCases.get(index)).getCoP();
                }
            }
        }
        return resultSet;
    }

    public void saveMcCases(int mcCasesCount, ArrayList<TnoDoublet> mcCases) {
        double[] powers = TnoStochasticContainerVar.find("geothermal power").getRealisations();
        double[] cop = TnoStochasticContainerVar.find("COP").getRealisations();
        double[] qVolPump = TnoStochasticContainerVar.find("pump volume flow").getRealisations();
        double[] pumpPowers = TnoStochasticContainerVar.find("required pump power").getRealisations();
        double[] aquiferKHnets = TnoStochasticContainerVar.find("aquifer kH net").getRealisations();
        double[] qmasses = TnoStochasticContainerVar.find("mass flow").getRealisations();
        double[] pdensities = TnoStochasticContainerVar.find("av. production density").getRealisations();
        double[] heatcapacities = TnoStochasticContainerVar.find("heat capacity").getRealisations();
        double[] deltaTemp = TnoStochasticContainerVar.find("delta T").getRealisations();
        for (int iCase = 0; iCase < mcCasesCount; ++iCase) {
            powers[iCase] = mcCases.get((int)iCase).geoThermalPower * 1.0E-6;
            cop[iCase] = mcCases.get((int)iCase).coP;
            qVolPump[iCase] = -mcCases.get(iCase).getQvolPump() * 3600.0;
            pumpPowers[iCase] = mcCases.get(iCase).getPumpPower() * 0.001;
            aquiferKHnets[iCase] = mcCases.get(iCase).getAquiferKHnet() * 1.01325E12;
            qmasses[iCase] = mcCases.get(iCase).getQmass();
            pdensities[iCase] = mcCases.get(iCase).getProductDensity();
            heatcapacities[iCase] = mcCases.get(iCase).getHeatCapacity();
            deltaTemp[iCase] = mcCases.get(iCase).getDeltaT();
        }
    }
}

