/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

import tno.geoenergy.doubletcalc.TnoPipe;

public class TnoGeoThermalWell {
    public TnoPipe wellTubing;
    private String name;
    private double outerDiameter;
    private double skin;

    double getSkin() {
        return this.skin;
    }

    void setSkin(double skin) {
        this.skin = skin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    double getOuterDiameter() {
        return this.outerDiameter;
    }

    void setOuterDiameter(double outerDiameter) {
        this.outerDiameter = outerDiameter;
    }

    double getOuterRadius() {
        return this.outerDiameter / 2.0;
    }

    void setOuterRadius(float value) {
        this.outerDiameter = 2.0f * value;
    }

    public TnoGeoThermalWell(String name, double pipeScaling, double[] depthSpec, double[] segmentSpec, double outDiamSpec, double[] inDiamSpec, double[] roughSpec, double segmentLengthTarget, boolean pumpPresent, double pumpZ, double pumpMaxPresDif, double pumpMaxCap, double pumpEfficiency, double skinSpec) {
        this.name = name;
        this.skin = skinSpec;
        this.wellTubing = new TnoPipe(name + "_Tubing", pipeScaling, depthSpec, segmentSpec, outDiamSpec, inDiamSpec, roughSpec, segmentLengthTarget, pumpPresent, pumpZ, pumpMaxPresDif, pumpMaxCap, pumpEfficiency);
        this.outerDiameter = outDiamSpec;
    }

    public double DpWellAquifer(double rateVol, double khNet, double distanceWells, double viscosity) {
        double dP = rateVol * viscosity * (Math.log(distanceWells / this.getOuterRadius()) + this.skin) / (Math.PI * 2 * khNet);
        return dP;
    }
}

