/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

import tno.geoenergy.doubletcalc.PipeCalcDirection;
import tno.geoenergy.doubletcalc.PipeTempCalcMethod;
import tno.geoenergy.doubletcalc.TnoUnits;
import tno.geoenergy.doubletcalc.TnoWaterProperties;

public class TnoPipe {
    public double[] lNode;
    public double[] zNode;
    public double[] pressureNode;
    public double[] temperatureNode;
    public double[] tempEnvironmentNode;
    public double[] salinityNode;
    public double[] densityNode;
    public double[] viscosityNode;
    public double[] heatCapacityNode;
    public double[] qVolNode;
    public double[] dPgravSegment;
    public double[] dPviscSegment;
    public double[] dPpumpSegment;
    public boolean notConverting = false;
    public String Name;
    public double Length;
    public double[] InnerDiameter;
    public double OuterDiameter;
    public double[] Roughness;
    public double Zbegin;
    public double Zend;
    public double[] SectionDepthAH;
    public double[] SectionDepthTVD;
    public double[] SectionAngle;
    public double[] InnerDiameterSegment;
    public double[] RoughnessSegment;
    public double[] SegmentAngle;
    public double[] SegmentIndex;
    private double PumpZ;
    public double PumpPressure;
    public double PumpMaxRate;
    public double PumpEfficiency;
    public PipeTempCalcMethod TemperatureCalculationOption;
    public double Qmass;
    public double QvolAvg;
    public double DpTotal;
    public double DTTotal;
    public double DpGravTotal;
    public double DpViscTotal;
    public double DpPumpTotal;
    public int SegmentsCount;
    public double SegmentLength;
    public int NodesCount;
    public int PumpSegment;
    public boolean PumpPresent;

    public TnoPipe(String name, double pipeScaling, double[] depthSpec, double[] segmentSpec, double diamOutSpec, double[] diamInSpec, double[] roughSpec, double segmentLengthTarget, boolean pumpPresent, double pumpZSpec, double pumpPressureSpec, double pumpMaxRateSpec, double pumpEfficiencySpec) {
        this.Name = name;
        this.SectionDepthAH = (double[])segmentSpec.clone();
        this.SectionDepthTVD = (double[])depthSpec.clone();
        this.SectionAngle = new double[segmentSpec.length];
        double md_prev = 0.0;
        double tvd_prev = 0.0;
        for (int s = 0; s < segmentSpec.length; ++s) {
            this.SectionAngle[s] = Math.acos((this.SectionDepthTVD[s] - tvd_prev) / (this.SectionDepthAH[s] - md_prev));
            tvd_prev = this.SectionDepthTVD[s];
            md_prev = this.SectionDepthAH[s];
        }
        int segmentToUpdate = 0;
        double diameter = 0.0;
        for (int s = 0; s < diamInSpec.length; ++s) {
            if (!(diamInSpec[s] > diameter)) continue;
            diameter = diamInSpec[s];
            segmentToUpdate = s;
        }
        double dTVD = segmentToUpdate == 0 ? (this.SectionDepthTVD[segmentToUpdate] < pipeScaling ? this.SectionDepthTVD[segmentToUpdate] : pipeScaling) : (this.SectionDepthTVD[segmentToUpdate] - this.SectionDepthTVD[segmentToUpdate - 1] < pipeScaling ? this.SectionDepthTVD[segmentToUpdate] - this.SectionDepthTVD[segmentToUpdate - 1] : pipeScaling);
        double dAH = dTVD / Math.cos(this.SectionAngle[segmentToUpdate]);
        for (int s = segmentToUpdate; s < segmentSpec.length; ++s) {
            this.SectionDepthAH[s] = this.SectionDepthAH[s] + dAH;
            this.SectionDepthTVD[s] = this.SectionDepthTVD[s] + dTVD;
        }
        this.InnerDiameter = diamInSpec;
        this.OuterDiameter = diamOutSpec;
        this.Roughness = roughSpec;
        this.Length = this.SectionDepthAH[this.SectionDepthAH.length - 1];
        this.SegmentsCount = (int)Math.round(this.Length / segmentLengthTarget);
        this.SegmentLength = this.Length / (double)this.SegmentsCount;
        this.NodesCount = this.SegmentsCount + 1;
        this.InnerDiameterSegment = new double[this.SegmentsCount];
        this.RoughnessSegment = new double[this.SegmentsCount];
        this.lNode = new double[this.NodesCount];
        this.zNode = new double[this.NodesCount];
        this.pressureNode = new double[this.NodesCount];
        this.temperatureNode = new double[this.NodesCount];
        this.tempEnvironmentNode = new double[this.NodesCount];
        this.salinityNode = new double[this.NodesCount];
        this.densityNode = new double[this.NodesCount];
        this.viscosityNode = new double[this.NodesCount];
        this.heatCapacityNode = new double[this.NodesCount];
        this.qVolNode = new double[this.NodesCount];
        this.dPgravSegment = new double[this.SegmentsCount];
        this.dPviscSegment = new double[this.SegmentsCount];
        this.dPpumpSegment = new double[this.SegmentsCount];
        this.SegmentAngle = new double[this.SegmentsCount];
        this.SegmentIndex = new double[this.SegmentsCount];
        for (int iN = 0; iN < this.NodesCount; ++iN) {
            this.lNode[iN] = (double)iN * this.SegmentLength;
            double[] sectionIndex = this.getSectionIndex(this.lNode[iN]);
            if (iN > 0) {
                this.zNode[iN] = this.zNode[iN - 1] - this.SegmentLength * Math.cos(this.getSectionValue(this.SectionAngle, sectionIndex));
                int iS = iN - 1;
                this.SegmentAngle[iS] = this.getSectionValue(this.SectionAngle, sectionIndex);
                this.InnerDiameterSegment[iS] = this.getSectionValue(this.InnerDiameter, sectionIndex);
                this.RoughnessSegment[iS] = this.getSectionValue(this.Roughness, sectionIndex);
                this.SegmentIndex[iS] = sectionIndex[0] + 1.0;
                continue;
            }
            this.zNode[iN] = 0.0;
        }
        if (pumpPresent) {
            this.SetPump(pumpZSpec);
            this.PumpPressure = pumpPressureSpec;
            this.PumpMaxRate = pumpMaxRateSpec;
            this.PumpEfficiency = pumpEfficiencySpec;
        }
    }

    private double getSectionValue(double[] SectionArray, double[] sectionIndex) {
        int section = (int)sectionIndex[0];
        double scale = sectionIndex[1];
        double res = 0.0;
        if (scale > 1.0) {
            scale = 1.0;
        }
        res = scale < 1.0 ? (section == SectionArray.length - 1 ? SectionArray[section] : scale * SectionArray[section] + (1.0 - scale) * SectionArray[section + 1]) : SectionArray[section];
        return res;
    }

    private double[] getSectionIndex(double lengthAH) {
        double[] res = new double[2];
        int section = -1;
        double scale = 1.0;
        for (int i = 0; i < this.SectionDepthAH.length; ++i) {
            if (this.SectionDepthAH[i] >= lengthAH) {
                section = i;
                scale = 1.0;
                res[0] = section;
                res[1] = scale;
                return res;
            }
            if (!(this.SectionDepthAH[i] >= lengthAH - this.SegmentLength)) continue;
            section = i;
            scale = 1.0 - (lengthAH - this.SectionDepthAH[i]) / this.SegmentLength;
            res[0] = section;
            res[1] = scale;
            return res;
        }
        return res;
    }

    public void CalcPressuresAlongPipe(double qMass, double presStartCalc, double tempStartCalc, double pumpPressure, PipeCalcDirection pipeCalcDirection, PipeTempCalcMethod tempCalcOption) {
        double viscAvg;
        double densAvg;
        double dZ;
        double dL;
        double pbTolerance = 10.0;
        double ebTolerance = 10.0;
        this.PumpPressure = this.PumpPresent ? pumpPressure : 0.0;
        this.Qmass = qMass;
        int signFlow = 0;
        if (qMass > 0.0) {
            signFlow = 1;
        }
        if (qMass < 0.0) {
            signFlow = -1;
        }
        int signCalc = pipeCalcDirection == PipeCalcDirection.BeginToEnd ? 1 : -1;
        int iNstart = pipeCalcDirection == PipeCalcDirection.BeginToEnd ? 0 : this.NodesCount - 1;
        this.pressureNode[iNstart] = presStartCalc;
        if (tempCalcOption == PipeTempCalcMethod.Implicit) {
            this.temperatureNode[iNstart] = tempStartCalc;
        }
        this.densityNode[iNstart] = TnoWaterProperties.Density(this.pressureNode[iNstart], this.temperatureNode[iNstart], this.salinityNode[iNstart]);
        this.viscosityNode[iNstart] = TnoWaterProperties.Viscosity(this.pressureNode[iNstart], this.temperatureNode[iNstart], this.salinityNode[iNstart]);
        this.heatCapacityNode[iNstart] = TnoWaterProperties.HeatCapacity(this.pressureNode[iNstart], this.temperatureNode[iNstart], this.salinityNode[iNstart]);
        this.qVolNode[iNstart] = this.Qmass / this.densityNode[iNstart];
        for (int i = 1; i < this.NodesCount; ++i) {
            double tempk;
            double ebkm1;
            double tempkm1;
            double cpNode;
            double tempEnvironment;
            int iSegment;
            int iNprev;
            int iN;
            if (pipeCalcDirection == PipeCalcDirection.BeginToEnd) {
                iN = i;
                iNprev = iN - 1;
                iSegment = iN - 1;
            } else {
                iN = this.NodesCount - 1 - i;
                iNprev = iN + 1;
                iSegment = iN;
            }
            dL = this.lNode[iN] - this.lNode[iNprev];
            dZ = this.zNode[iN] - this.zNode[iNprev];
            double outerDiamSeg = this.InnerDiameterSegment[iSegment] + 0.0254;
            double presNodePrev = this.pressureNode[iNprev];
            double tempNodePrev = this.temperatureNode[iNprev];
            double densNodePrev = this.densityNode[iNprev];
            double viscNodePrev = this.viscosityNode[iNprev];
            double cpNodePrev = this.heatCapacityNode[iNprev];
            double preskm1 = presNodePrev;
            densAvg = densNodePrev;
            viscAvg = viscNodePrev;
            double pbkm1 = this.CalcPressureBalance(preskm1, presNodePrev, qMass, dZ, dL, densAvg, viscAvg, iSegment, signFlow * signCalc);
            double presk = preskm1 - pbkm1;
            if (tempCalcOption == PipeTempCalcMethod.Implicit) {
                tempEnvironment = 0.5 * (this.tempEnvironmentNode[iNprev] + this.tempEnvironmentNode[iN]);
                cpNode = cpNodePrev;
                tempkm1 = tempNodePrev;
                ebkm1 = this.CalcEnergyBalance(qMass, tempkm1, tempNodePrev, tempEnvironment, dL, cpNode, cpNodePrev, outerDiamSeg);
                tempk = tempNodePrev + 0.1;
            } else {
                tempkm1 = tempk = this.temperatureNode[iN];
                tempEnvironment = 0.0;
                ebkm1 = 0.0;
            }
            boolean pbConverged = false;
            boolean ebConverged = false;
            boolean converged = false;
            int k = 0;
            while (!converged) {
                double pbkm2;
                if (++k > 100) {
                    this.notConverting = true;
                    break;
                }
                double preskm2 = preskm1;
                preskm1 = presk;
                double tempkm2 = tempkm1;
                tempkm1 = tempk;
                if (tempCalcOption == PipeTempCalcMethod.Implicit) {
                    densAvg = 0.5 * (densNodePrev + TnoWaterProperties.Density(preskm2, tempkm1, this.salinityNode[iN]));
                    viscAvg = 0.5 * (viscNodePrev + TnoWaterProperties.Viscosity(preskm2, tempkm1, this.salinityNode[iN]));
                    pbkm2 = this.CalcPressureBalance(preskm2, presNodePrev, qMass, dZ, dL, densAvg, viscAvg, iSegment, signFlow * signCalc);
                } else {
                    pbkm2 = pbkm1;
                }
                densAvg = 0.5 * (densNodePrev + TnoWaterProperties.Density(preskm1, tempkm1, this.salinityNode[iN]));
                viscAvg = 0.5 * (viscNodePrev + TnoWaterProperties.Viscosity(preskm1, tempkm1, this.salinityNode[iN]));
                pbkm1 = this.CalcPressureBalance(preskm1, presNodePrev, qMass, dZ, dL, densAvg, viscAvg, iSegment, signFlow * signCalc);
                double dPBdp = (pbkm2 - pbkm1) / (preskm2 - preskm1);
                presk = preskm1 - pbkm1 / dPBdp;
                boolean bl = pbConverged = Math.abs(pbkm1) < 10.0;
                if (tempCalcOption == PipeTempCalcMethod.Implicit) {
                    double ebkm2 = ebkm1;
                    cpNode = TnoWaterProperties.HeatCapacity(preskm1, tempkm1, this.salinityNode[iN]);
                    ebkm1 = this.CalcEnergyBalance(qMass, tempkm1, tempNodePrev, tempEnvironment, dL, cpNode, cpNodePrev, outerDiamSeg);
                    double dEBdT = (ebkm2 - ebkm1) / (tempkm2 - tempkm1);
                    tempk = tempkm1 - ebkm1 / dEBdT;
                    ebConverged = Math.abs(ebkm1) < 10.0;
                } else {
                    ebConverged = true;
                }
                converged = pbConverged && ebConverged;
            }
            this.pressureNode[iN] = presk;
            this.temperatureNode[iN] = tempk;
            this.densityNode[iN] = TnoWaterProperties.Density(this.pressureNode[iN], this.temperatureNode[iN], this.salinityNode[iN]);
            this.viscosityNode[iN] = TnoWaterProperties.Viscosity(this.pressureNode[iN], this.temperatureNode[iN], this.salinityNode[iN]);
            this.heatCapacityNode[iN] = TnoWaterProperties.HeatCapacity(this.pressureNode[iN], this.temperatureNode[iN], this.salinityNode[iN]);
            this.qVolNode[iN] = this.Qmass / this.densityNode[iN];
        }
        this.DpTotal = this.pressureNode[this.NodesCount - 1] - this.pressureNode[0];
        this.DTTotal = this.temperatureNode[this.NodesCount - 1] - this.temperatureNode[0];
        this.DpGravTotal = 0.0;
        this.DpViscTotal = 0.0;
        this.DpPumpTotal = 0.0;
        this.QvolAvg = this.qVolNode[0];
        for (int iN = 1; iN < this.NodesCount; ++iN) {
            int iSegment = iN - 1;
            dL = this.lNode[iN] - this.lNode[iN - 1];
            dZ = this.zNode[iN] - this.zNode[iN - 1];
            densAvg = 0.5 * (this.densityNode[iN] + this.densityNode[iN - 1]);
            viscAvg = 0.5 * (this.viscosityNode[iN] + this.viscosityNode[iN - 1]);
            this.dPgravSegment[iSegment] = this.DpGravity(dZ, densAvg);
            this.dPviscSegment[iSegment] = this.DpViscous(qMass, dL, densAvg, viscAvg, iSegment);
            this.dPpumpSegment[iSegment] = this.DpPump(iSegment, signFlow);
            this.DpGravTotal += this.dPgravSegment[iSegment];
            this.DpViscTotal += this.dPviscSegment[iSegment];
            this.DpPumpTotal += this.dPpumpSegment[iSegment];
            this.QvolAvg += this.qVolNode[0];
        }
        this.QvolAvg /= (double)this.NodesCount;
    }

    private double CalcPressureBalance(double presNode, double presNodePrev, double qMass, double dZ, double dL, double densAvg, double viscAvg, int iSegment, double signPump) {
        double dpGrav = this.DpGravity(dZ, densAvg);
        double dpVisc = this.DpViscous(qMass, dL, densAvg, viscAvg, iSegment);
        double dpPump = this.DpPump(iSegment, signPump);
        double pressureBalance = presNode - presNodePrev - dpGrav - dpVisc - dpPump;
        return pressureBalance;
    }

    private double CalcEnergyBalance(double qMass, double tempNode, double tempNodePrev, double tempEnvironment, double dL, double cpNode, double cpNodePrev, double outerDiameterSegment) {
        double kt = 3.0;
        double at = 1.2E-6;
        double time = 3.1536E7;
        double qheat = Math.PI * 4 * kt * ((tempNode + tempNodePrev) * 0.5 - tempEnvironment) / Math.log(16.0 * at * time / (TnoUnits.ExpEulerConstant * outerDiameterSegment * outerDiameterSegment));
        double energyBalance = qMass * (tempNode * cpNode - tempNodePrev * cpNodePrev) / dL + qheat;
        return energyBalance;
    }

    private double DpGravity(double dZ, double density) {
        double dP = -9.80665 * dZ * density;
        return dP;
    }

    private double DpViscous(double Qmass, double dL, double density, double viscosity, int iSegment) {
        double dP;
        if (Qmass == 0.0) {
            dP = 0.0;
        } else {
            double Qvol = Math.abs(Qmass / density);
            double v = Qvol / (0.7853981633974483 * this.InnerDiameterSegment[iSegment] * this.InnerDiameterSegment[iSegment]);
            double Re = density * v * this.InnerDiameterSegment[iSegment] / viscosity;
            double tempVariable = 1.14 - 2.0 * Math.log10(this.RoughnessSegment[iSegment] / this.InnerDiameterSegment[iSegment] + 21.25 / Math.pow(Re, 0.9));
            double f = 1.0 / (tempVariable * tempVariable);
            double dPsign = Qmass > 0.0 ? -1.0 : 1.0;
            dP = dPsign * f * density * dL * v * v / (2.0 * this.InnerDiameterSegment[iSegment]);
        }
        return dP;
    }

    private double DpPump(int iSegment, double signDpPump) {
        double dP = signDpPump * (iSegment == this.PumpSegment ? this.PumpPressure : 0.0);
        return dP;
    }

    public void SetPump(double pumpZSpec) {
        this.Zbegin = 0.0;
        this.Zend = -this.SectionDepthTVD[this.SectionDepthTVD.length - 1];
        this.PumpPresent = true;
        this.PumpZ = pumpZSpec;
        if (this.Zbegin > this.Zend) {
            if (this.PumpZ >= this.Zbegin) {
                this.PumpSegment = 0;
            } else if (this.PumpZ <= this.Zend) {
                this.PumpSegment = this.SegmentsCount - 1;
            } else {
                for (int iN = 1; iN < this.NodesCount; ++iN) {
                    if (!(this.PumpZ > this.zNode[iN])) continue;
                    this.PumpSegment = iN - 1;
                    break;
                }
            }
        } else if (this.Zbegin < this.Zend) {
            if (this.PumpZ >= this.Zend) {
                this.PumpSegment = this.SegmentsCount - 1;
            } else if (this.PumpZ <= this.Zbegin) {
                this.PumpSegment = 0;
            } else {
                for (int iN = 1; iN < this.NodesCount; ++iN) {
                    if (!(this.PumpZ < this.zNode[iN])) continue;
                    this.PumpSegment = iN - 1;
                    break;
                }
            }
        } else {
            this.PumpSegment = 0;
        }
    }

    public void RemovePump() {
        this.PumpZ = 0.0;
        this.PumpPressure = 0.0;
        this.PumpMaxRate = 0.0;
        this.PumpEfficiency = 0.0;
        this.PumpPresent = false;
        this.PumpSegment = 0;
    }
}

