/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.io.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import tno.geoenergy.doubletcalc.ResultSet;
import tno.geoenergy.doubletcalc.TnoPipe;
import tno.geoenergy.doubletcalc.io.file.StringToFile;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;

public class Dataexport {
    private Dataexport() {
    }

    private static double calcAverage(double[] nodeList) {
        double i = 0.0;
        double sum = 0.0;
        for (double node : nodeList) {
            sum += node;
            i += 1.0;
        }
        return sum / i;
    }

    private static double calcDiff(double[] nodeList) {
        double first = (float)nodeList[0];
        int maxIndex = nodeList.length - 1;
        double last = (float)nodeList[maxIndex];
        return last - first;
    }

    public static void createBaseCaseCSV(File filename, ResultSet rs) {
        TnoPipe PRODUCER = rs.baseCaseProducerPipe;
        TnoPipe INJECTOR = rs.baseCaseInjectorPipe;
        String SEP = ", ";
        try {
            TnoPipe[] pipes;
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write("Doublet Calculator 1.4 Base Case Details");
            bw.newLine();
            bw.newLine();
            for (TnoPipe pipe : pipes = new TnoPipe[]{PRODUCER, INJECTOR}) {
                String pipeID = pipe.equals(PRODUCER) ? "PRODUCER" : "INJECTOR";
                bw.write("=== " + pipeID + " ===");
                bw.newLine();
                bw.write("iN, Segment, L(m), Z(m), Angle (deg), Inner diameter(inch), Roughness(milli-inch), P(bar), T(degC), S(ppm), Density(kg/m3), Viscosity(Pa s), Qvol(m3/h), dPGrav(bar), dPVisc(bar), dPpump(bar)");
                bw.newLine();
                bw.write("0, , " + pipe.lNode[0] + ", " + pipe.zNode[0] + ", " + "" + ", " + "" + ", " + "" + ", " + pipe.pressureNode[0] / 100000.0 + ", " + pipe.temperatureNode[0] + ", " + (int)(pipe.salinityNode[0] * 1000000.0) + ", " + pipe.densityNode[0] + ", " + pipe.viscosityNode[0] + ", " + pipe.qVolNode[0] * 3600.0);
                bw.newLine();
                int maxInd = pipe.lNode.length;
                for (int n = 1; n < maxInd; ++n) {
                    bw.write(n + ", " + pipe.SegmentIndex[n - 1] + ", " + pipe.lNode[n] + ", " + pipe.zNode[n] + ", " + Math.toDegrees(pipe.SegmentAngle[n - 1]) + ", " + pipe.InnerDiameterSegment[n - 1] * 39.37007874015748 + ", " + pipe.RoughnessSegment[n - 1] * 39.37007874015748 * 1000.0 + ", " + pipe.pressureNode[n] / 100000.0 + ", " + pipe.temperatureNode[n] + ", " + (int)(pipe.salinityNode[n] * 1000000.0) + ", " + pipe.densityNode[n] + ", " + pipe.viscosityNode[n] + ", " + pipe.qVolNode[n] * 3600.0 + ", " + pipe.dPgravSegment[n - 1] / 100000.0 + ", " + pipe.dPviscSegment[n - 1] / 100000.0 + ", " + pipe.dPpumpSegment[n - 1] / 100000.0);
                    bw.newLine();
                }
                bw.write("total/average/difference, " + pipe.SegmentIndex[pipe.SegmentIndex.length - 1] + ", " + Dataexport.calcDiff(pipe.lNode) + ", " + Dataexport.calcDiff(pipe.zNode) + ", " + Math.toDegrees(Dataexport.calcAverage(pipe.SegmentAngle)) + ", " + Dataexport.calcAverage(pipe.InnerDiameterSegment) * 39.37007874015748 + ", " + Dataexport.calcAverage(pipe.RoughnessSegment) * 39.37007874015748 * 1000.0 + ", " + pipe.DpTotal / 100000.0 + ", " + pipe.DTTotal + ", " + (int)(Dataexport.calcAverage(pipe.salinityNode) * 1000000.0) + ", " + Dataexport.calcAverage(pipe.densityNode) + ", " + Dataexport.calcAverage(pipe.viscosityNode) + ", " + Dataexport.calcAverage(pipe.qVolNode) * 3600.0 + ", " + pipe.DpGravTotal / 100000.0 + ", " + pipe.DpViscTotal / 100000.0 + ", " + pipe.DpPumpTotal / 100000.0);
                bw.newLine();
                bw.newLine();
                bw.newLine();
            }
            bw.write("=== DOUBLET NODES ===");
            bw.newLine();
            bw.write("Node, P(bar), T(degC)");
            int maxIndex = rs.doubletNodes.length - 2;
            for (int i = 0; i <= maxIndex; ++i) {
                bw.newLine();
                bw.write(rs.doubletNodes[i] + ", " + ResultSet.pressureAlongDoublet[i] * 1.0E-5 + ", " + ResultSet.temperatureAlongDoublet[i]);
            }
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("=== BASE CASE RESULTS ===");
            bw.newLine();
            bw.write(TnoSingularContainer.find("aquifer kH net").getTitle() + ", " + TnoSingularContainer.find("aquifer kH net").getValue());
            bw.newLine();
            bw.write(TnoSingularContainer.find("mass flow").getTitle() + ", " + TnoSingularContainer.find("mass flow").getValue());
            bw.newLine();
            bw.write(TnoSingularContainer.find("pump volume flow").getTitle() + ", " + TnoSingularContainer.find("pump volume flow").getValue());
            bw.newLine();
            bw.write(TnoSingularContainer.find("required pump power").getTitle() + ", " + TnoSingularContainer.find("required pump power").getValue());
            bw.newLine();
            bw.write(TnoSingularContainer.find("geothermal power").getTitle() + ", " + TnoSingularContainer.find("geothermal power").getValue());
            bw.newLine();
            bw.write(TnoSingularContainer.find("COP").getTitle() + ", " + TnoSingularContainer.find("COP").getValue());
            bw.newLine();
            bw.write("pressure difference producer (bar), " + (ResultSet.pressureAlongDoublet[0] - ResultSet.pressureAlongDoublet[1]) * 1.0E-5);
            bw.newLine();
            bw.write("pressure difference injector (bar), " + (ResultSet.pressureAlongDoublet[rs.doubletNodes.length - 3] - ResultSet.pressureAlongDoublet[rs.doubletNodes.length - 2]) * 1.0E-5);
            bw.newLine();
            bw.newLine();
            bw.write("=== end of file ===");
            bw.flush();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            StringToFile.showNotFoundError();
        }
        catch (IOException e) {
            e.printStackTrace();
            StringToFile.showIOError();
        }
    }
}

