/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.io.file;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileDialog {
    private static FileDialog uniqueInstance;
    private JFileChooser fileChooser = new JFileChooser();
    private Frame frame = new Frame();
    private String title;
    private String extension = ".txt";
    private CustomFileFilter filter = new CustomFileFilter();
    private File fileInfo;
    private static File directory;

    private FileDialog() {
    }

    public static FileDialog getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new FileDialog();
        }
        return uniqueInstance;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setExtension(String s) {
        this.extension = s;
    }

    public File getDirectory() {
        return directory;
    }

    private File checkExtension(File f) {
        String fileName = f.toString().toLowerCase();
        if (fileName.endsWith(this.extension.toLowerCase())) {
            return new File(fileName);
        }
        return new File(fileName + this.extension.toLowerCase());
    }

    private void initializeDialog() {
        this.fileChooser.setDialogTitle(this.title);
        this.filter.setCustomFileFilter(this.extension);
        this.fileChooser.setFileFilter(this.filter);
        this.fileChooser.setCurrentDirectory(directory);
    }

    private int getSecurityDialog() {
        return JOptionPane.showConfirmDialog(this.frame, this.fileChooser.getSelectedFile().getName() + " already exists. Replace?", this.title, 0, 2);
    }

    private void getInfoDialog() {
        JOptionPane.showMessageDialog(this.frame, this.fileChooser.getSelectedFile().getName() + " does not exist.", this.title, 2);
    }

    public File saveDialog() {
        this.initializeDialog();
        boolean onFileDialog = true;
        while (onFileDialog) {
            int retValue = this.fileChooser.showSaveDialog(this.frame);
            if (retValue == 0) {
                this.fileInfo = this.checkExtension(this.fileChooser.getSelectedFile());
                if (this.fileChooser.getSelectedFile().exists() && this.getSecurityDialog() != 0) continue;
                break;
            }
            this.fileInfo = null;
            break;
        }
        directory = this.fileChooser.getCurrentDirectory();
        return this.fileInfo;
    }

    public File openDialog() {
        this.initializeDialog();
        boolean onFileDialog = true;
        while (onFileDialog) {
            int retValue = this.fileChooser.showOpenDialog(this.frame);
            if (retValue == 0) {
                if (this.fileChooser.getSelectedFile().exists()) {
                    this.fileInfo = this.fileChooser.getSelectedFile();
                    break;
                }
                this.getInfoDialog();
                continue;
            }
            this.fileInfo = null;
            break;
        }
        directory = this.fileChooser.getCurrentDirectory();
        return this.fileInfo;
    }

    static {
        directory = new File(".");
    }

    private class CustomFileFilter
    extends FileFilter {
        private String extension;

        private CustomFileFilter() {
        }

        private void setCustomFileFilter(String ext) {
            this.extension = ext;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fileName = f.getName().toLowerCase();
            return fileName.endsWith(this.extension.toLowerCase());
        }

        public String getDescription() {
            return this.extension;
        }
    }
}

