/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.stochastic;

import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticObject;

public class TnoSingularVariable
extends TnoStochasticObject {
    private double value;
    private double[] arrayvalue;
    private boolean optional;

    public TnoSingularVariable(String name, String unit, double value) {
        this.name = name;
        this.units = unit;
        this.value = value;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, double unitFactor, int round) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.unitFactor = unitFactor;
        this.round = round;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, double unitFactor, int round, boolean optional) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.unitFactor = unitFactor;
        this.round = round;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, boolean optional) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value, double unitFactor, int round) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        this.unitFactor = unitFactor;
        this.round = round;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value, double unitFactor, int round, boolean optional) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        this.unitFactor = unitFactor;
        this.round = round;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.units;
    }

    public double getValue() {
        return this.value;
    }

    public String getStrValue(int i) {
        if (i < this.arrayvalue.length) {
            return Double.toString(this.arrayvalue[i]);
        }
        return "";
    }

    public int getSize() {
        return this.arrayvalue.length;
    }

    public double[] getArray() {
        return this.arrayvalue;
    }

    public final double getValueForm() {
        return this.format(this.value);
    }

    public final String getStrValueForm() {
        try {
            double[] arr = this.format(this.arrayvalue);
            String res = "";
            for (int i = 0; i < arr.length; ++i) {
                res = res + arr[i];
                if (i == arr.length - 1) continue;
                res = res + ",";
            }
            return res;
        }
        catch (Exception e) {
            return Double.toString(this.format(this.value));
        }
    }

    public String getTitle() {
        String s = this.name + " " + "(" + this.units + ")";
        if (!this.optional) {
            return s;
        }
        return "[ " + s + " ]";
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setArray(double[] value) {
        this.arrayvalue = value;
    }

    public void setName(String name) {
        this.name = name;
    }
}

