/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.stochastic;

import java.util.Arrays;
import tno.geoenergy.doubletcalc.stochastic.TnoDistributionVarTriangular;
import tno.geoenergy.doubletcalc.stochastic.TnoDistributionVariable;
import tno.geoenergy.doubletcalc.stochastic.TnoRunControl;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticObject;

public class TnoStochasticVariable
extends TnoStochasticObject {
    protected double[] realisations = null;
    protected int numSamples = 0;
    public TnoDistributionVariable distribution = null;

    public double[] getRealisations() {
        return this.realisations;
    }

    public float[] getSortedRealisationsAsFloat() {
        double[] sortedRealisations = this.sort();
        float[] v = new float[this.numSamples];
        for (int i = 0; i < this.numSamples; ++i) {
            v[i] = (float)sortedRealisations[i];
        }
        return v;
    }

    public void setRealisations(double[] realisations) {
        this.realisations = realisations;
    }

    public TnoDistributionVariable getDistribution() {
        return this.distribution;
    }

    public void setDistribution(TnoDistributionVariable distribution) {
        this.distribution = distribution;
    }

    public TnoStochasticVariable(double[] samples) {
        this.realisations = samples;
        this.numSamples = samples.length;
    }

    public double NextValue(int i) {
        if (i == 0) {
            this.buildRealisations();
        }
        return this.realisations[i];
    }

    public TnoStochasticVariable(int nSamples) {
        this.numSamples = nSamples;
        this.createEmptyRealisations();
    }

    public TnoStochasticVariable(int nSamples, TnoDistributionVariable dist) {
        this.numSamples = nSamples;
        this.distribution = dist;
    }

    public TnoStochasticVariable(int nSamples, TnoDistributionVarTriangular dist) {
        this.numSamples = nSamples;
        this.distribution = dist;
    }

    public void setSamplesAndDist(int nSamples, TnoDistributionVarTriangular dist) {
        this.numSamples = nSamples;
        this.distribution = dist;
    }

    public TnoStochasticVariable(String name, String units, int idType) {
        super(name, units, idType);
        this.numSamples = TnoRunControl.numSamples;
        this.distribution = null;
    }

    public TnoStochasticVariable(String name, String units, int idType, double unitFactor, int round) {
        super(name, units, idType);
        this.numSamples = TnoRunControl.numSamples;
        this.distribution = null;
        this.unitFactor = unitFactor;
        this.round = round;
    }

    public void buildRealisations() {
        if (this.distribution != null) {
            this.realisations = this.distribution.generateSamples(this.numSamples);
        } else {
            this.createEmptyRealisations();
        }
    }

    public double size() {
        if (this.realisations != null) {
            return this.realisations.length;
        }
        return 0.0;
    }

    public void setSample(int i, double v) {
        this.realisations[i] = v;
    }

    public final double calcMax() {
        double result = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            double value = this.realisations[i];
            if (i == 0) {
                result = value;
            } else if (result < value) {
                result = value;
            }
            ++i;
        }
        return result;
    }

    public final double calcMean() {
        double total = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            total += this.realisations[i];
            ++i;
        }
        return total / this.size();
    }

    public final double calcMin() {
        double result = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            double value = this.realisations[i];
            if (i == 0) {
                result = value;
            } else if (result > value) {
                result = value;
            }
            ++i;
        }
        return result;
    }

    public final double calcDownside() {
        double result = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            double value = this.realisations[i];
            if (value < 0.0) {
                result += value;
            }
            ++i;
        }
        return result / this.size();
    }

    public final double calcUpside() {
        double result = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            double value = this.realisations[i];
            if (value > 0.0) {
                result += value;
            }
            ++i;
        }
        return result / this.size();
    }

    public final double calcPValue(double chance) {
        if (chance > 100.0 || chance < 0.0) {
            throw new RuntimeException("Invalid chance given : P" + chance);
        }
        chance = 100.0 - chance;
        int sampleCount = this.realisations.length;
        if (sampleCount == 1) {
            return this.realisations[0];
        }
        double[] sortedRealisations = this.sort();
        int chosenRealisation = (int)((double)sampleCount * chance / 100.0);
        if (chosenRealisation >= sampleCount) {
            return sortedRealisations[sampleCount - 1];
        }
        return sortedRealisations[chosenRealisation];
    }

    public final double calcPValueForm(double chance) {
        double pvalue = this.calcPValue(chance);
        return this.format(pvalue);
    }

    public double calcPvalueX(double x) {
        double p = this.size();
        double[] sortedRealisations = this.sort();
        int i = 0;
        while ((double)i < this.size()) {
            if (sortedRealisations[i] >= x) {
                return p * 1.0 / this.size();
            }
            p -= 1.0;
            ++i;
        }
        return p * 1.0 / this.size();
    }

    public final double calcStandardDeviation() {
        return Math.sqrt(this.calcVariance());
    }

    public final double calcVariance() {
        double total = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            total += this.realisations[i] * this.realisations[i];
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        double mean = this.calcMean();
        return Math.abs(total / this.size() - mean * mean);
    }

    public final double calcRangeWidth() {
        return this.calcMax() - this.calcMin();
    }

    public final double calcMedian() {
        return this.calcPValue(50.0);
    }

    public final double calcMeanStandardError() {
        return this.calcStandardDeviation() / Math.sqrt(this.size());
    }

    public final double calcCoeffientOfVariability() {
        return this.calcStandardDeviation() / this.calcMean();
    }

    public final double calcMoment(int m) {
        double mean = this.calcMean();
        double total = 0.0;
        int i = 0;
        while ((double)i < this.size()) {
            total += Math.pow(this.realisations[i] - mean, m);
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return total / this.size();
    }

    public final double calcSkewness() {
        double sd = this.calcStandardDeviation();
        double m3 = this.calcMoment(3);
        return m3 / Math.pow(sd, 3.0);
    }

    public final double calcKurtosis() {
        double m2 = this.calcMoment(2);
        double m4 = this.calcMoment(4);
        return m4 / (m2 * m2);
    }

    public void createEmptyRealisations() {
        if (this.realisations == null || this.numSamples != this.realisations.length) {
            this.realisations = new double[this.numSamples];
        }
        for (int i = 0; i < this.realisations.length; ++i) {
            this.realisations[i] = 0.0;
        }
    }

    protected double[] sort() {
        return this.sort(this.realisations);
    }

    protected double[] sort(double[] original) {
        if (original.length > 1) {
            double[] sorted = new double[original.length];
            System.arraycopy(original, 0, sorted, 0, original.length);
            Arrays.sort(sorted);
            return sorted;
        }
        return original;
    }
}

