/*
 * Decompiled with CFR 0.152.
 */
package okada;

import okada.DCCON0;
import okada.DCCON2;
import okada.SINGULAR;
import okada.StressChange;
import tno.geoenergy.data.Grid;
import tno.geoenergy.util.AsciiOut;

public class DC3D {
    public static double UX;
    public static double UY;
    public static double UZ;
    public static double UXX;
    public static double UYX;
    public static double UZX;
    public static double UXY;
    public static double UYY;
    public static double UZY;
    public static double UXZ;
    public static double UYZ;
    public static double UZZ;
    public static double IRET;
    private static int k;
    private static int j;
    private static int i;
    private static int l;
    public static double AI4;
    public static double AI3;
    public static double AK1;
    public static double AK3;
    public static double AJ3;
    public static double AJ6;
    public static double RD2;
    public static int F5;
    public static double XIX;
    public static double ETE;
    public static double[] XI;
    public static double[] ET;
    public static double[] KXI;
    public static double[] KET;
    public static double[] U;
    public static double[] DU;
    public static double[] DUA;
    public static double[] DUB;
    public static double[] DUC;
    public static double XY;
    public static double QX;
    public static double QY;
    public static double exx;
    public static double exy;
    public static double exz;
    public static double eyx;
    public static double eyy;
    public static double eyz;
    public static double ezx;
    public static double ezy;
    public static double ezz;
    public static double Sxx;
    public static double Sxy;
    public static double Sxz;
    public static double Syx;
    public static double Syy;
    public static double Syz;
    public static double Szx;
    public static double Szy;
    public static double Szz;
    public static double oz;
    public static double ox;
    public static double oy;
    public static double X;

    static {
        F5 = 5;
        XI = new double[2];
        ET = new double[2];
        KXI = new double[2];
        KET = new double[2];
        U = new double[13];
        DU = new double[13];
        DUA = new double[13];
        DUB = new double[13];
        DUC = new double[13];
    }

    public static void testa() {
        double sx = 0.0;
        double sy = 0.0;
        double sz = 4.8;
        double azim = 0.0;
        double dip = 0.0;
        double length = 5.0;
        double width = 5.0;
        DC3D.initializeSource(sx, sy, sz, azim, dip, length, width);
        System.out.println("source " + sx + " " + sy + " " + sz);
        System.out.println(" observations ");
        System.out.println("          x(m)            y(m)           z(km)          ux(m)            uy(m)          uz(m)          uxx              uyy           uzz");
        int NX = 10;
        int NY = 10;
        double dx = 1.0;
        double dy = 1.0;
        int i = 0;
        while (i < NX) {
            double xg = sx + (double)(i + 1) * dx;
            int j = 0;
            while (j < NY) {
                double yg = sy + (double)(j + 1) * dy;
                oz = -4.8;
                DCCON2.setObervationLocation(xg, yg, oz);
                ox = DCCON2.ox;
                oy = DCCON2.oy;
                DC3D.calculateAtObservation(ox, oy, oz, -oz, DCCON2.L1, DCCON2.L2, DCCON2.W1, DCCON2.W2, DCCON2.DISL1, DCCON2.DISL2, DCCON2.DISL3);
                AsciiOut as_f1 = new AsciiOut("00000.00000000", 15);
                AsciiOut as_f2 = new AsciiOut("00000.0000", 15);
                System.out.println(String.valueOf(as_f2.format(ox)) + " " + as_f2.format(oy) + " " + as_f2.format(oz) + " " + as_f1.format(Sxx) + " " + as_f1.format(UY) + " " + as_f1.format(UZ) + " " + as_f1.format(UXX) + " " + as_f1.format(UYY) + " " + as_f1.format(UZZ) + "     " + as_f1.format(UXZ) + as_f1.format(UYZ) + as_f1.format(UYX) + as_f1.format(UZX) + as_f1.format(UXY) + as_f1.format(UZY));
                ++j;
            }
            ++i;
        }
    }

    public static void test2() {
        double dx;
        double sx = -20.0;
        double sy = -20.0;
        double sz = 4.8;
        double azim = 40.0;
        double dip = 30.0;
        double length = 20.0;
        double width = 20.0;
        DC3D.initializeSource(sx, sy, sz, azim, dip, length, width);
        System.out.println("source " + sx + " " + sy + " " + sz);
        System.out.println(" observations ");
        System.out.println("x y z   ux uy  uz  uxx uyy uzz");
        int NX = 20;
        int NY = 20;
        double dy = dx = 2.0;
        AsciiOut as_f1 = new AsciiOut("00000.00", 15);
        String filename = "C:/Users/Saad/Desktop/Results/test1.grd";
        Grid g = DC3D.getGrid(sx, sy, dx, dy, NX, NY, filename);
        System.out.println("source " + sx + " " + sy + " " + sz);
        System.out.println(" observations ");
        System.out.println("x y z   ux uy  uz  uxx uyy uzz");
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                double ox = sx + (double)(i + 1) * dx;
                double oy = sy + (double)(j + 1) * dy;
                oz = -4.8;
                DCCON2.setObervationLocation(ox, oy, oz);
                DC3D.calculateAtObservation(ox, oy, oz, -oz, DCCON2.L1, DCCON2.L2, DCCON2.W1, DCCON2.W2, DCCON2.DISL1, DCCON2.DISL2, DCCON2.DISL3);
                StressChange.vectors(oz, azim, dip);
                g.values[i][j] = (float)StressChange.sn;
                ++j;
            }
            ++i;
        }
        try {
            g.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Grid getGrid(double orx, double ory, double dx, double dy, int nx, int ny, String filename) {
        Grid grid = new Grid();
        grid.values = new float[nx][ny];
        grid.originx = (float)orx;
        grid.originy = (float)ory;
        grid.dx = (float)dx;
        grid.dy = (float)dy;
        grid.nx = nx;
        grid.ny = ny;
        grid.setDataFormat("SURFER");
        grid.setFileName(filename);
        return grid;
    }

    public static void main(String[] args) {
        DC3D.testa();
    }

    public static void initializeSource(double sx, double sy, double sz, double azim, double dip, double length, double width) {
        DCCON2.setSourceLocation(sx, sy, sz);
        DCCON2.setSourceDimensions(azim, dip, length, width);
        DCCON2.prepareSource();
    }

    public static void calculateAtObservation(double ox, double oy, double oz, double DEPTH, double L1, double L2, double W1, double W2, double DISL1, double DISL2, double DISL3) {
        double KETJ;
        double KXIK;
        double R22;
        double R21;
        double R12;
        i = 0;
        while (i <= 12) {
            DC3D.U[DC3D.i] = DCCON0.F0;
            DC3D.DUA[DC3D.i] = DCCON0.F0;
            DC3D.DUB[DC3D.i] = DCCON0.F0;
            DC3D.DUC[DC3D.i] = DCCON0.F0;
            ++i;
        }
        DC3D.XI[0] = ox - L1;
        DC3D.XI[1] = ox - L2;
        if (Math.abs(XI[0]) < DCCON2.EPS) {
            DC3D.XI[0] = DCCON2.F0;
        }
        if (Math.abs(XI[1]) < DCCON2.EPS) {
            DC3D.XI[1] = DCCON2.F0;
        }
        double D = DEPTH + oz;
        double P = oy * DCCON2.CD + D * DCCON2.SD;
        double Q = oy * DCCON2.SD - D * DCCON2.CD;
        DC3D.ET[0] = P - W1;
        DC3D.ET[1] = P - W2;
        if (Math.abs(Q) < DCCON2.EPS) {
            Q = DCCON2.F0;
        }
        if (Math.abs(ET[0]) < DCCON2.EPS) {
            DC3D.ET[0] = DCCON2.F0;
        }
        if (Math.abs(ET[1]) < DCCON2.EPS) {
            DC3D.ET[1] = DCCON2.F0;
        }
        if (Q == DCCON2.F0 && (XI[0] * XI[1] <= DCCON2.F0 && ET[0] * ET[1] == DCCON2.F0 || ET[0] * ET[1] <= DCCON2.F0 && XI[0] * XI[1] == DCCON2.F0)) {
            SINGULAR.singular();
        } else {
            DC3D.KXI[0] = 0.0;
            DC3D.KXI[1] = 0.0;
            DC3D.KET[0] = 0.0;
            DC3D.KET[1] = 0.0;
            R12 = Math.sqrt(XI[0] * XI[0] + ET[1] * ET[1] + Q * Q);
            R21 = Math.sqrt(XI[1] * XI[1] + ET[0] * ET[0] + Q * Q);
            R22 = Math.sqrt(XI[1] * XI[1] + ET[1] * ET[1] + Q * Q);
            if (XI[0] < DCCON2.F0 && R21 + XI[1] < DCCON2.EPS) {
                DC3D.KXI[0] = 1.0;
            }
            if (XI[0] < DCCON2.F0 && R22 + XI[1] < DCCON2.EPS) {
                DC3D.KXI[1] = 1.0;
            }
            if (ET[0] < DCCON2.F0 && R12 + ET[1] < DCCON2.EPS) {
                DC3D.KET[0] = 1.0;
            }
            if (ET[0] < DCCON2.F0 && R22 + ET[1] < DCCON2.EPS) {
                DC3D.KET[1] = 1.0;
            }
        }
        k = 0;
        while (k <= 1) {
            j = 0;
            while (j <= 1) {
                XIX = XI[j];
                ETE = ET[k];
                KXIK = KXI[k];
                KETJ = KET[j];
                DCCON2.DCCON2(XIX, ETE, Q, DCCON2.SD, DCCON2.CD, KXIK, KETJ);
                DC3D.UA(XIX, ETE, Q, DISL1, DISL2, DISL3, DUA);
                i = 1;
                while (i <= 10) {
                    DC3D.DU[DC3D.i] = -DUA[i];
                    DC3D.DU[DC3D.i + 1] = -(DUA[i + 1] * DCCON2.CD) + DUA[i + 2] * DCCON2.SD;
                    DC3D.DU[DC3D.i + 2] = -(DUA[i + 1] * DCCON2.SD) - DUA[i + 2] * DCCON2.CD;
                    if (i >= 10) {
                        DC3D.DU[DC3D.i] = -DU[i];
                        DC3D.DU[DC3D.i + 1] = -DU[i + 1];
                        DC3D.DU[DC3D.i + 2] = -DU[i + 2];
                    }
                    i += 3;
                }
                i = 1;
                while (i <= 12) {
                    if (j + k != 1) {
                        DC3D.U[DC3D.i] = U[i] + DU[i];
                    }
                    if (j + k == 1) {
                        DC3D.U[DC3D.i] = U[i] - DU[i];
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        D = DEPTH - oz;
        P = oy * DCCON2.CD + D * DCCON2.SD;
        Q = oy * DCCON2.SD - D * DCCON2.CD;
        DC3D.ET[0] = P - W1;
        DC3D.ET[1] = P - W2;
        if (Math.abs(Q) < DCCON2.EPS) {
            Q = DCCON2.F0;
        }
        if (Math.abs(ET[0]) < DCCON2.EPS) {
            DC3D.ET[0] = DCCON2.F0;
        }
        if (Math.abs(ET[1]) < DCCON2.EPS) {
            DC3D.ET[1] = DCCON2.F0;
        }
        if (Q == DCCON2.F0 && (XI[0] * XI[1] <= DCCON2.F0 && ET[0] * ET[1] == DCCON2.F0 || ET[0] * ET[1] <= DCCON2.F0 && XI[0] * XI[1] == DCCON2.F0)) {
            SINGULAR.singular();
        } else {
            DC3D.KXI[0] = 0.0;
            DC3D.KXI[1] = 0.0;
            DC3D.KET[0] = 0.0;
            DC3D.KET[1] = 0.0;
            R12 = Math.sqrt(XI[0] * XI[0] + ET[1] * ET[1] + Q * Q);
            R21 = Math.sqrt(XI[1] * XI[1] + ET[0] * ET[0] + Q * Q);
            R22 = Math.sqrt(XI[1] * XI[1] + ET[1] * ET[1] + Q * Q);
            if (XI[0] < DCCON2.F0 && R21 + XI[1] < DCCON2.EPS) {
                DC3D.KXI[0] = 1.0;
            }
            if (XI[0] < DCCON2.F0 && R22 + XI[1] < DCCON2.EPS) {
                DC3D.KXI[1] = 1.0;
            }
            if (ET[0] < DCCON2.F0 && R12 + ET[1] < DCCON2.EPS) {
                DC3D.KET[0] = 1.0;
            }
            if (ET[0] < DCCON2.F0 && R22 + ET[1] < DCCON2.EPS) {
                DC3D.KET[1] = 1.0;
            }
        }
        k = 0;
        while (k <= 1) {
            j = 0;
            while (j <= 1) {
                XIX = XI[j];
                ETE = ET[k];
                KXIK = KXI[k];
                KETJ = KET[j];
                DCCON2.DCCON2(XIX, ETE, Q, DCCON2.SD, DCCON2.CD, KXIK, KETJ);
                DC3D.UA(XIX, ETE, Q, DISL1, DISL2, DISL3, DUA);
                DC3D.UB(XIX, ETE, Q, DISL1, DISL2, DISL3, DUB);
                DC3D.UC(XIX, ETE, Q, oz, DISL1, DISL2, DISL3, DUC);
                i = 1;
                while (i <= 10) {
                    DC3D.DU[DC3D.i] = DUA[i] + DUB[i] + oz * DUC[i];
                    DC3D.DU[DC3D.i + 1] = (DUA[i + 1] + DUB[i + 1] + oz * DUC[i + 1]) * DCCON2.CD - (DUA[i + 2] + DUB[i + 2] + oz * DUC[i + 2]) * DCCON2.SD;
                    DC3D.DU[DC3D.i + 2] = (DUA[i + 1] + DUB[i + 1] - oz * DUC[i + 1]) * DCCON2.SD + (DUA[i + 2] + DUB[i + 2] - oz * DUC[i + 2]) * DCCON2.CD;
                    if (i >= 10) {
                        DC3D.DU[10] = DU[10] + DUC[1];
                        DC3D.DU[11] = DU[11] + DUC[2] * DCCON2.CD - DUC[3] * DCCON2.SD;
                        DC3D.DU[12] = DU[12] - DUC[2] * DCCON2.SD - DUC[3] * DCCON2.CD;
                    }
                    i += 3;
                }
                i = 1;
                while (i <= 12) {
                    if (j + k != 1) {
                        DC3D.U[DC3D.i] = U[i] + DU[i];
                    }
                    if (j + k == 1) {
                        DC3D.U[DC3D.i] = U[i] - DU[i];
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        UX = U[1];
        UY = U[2];
        UZ = U[3];
        UXX = U[4];
        UYX = U[5];
        UZX = U[6];
        UXY = U[7];
        UYY = U[8];
        UZY = U[9];
        UXZ = U[10];
        UYZ = U[11];
        UZZ = U[12];
        IRET = 0.0;
        exx = UXX;
        eyy = UYY;
        ezz = UZZ;
        exy = eyx = 0.5 * (UYX + UXY);
        exz = ezx = 0.5 * (UXZ + UZX);
        eyz = ezy = 0.5 * (UYZ + UZY);
        double vol = UXX + UYY + UZZ;
        double YOUNG = DCCON2.E;
        double POIS = DCCON2.v;
        double sk = YOUNG / (1.0 + POIS);
        double gk = POIS / (1.0 - 2.0 * POIS);
        Sxx = sk * (gk * vol + UXX);
        Syy = sk * (gk * vol + UYY);
        Szz = sk * (gk * vol + UZZ);
        Sxy = Syx = YOUNG / (2.0 * (1.0 + POIS)) * (UXY + UYX);
        Sxz = Szx = YOUNG / (2.0 * (1.0 + POIS)) * (UXZ + UZX);
        Syz = Szy = YOUNG / (2.0 * (1.0 + POIS)) * (UYZ + UZY);
    }

    public static void UA(double XIX, double ETE, double Q, double DISL1, double DISL2, double DISL3, double[] U) {
        i = 1;
        while (i <= 12) {
            U[DC3D.i] = DCCON0.F0;
            ++i;
        }
        XY = XIX * DCCON2.Y11;
        QX = Q * DCCON2.X11;
        QY = Q * DCCON2.Y11;
        if (DISL1 != DCCON2.F0) {
            DC3D.DU[1] = DCCON2.TT / DCCON2.F2 + DCCON2.ALP2 * XIX * QY;
            DC3D.DU[2] = DCCON2.ALP2 * Q / DCCON2.R;
            DC3D.DU[3] = DCCON2.ALP1 * DCCON2.ALE - DCCON2.ALP2 * Q * QY;
            DC3D.DU[4] = -(DCCON2.ALP1 * QY) - DCCON2.ALP2 * DCCON2.XI2 * Q * DCCON2.Y32;
            DC3D.DU[5] = -(DCCON2.ALP2 * XIX * Q) / DCCON2.R3;
            DC3D.DU[6] = DCCON2.ALP1 * XY + DCCON2.ALP2 * XIX * DCCON2.Q2 * DCCON2.Y32;
            DC3D.DU[7] = DCCON2.ALP1 * XY * DCCON2.SD + DCCON2.ALP2 * XIX * DCCON2.FY + DCCON2.D / DCCON2.F2 * DCCON2.X11;
            DC3D.DU[8] = DCCON2.ALP2 * DCCON2.EY;
            DC3D.DU[9] = DCCON2.ALP1 * (DCCON2.CD / DCCON2.R + QY * DCCON2.SD) - DCCON2.ALP2 * Q * DCCON2.FY;
            DC3D.DU[10] = DCCON2.ALP1 * XY * DCCON2.CD + DCCON2.ALP2 * XIX * DCCON2.FZ + DCCON2.Y / DCCON2.F2 * DCCON2.X11;
            DC3D.DU[11] = DCCON2.ALP2 * DCCON2.EZ;
            DC3D.DU[12] = -(DCCON2.ALP1 * (DCCON2.SD / DCCON2.R - QY * DCCON2.CD)) - DCCON2.ALP2 * Q * DCCON2.FZ;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL1 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL2 != DCCON2.F0) {
            DC3D.DU[1] = DCCON2.ALP2 * (Q / DCCON2.R);
            DC3D.DU[2] = DCCON2.TT / DCCON2.F2 + DCCON2.ALP2 * ETE * QX;
            DC3D.DU[3] = DCCON2.ALP1 * DCCON2.ALX - DCCON2.ALP2 * Q * QX;
            DC3D.DU[4] = -(DCCON2.ALP2 * XIX * Q) / DCCON2.R3;
            DC3D.DU[5] = -(QY / DCCON2.F2) - DCCON2.ALP2 * ETE * Q / DCCON2.R3;
            DC3D.DU[6] = DCCON2.ALP1 / DCCON2.R + DCCON2.ALP2 * (DCCON2.Q2 / DCCON2.R3);
            DC3D.DU[7] = DCCON2.ALP2 * DCCON2.EY;
            DC3D.DU[8] = DCCON2.ALP1 * DCCON2.D * DCCON2.X11 + XY / DCCON2.F2 * DCCON2.SD + DCCON2.ALP2 * ETE * DCCON2.GY;
            DC3D.DU[9] = DCCON2.ALP1 * DCCON2.Y * DCCON2.X11 - DCCON2.ALP2 * Q * DCCON2.GY;
            DC3D.DU[10] = DCCON2.ALP2 * DCCON2.EZ;
            DC3D.DU[11] = DCCON2.ALP1 * DCCON2.Y * DCCON2.X11 + XY / DCCON2.F2 * DCCON2.CD + DCCON2.ALP2 * ETE * DCCON2.GZ;
            DC3D.DU[12] = -(DCCON2.ALP1 * DCCON2.D * DCCON2.X11) - DCCON2.ALP2 * Q * DCCON2.GZ;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL2 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL3 != DCCON2.F0) {
            DC3D.DU[1] = -(DCCON2.ALP1 * DCCON2.ALE) - DCCON2.ALP2 * Q * QY;
            DC3D.DU[2] = -(DCCON2.ALP1 * DCCON2.ALX) - DCCON2.ALP2 * Q * QX;
            DC3D.DU[3] = DCCON2.TT / DCCON2.F2 - DCCON2.ALP2 * (ETE * QX + XIX * QY);
            DC3D.DU[4] = -(DCCON2.ALP1 * XY) + DCCON2.ALP2 * XIX * DCCON2.Q2 * DCCON2.Y32;
            DC3D.DU[5] = -(DCCON2.ALP1 / DCCON2.R) + DCCON2.ALP2 * DCCON2.Q2 / DCCON2.R3;
            DC3D.DU[6] = -(DCCON2.ALP1 * QY) - DCCON2.ALP2 * Q * DCCON2.Q2 * DCCON2.Y32;
            DC3D.DU[7] = -(DCCON2.ALP1 * (DCCON2.CD / DCCON2.R + QY * DCCON2.SD)) - DCCON2.ALP2 * Q * DCCON2.FY;
            DC3D.DU[8] = -(DCCON2.ALP1 * DCCON2.Y * DCCON2.X11) - DCCON2.ALP2 * Q * DCCON2.GY;
            DC3D.DU[9] = DCCON2.ALP1 * (DCCON2.D * DCCON2.X11 + XY * DCCON2.SD) + DCCON2.ALP2 * Q * DCCON2.HY;
            DC3D.DU[10] = DCCON2.ALP1 * (DCCON2.SD / DCCON2.R - QY * DCCON2.CD) - DCCON2.ALP2 * Q * DCCON2.FZ;
            DC3D.DU[11] = DCCON2.ALP1 * DCCON2.D * DCCON2.X11 - DCCON2.ALP2 * Q * DCCON2.GZ;
            DC3D.DU[12] = DCCON2.ALP1 * (DCCON2.Y * DCCON2.X11 + XY * DCCON2.CD) + DCCON2.ALP2 * Q * DCCON2.HZ;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL3 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
    }

    public static void UB(double XIX, double ETE, double Q, double DISL1, double DISL2, double DISL3, double[] U) {
        double RD = DCCON2.R + DCCON2.D;
        double D11 = DCCON2.F1 / (DCCON2.R * RD);
        double AJ2 = XIX * DCCON2.Y / RD * D11;
        double AJ5 = -(DCCON2.D + DCCON2.Y * DCCON2.Y / RD) * D11;
        if (DCCON2.CD != DCCON2.F0) {
            if (XIX != DCCON2.F0) {
                AI4 = DCCON2.F0;
            } else {
                X = Math.sqrt(DCCON2.XI2 + DCCON2.Q2);
                AI4 = DCCON2.F1 / DCCON2.CDCD * (XIX / RD * DCCON2.SDCD + DCCON2.F2 * Math.atan((ETE * (X + Q * DCCON2.CD) + X * (DCCON2.R + X) * DCCON2.SD) / (XIX * (DCCON2.R + X) * DCCON2.CD)));
            }
            AI3 = (DCCON2.Y * DCCON2.CD / RD - DCCON2.ALE + DCCON2.SD * Math.log(RD)) / DCCON2.CDCD;
            AK1 = XIX * (D11 - DCCON2.Y11 * DCCON2.SD) / DCCON2.CD;
            AK3 = (Q * DCCON2.Y11 - DCCON2.Y * D11) / DCCON2.CD;
            AJ3 = (AK1 - AJ2 * DCCON2.SD) / DCCON2.CD;
            AJ6 = (AK3 - AJ5 * DCCON2.SD) / DCCON2.CD;
        } else {
            RD2 = RD * RD;
            AI3 = (ETE / RD + DCCON2.Y * Q / RD2 - DCCON2.ALE) / DCCON2.F2;
            AI4 = XIX * DCCON2.Y / RD2 / DCCON2.F2;
            AK1 = XIX * Q / RD * D11;
            AK3 = DCCON2.SD / RD * (DCCON2.XI2 * D11 - DCCON2.F1);
            AJ3 = -(XIX / RD2) * (DCCON2.Q2 * D11 - DCCON2.F1 / DCCON2.F2);
            AJ6 = -(DCCON2.Y / RD2) * (DCCON2.XI2 * D11 - DCCON2.F1 / DCCON2.F2);
        }
        XY = XIX * DCCON2.Y11;
        double AI1 = -(XIX / RD * DCCON2.CD) - AI4 * DCCON2.SD;
        double AI2 = Math.log(RD) + AI3 * DCCON2.SD;
        double AK2 = DCCON2.F1 / DCCON2.R + AK3 * DCCON2.SD;
        double AK4 = XY * DCCON2.CD - AK1 * DCCON2.SD;
        double AJ1 = AJ5 * DCCON2.CD - AJ6 * DCCON2.SD;
        double AJ4 = -XY - AJ2 * DCCON2.CD + AJ3 * DCCON2.SD;
        i = 1;
        while (i <= 12) {
            U[DC3D.i] = DCCON0.F0;
            ++i;
        }
        QX = Q * DCCON2.X11;
        QY = Q * DCCON2.Y11;
        if (DISL1 != DCCON2.F0) {
            DC3D.DU[1] = -(XIX * QY) - DCCON2.TT - DCCON2.ALP3 * AI1 * DCCON2.SD;
            DC3D.DU[2] = -(Q / DCCON2.R) + DCCON2.ALP3 * (DCCON2.Y / RD) * DCCON2.SD;
            DC3D.DU[3] = Q * QY - DCCON2.ALP3 * AI2 * DCCON2.SD;
            DC3D.DU[4] = DCCON2.XI2 * Q * DCCON2.Y32 - DCCON2.ALP3 * AJ1 * DCCON2.SD;
            DC3D.DU[5] = XIX * Q / DCCON2.R3 - DCCON2.ALP3 * AJ2 * DCCON2.SD;
            DC3D.DU[6] = -(XIX * DCCON2.Q2 * DCCON2.Y32) - DCCON2.ALP3 * AJ3 * DCCON2.SD;
            DC3D.DU[7] = -(XIX * DCCON2.FY) - DCCON2.D * DCCON2.X11 + DCCON2.ALP3 * (XY + AJ4) * DCCON2.SD;
            DC3D.DU[8] = -DCCON2.EY + DCCON2.ALP3 * (DCCON2.F1 / DCCON2.R + AJ5) * DCCON2.SD;
            DC3D.DU[9] = Q * DCCON2.FY - DCCON2.ALP3 * (QY - AJ6) * DCCON2.SD;
            DC3D.DU[10] = -(XIX * DCCON2.FZ) - DCCON2.Y * DCCON2.X11 + DCCON2.ALP3 * AK1 * DCCON2.SD;
            DC3D.DU[11] = -DCCON2.EZ + DCCON2.ALP3 * DCCON2.Y * D11 * DCCON2.SD;
            DC3D.DU[12] = Q * DCCON2.FZ + DCCON2.ALP3 * AK2 * DCCON2.SD;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL1 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL2 != DCCON2.F0) {
            DC3D.DU[1] = -(Q / DCCON2.R) + DCCON2.ALP3 * AI3 * DCCON2.SDCD;
            DC3D.DU[2] = -(ETE * QX) - DCCON2.TT - DCCON2.ALP3 * (XIX / RD) * DCCON2.SDCD;
            DC3D.DU[3] = Q * QX + DCCON2.ALP3 * AI4 * DCCON2.SDCD;
            DC3D.DU[4] = XIX * Q / DCCON2.R3 + DCCON2.ALP3 * AJ4 * DCCON2.SDCD;
            DC3D.DU[5] = ETE * Q / DCCON2.R3 + QY + DCCON2.ALP3 * AJ5 * DCCON2.SDCD;
            DC3D.DU[6] = -(DCCON2.Q2 / DCCON2.R3) + DCCON2.ALP3 * AJ6 * DCCON2.SDCD;
            DC3D.DU[7] = -DCCON2.EY + DCCON2.ALP3 * AJ1 * DCCON2.SDCD;
            DC3D.DU[8] = -(ETE * DCCON2.GY) - XY * DCCON2.SD + DCCON2.ALP3 * AJ2 * DCCON2.SDCD;
            DC3D.DU[9] = Q * DCCON2.GY + DCCON2.ALP3 * AJ3 * DCCON2.SDCD;
            DC3D.DU[10] = -DCCON2.EZ - DCCON2.ALP3 * AK3 * DCCON2.SDCD;
            DC3D.DU[11] = -(ETE * DCCON2.GZ) - XY * DCCON2.CD - DCCON2.ALP3 * XIX * D11 * DCCON2.SDCD;
            DC3D.DU[12] = Q * DCCON2.GZ - DCCON2.ALP3 * AK4 * DCCON2.SDCD;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL2 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL3 != DCCON2.F0) {
            DC3D.DU[1] = Q * QY - DCCON2.ALP3 * AI3 * DCCON2.SDSD;
            DC3D.DU[2] = Q * QX + DCCON2.ALP3 * (XIX / RD) * DCCON2.SDSD;
            DC3D.DU[3] = ETE * QX + XIX * QY - DCCON2.TT - DCCON2.ALP3 * AI4 * DCCON2.SDSD;
            DC3D.DU[4] = -(XIX * DCCON2.Q2 * DCCON2.Y32) - DCCON2.ALP3 * AJ4 * DCCON2.SDSD;
            DC3D.DU[5] = -(DCCON2.Q2 / DCCON2.R3) - DCCON2.ALP3 * AJ5 * DCCON2.SDSD;
            DC3D.DU[6] = Q * DCCON2.Q2 * DCCON2.Y32 - DCCON2.ALP3 * AJ6 * DCCON2.SDSD;
            DC3D.DU[7] = Q * DCCON2.FY - DCCON2.ALP3 * AJ1 * DCCON2.SDSD;
            DC3D.DU[8] = Q * DCCON2.GY - DCCON2.ALP3 * AJ2 * DCCON2.SDSD;
            DC3D.DU[9] = -(Q * DCCON2.HY) - DCCON2.ALP3 * AJ3 * DCCON2.SDSD;
            DC3D.DU[10] = Q * DCCON2.FZ + DCCON2.ALP3 * AK3 * DCCON2.SDSD;
            DC3D.DU[11] = Q * DCCON2.GZ + DCCON2.ALP3 * XIX * D11 * DCCON2.SDSD;
            DC3D.DU[12] = -(Q * DCCON2.HZ) + DCCON2.ALP3 * AK4 * DCCON2.SDSD;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL3 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
    }

    public static void UC(double XIX, double ETE, double Q, double Z, double DISL1, double DISL2, double DISL3, double[] U) {
        double C = DCCON2.D + Z;
        double X53 = (8.0 * DCCON2.R2 + 9.0 * DCCON2.R * XIX + DCCON2.F3 * DCCON2.XI2) / (DCCON2.R5 * (DCCON2.RXI * DCCON2.RXI * DCCON2.RXI));
        double Y53 = (8.0 * DCCON2.R2 + 9.0 * DCCON2.R * ETE + DCCON2.F3 * DCCON2.ET2) / (DCCON2.R5 * (DCCON2.RET * DCCON2.RET * DCCON2.RET));
        double H = Q * DCCON2.CD - Z;
        double Z32 = DCCON2.SD / DCCON2.R3 - H * DCCON2.Y32;
        double Z53 = DCCON2.F3 * DCCON2.SD / DCCON2.R5 - H * Y53;
        double Y0 = DCCON2.Y11 - DCCON2.XI2 * DCCON2.Y32;
        double Z0 = Z32 - DCCON2.XI2 * Z53;
        double PPY = DCCON2.CD / DCCON2.R3 + Q * DCCON2.Y32 * DCCON2.SD;
        double PPZ = DCCON2.SD / DCCON2.R3 - Q * DCCON2.Y32 * DCCON2.CD;
        double QQ = Z * DCCON2.Y32 + Z32 + Z0;
        double QQY = DCCON2.F3 * C * DCCON2.D / DCCON2.R5 - QQ * DCCON2.SD;
        double QQZ = DCCON2.F3 * C * DCCON2.Y / DCCON2.R5 - QQ * DCCON2.CD + Q * DCCON2.Y32;
        double QR = DCCON2.F3 * Q / DCCON2.R5;
        double CQX = C * Q * X53;
        double CDR = (C + DCCON2.D) / DCCON2.R3;
        double YY0 = DCCON2.Y / DCCON2.R3 - Y0 * DCCON2.CD;
        i = 1;
        while (i <= 12) {
            U[DC3D.i] = DCCON0.F0;
            ++i;
        }
        if (DISL1 != DCCON2.F0) {
            DC3D.DU[1] = DCCON2.ALP4 * XY * DCCON2.CD - DCCON2.ALP5 * XIX * Q * Z32;
            DC3D.DU[2] = DCCON2.ALP4 * (DCCON2.CD / DCCON2.R + DCCON2.F2 * QY * DCCON2.SD) - DCCON2.ALP5 * C * Q / DCCON2.R3;
            DC3D.DU[3] = DCCON2.ALP4 * QY * DCCON2.CD - DCCON2.ALP5 * (C * ETE / DCCON2.R3 - Z * DCCON2.Y11 + DCCON2.XI2 * Z32);
            DC3D.DU[4] = DCCON2.ALP4 * Y0 * DCCON2.CD - DCCON2.ALP5 * Q * Z0;
            DC3D.DU[5] = -(DCCON2.ALP4 * XIX * (DCCON2.CD / DCCON2.R3 + DCCON2.F2 * Q * DCCON2.Y32 * DCCON2.SD)) + DCCON2.ALP5 * C * XIX * QR;
            DC3D.DU[6] = -DCCON2.ALP4 * (XIX * Q * DCCON2.Y32 * DCCON2.CD) + DCCON2.ALP5 * XIX * (DCCON2.F3 * C * ETE / DCCON2.R5 - QQ);
            DC3D.DU[7] = -(DCCON2.ALP4 * XIX * PPY * DCCON2.CD) - DCCON2.ALP5 * XIX * QQY;
            DC3D.DU[8] = DCCON2.ALP4 * DCCON2.F2 * (DCCON2.D / DCCON2.R3 - Y0 * DCCON2.SD) * DCCON2.SD - DCCON2.Y / DCCON2.R3 * DCCON2.CD - DCCON2.ALP5 * (CDR * DCCON2.SD - ETE / DCCON2.R3 - C * DCCON2.Y * QR);
            DC3D.DU[9] = -DCCON2.ALP4 * (Q / DCCON2.R3) + YY0 * DCCON2.SD + DCCON2.ALP5 * (CDR * DCCON2.CD + C * DCCON2.D * QR - (Y0 * DCCON2.CD + Q * Z0) * DCCON2.SD);
            DC3D.DU[10] = DCCON2.ALP4 * XIX * PPZ * DCCON2.CD - DCCON2.ALP5 * XIX * QQZ;
            DC3D.DU[11] = DCCON2.ALP4 * DCCON2.F2 * (DCCON2.Y / DCCON2.R3 - Y0 * DCCON2.CD) * DCCON2.SD + DCCON2.D / DCCON2.R3 * DCCON2.CD - DCCON2.ALP5 * (CDR * DCCON2.CD + C * DCCON2.D * QR);
            DC3D.DU[12] = YY0 * DCCON2.CD - DCCON2.ALP5 * (CDR * DCCON2.SD - C * DCCON2.Y * QR - Y0 * DCCON2.SDSD + Q * Z0 * DCCON2.CD);
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL1 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL2 != DCCON2.F0) {
            DC3D.DU[1] = DCCON2.ALP4 * DCCON2.CD / DCCON2.R - QY * DCCON2.SD - DCCON2.ALP5 * C * Q / DCCON2.R3;
            DC3D.DU[2] = DCCON2.ALP4 * DCCON2.Y * DCCON2.X11 - DCCON2.ALP5 * C * ETE * Q * DCCON2.X32;
            DC3D.DU[3] = -(DCCON2.D * DCCON2.X11) - XY * DCCON2.SD - DCCON2.ALP5 * C * (DCCON2.X11 - DCCON2.Q2 * DCCON2.X32);
            DC3D.DU[4] = -(DCCON2.ALP4 * XIX / DCCON2.R3 * DCCON2.CD) + DCCON2.ALP5 * C * XIX * QR + XIX * Q * DCCON2.Y32 * DCCON2.SD;
            DC3D.DU[5] = -(DCCON2.ALP4 * DCCON2.Y / DCCON2.R3) + DCCON2.ALP5 * C * ETE * QR;
            DC3D.DU[6] = DCCON2.D / DCCON2.R3 - Y0 * DCCON2.SD + DCCON2.ALP5 * (C / DCCON2.R3) * (DCCON2.F1 - DCCON2.F3 * (DCCON2.Q2 / DCCON2.R2));
            DC3D.DU[7] = -(DCCON2.ALP4 * ETE / DCCON2.R3) + Y0 * DCCON2.SDSD - DCCON2.ALP5 * (CDR * DCCON2.SD - C * DCCON2.Y * QR);
            DC3D.DU[8] = DCCON2.ALP4 * (DCCON2.X11 - DCCON2.Y * DCCON2.Y * DCCON2.X32) - DCCON2.ALP5 * C * ((DCCON2.D + DCCON2.F2 * Q * DCCON2.CD) * DCCON2.X32 - DCCON2.Y * ETE * Q * X53);
            DC3D.DU[9] = XIX * PPY * DCCON2.SD + DCCON2.Y * DCCON2.D * DCCON2.X32 + DCCON2.ALP5 * C * ((DCCON2.Y + DCCON2.F2 * Q * DCCON2.SD) * DCCON2.X32 - DCCON2.Y * DCCON2.Q2 * X53);
            DC3D.DU[10] = -(Q / DCCON2.R3) + Y0 * DCCON2.SDCD - DCCON2.ALP5 * (CDR * DCCON2.CD + C * DCCON2.D * QR);
            DC3D.DU[11] = DCCON2.ALP4 * DCCON2.Y * DCCON2.D * DCCON2.X32 - DCCON2.ALP5 * C * ((DCCON2.Y - DCCON2.F2 * Q * DCCON2.SD) * DCCON2.X32 + DCCON2.D * ETE * Q * X53);
            DC3D.DU[12] = -(XIX * PPZ * DCCON2.SD) + DCCON2.X11 - DCCON2.D * DCCON2.D * DCCON2.X32 - DCCON2.ALP5 * C * ((DCCON2.D - DCCON2.F2 * Q * DCCON2.CD) * DCCON2.X32 - DCCON2.D * DCCON2.Q2 * X53);
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL2 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
        if (DISL3 != DCCON2.F0) {
            DC3D.DU[1] = -(DCCON2.ALP4 * (DCCON2.SD / DCCON2.R + QY * DCCON2.CD)) - DCCON2.ALP5 * (Z * DCCON2.Y11 - DCCON2.Q2 * Z32);
            DC3D.DU[2] = DCCON2.ALP4 * DCCON2.F2 * XY * DCCON2.SD + DCCON2.D * DCCON2.X11 - DCCON2.ALP5 * C * (DCCON2.X11 - DCCON2.Q2 * DCCON2.X32);
            DC3D.DU[3] = DCCON2.ALP4 * (DCCON2.Y * DCCON2.X11 + XY * DCCON2.CD) + DCCON2.ALP5 * Q * (C * ETE * DCCON2.X32 + XIX * Z32);
            DC3D.DU[4] = DCCON2.ALP4 * XIX / DCCON2.R3 * DCCON2.SD + XIX * Q * DCCON2.Y32 * DCCON2.CD + DCCON2.ALP5 * XIX * (DCCON2.F3 * C * ETE / DCCON2.R5 - DCCON2.F2 * Z32 - Z0);
            DC3D.DU[5] = DCCON2.ALP4 * DCCON2.F2 * Y0 * DCCON2.SD - DCCON2.D / DCCON2.R3 + DCCON2.ALP5 * (C / DCCON2.R3) * (DCCON2.F1 - DCCON2.F3 * (DCCON2.Q2 / DCCON2.R2));
            DC3D.DU[6] = -(DCCON2.ALP4 * YY0) - DCCON2.ALP5 * (C * ETE * QR - Q * Z0);
            DC3D.DU[7] = DCCON2.ALP4 * (Q / DCCON2.R3 + Y0 * DCCON2.SDCD) + DCCON2.ALP5 * (Z / DCCON2.R3 * DCCON2.CD + C * DCCON2.D * QR - Q * Z0 * DCCON2.SD);
            DC3D.DU[8] = -(DCCON2.ALP4 * DCCON2.F2 * XIX * PPY * DCCON2.SD) - DCCON2.Y * DCCON2.D * DCCON2.X32 + DCCON2.ALP5 * C * ((DCCON2.Y + DCCON2.F2 * Q * DCCON2.SD) * DCCON2.X32 - DCCON2.Y * DCCON2.Q2 * X53);
            DC3D.DU[9] = -(DCCON2.ALP4 * (XIX * PPY * DCCON2.CD - DCCON2.X11 + DCCON2.Y * DCCON2.Y * DCCON2.X32)) + DCCON2.ALP5 * C * ((DCCON2.D + DCCON2.F2 * Q * DCCON2.CD) * DCCON2.X32 - DCCON2.Y * ETE * Q * X53) + XIX * QQY;
            DC3D.DU[10] = -(ETE / DCCON2.R3) + Y0 * DCCON2.CDCD - DCCON2.ALP5 * (Z / DCCON2.R3 * DCCON2.SD - C * DCCON2.Y * QR - Y0 * DCCON2.SDSD + Q * Z0 * DCCON2.CD);
            DC3D.DU[11] = DCCON2.ALP4 * DCCON2.F2 * XIX * PPZ * DCCON2.SD - DCCON2.X11 + DCCON2.D * DCCON2.D * DCCON2.X32 - DCCON2.ALP5 * C * ((DCCON2.D - DCCON2.F2 * Q * DCCON2.CD) * DCCON2.X32 - DCCON2.D * DCCON2.Q2 * X53);
            DC3D.DU[12] = DCCON2.ALP4 * (XIX * PPZ * DCCON2.CD + DCCON2.Y * DCCON2.D * DCCON2.X32) + DCCON2.ALP5 * C * ((DCCON2.Y - DCCON2.F2 * Q * DCCON2.SD) * DCCON2.X32 + DCCON2.D * ETE * Q * X53) + DCCON2.ALP5 * XIX * QQZ;
            i = 1;
            while (i <= 12) {
                U[DC3D.i] = U[i] + DISL3 / DCCON2.PI2 * DU[i];
                ++i;
            }
        }
    }
}

