/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Matrix3d;
import okada.DCCON0;
import okada.DCCON1;
import okada.SINGULAR;
import tno.geoenergy.data.Grid;

public class DC3D0 {
    public static double[] U = new double[13];
    public static double DU;
    public static double[] DUA;
    public static double[] DUB;
    public static double[] DUC;
    public static int i;
    public static double UX;
    public static double UY;
    public static double UZ;
    public static double UXX;
    public static double UYX;
    public static double UZX;
    public static double UXY;
    public static double UYY;
    public static double UZY;
    public static double UXZ;
    public static double UYZ;
    public static double UZZ;
    public static double IRET;
    public static double DD;
    public static double ox;
    public static double oy;
    public static double oz;
    public static double exx;
    public static double exy;
    public static double exz;
    public static double eyx;
    public static double eyy;
    public static double eyz;
    public static double ezx;
    public static double ezy;
    public static double ezz;
    public static double Sxx;
    public static double Sxy;
    public static double Sxz;
    public static double Syx;
    public static double Syy;
    public static double Syz;
    public static double Szx;
    public static double Szy;
    public static double Szz;
    static Matrix3d internalStress;

    static {
        DUA = new double[13];
        DUB = new double[13];
        DUC = new double[13];
        internalStress = new Matrix3d();
    }

    public static Grid getGrid(double orx, double ory, double dx, double dy, int nx, int ny, String filename) {
        Grid grid = new Grid();
        grid.values = new float[nx][ny];
        grid.originx = (float)orx;
        grid.originy = (float)ory;
        grid.dx = (float)dx;
        grid.dy = (float)dy;
        grid.nx = nx;
        grid.ny = ny;
        grid.unknown = 0.0f;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                grid.values[i][j] = grid.unknown;
                ++j;
            }
            ++i;
        }
        grid.setDataFormat("SURFER");
        grid.setFileName(filename);
        return grid;
    }

    public static void test1() {
        double sx = 0.0;
        double sy = 0.0;
        double sz = 2000.0;
        double top = 2000.0;
        double bottom = 2500.0;
        double depth = 2500.0;
        DCCON0.setSourceLocation(sx, sy, sz);
        double azim = 0.0;
        double dip = 0.0;
        double alpha = DCCON0.ALPHA;
        DCCON0.prepareSource(azim);
        DC3D0.initializeSource(dip, alpha);
        System.out.println("source " + sx + " " + sy + " " + sz);
        System.out.println(" Compaction Test 1 observations ");
        System.out.println("x       y        z         ux         uy       uz       Sxx         Syy        Szz");
        int NX = 200;
        double dx = 10.0;
        int i = 0;
        while (i < NX) {
            double ox = 1000.0;
            double oy = 2500.0;
            oz = -((double)i * dx);
            double pot1 = -1000000.0;
            double pot2 = 0.0;
            double pot3 = 0.0;
            double pot4 = 0.0;
            DCCON0.setObervationLocation(ox, oy, oz);
            DC3D0.calculateAtObservation(ox, oy, oz, depth, pot1, pot2, pot3, pot4);
            System.out.println(String.valueOf(ox) + " " + oy + " " + oz + " " + UX + " " + UY + " " + UZ + " " + Sxx + " " + Syy + " " + Szz);
            ++i;
        }
    }

    public static void test2() {
        double dx;
        double sx = -2000.0;
        double sy = 0.0;
        double sz = 0.0;
        DCCON0.setSourceLocation(sx, sy, sz);
        double azim = 40.0;
        double dip = 0.01;
        double alpha = DCCON0.ALPHA;
        double top = 2.0;
        double bottom = 2.02;
        double depth = 0.5 * (top + bottom);
        DCCON0.prepareSource(azim);
        DC3D0.initializeSource(dip, alpha);
        System.out.println("source " + sx + " " + sy + " " + sz);
        System.out.println(" observations ");
        System.out.println("x y z   ux uy  uz  uxx uyy uzz");
        int NX = 20;
        int NY = 20;
        double dy = dx = 2.0;
        String filename = "C:/Users/Saad/Desktop/Results/test1.grd";
        Grid g = DC3D0.getGrid(sx, sy, dx, dy, NX, NY, filename);
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                double xg = sx + (double)(i + 1) * dx;
                double yg = sy + (double)(j + 1) * dy;
                oz = -4.8;
                DCCON0.setObervationLocation(xg, yg, oz);
                ox = DCCON0.ox;
                oy = DCCON0.oy;
                DC3D0.calculateAtObservation(ox, oy, oz, depth, DCCON0.POT1, DCCON0.POT2, DCCON0.POT3, DCCON0.POT4);
                g.values[i][j] = (float)Sxx;
                ++j;
            }
            ++i;
        }
        try {
            g.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DC3D0.test1();
    }

    public static void initializeSource(double dip, double alpha) {
        DCCON0.DCCON0(alpha, dip);
    }

    public static void calculateAtObservation(double ox, double oy, double oz, double depth, double POT1, double POT2, double POT3, double POT4) {
        i = 0;
        while (i <= 12) {
            DC3D0.U[DC3D0.i] = DCCON0.F0;
            DC3D0.DUA[DC3D0.i] = DCCON0.F0;
            DC3D0.DUB[DC3D0.i] = DCCON0.F0;
            DC3D0.DUC[DC3D0.i] = DCCON0.F0;
            ++i;
        }
        double XX = ox;
        double YY = oy;
        double ZZ = oz;
        DD = depth + ZZ;
        DCCON1.DCCON1(XX, YY, DD);
        if (DCCON1.R == (double)DCCON0.F0) {
            SINGULAR.singular();
        } else {
            double PP1 = POT1;
            double PP2 = POT2;
            double PP3 = POT3;
            double PP4 = POT4;
            DC3D0.UA0(XX, YY, DD, PP1, PP2, PP3, PP4, DUA);
            i = 1;
            while (i <= 12) {
                if (i < 10) {
                    DC3D0.U[DC3D0.i] = U[i] - DUA[i];
                }
                if (i >= 10) {
                    DC3D0.U[DC3D0.i] = U[i] + DUA[i];
                }
                ++i;
            }
            DD = depth - ZZ;
            DCCON1.DCCON1(XX, YY, DD);
            DC3D0.UA0(XX, YY, DD, PP1, PP2, PP3, PP4, DUA);
            DC3D0.UB0(XX, YY, DD, ZZ, PP1, PP2, PP3, PP4, DUB);
            DC3D0.UC0(XX, YY, DD, ZZ, PP1, PP2, PP3, PP4, DUC);
            i = 1;
            while (i <= 12) {
                DU = DUA[i] + DUB[i] + ZZ * DUC[i];
                if (i >= 10) {
                    DU += DUC[i - 9];
                }
                DC3D0.U[DC3D0.i] = U[i] + DU;
                ++i;
            }
            UX = U[1];
            UY = U[2];
            UZ = U[3];
            UXX = U[4];
            UYX = U[5];
            UZX = U[6];
            UXY = U[7];
            UYY = U[8];
            UZY = U[9];
            UXZ = U[10];
            UYZ = U[11];
            UZZ = U[12];
            IRET = 0.0;
            exx = UXX;
            eyy = UYY;
            ezz = UZZ;
            exy = eyx = 0.5 * (UYX + UXY);
            exz = ezx = 0.5 * (UXZ + UZX);
            eyz = ezy = 0.5 * (UYZ + UZX);
            double vol = UXX + UYY + UZZ;
            double YOUNG = DCCON0.E;
            double POIS = DCCON0.v;
            double sk = YOUNG / (1.0 + POIS);
            double gk = POIS / (1.0 - 2.0 * POIS);
            Sxx = sk * (gk * vol + UXX);
            Syy = sk * (gk * vol + UYY);
            Szz = sk * (gk * vol + UZZ);
            Sxy = Syx = YOUNG / (2.0 * (1.0 + POIS)) * (UXY + UYX);
            Sxz = Szx = YOUNG / (2.0 * (1.0 + POIS)) * (UXZ + UZX);
            Syz = Szy = YOUNG / (2.0 * (1.0 + POIS)) * (UYZ + UZY);
            DC3D0.internalStress.m00 = Sxx;
            DC3D0.internalStress.m11 = Syy;
            DC3D0.internalStress.m22 = Szz;
            DC3D0.internalStress.m01 = DC3D0.internalStress.m10 = Sxy;
            DC3D0.internalStress.m02 = DC3D0.internalStress.m20 = Sxz;
            DC3D0.internalStress.m12 = DC3D0.internalStress.m21 = Syz;
        }
    }

    public static void UA0(double X, double Y, double D, double POT1, double POT2, double POT3, double POT4, double[] U) {
        double[] DU = new double[13];
        i = 1;
        while (i <= 12) {
            U[DC3D0.i] = DCCON0.F0;
            ++i;
        }
        if (POT1 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP1 * DCCON1.Q / DCCON1.R3 + DCCON0.ALP2 * DCCON1.X2 * DCCON1.QR;
            DU[2] = DCCON0.ALP1 * X / DCCON1.R3 * DCCON0.SD + DCCON0.ALP2 * DCCON1.XY * DCCON1.QR;
            DU[3] = -(DCCON0.ALP1 * X / DCCON1.R3) * DCCON0.CD + DCCON0.ALP2 * X * D * DCCON1.QR;
            DU[4] = X * DCCON1.QR * (-DCCON0.ALP1 + DCCON0.ALP2 * ((double)DCCON0.F1 + DCCON1.A5));
            DU[5] = DCCON0.ALP1 * DCCON1.A3 / DCCON1.R3 * DCCON0.SD + DCCON0.ALP2 * Y * DCCON1.QR * DCCON1.A5;
            DU[6] = -(DCCON0.ALP1 * DCCON1.A3 / DCCON1.R3) * DCCON0.CD + DCCON0.ALP2 * D * DCCON1.QR * DCCON1.A5;
            DU[7] = DCCON0.ALP1 * (DCCON0.SD / DCCON1.R3 - Y * DCCON1.QR) + DCCON0.ALP2 * (double)DCCON1.F3 * DCCON1.X2 / DCCON1.R5 * DCCON1.UY;
            DU[8] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP1 * Y * DCCON0.SD + DCCON0.ALP2 * (Y * DCCON1.UY + DCCON1.Q));
            DU[9] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP1 * Y * DCCON0.CD + DCCON0.ALP2 * D * DCCON1.UY);
            DU[10] = DCCON0.ALP1 * (DCCON0.CD / DCCON1.R3 + D * DCCON1.QR) + DCCON0.ALP2 * (double)DCCON1.F3 * DCCON1.X2 / DCCON1.R5 * DCCON1.UZ;
            DU[11] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP1 * D * DCCON0.SD + DCCON0.ALP2 * Y * DCCON1.UZ);
            DU[12] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP1 * D * DCCON0.CD + DCCON0.ALP2 * (D * DCCON1.UZ - DCCON1.Q));
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT1 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT2 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP2 * X * DCCON1.P * DCCON1.QR;
            DU[2] = DCCON0.ALP1 * DCCON1.S / DCCON1.R3 + DCCON0.ALP2 * Y * DCCON1.P * DCCON1.QR;
            DU[3] = -(DCCON0.ALP1 * DCCON1.T / DCCON1.R3) + DCCON0.ALP2 * D * DCCON1.P * DCCON1.QR;
            DU[4] = DCCON0.ALP2 * DCCON1.P * DCCON1.QR * DCCON1.A5;
            DU[5] = -(DCCON0.ALP1 * (double)DCCON1.F3 * X * DCCON1.S / DCCON1.R5) - DCCON0.ALP2 * Y * DCCON1.P * DCCON1.QRX;
            DU[6] = DCCON0.ALP1 * (double)DCCON1.F3 * X * DCCON1.T / DCCON1.R5 - DCCON0.ALP2 * D * DCCON1.P * DCCON1.QRX;
            DU[7] = DCCON0.ALP2 * (double)DCCON1.F3 * X / DCCON1.R5 * DCCON1.VY;
            DU[8] = DCCON0.ALP1 * (DCCON0.S2D / DCCON1.R3 - (double)DCCON1.F3 * Y * DCCON1.S / DCCON1.R5) + DCCON0.ALP2 * ((double)DCCON1.F3 * Y / DCCON1.R5 * DCCON1.VY + DCCON1.P * DCCON1.QR);
            DU[9] = -DCCON0.ALP1 * (DCCON0.C2D / DCCON1.R3 - (double)DCCON1.F3 * Y * DCCON1.T / DCCON1.R5) + DCCON0.ALP2 * (double)DCCON1.F3 * D / DCCON1.R5 * DCCON1.VY;
            DU[10] = DCCON0.ALP2 * (double)DCCON1.F3 * X / DCCON1.R5 * DCCON1.VZ;
            DU[11] = DCCON0.ALP1 * (DCCON0.C2D / DCCON1.R3 + (double)DCCON1.F3 * D * DCCON1.S / DCCON1.R5) + DCCON0.ALP2 * (double)DCCON1.F3 * Y / DCCON1.R5 * DCCON1.VZ;
            DU[12] = DCCON0.ALP1 * (DCCON0.S2D / DCCON1.R3 - (double)DCCON1.F3 * D * DCCON1.T / DCCON1.R5) + DCCON0.ALP2 * ((double)DCCON1.F3 * D / DCCON1.R5 * DCCON1.VZ - DCCON1.P * DCCON1.QR);
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT2 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT3 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP1 * X / DCCON1.R3 - DCCON0.ALP2 * X * DCCON1.Q * DCCON1.QR;
            DU[2] = DCCON0.ALP1 * DCCON1.T / DCCON1.R3 - DCCON0.ALP2 * Y * DCCON1.Q * DCCON1.QR;
            DU[3] = DCCON0.ALP1 * DCCON1.S / DCCON1.R3 - DCCON0.ALP2 * D * DCCON1.Q * DCCON1.QR;
            DU[4] = DCCON0.ALP1 * DCCON1.A3 / DCCON1.R3 - DCCON0.ALP2 * DCCON1.Q * DCCON1.QR * DCCON1.A5;
            DU[5] = -DCCON0.ALP1 * (double)DCCON1.F3 * X * DCCON1.T / DCCON1.R5 + DCCON0.ALP2 * Y * DCCON1.Q * DCCON1.QRX;
            DU[6] = -DCCON0.ALP1 * (double)DCCON1.F3 * X * DCCON1.S / DCCON1.R5 + DCCON0.ALP2 * D * DCCON1.Q * DCCON1.QRX;
            DU[7] = -DCCON0.ALP1 * (double)DCCON1.F3 * DCCON1.XY / DCCON1.R5 - DCCON0.ALP2 * X * DCCON1.QR * DCCON1.WY;
            DU[8] = DCCON0.ALP1 * (DCCON0.C2D / DCCON1.R3 - (double)DCCON1.F3 * Y * DCCON1.T / DCCON1.R5) - DCCON0.ALP2 * (Y * DCCON1.WY + DCCON1.Q) * DCCON1.QR;
            DU[9] = DCCON0.ALP1 * (DCCON0.S2D / DCCON1.R3 - (double)DCCON1.F3 * Y * DCCON1.S / DCCON1.R5) - DCCON0.ALP2 * D * DCCON1.QR * DCCON1.WY;
            DU[10] = DCCON0.ALP1 * (double)DCCON1.F3 * X * D / DCCON1.R5 - DCCON0.ALP2 * X * DCCON1.QR * DCCON1.WZ;
            DU[11] = -DCCON0.ALP1 * (DCCON0.S2D / DCCON1.R3 - (double)DCCON1.F3 * D * DCCON1.T / DCCON1.R5) - DCCON0.ALP2 * Y * DCCON1.QR * DCCON1.WZ;
            DU[12] = DCCON0.ALP1 * (DCCON0.C2D / DCCON1.R3 + (double)DCCON1.F3 * D * DCCON1.S / DCCON1.R5) - DCCON0.ALP2 * (D * DCCON1.WZ - DCCON1.Q) * DCCON1.QR;
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT3 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT4 != (double)DCCON0.F0) {
            DU[1] = -DCCON0.ALP1 * X / DCCON1.R3;
            DU[2] = -DCCON0.ALP1 * Y / DCCON1.R3;
            DU[3] = -DCCON0.ALP1 * D / DCCON1.R3;
            DU[4] = -DCCON0.ALP1 * DCCON1.A3 / DCCON1.R3;
            DU[5] = DCCON0.ALP1 * (double)DCCON1.F3 * DCCON1.XY / DCCON1.R5;
            DU[6] = DCCON0.ALP1 * (double)DCCON1.F3 * X * D / DCCON1.R5;
            DU[7] = DU[5];
            DU[8] = -DCCON0.ALP1 * DCCON1.B3 / DCCON1.R3;
            DU[9] = DCCON0.ALP1 * (double)DCCON1.F3 * Y * D / DCCON1.R5;
            DU[10] = -DU[6];
            DU[11] = -DU[9];
            DU[12] = DCCON0.ALP1 * DCCON1.C3 / DCCON1.R3;
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT4 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
    }

    public static void UB0(double X, double Y, double D, double Z, double POT1, double POT2, double POT3, double POT4, double[] U) {
        double[] DU = new double[13];
        double C = D + Z;
        double RD = D + DCCON1.R;
        double D12 = (double)DCCON1.F1 / (DCCON1.R * RD * RD);
        double D32 = D12 * ((double)DCCON0.F2 * DCCON1.R + D) / DCCON1.R2;
        double D33 = D12 * ((double)DCCON1.F3 * DCCON1.R + D) / (DCCON1.R2 * RD);
        double D53 = D12 * ((double)DCCON0.F8 * DCCON1.R2 + (double)DCCON0.F9 * DCCON1.R * D + (double)DCCON1.F3 * DCCON1.D2) / (DCCON1.R2 * DCCON1.R2 * RD);
        double D54 = D12 * ((double)DCCON1.F5 * DCCON1.R2 + (double)DCCON0.F4 * DCCON1.R * D + DCCON1.D2) / DCCON1.R3 * D12;
        double FI1 = Y * (D12 - DCCON1.X2 * D33);
        double FI2 = X * (D12 - DCCON1.Y2 * D33);
        double FI3 = X / DCCON1.R3 - FI2;
        double FI4 = -DCCON1.XY * D32;
        double FI5 = (double)DCCON0.F1 / (DCCON1.R * RD) - DCCON1.X2 * D32;
        double FJ1 = (double)(-DCCON1.F3) * DCCON1.XY * (D33 - DCCON1.X2 * D54);
        double FJ2 = (double)DCCON1.F1 / DCCON1.R3 - (double)DCCON1.F3 * D12 + (double)DCCON1.F3 * DCCON1.X2 * DCCON1.Y2 * D54;
        double FJ3 = DCCON1.A3 / DCCON1.R3 - FJ2;
        double FJ4 = (double)(-DCCON1.F3) * DCCON1.XY / DCCON1.R5 - FJ1;
        double FK1 = -Y * (D32 - DCCON1.X2 * D53);
        double FK2 = -X * (D32 - DCCON1.Y2 * D53);
        double FK3 = (double)(-DCCON1.F3) * X * D / DCCON1.R5 - FK2;
        i = 1;
        while (i <= 12) {
            U[DC3D0.i] = DCCON0.F0;
            ++i;
        }
        if (POT1 != (double)DCCON0.F0) {
            DU[1] = -DCCON1.X2 * DCCON1.QR - DCCON0.ALP3 * FI1 * DCCON0.SD;
            DU[2] = -DCCON1.XY * DCCON1.QR - DCCON0.ALP3 * FI2 * DCCON0.SD;
            DU[3] = -C * X * DCCON1.QR - DCCON0.ALP3 * FI4 * DCCON0.SD;
            DU[4] = -X * DCCON1.QR * ((double)DCCON1.F1 + DCCON1.A5) - DCCON0.ALP3 * FJ1 * DCCON0.SD;
            DU[5] = -Y * DCCON1.QR * DCCON1.A5 - DCCON0.ALP3 * FJ2 * DCCON0.SD;
            DU[6] = -C * DCCON1.QR * DCCON1.A5 - DCCON0.ALP3 * FK1 * DCCON0.SD;
            DU[7] = (double)(-DCCON1.F3) * DCCON1.X2 / DCCON1.R5 * DCCON1.UY - DCCON0.ALP3 * FJ2 * DCCON0.SD;
            DU[8] = (double)(-DCCON1.F3) * DCCON1.XY / DCCON1.R5 * DCCON1.UY - X * DCCON1.QR - DCCON0.ALP3 * FJ4 * DCCON0.SD;
            DU[9] = (double)(-DCCON1.F3) * C * X / DCCON1.R5 * DCCON1.UY - DCCON0.ALP3 * FK2 * DCCON0.SD;
            DU[10] = (double)(-DCCON1.F3) * DCCON1.X2 / DCCON1.R5 * DCCON1.UZ + DCCON0.ALP3 * FK1 * DCCON0.SD;
            DU[11] = (double)(-DCCON1.F3) * DCCON1.XY / DCCON1.R5 * DCCON1.UZ + DCCON0.ALP3 * FK2 * DCCON0.SD;
            DU[12] = (double)DCCON1.F3 * X / DCCON1.R5 * (-C * DCCON1.UZ + DCCON0.ALP3 * Y * DCCON0.SD);
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT1 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT2 != (double)DCCON0.F0) {
            DU[1] = -X * DCCON1.P * DCCON1.QR + DCCON0.ALP3 * FI3 * DCCON0.SDCD;
            DU[2] = -Y * DCCON1.P * DCCON1.QR + DCCON0.ALP3 * FI1 * DCCON0.SDCD;
            DU[3] = -C * DCCON1.P * DCCON1.QR + DCCON0.ALP3 * FI5 * DCCON0.SDCD;
            DU[4] = -DCCON1.P * DCCON1.QR * DCCON1.A5 + DCCON0.ALP3 * FJ3 * DCCON0.SDCD;
            DU[5] = Y * DCCON1.P * DCCON1.QRX + DCCON0.ALP3 * FJ1 * DCCON0.SDCD;
            DU[6] = C * DCCON1.P * DCCON1.QRX + DCCON0.ALP3 * FK3 * DCCON0.SDCD;
            DU[7] = (double)(-DCCON1.F3) * X / DCCON1.R5 * DCCON1.VY + DCCON0.ALP3 * FJ1 * DCCON0.SDCD;
            DU[8] = (double)(-DCCON1.F3) * Y / DCCON1.R5 * DCCON1.VY - DCCON1.P * DCCON1.QR + DCCON0.ALP3 * FJ2 * DCCON0.SDCD;
            DU[9] = (double)(-DCCON1.F3) * C / DCCON1.R5 * DCCON1.VY + DCCON0.ALP3 * FK1 * DCCON0.SDCD;
            DU[10] = (double)(-DCCON1.F3) * X / DCCON1.R5 * DCCON1.VZ - DCCON0.ALP3 * FK3 * DCCON0.SDCD;
            DU[11] = (double)(-DCCON1.F3) * Y / DCCON1.R5 * DCCON1.VZ - DCCON0.ALP3 * FK1 * DCCON0.SDCD;
            DU[12] = (double)(-DCCON1.F3) * C / DCCON1.R5 * DCCON1.VZ + DCCON0.ALP3 * DCCON1.A3 / DCCON1.R3 * DCCON0.SDCD;
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT2 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT3 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP3 * X / DCCON1.R3;
            DU[2] = DCCON0.ALP3 * Y / DCCON1.R3;
            DU[3] = DCCON0.ALP3 * D / DCCON1.R3;
            DU[4] = DCCON0.ALP3 * DCCON1.A3 / DCCON1.R3;
            DU[5] = -DCCON0.ALP3 * (double)DCCON1.F3 * DCCON1.XY / DCCON1.R5;
            DU[6] = -DCCON0.ALP3 * (double)DCCON1.F3 * X * D / DCCON1.R5;
            DU[7] = DU[5];
            DU[8] = DCCON0.ALP3 * DCCON1.B3 / DCCON1.R3;
            DU[9] = -DCCON0.ALP3 * (double)DCCON1.F3 * Y * D / DCCON1.R5;
            DU[10] = DU[6];
            DU[11] = DU[9];
            DU[12] = -DCCON0.ALP3 * DCCON1.C3 / DCCON1.R3;
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT3 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT4 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP3 * X / DCCON1.R3;
            DU[2] = DCCON0.ALP3 * Y / DCCON1.R3;
            DU[3] = DCCON0.ALP3 * D / DCCON1.R3;
            DU[4] = DCCON0.ALP3 * DCCON1.A3 / DCCON1.R3;
            DU[5] = -DCCON0.ALP3 * (double)DCCON1.F3 * DCCON1.XY / DCCON1.R5;
            DU[6] = -DCCON0.ALP3 * (double)DCCON1.F3 * X * D / DCCON1.R5;
            DU[7] = DU[5];
            DU[8] = DCCON0.ALP3 * DCCON1.B3 / DCCON1.R3;
            DU[9] = -DCCON0.ALP3 * (double)DCCON1.F3 * Y * D / DCCON1.R5;
            DU[10] = DU[6];
            DU[11] = DU[9];
            DU[12] = -DCCON0.ALP3 * DCCON1.C3 / DCCON1.R3;
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT4 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
    }

    public static void UC0(double X, double Y, double D, double Z, double POT1, double POT2, double POT3, double POT4, double[] U) {
        double[] DU = new double[13];
        double C = D + Z;
        double Q2 = DCCON1.Q * DCCON1.Q;
        double R7 = DCCON1.R5 * DCCON1.R2;
        double A7 = (double)DCCON1.F1 - (double)DCCON0.F7 * DCCON1.X2 / DCCON1.R2;
        double B5 = (double)DCCON1.F1 - (double)DCCON1.F5 * DCCON1.Y2 / DCCON1.R2;
        double B7 = (double)DCCON0.F1 - (double)DCCON0.F7 * DCCON1.Y2 / DCCON1.R2;
        double C5 = (double)DCCON1.F1 - (double)DCCON1.F5 * DCCON1.D2 / DCCON1.R2;
        double C7 = (double)DCCON1.F1 - (double)DCCON0.F7 * DCCON1.D2 / DCCON1.R2;
        double D7 = (double)DCCON0.F2 - (double)DCCON0.F7 * Q2 / DCCON1.R2;
        double QR5 = (double)DCCON1.F5 * DCCON1.Q / DCCON1.R2;
        double QR7 = (double)DCCON0.F7 * DCCON1.Q / DCCON1.R2;
        double DR5 = (double)DCCON1.F5 * D / DCCON1.R2;
        i = 1;
        while (i <= 12) {
            U[DC3D0.i] = DCCON0.F0;
            ++i;
        }
        if (POT1 != (double)DCCON0.F0) {
            DU[1] = -DCCON0.ALP4 * DCCON1.A3 / DCCON1.R3 * DCCON0.CD + DCCON0.ALP5 * C * DCCON1.QR * DCCON1.A5;
            DU[2] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP4 * Y * DCCON0.CD + DCCON0.ALP5 * C * (DCCON0.SD - Y * QR5));
            DU[3] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * Y * DCCON0.SD + DCCON0.ALP5 * C * (DCCON0.CD + D * QR5));
            DU[4] = DCCON0.ALP4 * (double)DCCON1.F3 * X / DCCON1.R5 * ((double)DCCON0.F2 + DCCON1.A5) * DCCON0.CD - DCCON0.ALP5 * C * DCCON1.QRX * ((double)DCCON0.F2 + A7);
            DU[5] = (double)DCCON1.F3 / DCCON1.R5 * (DCCON0.ALP4 * Y * DCCON1.A5 * DCCON0.CD + DCCON0.ALP5 * C * (DCCON1.A5 * DCCON0.SD - Y * QR5 * A7));
            DU[6] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * Y * DCCON1.A5 * DCCON0.SD + DCCON0.ALP5 * C * (DCCON1.A5 * DCCON0.CD + D * QR5 * A7));
            DU[7] = DU[5];
            DU[8] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP4 * B5 * DCCON0.CD - DCCON0.ALP5 * (double)DCCON1.F5 * C / DCCON1.R2 * ((double)DCCON0.F2 * Y * DCCON0.SD + DCCON1.Q * B7));
            DU[9] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * B5 * DCCON0.SD + DCCON0.ALP5 * (double)DCCON1.F5 * C / DCCON1.R2 * (D * B7 * DCCON0.SD - Y * C7 * DCCON0.CD));
            DU[10] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * D * DCCON1.A5 * DCCON0.CD + DCCON0.ALP5 * C * (DCCON1.A5 * DCCON0.CD + D * QR5 * A7));
            DU[11] = (double)DCCON0.F15 * X / R7 * (DCCON0.ALP4 * Y * D * DCCON0.CD + DCCON0.ALP5 * C * (D * B7 * DCCON0.SD - Y * C7 * DCCON0.CD));
            DU[12] = (double)DCCON0.F15 * X / R7 * (-DCCON0.ALP4 * Y * D * DCCON0.SD + DCCON0.ALP5 * C * ((double)DCCON0.F2 * D * DCCON0.CD - DCCON1.Q * C7));
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT1 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT2 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP4 * (double)DCCON1.F3 * X * DCCON1.T / DCCON1.R5 - DCCON0.ALP5 * C * DCCON1.P * DCCON1.QRX;
            DU[2] = -DCCON0.ALP4 / DCCON1.R3 * (DCCON0.C2D - (double)DCCON1.F3 * Y * DCCON1.T / DCCON1.R2) + DCCON0.ALP5 * (double)DCCON1.F3 * C / DCCON1.R5 * (DCCON1.S - Y * DCCON1.P * QR5);
            DU[3] = -DCCON0.ALP4 * DCCON1.A3 / DCCON1.R3 * DCCON0.SDCD + DCCON0.ALP5 * (double)DCCON1.F3 * C / DCCON1.R5 * (DCCON1.T + D * DCCON1.P * QR5);
            DU[4] = DCCON0.ALP4 * (double)DCCON1.F3 * DCCON1.T / DCCON1.R5 * DCCON1.A5 - DCCON0.ALP5 * (double)DCCON1.F5 * C * DCCON1.P * DCCON1.QR / DCCON1.R2 * A7;
            DU[5] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP4 * (DCCON0.C2D - (double)DCCON1.F5 * Y * DCCON1.T / DCCON1.R2) - DCCON0.ALP5 * (double)DCCON1.F5 * C / DCCON1.R2 * (DCCON1.S - Y * DCCON1.P * QR7));
            DU[6] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP4 * ((double)DCCON0.F2 + DCCON1.A5) * DCCON0.SDCD - DCCON0.ALP5 * (double)DCCON1.F5 * C / DCCON1.R2 * (DCCON1.T + D * DCCON1.P * QR7));
            DU[7] = DU[5];
            DU[8] = (double)DCCON1.F3 / DCCON1.R5 * (DCCON0.ALP4 * ((double)DCCON0.F2 * Y * DCCON0.C2D + DCCON1.T * B5) + DCCON0.ALP5 * C * (DCCON0.S2D - (double)DCCON0.F10 * Y * DCCON1.S / DCCON1.R2 - DCCON1.P * QR5 * B7));
            DU[9] = (double)DCCON1.F3 / DCCON1.R5 * (DCCON0.ALP4 * Y * DCCON1.A5 * DCCON0.SDCD - DCCON0.ALP5 * C * (((double)DCCON1.F3 + DCCON1.A5) * DCCON0.C2D + Y * DCCON1.P * DR5 * QR7));
            DU[10] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * (DCCON0.S2D - DCCON1.T * DR5) - DCCON0.ALP5 * (double)DCCON1.F5 * C / DCCON1.R2 * (DCCON1.T + D * DCCON1.P * QR7));
            DU[11] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * (D * B5 * DCCON0.C2D + Y * C5 * DCCON0.S2D) - DCCON0.ALP5 * C * (((double)DCCON1.F3 + DCCON1.A5) * DCCON0.C2D + Y * DCCON1.P * DR5 * QR7));
            DU[12] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * D * DCCON1.A5 * DCCON0.SDCD - DCCON0.ALP5 * C * (DCCON0.S2D - (double)DCCON0.F10 * D * DCCON1.T / DCCON1.R2 + DCCON1.P * QR5 * C7));
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT2 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT3 != (double)DCCON0.F0) {
            DU[1] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * DCCON1.S + DCCON0.ALP5 * (C * DCCON1.Q * QR5 - Z));
            DU[2] = DCCON0.ALP4 / DCCON1.R3 * (DCCON0.S2D - (double)DCCON1.F3 * Y * DCCON1.S / DCCON1.R2) + DCCON0.ALP5 * (double)DCCON1.F3 / DCCON1.R5 * (C * (DCCON1.T - Y + Y * DCCON1.Q * QR5) - Y * Z);
            DU[3] = -DCCON0.ALP4 / DCCON1.R3 * ((double)DCCON0.F1 - DCCON1.A3 * DCCON0.SDSD) - DCCON0.ALP5 * (double)DCCON1.F3 / DCCON1.R5 * (C * (DCCON1.S - D + D * DCCON1.Q * QR5) - D * Z);
            DU[4] = -DCCON0.ALP4 * (double)DCCON1.F3 * DCCON1.S / DCCON1.R5 * DCCON1.A5 + DCCON0.ALP5 * (C * DCCON1.QR * QR5 * A7 - (double)DCCON1.F3 * Z / DCCON1.R5 * DCCON1.A5);
            DU[4] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * (DCCON0.S2D - (double)DCCON1.F5 * Y * DCCON1.S / DCCON1.R2));
            DU[5] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * (DCCON0.S2D - (double)DCCON1.F5 * Y * DCCON1.S / DCCON1.R2) - DCCON0.ALP5 * (double)DCCON1.F5 / DCCON1.R2 * (C * (DCCON1.T - Y + Y * DCCON1.Q * QR7) - Y * Z));
            DU[6] = (double)DCCON1.F3 * X / DCCON1.R5 * (DCCON0.ALP4 * ((double)DCCON1.F1 - ((double)DCCON0.F2 + DCCON1.A5) * DCCON0.SDSD) + DCCON0.ALP5 * (double)DCCON1.F5 / DCCON1.R2 * (C * (DCCON1.S - D + D * DCCON1.Q * QR7) - D * Z));
            DU[7] = DU[5];
            DU[8] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * ((double)DCCON0.F2 * Y * DCCON0.S2D + DCCON1.S * B5) - DCCON0.ALP5 * (C * ((double)DCCON0.F2 * DCCON0.SDSD + (double)DCCON0.F10 * Y * (DCCON1.T - Y) / DCCON1.R2 - DCCON1.Q * QR5 * B7) + Z * B5));
            DU[9] = (double)DCCON1.F3 / DCCON1.R5 * (DCCON0.ALP4 * Y * ((double)DCCON1.F1 - DCCON1.A5 * DCCON0.SDSD) + DCCON0.ALP5 * (C * ((double)DCCON1.F3 + DCCON1.A5) * DCCON0.S2D - Y * DR5 * (C * D7 + Z)));
            DU[10] = (double)DCCON1.F3 * X / DCCON1.R5 * (-DCCON0.ALP4 * (DCCON0.C2D + DCCON1.S * DR5) + DCCON0.ALP5 * ((double)DCCON1.F5 * C / DCCON1.R2 * (DCCON1.S - D + D * DCCON1.Q * QR7) - (double)DCCON1.F1 - Z * DR5));
            DU[11] = (double)DCCON1.F3 / DCCON1.R5 * (DCCON0.ALP4 * (D * B5 * DCCON0.S2D - Y * C5 * DCCON0.C2D) + DCCON0.ALP5 * (C * (((double)DCCON1.F3 + DCCON1.A5) * DCCON0.S2D - Y * DR5 * D7) - Y * ((double)DCCON1.F1 + Z * DR5)));
            DU[12] = (double)DCCON1.F3 / DCCON1.R5 * (-DCCON0.ALP4 * D * ((double)DCCON1.F1 - DCCON1.A5 * DCCON0.SDSD) - DCCON0.ALP5 * (C * (DCCON0.C2D + (double)DCCON0.F10 * D * (DCCON1.S - D) / DCCON1.R2 - DCCON1.Q * QR5 * C7) + Z * ((double)DCCON1.F1 + C5)));
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT3 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
        if (POT4 != (double)DCCON0.F0) {
            DU[1] = DCCON0.ALP4 * (double)DCCON1.F3 * X * D / DCCON1.R5;
            DU[2] = DCCON0.ALP4 * (double)DCCON1.F3 * Y * D / DCCON1.R5;
            DU[3] = DCCON0.ALP4 * DCCON1.C3 / DCCON1.R3;
            DU[4] = DCCON0.ALP4 * (double)DCCON1.F3 * D / DCCON1.R5 * DCCON1.A5;
            DU[5] = -DCCON0.ALP4 * (double)DCCON0.F15 * DCCON1.XY * D / R7;
            DU[6] = -DCCON0.ALP4 * (double)DCCON1.F3 * X / DCCON1.R5 * C;
            DU[7] = DU[5];
            DU[8] = DCCON0.ALP4 * (double)DCCON1.F3 * D / DCCON1.R5 * B5;
            DU[9] = -DCCON0.ALP4 * (double)DCCON1.F3 * Y / DCCON1.R5 * C5;
            DU[10] = DU[6];
            DU[11] = DU[9];
            DU[12] = DCCON0.ALP4 * (double)DCCON1.F3 * D / DCCON1.R5 * ((double)DCCON0.F2 + C5);
            i = 1;
            while (i <= 12) {
                U[DC3D0.i] = U[i] + POT4 / DCCON0.PI2 * DU[i];
                ++i;
            }
        }
    }
}

