/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Vector3d;
import okada.DC3D;

public class DCCON2 {
    public static double XI2;
    public static double ET2;
    public static double Q2;
    public static double R;
    public static double R2;
    public static double R3;
    public static double R5;
    public static double SD;
    public static double CD;
    public static double SA;
    public static double CA;
    public static double TEMPX;
    public static double TEMPY;
    public static double SDSD;
    public static double SDCD;
    public static double CDCD;
    public static double S2D;
    public static double C2D;
    public static double D;
    public static double TT;
    public static double ALX;
    public static double ALE;
    public static double X11;
    public static double Y11;
    public static double X32;
    public static double Y32;
    public static double EY;
    public static double EZ;
    public static double FY;
    public static double FZ;
    public static double GY;
    public static double GZ;
    public static double HY;
    public static double HZ;
    public static double RET;
    public static double ALP1;
    public static double ALP2;
    public static double ALP3;
    public static double ALP4;
    public static double ALP5;
    public static double AZIM;
    public static double DIP;
    public static double Y;
    public static double Z;
    public static double DISL1;
    public static double DISL2;
    public static double DISL3;
    public static double L1;
    public static double L2;
    public static double DEPTH;
    public static double W1;
    public static double W2;
    public static double ox;
    public static double oy;
    public static double oz;
    public static double S_X;
    public static double S_Y;
    public static double S_Z;
    public static double L;
    public static double W;
    public static double RXI;
    public static double[] KXI1;
    public static double[] KET1;
    public static double E;
    public static double v;
    public static double LAMBDA;
    public static double MYU;
    public static double ALPHA;
    public static double phi;
    public static double PI2;
    public static double P18;
    public static double EPS;
    public static double F1;
    public static double F2;
    public static double F3;
    public static double F4;
    public static double F5;
    public static double F6;
    public static double F0;
    public static Vector3d XL;
    public static Vector3d YL;
    public static Vector3d ZL;

    static {
        KXI1 = new double[2];
        KET1 = new double[2];
        E = 800000.0;
        v = 0.18;
        LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        MYU = E / (2.0 * (1.0 + v));
        ALPHA = (LAMBDA + MYU) / (LAMBDA + 2.0 * MYU);
        phi = 0.15;
        PI2 = Math.PI * 2;
        P18 = PI2 / 360.0;
        EPS = 1.0E-6;
        F1 = 1.0;
        F2 = 2.0;
        F3 = 3.0;
        F4 = 4.0;
        F5 = 5.0;
        F6 = 6.0;
        F0 = 0.0;
    }

    public static void setSourceLocation(double x, double y, double z) {
        S_X = x;
        S_Y = y;
        S_Z = z;
    }

    public static void setObervationLocation(double o_x, double o_y, double o_z) {
        ox = o_x;
        oy = o_y;
        oz = o_z;
        TEMPX = ox;
        TEMPY = oy;
        ox = TEMPX * DCCON2.XL.x + TEMPY * DCCON2.XL.y;
        oy = TEMPX * DCCON2.YL.x + TEMPY * DCCON2.YL.y;
    }

    public static void setSourceDimensions(double azim, double dip, double L, double W) {
        AZIM = azim;
        DIP = dip;
        L1 = -0.5 * L;
        L2 = 0.5 * L;
        W1 = -0.5 * W;
        W2 = 0.5 * W;
        SD = Math.sin(DIP * P18);
        CD = Math.cos(DIP * P18);
    }

    public static void prepareSource() {
        if (XL == null) {
            XL = new Vector3d();
        }
        if (YL == null) {
            YL = new Vector3d();
        }
        DCCON2.XL.x = 1.0;
        DCCON2.XL.y = 0.0;
        DCCON2.XL.z = 0.0;
        DCCON2.YL.x = 0.0;
        DCCON2.YL.y = 1.0;
        DCCON2.YL.z = 0.0;
        SA = Math.sin(AZIM * P18);
        CA = Math.cos(AZIM * P18);
        TEMPX = DCCON2.XL.x;
        TEMPY = DCCON2.XL.y;
        DCCON2.XL.x = CA * TEMPX + SA * TEMPY;
        DCCON2.XL.y = -SA * TEMPX + CA * TEMPY;
        TEMPX = DCCON2.YL.x;
        TEMPY = DCCON2.YL.y;
        DCCON2.YL.x = CA * TEMPX + SA * TEMPY;
        DCCON2.YL.y = -SA * TEMPX + CA * TEMPY;
        ALP1 = (F1 - ALPHA) / F2;
        ALP2 = ALPHA / F2;
        ALP3 = (F1 - ALPHA) / ALPHA;
        ALP4 = F1 - ALPHA;
        ALP5 = ALPHA;
        if (Math.abs(CD) < EPS) {
            CD = F0;
            if (SD > F0) {
                SD = F1;
            }
            if (SD < F0) {
                SD = -F1;
            }
        }
        SDSD = SD * SD;
        CDCD = CD * CD;
        SDCD = SD * CD;
        S2D = F2 * SDCD;
        C2D = CDCD - SDSD;
    }

    public static void DCCON2(double XIX, double ETE, double Q, double SD, double CD, double KXI, double KET) {
        if (Math.abs(XIX) < EPS) {
            XIX = F0;
        }
        if (Math.abs(ETE) < EPS) {
            ETE = F0;
        }
        if (Math.abs(Q) < EPS) {
            Q = F0;
        }
        if ((R = Math.sqrt(R2 = (XI2 = XIX * XIX) + (ET2 = ETE * ETE) + (Q2 = Q * Q))) == F0) {
            return;
        }
        R3 = R * R2;
        R5 = R2 * R3;
        Y = ETE * CD + Q * SD;
        D = ETE * SD - Q * CD;
        TT = Q == F0 ? F0 : Math.atan(XIX * ETE / (Q * R));
        int i = 0;
        while (i < 2) {
            DCCON2.KXI1[i] = F1;
            ++i;
        }
        if (DC3D.KXI == KXI1) {
            ALX = -Math.log(R - XIX);
            X11 = F0;
            X32 = F0;
        } else {
            RXI = R + XIX;
            ALX = Math.log(RXI);
            X11 = F1 / (R * RXI);
            X32 = (R + RXI) * X11 * X11 / R;
        }
        i = 0;
        while (i < 2) {
            DCCON2.KET1[i] = F1;
            ++i;
        }
        if (DC3D.KET == KET1) {
            ALE = -Math.log(R - ETE);
            Y11 = F0;
            Y32 = F0;
        } else {
            RET = R + ETE;
            ALE = Math.log(RET);
            Y11 = F1 / (R * RET);
            Y32 = (R + RET) * Y11 * Y11 / R;
        }
        EY = SD / R - Y * Q / R3;
        EZ = CD / R + D * Q / R3;
        FY = D / R3 + XI2 * Y32 * SD;
        FZ = Y / R3 + XI2 * Y32 * CD;
        GY = F2 * X11 * SD - Y * Q * X32;
        GZ = F2 * X11 * CD + D * Q * X32;
        HY = D * Q * X32 + XIX * Q * Y32 * SD;
        HZ = Y * Q * X32 + XIX * Q * Y32 * CD;
    }

    public static double getALPHA() {
        return ALPHA;
    }

    public static void setALPHA(double alpha) {
        ALPHA = alpha;
    }
}

