/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Vector3d;

public class OkadaDC3DPoint {
    public static double SD;
    public static double CD;
    public static double SDSD;
    public static double CDCD;
    public static double SDCD;
    public static double S2D;
    public static double C2D;
    public static final double F0 = 0.0;
    public static final double F1 = 1.0;
    public static final double F2 = 2.0;
    public static final double F3 = 3.0;
    public static final double F4 = 4.0;
    public static final double F5 = 5.0;
    public static final double F6 = 6.0;
    public static final double F7 = 7.0;
    public static final double F8 = 8.0;
    public static final double F9 = 9.0;
    public static final double F10 = 10.0;
    public static final double F15 = 15.0;
    public static final double PI2 = Math.PI * 2;
    public static final double EPS = 1.0E-6;
    public static double ALP1;
    public static double ALP2;
    public static double ALP3;
    public static double ALP4;
    public static double ALP5;
    public static double P;
    public static double Q;
    public static double S;
    public static double T;
    public static double XY;
    public static double X2;
    public static double Y2;
    public static double D2;
    public static double R;
    public static double R2;
    public static double R3;
    public static double R5;
    public static double QR;
    public static double QRX;
    public static double A3;
    public static double A5;
    public static double B3;
    public static double C3;
    public static double UY;
    public static double VY;
    public static double WY;
    public static double UZ;
    public static double VZ;
    public static double WZ;
    public static double UX;
    private static double[] U;
    private static double UXX;
    private static double UYX;
    private static double UZX;
    private static double UXY;
    private static double UYY;
    private static double UZY;
    private static double UXZ;
    private static double UYZ;
    private static double UZZ;
    public static double dip;
    public static double exx;
    public static double eyy;
    public static double ezz;
    public static double exy;
    public static double exz;
    public static double eyz;
    public static double eyx;
    public static double ezx;
    public static double ezy;
    public static double Sxx;
    public static double Syy;
    public static double Szz;
    public static double Sxy;
    public static double Syx;
    public static double Sxz;
    public static double Szx;
    public static double Syz;
    public static double Szy;
    public static double[] DU;
    public static double rmin;
    public static double rmin2;

    static {
        ALP1 = 0.0;
        ALP2 = 0.0;
        ALP3 = 0.0;
        ALP4 = 0.0;
        ALP5 = 0.0;
        U = new double[13];
        dip = 0.0;
        DU = new double[13];
        rmin = 1.0E-6;
        rmin2 = 1.0E-12;
    }

    public static void calculateAtObservation(double x, double y, double z, double depth, double POT1, double POT2, double POT3, double POT4, double ALPHA, double YOUNG, double POIS) {
        OkadaDC3DPoint.DC3D0(ALPHA, x, y, z, depth, dip, POT1, POT2, POT3, POT4, U);
        UX = U[1];
        UY = U[2];
        UZ = U[3];
        UXX = U[4];
        UYX = U[5];
        UZX = U[6];
        UXY = U[7];
        UYY = U[8];
        UZY = U[9];
        UXZ = U[10];
        UYZ = U[11];
        UZZ = U[12];
        exx = UXX;
        eyy = UYY;
        ezz = UZZ;
        exy = eyx = 0.5 * (UYX + UXY);
        exz = ezx = 0.5 * (UXZ + UZX);
        eyz = ezy = 0.5 * (UYZ + UZX);
        double vol = UXX + UYY + UZZ;
        double sk = YOUNG / (1.0 + POIS);
        double gk = POIS / (1.0 - 2.0 * POIS);
        Sxx = sk * (gk * vol + UXX);
        Syy = sk * (gk * vol + UYY);
        Szz = sk * (gk * vol + UZZ);
        Sxy = Syx = YOUNG / (2.0 * (1.0 + POIS)) * (UXY + UYX);
        Sxz = Szx = YOUNG / (2.0 * (1.0 + POIS)) * (UXZ + UZX);
        Syz = Szy = YOUNG / (2.0 * (1.0 + POIS)) * (UYZ + UZY);
    }

    public static int DC3D0(double ALPHA, double X, double Y, double Z, double DEPTH, double DIP, double POT1, double POT2, double POT3, double POT4, double[] URES) {
        double[] U = new double[13];
        double[] DUA = new double[13];
        double[] DUB = new double[13];
        double[] DUC = new double[13];
        if (Z > 0.0) {
            System.out.println("error: positive Z given as input");
        }
        int i = 1;
        while (i <= 12) {
            U[i] = 0.0;
            DUA[i] = 0.0;
            DUB[i] = 0.0;
            DUC[i] = 0.0;
            URES[i] = 0.0;
            ++i;
        }
        double AALPHA = ALPHA;
        double DDIP = DIP;
        OkadaDC3DPoint.DCCON0(AALPHA, DDIP);
        double XX = X;
        double YY = Y;
        double ZZ = Z;
        double DD = DEPTH + Z;
        OkadaDC3DPoint.DCCON1(XX, YY, DD);
        if (R == 0.0) {
            System.out.println("should goto 99");
            return 1;
        }
        double PP1 = POT1;
        double PP2 = POT2;
        double PP3 = POT3;
        double PP4 = POT4;
        OkadaDC3DPoint.UA0(XX, YY, DD, PP1, PP2, PP3, PP4, DUA);
        int I = 1;
        while (I <= 12) {
            if (I < 10) {
                U[I] = U[I] - DUA[I];
            }
            if (I >= 10) {
                U[I] = U[I] + DUA[I];
            }
            ++I;
        }
        DD = DEPTH - Z;
        OkadaDC3DPoint.DCCON1(XX, YY, DD);
        OkadaDC3DPoint.UA0(XX, YY, DD, PP1, PP2, PP3, PP4, DUA);
        OkadaDC3DPoint.UB0(XX, YY, DD, ZZ, PP1, PP2, PP3, PP4, DUB);
        OkadaDC3DPoint.UC0(XX, YY, DD, ZZ, PP1, PP2, PP3, PP4, DUC);
        I = 1;
        while (I <= 12) {
            double DU = DUA[I] + DUB[I] + ZZ * DUC[I];
            if (I >= 10) {
                DU += DUC[I - 9];
            }
            U[I] = U[I] + DU;
            ++I;
        }
        I = 1;
        while (I <= 12) {
            URES[I] = U[I];
            ++I;
        }
        return 0;
    }

    public static void UA0(double X, double Y, double D, double POT1, double POT2, double POT3, double POT4, double[] U) {
        int I = 1;
        while (I <= 12) {
            U[I] = 0.0;
            OkadaDC3DPoint.DU[I] = 0.0;
            ++I;
        }
        if (POT1 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP1 * Q / R3 + ALP2 * X2 * QR;
            OkadaDC3DPoint.DU[2] = ALP1 * X / R3 * SD + ALP2 * XY * QR;
            OkadaDC3DPoint.DU[3] = -ALP1 * X / R3 * CD + ALP2 * X * D * QR;
            OkadaDC3DPoint.DU[4] = X * QR * (-ALP1 + ALP2 * (1.0 + A5));
            OkadaDC3DPoint.DU[5] = ALP1 * A3 / R3 * SD + ALP2 * Y * QR * A5;
            OkadaDC3DPoint.DU[6] = -ALP1 * A3 / R3 * CD + ALP2 * D * QR * A5;
            OkadaDC3DPoint.DU[7] = ALP1 * (SD / R3 - Y * QR) + ALP2 * 3.0 * X2 / R5 * UY;
            OkadaDC3DPoint.DU[8] = 3.0 * X / R5 * (-ALP1 * Y * SD + ALP2 * (Y * UY + Q));
            OkadaDC3DPoint.DU[9] = 3.0 * X / R5 * (ALP1 * Y * CD + ALP2 * D * UY);
            OkadaDC3DPoint.DU[10] = ALP1 * (CD / R3 + D * QR) + ALP2 * 3.0 * X2 / R5 * UZ;
            OkadaDC3DPoint.DU[11] = 3.0 * X / R5 * (ALP1 * D * SD + ALP2 * Y * UZ);
            OkadaDC3DPoint.DU[12] = 3.0 * X / R5 * (-ALP1 * D * CD + ALP2 * (D * UZ - Q));
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT2 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP2 * X * P * QR;
            OkadaDC3DPoint.DU[2] = ALP1 * S / R3 + ALP2 * Y * P * QR;
            OkadaDC3DPoint.DU[3] = -ALP1 * T / R3 + ALP2 * D * P * QR;
            OkadaDC3DPoint.DU[4] = ALP2 * P * QR * A5;
            OkadaDC3DPoint.DU[5] = -ALP1 * 3.0 * X * S / R5 - ALP2 * Y * P * QRX;
            OkadaDC3DPoint.DU[6] = ALP1 * 3.0 * X * T / R5 - ALP2 * D * P * QRX;
            OkadaDC3DPoint.DU[7] = ALP2 * 3.0 * X / R5 * VY;
            OkadaDC3DPoint.DU[8] = ALP1 * (S2D / R3 - 3.0 * Y * S / R5) + ALP2 * (3.0 * Y / R5 * VY + P * QR);
            OkadaDC3DPoint.DU[9] = -ALP1 * (C2D / R3 - 3.0 * Y * T / R5) + ALP2 * 3.0 * D / R5 * VY;
            OkadaDC3DPoint.DU[10] = ALP2 * 3.0 * X / R5 * VZ;
            OkadaDC3DPoint.DU[11] = ALP1 * (C2D / R3 + 3.0 * D * S / R5) + ALP2 * 3.0 * Y / R5 * VZ;
            OkadaDC3DPoint.DU[12] = ALP1 * (S2D / R3 - 3.0 * D * T / R5) + ALP2 * (3.0 * D / R5 * VZ - P * QR);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT3 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP1 * X / R3 - ALP2 * X * Q * QR;
            OkadaDC3DPoint.DU[2] = ALP1 * T / R3 - ALP2 * Y * Q * QR;
            OkadaDC3DPoint.DU[3] = ALP1 * S / R3 - ALP2 * D * Q * QR;
            OkadaDC3DPoint.DU[4] = ALP1 * A3 / R3 - ALP2 * Q * QR * A5;
            OkadaDC3DPoint.DU[5] = -ALP1 * 3.0 * X * T / R5 + ALP2 * Y * Q * QRX;
            OkadaDC3DPoint.DU[6] = -ALP1 * 3.0 * X * S / R5 + ALP2 * D * Q * QRX;
            OkadaDC3DPoint.DU[7] = -ALP1 * 3.0 * XY / R5 - ALP2 * X * QR * WY;
            OkadaDC3DPoint.DU[8] = ALP1 * (C2D / R3 - 3.0 * Y * T / R5) - ALP2 * (Y * WY + Q) * QR;
            OkadaDC3DPoint.DU[9] = ALP1 * (S2D / R3 - 3.0 * Y * S / R5) - ALP2 * D * QR * WY;
            OkadaDC3DPoint.DU[10] = ALP1 * 3.0 * X * D / R5 - ALP2 * X * QR * WZ;
            OkadaDC3DPoint.DU[11] = -ALP1 * (S2D / R3 - 3.0 * D * T / R5) - ALP2 * Y * QR * WZ;
            OkadaDC3DPoint.DU[12] = ALP1 * (C2D / R3 + 3.0 * D * S / R5) - ALP2 * (D * WZ - Q) * QR;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT4 != 0.0) {
            OkadaDC3DPoint.DU[1] = -ALP1 * X / R3;
            OkadaDC3DPoint.DU[2] = -ALP1 * Y / R3;
            OkadaDC3DPoint.DU[3] = -ALP1 * D / R3;
            OkadaDC3DPoint.DU[4] = -ALP1 * A3 / R3;
            OkadaDC3DPoint.DU[5] = ALP1 * 3.0 * XY / R5;
            OkadaDC3DPoint.DU[6] = ALP1 * 3.0 * X * D / R5;
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = -ALP1 * B3 / R3;
            OkadaDC3DPoint.DU[9] = ALP1 * 3.0 * Y * D / R5;
            OkadaDC3DPoint.DU[10] = -DU[6];
            OkadaDC3DPoint.DU[11] = -DU[9];
            OkadaDC3DPoint.DU[12] = ALP1 * C3 / R3;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT4 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void UB0(double X, double Y, double D, double Z, double POT1, double POT2, double POT3, double POT4, double[] U) {
        double C = D + Z;
        double RD = R + D;
        double D12 = 1.0 / (R * RD * RD);
        double D32 = D12 * (2.0 * R + D) / R2;
        double D33 = D12 * (3.0 * R + D) / (R2 * RD);
        double D53 = D12 * (8.0 * R2 + 9.0 * R * D + 3.0 * D2) / (R2 * R2 * RD);
        double D54 = D12 * (5.0 * R2 + 4.0 * R * D + D2) / R3 * D12;
        double FI1 = Y * (D12 - X2 * D33);
        double FI2 = X * (D12 - Y2 * D33);
        double FI3 = X / R3 - FI2;
        double FI4 = -XY * D32;
        double FI5 = 1.0 / (R * RD) - X2 * D32;
        double FJ1 = -3.0 * XY * (D33 - X2 * D54);
        double FJ2 = 1.0 / R3 - 3.0 * D12 + 3.0 * X2 * Y2 * D54;
        double FJ3 = A3 / R3 - FJ2;
        double FJ4 = -3.0 * XY / R5 - FJ1;
        double FK1 = -Y * (D32 - X2 * D53);
        double FK2 = -X * (D32 - Y2 * D53);
        double FK3 = -3.0 * X * D / R5 - FK2;
        int I = 1;
        while (I <= 12) {
            U[I] = 0.0;
            OkadaDC3DPoint.DU[I] = 0.0;
            ++I;
        }
        if (POT1 != 0.0) {
            OkadaDC3DPoint.DU[1] = -X2 * QR - ALP3 * FI1 * SD;
            OkadaDC3DPoint.DU[2] = -XY * QR - ALP3 * FI2 * SD;
            OkadaDC3DPoint.DU[3] = -C * X * QR - ALP3 * FI4 * SD;
            OkadaDC3DPoint.DU[4] = -X * QR * (1.0 + A5) - ALP3 * FJ1 * SD;
            OkadaDC3DPoint.DU[5] = -Y * QR * A5 - ALP3 * FJ2 * SD;
            OkadaDC3DPoint.DU[6] = -C * QR * A5 - ALP3 * FK1 * SD;
            OkadaDC3DPoint.DU[7] = -3.0 * X2 / R5 * UY - ALP3 * FJ2 * SD;
            OkadaDC3DPoint.DU[8] = -3.0 * XY / R5 * UY - X * QR - ALP3 * FJ4 * SD;
            OkadaDC3DPoint.DU[9] = -3.0 * C * X / R5 * UY - ALP3 * FK2 * SD;
            OkadaDC3DPoint.DU[10] = -3.0 * X2 / R5 * UZ + ALP3 * FK1 * SD;
            OkadaDC3DPoint.DU[11] = -3.0 * XY / R5 * UZ + ALP3 * FK2 * SD;
            OkadaDC3DPoint.DU[12] = 3.0 * X / R5 * (-C * UZ + ALP3 * Y * SD);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT2 != 0.0) {
            OkadaDC3DPoint.DU[1] = -X * P * QR + ALP3 * FI3 * SDCD;
            OkadaDC3DPoint.DU[2] = -Y * P * QR + ALP3 * FI1 * SDCD;
            OkadaDC3DPoint.DU[3] = -C * P * QR + ALP3 * FI5 * SDCD;
            OkadaDC3DPoint.DU[4] = -P * QR * A5 + ALP3 * FJ3 * SDCD;
            OkadaDC3DPoint.DU[5] = Y * P * QRX + ALP3 * FJ1 * SDCD;
            OkadaDC3DPoint.DU[6] = C * P * QRX + ALP3 * FK3 * SDCD;
            OkadaDC3DPoint.DU[7] = -3.0 * X / R5 * VY + ALP3 * FJ1 * SDCD;
            OkadaDC3DPoint.DU[8] = -3.0 * Y / R5 * VY - P * QR + ALP3 * FJ2 * SDCD;
            OkadaDC3DPoint.DU[9] = -3.0 * C / R5 * VY + ALP3 * FK1 * SDCD;
            OkadaDC3DPoint.DU[10] = -3.0 * X / R5 * VZ - ALP3 * FK3 * SDCD;
            OkadaDC3DPoint.DU[11] = -3.0 * Y / R5 * VZ - ALP3 * FK1 * SDCD;
            OkadaDC3DPoint.DU[12] = -3.0 * C / R5 * VZ + ALP3 * A3 / R3 * SDCD;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT3 != 0.0) {
            OkadaDC3DPoint.DU[1] = X * Q * QR - ALP3 * FI3 * SDSD;
            OkadaDC3DPoint.DU[2] = Y * Q * QR - ALP3 * FI1 * SDSD;
            OkadaDC3DPoint.DU[3] = C * Q * QR - ALP3 * FI5 * SDSD;
            OkadaDC3DPoint.DU[4] = Q * QR * A5 - ALP3 * FJ3 * SDSD;
            OkadaDC3DPoint.DU[5] = -Y * Q * QRX - ALP3 * FJ1 * SDSD;
            OkadaDC3DPoint.DU[6] = -C * Q * QRX - ALP3 * FK3 * SDSD;
            OkadaDC3DPoint.DU[7] = X * QR * WY - ALP3 * FJ1 * SDSD;
            OkadaDC3DPoint.DU[8] = QR * (Y * WY + Q) - ALP3 * FJ2 * SDSD;
            OkadaDC3DPoint.DU[9] = C * QR * WY - ALP3 * FK1 * SDSD;
            OkadaDC3DPoint.DU[10] = X * QR * WZ + ALP3 * FK3 * SDSD;
            OkadaDC3DPoint.DU[11] = Y * QR * WZ + ALP3 * FK1 * SDSD;
            OkadaDC3DPoint.DU[12] = C * QR * WZ - ALP3 * A3 / R3 * SDSD;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT4 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP3 * X / R3;
            OkadaDC3DPoint.DU[2] = ALP3 * Y / R3;
            OkadaDC3DPoint.DU[3] = ALP3 * D / R3;
            OkadaDC3DPoint.DU[4] = ALP3 * A3 / R3;
            OkadaDC3DPoint.DU[5] = -ALP3 * 3.0 * XY / R5;
            OkadaDC3DPoint.DU[6] = -ALP3 * 3.0 * X * D / R5;
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = ALP3 * B3 / R3;
            OkadaDC3DPoint.DU[9] = -ALP3 * 3.0 * Y * D / R5;
            OkadaDC3DPoint.DU[10] = -DU[6];
            OkadaDC3DPoint.DU[11] = -DU[9];
            OkadaDC3DPoint.DU[12] = -ALP3 * C3 / R3;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT4 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void UC0(double X, double Y, double D, double Z, double POT1, double POT2, double POT3, double POT4, double[] U) {
        double C = D + Z;
        double Q2 = Q * Q;
        double R7 = R5 * R2;
        double A7 = 1.0 - 7.0 * X2 / R2;
        double B5 = 1.0 - 5.0 * Y2 / R2;
        double B7 = 1.0 - 7.0 * Y2 / R2;
        double C5 = 1.0 - 5.0 * D2 / R2;
        double C7 = 1.0 - 7.0 * D2 / R2;
        double D7 = 2.0 - 7.0 * Q2 / R2;
        double QR5 = 5.0 * Q / R2;
        double QR7 = 7.0 * Q / R2;
        double DR5 = 5.0 * D / R2;
        int I = 1;
        while (I <= 12) {
            U[I] = 0.0;
            OkadaDC3DPoint.DU[I] = 0.0;
            ++I;
        }
        if (POT1 != 0.0) {
            OkadaDC3DPoint.DU[1] = -ALP4 * A3 / R3 * CD + ALP5 * C * QR * A5;
            OkadaDC3DPoint.DU[2] = 3.0 * X / R5 * (ALP4 * Y * CD + ALP5 * C * (SD - Y * QR5));
            OkadaDC3DPoint.DU[3] = 3.0 * X / R5 * (-ALP4 * Y * SD + ALP5 * C * (CD + D * QR5));
            OkadaDC3DPoint.DU[4] = ALP4 * 3.0 * X / R5 * (2.0 + A5) * CD - ALP5 * C * QRX * (2.0 + A7);
            OkadaDC3DPoint.DU[5] = 3.0 / R5 * (ALP4 * Y * A5 * CD + ALP5 * C * (A5 * SD - Y * QR5 * A7));
            OkadaDC3DPoint.DU[6] = 3.0 / R5 * (-ALP4 * Y * A5 * SD + ALP5 * C * (A5 * CD + D * QR5 * A7));
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = 3.0 * X / R5 * (ALP4 * B5 * CD - ALP5 * 5.0 * C / R2 * (2.0 * Y * SD + Q * B7));
            OkadaDC3DPoint.DU[9] = 3.0 * X / R5 * (-ALP4 * B5 * SD + ALP5 * 5.0 * C / R2 * (D * B7 * SD - Y * C7 * CD));
            OkadaDC3DPoint.DU[10] = 3.0 / R5 * (-ALP4 * D * A5 * CD + ALP5 * C * (A5 * CD + D * QR5 * A7));
            OkadaDC3DPoint.DU[11] = 15.0 * X / R7 * (ALP4 * Y * D * CD + ALP5 * C * (D * B7 * SD - Y * C7 * CD));
            OkadaDC3DPoint.DU[12] = 15.0 * X / R7 * (-ALP4 * Y * D * SD + ALP5 * C * (2.0 * D * CD - Q * C7));
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT2 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP4 * 3.0 * X * T / R5 - ALP5 * C * P * QRX;
            OkadaDC3DPoint.DU[2] = -ALP4 / R3 * (C2D - 3.0 * Y * T / R2) + ALP5 * 3.0 * C / R5 * (S - Y * P * QR5);
            OkadaDC3DPoint.DU[3] = -ALP4 * A3 / R3 * SDCD + ALP5 * 3.0 * C / R5 * (T + D * P * QR5);
            OkadaDC3DPoint.DU[4] = ALP4 * 3.0 * T / R5 * A5 - ALP5 * 5.0 * C * P * QR / R2 * A7;
            OkadaDC3DPoint.DU[5] = 3.0 * X / R5 * (ALP4 * (C2D - 5.0 * Y * T / R2) - ALP5 * 5.0 * C / R2 * (S - Y * P * QR7));
            OkadaDC3DPoint.DU[6] = 3.0 * X / R5 * (ALP4 * (2.0 + A5) * SDCD - ALP5 * 5.0 * C / R2 * (T + D * P * QR7));
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = 3.0 / R5 * (ALP4 * (2.0 * Y * C2D + T * B5) + ALP5 * C * (S2D - 10.0 * Y * S / R2 - P * QR5 * B7));
            OkadaDC3DPoint.DU[9] = 3.0 / R5 * (ALP4 * Y * A5 * SDCD - ALP5 * C * ((3.0 + A5) * C2D + Y * P * DR5 * QR7));
            OkadaDC3DPoint.DU[10] = 3.0 * X / R5 * (-ALP4 * (S2D - T * DR5) - ALP5 * 5.0 * C / R2 * (T + D * P * QR7));
            OkadaDC3DPoint.DU[11] = 3.0 / R5 * (-ALP4 * (D * B5 * C2D + Y * C5 * S2D) - ALP5 * C * ((3.0 + A5) * C2D + Y * P * DR5 * QR7));
            OkadaDC3DPoint.DU[12] = 3.0 / R5 * (-ALP4 * D * A5 * SDCD - ALP5 * C * (S2D - 10.0 * D * T / R2 + P * QR5 * C7));
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT3 != 0.0) {
            OkadaDC3DPoint.DU[1] = 3.0 * X / R5 * (-ALP4 * S + ALP5 * (C * Q * QR5 - Z));
            OkadaDC3DPoint.DU[2] = ALP4 / R3 * (S2D - 3.0 * Y * S / R2) + ALP5 * 3.0 / R5 * (C * (T - Y + Y * Q * QR5) - Y * Z);
            OkadaDC3DPoint.DU[3] = -ALP4 / R3 * (1.0 - A3 * SDSD) - ALP5 * 3.0 / R5 * (C * (S - D + D * Q * QR5) - D * Z);
            OkadaDC3DPoint.DU[4] = -ALP4 * 3.0 * S / R5 * A5 + ALP5 * (C * QR * QR5 * A7 - 3.0 * Z / R5 * A5);
            OkadaDC3DPoint.DU[5] = 3.0 * X / R5 * (-ALP4 * (S2D - 5.0 * Y * S / R2) - ALP5 * 5.0 / R2 * (C * (T - Y + Y * Q * QR7) - Y * Z));
            OkadaDC3DPoint.DU[6] = 3.0 * X / R5 * (ALP4 * (1.0 - (2.0 + A5) * SDSD) + ALP5 * 5.0 / R2 * (C * (S - D + D * Q * QR7) - D * Z));
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = 3.0 / R5 * (-ALP4 * (2.0 * Y * S2D + S * B5) - ALP5 * (C * (2.0 * SDSD + 10.0 * Y * (T - Y) / R2 - Q * QR5 * B7) + Z * B5));
            OkadaDC3DPoint.DU[9] = 3.0 / R5 * (ALP4 * Y * (1.0 - A5 * SDSD) + ALP5 * (C * (3.0 + A5) * S2D - Y * DR5 * (C * D7 + Z)));
            OkadaDC3DPoint.DU[10] = 3.0 * X / R5 * (-ALP4 * (C2D + S * DR5) + ALP5 * (5.0 * C / R2 * (S - D + D * Q * QR7) - 1.0 - Z * DR5));
            OkadaDC3DPoint.DU[11] = 3.0 / R5 * (ALP4 * (D * B5 * S2D - Y * C5 * C2D) + ALP5 * (C * ((3.0 + A5) * S2D - Y * DR5 * D7) - Y * (1.0 + Z * DR5)));
            OkadaDC3DPoint.DU[12] = 3.0 / R5 * (-ALP4 * D * (1.0 - A5 * SDSD) - ALP5 * (C * (C2D + 10.0 * D * (S - D) / R2 - Q * QR5 * C7) + Z * (1.0 + C5)));
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (POT4 != 0.0) {
            OkadaDC3DPoint.DU[1] = ALP4 * 3.0 * X * D / R5;
            OkadaDC3DPoint.DU[2] = ALP4 * 3.0 * Y * D / R5;
            OkadaDC3DPoint.DU[3] = ALP4 * C3 / R3;
            OkadaDC3DPoint.DU[4] = ALP4 * 3.0 * D / R5 * A5;
            OkadaDC3DPoint.DU[5] = -ALP4 * 15.0 * XY * D / R7;
            OkadaDC3DPoint.DU[6] = -ALP4 * 3.0 * X / R5 * C5;
            OkadaDC3DPoint.DU[7] = DU[5];
            OkadaDC3DPoint.DU[8] = ALP4 * 3.0 * D / R5 * B5;
            OkadaDC3DPoint.DU[9] = -ALP4 * 3.0 * Y / R5 * C5;
            OkadaDC3DPoint.DU[10] = DU[6];
            OkadaDC3DPoint.DU[11] = DU[9];
            OkadaDC3DPoint.DU[12] = ALP4 * 3.0 * D / R5 * (2.0 + C5);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + POT4 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void DCCON0(double ALPHA, double DIP) {
        ALP1 = (1.0 - ALPHA) / 2.0;
        ALP2 = ALPHA / 2.0;
        ALP3 = (1.0 - ALPHA) / ALPHA;
        ALP4 = 1.0 - ALPHA;
        ALP5 = ALPHA;
        double P18 = Math.PI / 180;
        SD = Math.sin(DIP * P18);
        CD = Math.cos(DIP * P18);
        if (Math.abs(CD) < 1.0E-6) {
            CD = 0.0;
            if (SD > 0.0) {
                SD = 1.0;
            }
            if (SD < 0.0) {
                SD = -1.0;
            }
        }
        SDSD = SD * SD;
        CDCD = CD * CD;
        SDCD = SD * CD;
        S2D = 2.0 * SDCD;
        C2D = CDCD - SDSD;
    }

    public static void DCCON1(double X, double Y, double D) {
        if (Math.abs(X) < 1.0E-6) {
            X = 0.0;
        }
        if (Math.abs(Y) < 1.0E-6) {
            Y = 0.0;
        }
        if (Math.abs(D) < 1.0E-6) {
            D = 0.0;
        }
        P = Y * CD + D * SD;
        Q = Y * SD - D * CD;
        S = P * SD + Q * CD;
        T = P * CD - Q * SD;
        XY = X * Y;
        X2 = X * X;
        Y2 = Y * Y;
        D2 = D * D;
        R2 = X2 + Y2 + D2;
        R = Math.sqrt(R2);
        if (R == 0.0) {
            return;
        }
        R3 = R * R2;
        R5 = R3 * R2;
        double R7 = R5 * R2;
        A3 = 1.0 - 3.0 * X2 / R2;
        A5 = 1.0 - 5.0 * X2 / R2;
        B3 = 1.0 - 3.0 * Y2 / R2;
        C3 = 1.0 - 3.0 * D2 / R2;
        QR = 3.0 * Q / R5;
        QRX = 5.0 * QR * X / R2;
        UY = SD - 5.0 * Y * Q / R2;
        UZ = CD + 5.0 * D * Q / R2;
        VY = S - 5.0 * Y * P * Q / R2;
        VZ = T + 5.0 * D * P * Q / R2;
        WY = UY + SD;
        WZ = UZ + CD;
    }

    public static double u3HP(double x, double y, double z, double G, double nu) {
        double rhox2 = x * x + z * z;
        double rhoy2 = y * y + z * z;
        double r2 = rhox2 + y * y;
        if (rhox2 < rmin2) {
            rhox2 = rmin2;
        }
        if (rhoy2 < rmin2) {
            rhoy2 = rmin2;
        }
        if (r2 < rmin2) {
            r2 = rmin2;
        }
        double u3HP = -1.0 / (2.0 * G) * x * y * (rhox2 + rhoy2) / (rhox2 * rhoy2 * Math.sqrt(r2));
        return u3HP;
    }

    public static double u3Hv(double dx1, double dx2, double dy1, double dy2, double zminc, double G, double nu) {
        double u3Hv = OkadaDC3DPoint.u3HP(dx1, dy1, zminc, G, nu) - OkadaDC3DPoint.u3HP(dx2, dy1, zminc, G, nu) - OkadaDC3DPoint.u3HP(dx1, dy2, zminc, G, nu) + OkadaDC3DPoint.u3HP(dx2, dy2, zminc, G, nu);
        return u3Hv;
    }

    public static double u3BP(double x, double y, double z, double G, double nu) {
        double rhox2 = x * x + z * z;
        double rhoy2 = y * y + z * z;
        double r2 = rhox2 + y * y;
        double zl = z;
        if (rhox2 < rmin2) {
            rhox2 = rmin2;
        }
        if (rhoy2 < rmin2) {
            rhoy2 = rmin2;
        }
        if (r2 < rmin2) {
            r2 = rmin2;
        }
        if (zl < 0.0 && zl > -rmin) {
            zl = -rmin;
        }
        if (zl > 0.0 && zl < rmin) {
            zl = rmin;
        }
        double u3BP = 1.0 / (2.0 * G) * (-x * y * z * (rhox2 + rhoy2) / (rhox2 * rhoy2 * Math.sqrt(r2)) + 2.0 * (-1.0 + 2.0 * nu) * Math.atan(x * y / (zl * Math.sqrt(r2))));
        return u3BP;
    }

    public static double u3Bv(double dx1, double dx2, double dy1, double dy2, double zminc, double G, double nu) {
        double u3Bv = OkadaDC3DPoint.u3BP(dx1, dy1, zminc, G, nu) - OkadaDC3DPoint.u3BP(dx2, dy1, zminc, G, nu) - OkadaDC3DPoint.u3BP(dx1, dy2, zminc, G, nu) + OkadaDC3DPoint.u3BP(dx2, dy2, zminc, G, nu);
        return u3Bv;
    }

    public static double u3EP(double x, double y, double z, double G) {
        double r2 = x * x + y * y + z * z;
        double zl = z;
        if (r2 < rmin2) {
            r2 = rmin2;
        }
        if (zl < 0.0 && zl > -rmin) {
            zl = -rmin;
        }
        if (zl > 0.0 && zl < rmin) {
            zl = rmin;
        }
        double u3EP = 1.0 / (2.0 * G) * Math.atan(x * y / (zl * Math.sqrt(r2)));
        return u3EP;
    }

    public static double u3Ev(double dx1, double dx2, double dy1, double dy2, double zminc, double G, double nu) {
        double u3Ev = OkadaDC3DPoint.u3EP(dx1, dy1, zminc, G) - OkadaDC3DPoint.u3EP(dx2, dy1, zminc, G) - OkadaDC3DPoint.u3EP(dx1, dy2, zminc, G) + OkadaDC3DPoint.u3EP(dx2, dy2, zminc, G);
        return u3Ev;
    }

    public static void testPOINT() {
        double[] U = new double[13];
        double length = 2000.0;
        double depth = 2000.0;
        double shiftdx = 0.0;
        double shiftdy = 0.0;
        double POT1 = 0.0;
        double POT2 = 0.0;
        double POT3 = 0.0;
        double POT4 = 8000000.0;
        double E = 1.0E10;
        double v = 0.35;
        double LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        double MYU = E / (2.0 * (1.0 + v));
        double ALPHA = (LAMBDA + MYU) / (LAMBDA + 2.0 * MYU);
        POT4 *= 2.0 + LAMBDA / MYU;
        double DIP = 0.0;
        System.out.println("X, Y, Z, UX, UY, UZ");
        int NSTEP = 100;
        int i = 0;
        while (i < NSTEP) {
            double z = -i * 4000 / NSTEP;
            Vector3d x = new Vector3d(shiftdx, shiftdy, z);
            int ires = OkadaDC3DPoint.DC3D0(ALPHA, x.x, x.y, x.z, depth, 0.0, POT1, POT2, POT3, POT4, U);
            System.out.println(String.valueOf(x.x) + " " + x.y + " " + x.z + " " + U[1] + " " + U[2] + " " + U[3]);
            ++i;
        }
    }

    public static void testAEsubs() {
        double[] U = new double[13];
        double length = 2000.0;
        double depth = 2000.0;
        double shiftdx = 0.0;
        double shiftdy = 0.0;
        double dx1 = -length * 0.5;
        double dx2 = length * 0.5;
        double dy1 = -length * 0.5;
        double dy2 = length * 0.5;
        double POT1 = 0.0;
        double POT2 = 0.0;
        double POT3 = 0.0;
        double POT4 = 4000000.0;
        double E = 1.0E10;
        double v = 0.35;
        double LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        double MYU = E / (2.0 * (1.0 + v));
        double ALPHA = (LAMBDA + MYU) / (LAMBDA + 2.0 * MYU);
        POT4 = 1.0;
        POT4 *= MYU / (Math.PI * 2);
        double DIP = 0.0;
        System.out.println("X, Y, Z, UX, UY, UZ");
        int NSTEP = 100;
        int i = 0;
        while (i < NSTEP) {
            double z = -i * 4000 / NSTEP;
            Vector3d x = new Vector3d(shiftdx, shiftdy, z);
            double zminc = -(x.z + depth);
            double mirrorz = -(x.z - depth);
            double aplus = POT4 * OkadaDC3DPoint.u3Ev(dx1, dx2, dy1, dy2, zminc, MYU, v);
            double amin = POT4 * OkadaDC3DPoint.u3Ev(dx1, dx2, dy1, dy2, mirrorz, MYU, v);
            double bplus = POT4 * OkadaDC3DPoint.u3Bv(dx1, dx2, dy1, dy2, zminc, MYU, v);
            double bmin = POT4 * OkadaDC3DPoint.u3Bv(dx1, dx2, dy1, dy2, mirrorz, MYU, v);
            double cplus = POT4 * OkadaDC3DPoint.u3Hv(dx1, dx2, dy1, dy2, zminc, MYU, v);
            double cmin = POT4 * OkadaDC3DPoint.u3Hv(dx1, dx2, dy1, dy2, mirrorz, MYU, v);
            U[1] = aplus;
            U[2] = amin;
            U[3] = bplus;
            U[4] = bmin;
            U[5] = cplus;
            U[6] = cmin;
            U[7] = aplus + amin + bmin + cmin;
            System.out.println(String.valueOf(x.x) + " " + x.y + " " + x.z + " " + U[1] + " " + U[2] + " " + U[3] + " " + U[4] + " " + U[5] + " " + U[6] + " " + U[7]);
            ++i;
        }
    }

    public static void main(String[] args) {
        OkadaDC3DPoint.testPOINT();
        OkadaDC3DPoint.testAEsubs();
    }
}

