/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DC3D;
import okada.DCCON2;
import wrapper.RectangularSource;

public class OkadaDC3DRect {
    public static int I_UX = 0;
    public static int I_UY = 1;
    public static double[] DUMMMY = new double[6];
    public static double SD;
    public static double CD;
    public static double SDSD;
    public static double CDCD;
    public static double SDCD;
    public static double S2D;
    public static double C2D;
    public static final double F0 = 0.0;
    public static final double F1 = 1.0;
    public static final double F2 = 2.0;
    public static final double F3 = 3.0;
    public static final double F5 = 5.0;
    public static final double PI2 = Math.PI * 2;
    public static final double EPS = 1.0E-6;
    public static double ALP1;
    public static double ALP2;
    public static double ALP3;
    public static double ALP4;
    public static double ALP5;
    public static double XI2;
    public static double ET2;
    public static double Q2;
    public static double R;
    public static double R2;
    public static double R3;
    public static double R5;
    public static double Y;
    public static double D;
    public static double TT;
    public static double ALX;
    public static double ALE;
    public static double X11;
    public static double Y11;
    public static double X32;
    public static double Y32;
    public static double EY;
    public static double EZ;
    public static double FY;
    public static double FZ;
    public static double GY;
    public static double GZ;
    public static double HY;
    public static double HZ;
    public static double[] DU;
    static double AL1;
    static double AL2;
    static double AW1;
    static double AW2;
    static double E;
    static double v;
    static double LAMBDA;
    static double MYU;
    static double ALPHA;
    static double DIP;
    static double[] U;
    public static Vector3d u;
    public static Vector3d eii;
    public static Vector3d eij;
    public static Vector3d sii;
    public static Vector3d sij;
    public static Vector3d initraction;

    static {
        ALP1 = 0.0;
        ALP2 = 0.0;
        ALP3 = 0.0;
        ALP4 = 0.0;
        ALP5 = 0.0;
        DU = new double[13];
        U = new double[13];
        u = new Vector3d();
        eii = new Vector3d();
        eij = new Vector3d();
        sii = new Vector3d();
        sij = new Vector3d();
        initraction = null;
    }

    public static int DC3D(double ALPHA, double X, double Y, double Z, double DEPTH, double DIP, double AL1, double AL2, double AW1, double AW2, double DISL1, double DISL2, double DISL3, double[] URES) {
        int I;
        int J;
        double[] XI = new double[3];
        double[] ET = new double[3];
        int[] KXI = new int[3];
        int[] KET = new int[3];
        double[] U = new double[13];
        double[] DU = new double[13];
        double[] DUA = new double[13];
        double[] DUB = new double[13];
        double[] DUC = new double[13];
        if (Z > 0.0) {
            System.out.println("error: positive Z given as input");
        }
        int i = 1;
        while (i <= 12) {
            U[i] = 0.0;
            DUA[i] = 0.0;
            DUB[i] = 0.0;
            DUC[i] = 0.0;
            URES[i] = 0.0;
            ++i;
        }
        double AALPHA = ALPHA;
        double DDIP = DIP;
        OkadaDC3DRect.DCCON0(AALPHA, DDIP);
        double ZZ = Z;
        double DD1 = DISL1;
        double DD2 = DISL2;
        double DD3 = DISL3;
        XI[1] = X - AL1;
        XI[2] = X - AL2;
        if (Math.abs(XI[1]) < 1.0E-6) {
            XI[1] = 0.0;
        }
        if (Math.abs(XI[2]) < 1.0E-6) {
            XI[2] = 0.0;
        }
        double D = DEPTH + Z;
        double P = Y * CD + D * SD;
        double Q = Y * SD - D * CD;
        ET[1] = P - AW1;
        ET[2] = P - AW2;
        if (Math.abs(Q) < 1.0E-6) {
            Q = 0.0;
        }
        if (Math.abs(ET[1]) < 1.0E-6) {
            ET[1] = 0.0;
        }
        if (Math.abs(ET[2]) < 1.0E-6) {
            ET[2] = 0.0;
        }
        if (Q == 0.0 && (XI[1] * XI[2] <= 0.0 && ET[1] * ET[2] == 0.0 || ET[1] * ET[2] <= 0.0 && XI[1] * XI[2] == 0.0)) {
            System.out.println("should goto 99");
            return 1;
        }
        KXI[1] = 0;
        KXI[2] = 0;
        KET[1] = 0;
        KET[2] = 0;
        double R12 = Math.sqrt(XI[1] * XI[1] + ET[2] * ET[2] + Q * Q);
        double R21 = Math.sqrt(XI[2] * XI[2] + ET[1] * ET[1] + Q * Q);
        double R22 = Math.sqrt(XI[2] * XI[2] + ET[2] * ET[2] + Q * Q);
        if (XI[1] < 0.0 && R21 + XI[2] < 1.0E-6) {
            KXI[1] = 1;
        }
        if (XI[1] < 0.0 && R22 + XI[2] < 1.0E-6) {
            KXI[2] = 1;
        }
        if (ET[1] < 0.0 && R12 + ET[2] < 1.0E-6) {
            KET[1] = 1;
        }
        if (ET[1] < 0.0 && R22 + ET[2] < 1.0E-6) {
            KET[2] = 1;
        }
        int K = 1;
        while (K <= 2) {
            J = 1;
            while (J <= 2) {
                OkadaDC3DRect.DCCON2(XI[J], ET[K], Q, SD, CD, KXI[K], KET[J]);
                OkadaDC3DRect.UA(XI[J], ET[K], Q, DD1, DD2, DD3, DUA);
                I = 1;
                while (I <= 10) {
                    DU[I] = -DUA[I];
                    DU[I + 1] = -DUA[I + 1] * CD + DUA[I + 2] * SD;
                    DU[I + 2] = -DUA[I + 1] * SD - DUA[I + 2] * CD;
                    if (I >= 10) {
                        DU[I] = -DU[I];
                        DU[I + 1] = -DU[I + 1];
                        DU[I + 2] = -DU[I + 2];
                    }
                    I += 3;
                }
                I = 1;
                while (I <= 12) {
                    if (J + K != 3) {
                        U[I] = U[I] + DU[I];
                    }
                    if (J + K == 3) {
                        U[I] = U[I] - DU[I];
                    }
                    ++I;
                }
                ++J;
            }
            ++K;
        }
        D = DEPTH - Z;
        P = Y * CD + D * SD;
        Q = Y * SD - D * CD;
        ET[1] = P - AW1;
        ET[2] = P - AW2;
        if (Math.abs(Q) < 1.0E-6) {
            Q = 0.0;
        }
        if (Math.abs(ET[1]) < 1.0E-6) {
            ET[1] = 0.0;
        }
        if (Math.abs(ET[2]) < 1.0E-6) {
            ET[2] = 0.0;
        }
        if (Q == 0.0 && (XI[1] * XI[2] <= 0.0 && ET[1] * ET[2] == 0.0 || ET[1] * ET[2] <= 0.0 && XI[1] * XI[2] == 0.0)) {
            System.out.println("should goto 99");
        }
        KXI[1] = 0;
        KXI[2] = 0;
        KET[1] = 0;
        KET[2] = 0;
        R12 = Math.sqrt(XI[1] * XI[1] + ET[2] * ET[2] + Q * Q);
        R21 = Math.sqrt(XI[2] * XI[2] + ET[1] * ET[1] + Q * Q);
        R22 = Math.sqrt(XI[2] * XI[2] + ET[2] * ET[2] + Q * Q);
        if (XI[1] < 0.0 && R21 + XI[2] < 1.0E-6) {
            KXI[1] = 1;
        }
        if (XI[1] < 0.0 && R22 + XI[2] < 1.0E-6) {
            KXI[2] = 1;
        }
        if (ET[1] < 0.0 && R12 + ET[2] < 1.0E-6) {
            KET[1] = 1;
        }
        if (ET[1] < 0.0 && R22 + ET[2] < 1.0E-6) {
            KET[2] = 1;
        }
        K = 1;
        while (K <= 2) {
            J = 1;
            while (J <= 2) {
                OkadaDC3DRect.DCCON2(XI[J], ET[K], Q, SD, CD, KXI[K], KET[J]);
                OkadaDC3DRect.UA(XI[J], ET[K], Q, DD1, DD2, DD3, DUA);
                OkadaDC3DRect.UB(XI[J], ET[K], Q, DD1, DD2, DD3, DUB);
                OkadaDC3DRect.UC(XI[J], ET[K], Q, ZZ, DD1, DD2, DD3, DUC);
                I = 1;
                while (I <= 10) {
                    DU[I] = DUA[I] + DUB[I] + Z * DUC[I];
                    DU[I + 1] = (DUA[I + 1] + DUB[I + 1] + Z * DUC[I + 1]) * CD - (DUA[I + 2] + DUB[I + 2] + Z * DUC[I + 2]) * SD;
                    DU[I + 2] = (DUA[I + 1] + DUB[I + 1] - Z * DUC[I + 1]) * SD + (DUA[I + 2] + DUB[I + 2] - Z * DUC[I + 2]) * CD;
                    if (I >= 10) {
                        DU[10] = DU[10] + DUC[1];
                        DU[11] = DU[11] + DUC[2] * CD - DUC[3] * SD;
                        DU[12] = DU[12] - DUC[2] * SD - DUC[3] * CD;
                    }
                    I += 3;
                }
                I = 1;
                while (I <= 12) {
                    if (J + K != 3) {
                        U[I] = U[I] + DU[I];
                    }
                    if (J + K == 3) {
                        U[I] = U[I] - DU[I];
                    }
                    ++I;
                }
                ++J;
            }
            ++K;
        }
        int I2 = 1;
        while (I2 <= 12) {
            URES[I2] = U[I2];
            ++I2;
        }
        return 0;
    }

    public static void UA(double XI, double ET, double Q, double DISL1, double DISL2, double DISL3, double[] U) {
        int I;
        int I2 = 1;
        while (I2 <= 12) {
            U[I2] = 0.0;
            OkadaDC3DRect.DU[I2] = 0.0;
            ++I2;
        }
        double XY = XI * Y11;
        double QX = Q * X11;
        double QY = Q * Y11;
        if (DISL1 != 0.0) {
            OkadaDC3DRect.DU[1] = TT / 2.0 + ALP2 * XI * QY;
            OkadaDC3DRect.DU[2] = ALP2 * Q / R;
            OkadaDC3DRect.DU[3] = ALP1 * ALE - ALP2 * Q * QY;
            OkadaDC3DRect.DU[4] = -ALP1 * QY - ALP2 * XI2 * Q * Y32;
            OkadaDC3DRect.DU[5] = -ALP2 * XI * Q / R3;
            OkadaDC3DRect.DU[6] = ALP1 * XY + ALP2 * XI * Q2 * Y32;
            OkadaDC3DRect.DU[7] = ALP1 * XY * SD + ALP2 * XI * FY + D / 2.0 * X11;
            OkadaDC3DRect.DU[8] = ALP2 * EY;
            OkadaDC3DRect.DU[9] = ALP1 * (CD / R + QY * SD) - ALP2 * Q * FY;
            OkadaDC3DRect.DU[10] = ALP1 * XY * CD + ALP2 * XI * FZ + Y / 2.0 * X11;
            OkadaDC3DRect.DU[11] = ALP2 * EZ;
            OkadaDC3DRect.DU[12] = -ALP1 * (SD / R - QY * CD) - ALP2 * Q * FZ;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL2 != 0.0) {
            OkadaDC3DRect.DU[1] = ALP2 * Q / R;
            OkadaDC3DRect.DU[2] = TT / 2.0 + ALP2 * ET * QX;
            OkadaDC3DRect.DU[3] = ALP1 * ALX - ALP2 * Q * QX;
            OkadaDC3DRect.DU[4] = -ALP2 * XI * Q / R3;
            OkadaDC3DRect.DU[5] = -QY / 2.0 - ALP2 * ET * Q / R3;
            OkadaDC3DRect.DU[6] = ALP1 / R + ALP2 * Q2 / R3;
            OkadaDC3DRect.DU[7] = ALP2 * EY;
            OkadaDC3DRect.DU[8] = ALP1 * D * X11 + XY / 2.0 * SD + ALP2 * ET * GY;
            OkadaDC3DRect.DU[9] = ALP1 * Y * X11 - ALP2 * Q * GY;
            OkadaDC3DRect.DU[10] = ALP2 * EZ;
            OkadaDC3DRect.DU[11] = ALP1 * Y * X11 + XY / 2.0 * CD + ALP2 * ET * GZ;
            OkadaDC3DRect.DU[12] = -ALP1 * D * X11 - ALP2 * Q * GZ;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL3 != 0.0) {
            OkadaDC3DRect.DU[1] = -ALP1 * ALE - ALP2 * Q * QY;
            OkadaDC3DRect.DU[2] = -ALP1 * ALX - ALP2 * Q * QX;
            OkadaDC3DRect.DU[3] = TT / 2.0 - ALP2 * (ET * QX + XI * QY);
            OkadaDC3DRect.DU[4] = -ALP1 * XY + ALP2 * XI * Q2 * Y32;
            OkadaDC3DRect.DU[5] = -ALP1 / R + ALP2 * Q2 / R3;
            OkadaDC3DRect.DU[6] = -ALP1 * QY - ALP2 * Q * Q2 * Y32;
            OkadaDC3DRect.DU[7] = -ALP1 * (CD / R + QY * SD) - ALP2 * Q * FY;
            OkadaDC3DRect.DU[8] = -ALP1 * Y * X11 - ALP2 * Q * GY;
            OkadaDC3DRect.DU[9] = ALP1 * (D * X11 + XY * SD) + ALP2 * Q * HY;
            OkadaDC3DRect.DU[10] = ALP1 * (SD / R - QY * CD) - ALP2 * Q * FZ;
            OkadaDC3DRect.DU[11] = ALP1 * D * X11 - ALP2 * Q * GZ;
            OkadaDC3DRect.DU[12] = ALP1 * (Y * X11 + XY * CD) + ALP2 * Q * HZ;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void UB(double XI, double ET, double Q, double DISL1, double DISL2, double DISL3, double[] U) {
        double AJ6;
        double AJ3;
        double AK3;
        double AK1;
        double AI3;
        double AI4;
        double RD = R + D;
        double D11 = 1.0 / (R * RD);
        double AJ2 = XI * Y / RD * D11;
        double AJ5 = -(D + Y * Y / RD) * D11;
        if (CD != 0.0) {
            if (XI == 0.0) {
                AI4 = 0.0;
            } else {
                double X = Math.sqrt(XI2 + Q2);
                AI4 = 1.0 / CDCD * (XI / RD * SDCD + 2.0 * Math.atan((ET * (X + Q * CD) + X * (R + X) * SD) / (XI * (R + X) * CD)));
            }
            AI3 = (Y * CD / RD - ALE + SD * Math.log(RD)) / CDCD;
            AK1 = XI * (D11 - Y11 * SD) / CD;
            AK3 = (Q * Y11 - Y * D11) / CD;
            AJ3 = (AK1 - AJ2 * SD) / CD;
            AJ6 = (AK3 - AJ5 * SD) / CD;
        } else {
            double RD2 = RD * RD;
            AI3 = (ET / RD + Y * Q / RD2 - ALE) / 2.0;
            AI4 = XI * Y / RD2 / 2.0;
            AK1 = XI * Q / RD * D11;
            AK3 = SD / RD * (XI2 * D11 - 1.0);
            AJ3 = -XI / RD2 * (Q2 * D11 - 0.5);
            AJ6 = -Y / RD2 * (XI2 * D11 - 0.5);
        }
        double XY = XI * Y11;
        double AI1 = -XI / RD * CD - AI4 * SD;
        double AI2 = Math.log(RD) + AI3 * SD;
        double AK2 = 1.0 / R + AK3 * SD;
        double AK4 = XY * CD - AK1 * SD;
        double AJ1 = AJ5 * CD - AJ6 * SD;
        double AJ4 = -XY - AJ2 * CD + AJ3 * SD;
        int I = 1;
        while (I <= 12) {
            U[I] = 0.0;
            OkadaDC3DRect.DU[I] = 0.0;
            ++I;
        }
        double QX = Q * X11;
        double QY = Q * Y11;
        if (DISL1 != 0.0) {
            OkadaDC3DRect.DU[1] = -XI * QY - TT - ALP3 * AI1 * SD;
            OkadaDC3DRect.DU[2] = -Q / R + ALP3 * Y / RD * SD;
            OkadaDC3DRect.DU[3] = Q * QY - ALP3 * AI2 * SD;
            OkadaDC3DRect.DU[4] = XI2 * Q * Y32 - ALP3 * AJ1 * SD;
            OkadaDC3DRect.DU[5] = XI * Q / R3 - ALP3 * AJ2 * SD;
            OkadaDC3DRect.DU[6] = -XI * Q2 * Y32 - ALP3 * AJ3 * SD;
            OkadaDC3DRect.DU[7] = -XI * FY - D * X11 + ALP3 * (XY + AJ4) * SD;
            OkadaDC3DRect.DU[8] = -EY + ALP3 * (1.0 / R + AJ5) * SD;
            OkadaDC3DRect.DU[9] = Q * FY - ALP3 * (QY - AJ6) * SD;
            OkadaDC3DRect.DU[10] = -XI * FZ - Y * X11 + ALP3 * AK1 * SD;
            OkadaDC3DRect.DU[11] = -EZ + ALP3 * Y * D11 * SD;
            OkadaDC3DRect.DU[12] = Q * FZ + ALP3 * AK2 * SD;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL2 != 0.0) {
            OkadaDC3DRect.DU[1] = -Q / R + ALP3 * AI3 * SDCD;
            OkadaDC3DRect.DU[2] = -ET * QX - TT - ALP3 * XI / RD * SDCD;
            OkadaDC3DRect.DU[3] = Q * QX + ALP3 * AI4 * SDCD;
            OkadaDC3DRect.DU[4] = XI * Q / R3 + ALP3 * AJ4 * SDCD;
            OkadaDC3DRect.DU[5] = ET * Q / R3 + QY + ALP3 * AJ5 * SDCD;
            OkadaDC3DRect.DU[6] = -Q2 / R3 + ALP3 * AJ6 * SDCD;
            OkadaDC3DRect.DU[7] = -EY + ALP3 * AJ1 * SDCD;
            OkadaDC3DRect.DU[8] = -ET * GY - XY * SD + ALP3 * AJ2 * SDCD;
            OkadaDC3DRect.DU[9] = Q * GY + ALP3 * AJ3 * SDCD;
            OkadaDC3DRect.DU[10] = -EZ - ALP3 * AK3 * SDCD;
            OkadaDC3DRect.DU[11] = -ET * GZ - XY * CD - ALP3 * XI * D11 * SDCD;
            OkadaDC3DRect.DU[12] = Q * GZ - ALP3 * AK4 * SDCD;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL3 != 0.0) {
            OkadaDC3DRect.DU[1] = Q * QY - ALP3 * AI3 * SDSD;
            OkadaDC3DRect.DU[2] = Q * QX + ALP3 * XI / RD * SDSD;
            OkadaDC3DRect.DU[3] = ET * QX + XI * QY - TT - ALP3 * AI4 * SDSD;
            OkadaDC3DRect.DU[4] = -XI * Q2 * Y32 - ALP3 * AJ4 * SDSD;
            OkadaDC3DRect.DU[5] = -Q2 / R3 - ALP3 * AJ5 * SDSD;
            OkadaDC3DRect.DU[6] = Q * Q2 * Y32 - ALP3 * AJ6 * SDSD;
            OkadaDC3DRect.DU[7] = Q * FY - ALP3 * AJ1 * SDSD;
            OkadaDC3DRect.DU[8] = Q * GY - ALP3 * AJ2 * SDSD;
            OkadaDC3DRect.DU[9] = -Q * HY - ALP3 * AJ3 * SDSD;
            OkadaDC3DRect.DU[10] = Q * FZ + ALP3 * AK3 * SDSD;
            OkadaDC3DRect.DU[11] = Q * GZ + ALP3 * XI * D11 * SDSD;
            OkadaDC3DRect.DU[12] = -Q * HZ + ALP3 * AK4 * SDSD;
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void UC(double XI, double ET, double Q, double Z, double DISL1, double DISL2, double DISL3, double[] U) {
        double C = D + Z;
        double X53 = (8.0 * R2 + 9.0 * R * XI + 3.0 * XI2) * X11 * X11 * X11 / R2;
        double Y53 = (8.0 * R2 + 9.0 * R * ET + 3.0 * ET2) * Y11 * Y11 * Y11 / R2;
        double H = Q * CD - Z;
        double Z32 = SD / R3 - H * Y32;
        double Z53 = 3.0 * SD / R5 - H * Y53;
        double Y0 = Y11 - XI2 * Y32;
        double Z0 = Z32 - XI2 * Z53;
        double PPY = CD / R3 + Q * Y32 * SD;
        double PPZ = SD / R3 - Q * Y32 * CD;
        double QQ = Z * Y32 + Z32 + Z0;
        double QQY = 3.0 * C * D / R5 - QQ * SD;
        double QQZ = 3.0 * C * Y / R5 - QQ * CD + Q * Y32;
        double XY = XI * Y11;
        double QX = Q * X11;
        double QY = Q * Y11;
        double QR = 3.0 * Q / R5;
        double CQX = C * Q * X53;
        double CDR = (C + D) / R3;
        double YY0 = Y / R3 - Y0 * CD;
        int I = 1;
        while (I <= 12) {
            U[I] = 0.0;
            OkadaDC3DRect.DU[I] = 0.0;
            ++I;
        }
        if (DISL1 != 0.0) {
            OkadaDC3DRect.DU[1] = ALP4 * XY * CD - ALP5 * XI * Q * Z32;
            OkadaDC3DRect.DU[2] = ALP4 * (CD / R + 2.0 * QY * SD) - ALP5 * C * Q / R3;
            OkadaDC3DRect.DU[3] = ALP4 * QY * CD - ALP5 * (C * ET / R3 - Z * Y11 + XI2 * Z32);
            OkadaDC3DRect.DU[4] = ALP4 * Y0 * CD - ALP5 * Q * Z0;
            OkadaDC3DRect.DU[5] = -ALP4 * XI * (CD / R3 + 2.0 * Q * Y32 * SD) + ALP5 * C * XI * QR;
            OkadaDC3DRect.DU[6] = -ALP4 * XI * Q * Y32 * CD + ALP5 * XI * (3.0 * C * ET / R5 - QQ);
            OkadaDC3DRect.DU[7] = -ALP4 * XI * PPY * CD - ALP5 * XI * QQY;
            OkadaDC3DRect.DU[8] = ALP4 * 2.0 * (D / R3 - Y0 * SD) * SD - Y / R3 * CD - ALP5 * (CDR * SD - ET / R3 - C * Y * QR);
            OkadaDC3DRect.DU[9] = -ALP4 * Q / R3 + YY0 * SD + ALP5 * (CDR * CD + C * D * QR - (Y0 * CD + Q * Z0) * SD);
            OkadaDC3DRect.DU[10] = ALP4 * XI * PPZ * CD - ALP5 * XI * QQZ;
            OkadaDC3DRect.DU[11] = ALP4 * 2.0 * (Y / R3 - Y0 * CD) * SD + D / R3 * CD - ALP5 * (CDR * CD + C * D * QR);
            OkadaDC3DRect.DU[12] = YY0 * CD - ALP5 * (CDR * SD - C * Y * QR - Y0 * SDSD + Q * Z0 * CD);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL1 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL2 != 0.0) {
            OkadaDC3DRect.DU[1] = ALP4 * CD / R - QY * SD - ALP5 * C * Q / R3;
            OkadaDC3DRect.DU[2] = ALP4 * Y * X11 - ALP5 * C * ET * Q * X32;
            OkadaDC3DRect.DU[3] = -D * X11 - XY * SD - ALP5 * C * (X11 - Q2 * X32);
            OkadaDC3DRect.DU[4] = -ALP4 * XI / R3 * CD + ALP5 * C * XI * QR + XI * Q * Y32 * SD;
            OkadaDC3DRect.DU[5] = -ALP4 * Y / R3 + ALP5 * C * ET * QR;
            OkadaDC3DRect.DU[6] = D / R3 - Y0 * SD + ALP5 * C / R3 * (1.0 - 3.0 * Q2 / R2);
            OkadaDC3DRect.DU[7] = -ALP4 * ET / R3 + Y0 * SDSD - ALP5 * (CDR * SD - C * Y * QR);
            OkadaDC3DRect.DU[8] = ALP4 * (X11 - Y * Y * X32) - ALP5 * C * ((D + 2.0 * Q * CD) * X32 - Y * ET * Q * X53);
            OkadaDC3DRect.DU[9] = XI * PPY * SD + Y * D * X32 + ALP5 * C * ((Y + 2.0 * Q * SD) * X32 - Y * Q2 * X53);
            OkadaDC3DRect.DU[10] = -Q / R3 + Y0 * SDCD - ALP5 * (CDR * CD + C * D * QR);
            OkadaDC3DRect.DU[11] = ALP4 * Y * D * X32 - ALP5 * C * ((Y - 2.0 * Q * SD) * X32 + D * ET * Q * X53);
            OkadaDC3DRect.DU[12] = -XI * PPZ * SD + X11 - D * D * X32 - ALP5 * C * ((D - 2.0 * Q * CD) * X32 - D * Q2 * X53);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL2 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
        if (DISL3 != 0.0) {
            OkadaDC3DRect.DU[1] = -ALP4 * (SD / R + QY * CD) - ALP5 * (Z * Y11 - Q2 * Z32);
            OkadaDC3DRect.DU[2] = ALP4 * 2.0 * XY * SD + D * X11 - ALP5 * C * (X11 - Q2 * X32);
            OkadaDC3DRect.DU[3] = ALP4 * (Y * X11 + XY * CD) + ALP5 * Q * (C * ET * X32 + XI * Z32);
            OkadaDC3DRect.DU[4] = ALP4 * XI / R3 * SD + XI * Q * Y32 * CD + ALP5 * XI * (3.0 * C * ET / R5 - 2.0 * Z32 - Z0);
            OkadaDC3DRect.DU[5] = ALP4 * 2.0 * Y0 * SD - D / R3 + ALP5 * C / R3 * (1.0 - 3.0 * Q2 / R2);
            OkadaDC3DRect.DU[6] = -ALP4 * YY0 - ALP5 * (C * ET * QR - Q * Z0);
            OkadaDC3DRect.DU[7] = ALP4 * (Q / R3 + Y0 * SDCD) + ALP5 * (Z / R3 * CD + C * D * QR - Q * Z0 * SD);
            OkadaDC3DRect.DU[8] = -ALP4 * 2.0 * XI * PPY * SD - Y * D * X32 + ALP5 * C * ((Y + 2.0 * Q * SD) * X32 - Y * Q2 * X53);
            OkadaDC3DRect.DU[9] = -ALP4 * (XI * PPY * CD - X11 + Y * Y * X32) + ALP5 * (C * ((D + 2.0 * Q * CD) * X32 - Y * ET * Q * X53) + XI * QQY);
            OkadaDC3DRect.DU[10] = -ET / R3 + Y0 * CDCD - ALP5 * (Z / R3 * SD - C * Y * QR - Y0 * SDSD + Q * Z0 * CD);
            OkadaDC3DRect.DU[11] = ALP4 * 2.0 * XI * PPZ * SD - X11 + D * D * X32 - ALP5 * C * ((D - 2.0 * Q * CD) * X32 - D * Q2 * X53);
            OkadaDC3DRect.DU[12] = ALP4 * (XI * PPZ * CD + Y * D * X32) + ALP5 * (C * ((Y - 2.0 * Q * SD) * X32 + D * ET * Q * X53) + XI * QQZ);
            I = 1;
            while (I <= 12) {
                U[I] = U[I] + DISL3 / (Math.PI * 2) * DU[I];
                ++I;
            }
        }
    }

    public static void DCCON0(double ALPHA, double DIP) {
        ALP1 = (1.0 - ALPHA) / 2.0;
        ALP2 = ALPHA / 2.0;
        ALP3 = (1.0 - ALPHA) / ALPHA;
        ALP4 = 1.0 - ALPHA;
        ALP5 = ALPHA;
        double P18 = Math.PI / 180;
        SD = Math.sin(DIP * P18);
        CD = Math.cos(DIP * P18);
        if (Math.abs(CD) < 1.0E-6) {
            CD = 0.0;
            if (SD > 0.0) {
                SD = 1.0;
            }
            if (SD < 0.0) {
                SD = -1.0;
            }
        }
        SDSD = SD * SD;
        CDCD = CD * CD;
        SDCD = SD * CD;
        S2D = 2.0 * SDCD;
        C2D = CDCD - SDSD;
    }

    public static void DCCON2(double XI, double ET, double Q, double SD, double CD, int KXI, int KET) {
        if (Math.abs(XI) < 1.0E-6) {
            XI = 0.0;
        }
        if (Math.abs(ET) < 1.0E-6) {
            ET = 0.0;
        }
        if (Math.abs(Q) < 1.0E-6) {
            Q = 0.0;
        }
        if ((R = Math.sqrt(R2 = (XI2 = XI * XI) + (ET2 = ET * ET) + (Q2 = Q * Q))) == 0.0) {
            return;
        }
        R3 = R * R2;
        R5 = R3 * R2;
        Y = ET * CD + Q * SD;
        D = ET * SD - Q * CD;
        TT = Q == 0.0 ? 0.0 : Math.atan(XI * ET / (Q * R));
        if (KXI == 1) {
            ALX = -Math.log(R - XI);
            X11 = 0.0;
            X32 = 0.0;
        } else {
            double RXI = R + XI;
            ALX = Math.log(RXI);
            X11 = 1.0 / (R * RXI);
            X32 = (R + RXI) * X11 * X11 / R;
        }
        if (KET == 1) {
            ALE = -Math.log(R - ET);
            Y11 = 0.0;
            Y32 = 0.0;
        } else {
            double RET = R + ET;
            ALE = Math.log(RET);
            Y11 = 1.0 / (R * RET);
            Y32 = (R + RET) * Y11 * Y11 / R;
        }
        EY = SD / R - Y * Q / R3;
        EZ = CD / R + D * Q / R3;
        FY = D / R3 + XI2 * Y32 * SD;
        FZ = Y / R3 + XI2 * Y32 * CD;
        GY = 2.0 * X11 * SD - Y * Q * X32;
        GZ = 2.0 * X11 * CD + D * Q * X32;
        HY = D * Q * X32 + XI * Q * Y32 * SD;
        HZ = Y * Q * X32 + XI * Q * Y32 * CD;
    }

    public static double uzmid(double L, double W, double depth) {
        double x = 0.5 * L;
        double y = 0.5 * W;
        double d = depth;
        double R = Math.sqrt(x * x + y * y + d * d);
        double[] coorX = new double[]{x, x - L};
        double[] weightsX = new double[]{1.0, -1.0};
        double[] coorE = new double[]{y, y - W};
        double[] weightsE = new double[]{1.0, -1.0};
        double sum = 0.0;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                double q = -d;
                double xsi = coorX[i];
                double eta = coorE[j];
                double X11 = 1.0 / (R * (R + xsi));
                double Y11 = 1.0 / (R * (R + eta));
                double theta = Math.atan(xsi * eta / (q * R));
                double res = q * (eta * X11 + xsi * Y11) - theta;
                sum += weightsX[i] * weightsE[j] * res;
                ++j;
            }
            ++i;
        }
        return sum *= 0.15915494309189535;
    }

    public static void setStressParameters(double Ein, double vin) {
        E = Ein;
        v = vin;
        LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        MYU = E / (2.0 * (1.0 + v));
        ALPHA = (LAMBDA + MYU) / (LAMBDA + 2.0 * MYU);
    }

    public static void calculateLocalAtObservation(Vector3d x, double depth, double dip, Vector3d displ, double length, double width) {
        DIP = dip;
        AL1 = -0.5 * length;
        AL2 = 0.5 * length;
        AW1 = -0.5 * width;
        AW2 = 0.5 * width;
        int ires = OkadaDC3DRect.DC3D(ALPHA, x.x, x.y, x.z, depth, dip, AL1, AL2, AW1, AW2, displ.x, displ.y, displ.z, U);
        double UX = U[1];
        double UY = U[2];
        double UZ = U[3];
        double UXX = U[4];
        double UYX = U[5];
        double UZX = U[6];
        double UXY = U[7];
        double UYY = U[8];
        double UZY = U[9];
        double UXZ = U[10];
        double UYZ = U[11];
        double UZZ = U[12];
        OkadaDC3DRect.u.x = UX;
        OkadaDC3DRect.u.y = UY;
        OkadaDC3DRect.u.z = UZ;
        OkadaDC3DRect.eii.x = UXX;
        OkadaDC3DRect.eii.y = UYY;
        OkadaDC3DRect.eii.z = UZZ;
        OkadaDC3DRect.eij.x = 0.5 * (UYX + UXY);
        OkadaDC3DRect.eij.y = 0.5 * (UXZ + UZX);
        OkadaDC3DRect.eij.z = 0.5 * (UYZ + UZY);
        double ekk = OkadaDC3DRect.eii.x + OkadaDC3DRect.eii.y + OkadaDC3DRect.eii.z;
        OkadaDC3DRect.sii.x = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.x;
        OkadaDC3DRect.sii.y = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.y;
        OkadaDC3DRect.sii.z = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.z;
        sij.scale(2.0 * MYU, eij);
        double frictionangle = 30.0;
        double cosdip = Math.cos(dip * Math.PI / 180.0);
        double sindip = Math.sin(dip * Math.PI / 180.0);
        Vector3d normal = new Vector3d(0.0, -sindip, cosdip);
        double coulombstress = OkadaDC3DRect.getCoulombStress(sii, sij, normal, frictionangle);
        System.out.println("coul stress " + coulombstress + "stress diag " + sii.toString() + " dev  " + sij.toString());
    }

    public static void calculateLocalAtObservationOld(Vector3d x, double depth, double dip, Vector3d displ, double length, double width) {
        RectangularSource.setStressParameters(E, v);
        DCCON2.AZIM = 0.0;
        DCCON2.DIP = dip;
        DC3D.initializeSource(x.x, x.y, x.z, 0.0, dip, length, width);
        DCCON2.prepareSource();
        DCCON2.setObervationLocation(x.x, x.y, x.z);
        Vector3d OP = new Vector3d();
        OP.x = DCCON2.ox;
        OP.y = DCCON2.oy;
        OP.z = x.z;
        double DISL1 = displ.x;
        double DISL2 = displ.y;
        double DISL3 = displ.z;
        DC3D.calculateAtObservation(OP.x, OP.y, OP.z, depth, DCCON2.L1, DCCON2.L2, DCCON2.W1, DCCON2.W2, DISL1, DISL2, DISL3);
        OkadaDC3DRect.u.x = DC3D.UX;
        OkadaDC3DRect.u.y = DC3D.UY;
        OkadaDC3DRect.u.z = DC3D.UZ;
        OkadaDC3DRect.eii.x = DC3D.UXX;
        OkadaDC3DRect.eii.y = DC3D.UYY;
        OkadaDC3DRect.eii.z = DC3D.UZZ;
        OkadaDC3DRect.eij.x = 0.5 * (DC3D.UYX + DC3D.UXY);
        OkadaDC3DRect.eij.y = 0.5 * (DC3D.UXZ + DC3D.UZX);
        OkadaDC3DRect.eij.z = 0.5 * (DC3D.UYZ + DC3D.UZY);
        double ekk = OkadaDC3DRect.eii.x + OkadaDC3DRect.eii.y + OkadaDC3DRect.eii.z;
        OkadaDC3DRect.sii.x = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.x;
        OkadaDC3DRect.sii.y = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.y;
        OkadaDC3DRect.sii.z = LAMBDA * ekk + 2.0 * MYU * OkadaDC3DRect.eii.z;
        sij.scale(2.0 * MYU, eij);
        System.out.println(" stress diag " + sii.toString() + " dev  " + sij.toString());
    }

    public static Matrix3d getStressTensor(Vector3d sii, Vector3d sij) {
        Matrix3d stress = new Matrix3d();
        stress.m00 = sii.x;
        stress.m11 = sii.y;
        stress.m22 = sii.z;
        stress.m01 = stress.m10 = sij.x;
        stress.m02 = stress.m20 = sij.y;
        stress.m12 = stress.m21 = sij.z;
        return stress;
    }

    public static Vector3d getTraction(Matrix3d stress, Vector3d normal) {
        Vector3d v = new Vector3d();
        Vector3d row = new Vector3d();
        int i = 0;
        while (i < 3) {
            row.scale(0.0);
            stress.getRow(i, row);
            double prod = row.dot(normal);
            switch (i) {
                case 0: {
                    v.x = prod;
                }
                case 1: {
                    v.y = prod;
                }
                case 2: {
                    v.z = prod;
                }
            }
            ++i;
        }
        return v;
    }

    public static double getCoulombStress(Vector3d sii, Vector3d sij, Vector3d normal, double friction) {
        double cs = 0.0;
        Matrix3d stress = OkadaDC3DRect.getStressTensor(sii, sij);
        Vector3d traction = OkadaDC3DRect.getTraction(stress, normal);
        if (initraction == null) {
            initraction = new Vector3d(traction);
        }
        double sn = traction.dot(normal);
        Vector3d snvec = new Vector3d();
        snvec.scale(sn, normal);
        Vector3d ssvec = new Vector3d();
        ssvec.sub(traction, snvec);
        double sign = 1.0;
        if (initraction.dot(traction) < 0.0) {
            sign = -1.0;
        }
        double ss = ssvec.length() * sign;
        cs = ss - sn * Math.tan(friction * Math.PI / 180.0);
        return cs;
    }

    public static void testDIP() {
        OkadaDC3DRect.setStressParameters(1.8E10, 0.18);
        double depth = 2000.0;
        double lw = 50.0;
        double dip = 0.0;
        Vector3d xobs = new Vector3d(0.0, 0.0, -depth);
        Vector3d trans = new Vector3d(0.0, 0.0, 0.0);
        trans.y = Math.cos(dip * Math.PI / 180.0) * 0.1 * lw;
        trans.z = Math.sin(dip * Math.PI / 180.0) * 0.1 * lw;
        Vector3d displ = new Vector3d(0.0, 0.1, 0.0);
        int i = 0;
        while (i < 21) {
            System.out.print("trans " + i);
            OkadaDC3DRect.calculateLocalAtObservation(xobs, depth, dip, displ, lw, lw);
            xobs.add(trans);
            ++i;
        }
    }

    public static void testDIP2() {
        OkadaDC3DRect.setStressParameters(8.0E9, 0.3);
        double depth = 2000.0;
        double lw = 5.0;
        double dip = 0.0;
        Vector3d xobs = new Vector3d(0.0, 0.0, -depth);
        xobs.z += 0.1;
        Vector3d trans = new Vector3d(0.0, 0.0, 0.0);
        trans.x = 0.1 * lw;
        trans.z = 0.0;
        Vector3d displ = new Vector3d(0.0, 0.0, 0.001);
        int i = 0;
        while (i < 21) {
            System.out.print("trans " + i);
            OkadaDC3DRect.calculateLocalAtObservation(xobs, depth, dip, displ, lw, lw);
            xobs.add(trans);
            ++i;
        }
    }

    public static void testDC3D() {
        double[] U = new double[13];
        double length = 2000.0;
        double depth = 2000.0;
        double shiftdx = 0.0;
        double shiftdy = 0.0;
        Vector3d u = new Vector3d(0.0, 0.0, -1.0);
        double AL1 = -length / 2.0 + shiftdx;
        double AL2 = AL1 + length;
        double AW1 = -length / 2.0 + shiftdy;
        double AW2 = AW1 + length;
        double E = 1.8E10;
        double v = 0.18;
        double LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        double MYU = E / (2.0 * (1.0 + v));
        double ALPHA = (LAMBDA + MYU) / (LAMBDA + 2.0 * MYU);
        double DIP = 0.0;
        System.out.println("X, Y, Z, UX, UY, UZ");
        int NSTEP = 100;
        int i = 0;
        while (i < NSTEP) {
            double z = -i * 4000 / NSTEP;
            Vector3d x = new Vector3d(shiftdx, shiftdy, z);
            int ires = OkadaDC3DRect.DC3D(ALPHA, x.x, x.y, x.z, depth, 0.0, AL1, AL2, AW1, AW2, u.x, u.y, u.z, U);
            System.out.println(String.valueOf(x.x) + " " + x.y + " " + x.z + " " + U[1] + " " + U[2] + " " + U[3]);
            ++i;
        }
        System.out.println(" direct solution UZ " + OkadaDC3DRect.uzmid(length, length, depth));
    }

    public static void main(String[] args) {
        OkadaDC3DRect.testDIP();
    }
}

