/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class Stress3D {
    Matrix3f sigma_tectonic = new Matrix3f();
    Matrix3f sigma = new Matrix3f();
    float[] press_coeffs = new float[2];
    float transDepth = 0.0f;
    float rockdens = 0.0f;
    Vector3f vparalel = new Vector3f();
    Vector3f vperp = new Vector3f();
    float ss = 0.0f;
    float sn = 0.0f;
    float critstress = 0.0f;

    public Stress3D(float sh, float sH, float azimsh, float rockdens) {
        this.sigma_tectonic = new Matrix3f();
        Matrix3f teta = new Matrix3f();
        this.sigma_tectonic.m00 = sh;
        this.sigma_tectonic.m11 = sH;
        this.sigma_tectonic.m22 = 1.0f;
        float rot = azimsh;
        teta.rotZ((float)(1.5707963267948966 - Math.PI * 2 * (double)rot / 360.0));
        Matrix3f tetaT = new Matrix3f(teta);
        tetaT.transpose();
        this.sigma_tectonic.mul(this.sigma_tectonic, tetaT);
        this.sigma_tectonic.mul(teta, this.sigma_tectonic);
        this.press_coeffs[0] = 0.1f;
        this.press_coeffs[1] = 0.0f;
        this.rockdens = rockdens;
    }

    public float getProximityToFailure(Vector3f norm, float depth, float p, float frictionangle, float c, float ssdrop) {
        this.critstress = c;
        Vector3f t = this.getStress(norm, depth);
        this.sn = t.dot(norm);
        this.vperp.scale(this.sn, norm);
        this.vparalel.sub(t, this.vperp);
        this.ss = this.vparalel.length() - ssdrop;
        this.sn -= p;
        if ((double)Math.abs(this.sn) > 0.001) {
            this.critstress += (float)Math.tan((double)frictionangle * Math.PI / 180.0) * this.sn;
            return (this.ss - this.critstress) / Math.abs(this.critstress);
        }
        if ((double)c > 0.001) {
            return (this.ss - this.critstress) / c;
        }
        return this.ss;
    }

    public Vector3f getStress(Vector3f norm, float depth) {
        this.press_coeffs[1] = 0.0f;
        this.sigma = this.calcSigma(depth);
        Vector3f v = new Vector3f();
        int j = 0;
        while (j < 3) {
            Vector3f row = new Vector3f();
            this.sigma.getRow(j, row);
            float prod = row.dot(norm);
            switch (j) {
                case 0: {
                    v.x = prod;
                    break;
                }
                case 1: {
                    v.y = prod;
                    break;
                }
                case 2: {
                    v.z = prod;
                }
            }
            ++j;
        }
        return v;
    }

    public Matrix3f calcSigma(float depth) {
        Matrix3f total_stress = new Matrix3f();
        Matrix3f ts = new Matrix3f(this.sigma_tectonic);
        float P = -(this.press_coeffs[0] * Math.abs(depth) + this.press_coeffs[1]);
        ts.mul(this.rockdens * depth * 0.1f);
        total_stress.add(ts, new Matrix3f(P, 0.0f, 0.0f, 0.0f, P, 0.0f, 0.0f, 0.0f, P));
        return total_stress;
    }

    public Vector3f getNormal(float azim, float dip) {
        Vector3f norm = new Vector3f();
        dip = 90.0f - dip;
        norm.z = (float)Math.sin((double)dip * Math.PI / 180.0);
        float rh = (float)Math.cos((double)dip * Math.PI / 180.0);
        float rotradians = (float)(1.5707963267948966 - Math.PI * 2 * (double)azim / 360.0);
        norm.x = (float)Math.cos(rotradians) * rh;
        norm.y = (float)Math.sin(rotradians) * rh;
        return norm;
    }

    public static void main(String[] args) {
        float sh = 0.35f;
        float sH = 0.6f;
        float azim_sh = 90.0f;
        float rockdens = 2.3f;
        float frictionangle = 30.0f;
        float cohesion = 0.0f;
        float azim_fault = 90.0f;
        float depth = 1000.0f;
        float pressure = 0.0f;
        Stress3D s = new Stress3D(sh, sH, azim_sh, rockdens);
        int i = 0;
        while (i < 90) {
            float dip_fault = i;
            Vector3f normal = s.getNormal(azim_fault, dip_fault);
            float pf = s.getProximityToFailure(normal, depth, pressure, frictionangle, cohesion, 0.0f);
            System.out.println("dip " + dip_fault + "  " + s.sn + "  " + s.ss + " " + s.critstress + " " + normal.length() + "  prox failure " + pf);
            ++i;
        }
        System.out.println(s.sigma.toString());
    }
}

