/*
 * Decompiled with CFR 0.152.
 */
package okada;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DC3D;
import okada.DCCON2;

public class StressChange {
    static Matrix3d stressChange = new Matrix3d();
    static Vector3d normVector = new Vector3d();
    static Matrix3d sigma_tectonic = new Matrix3d();
    public static Vector3d vparalel = new Vector3d();
    public static Vector3d vperp = new Vector3d();
    static Matrix3d sigma = new Matrix3d();
    private static double[] press_coeff = new double[2];
    private static double PI8 = 0.01745329238474369;
    private static double rockdens = 2.3;
    public static double ss = 0.0;
    public static double sn = 0.0;
    public static double tow = 0.0;
    float critstress = 0.0f;
    public static double CFF;

    public void Stress3D(float sh, float sH, float azimsh, float rockdens) {
        sigma_tectonic = new Matrix3d();
        Matrix3d teta = new Matrix3d();
        StressChange.sigma_tectonic.m00 = sh;
        StressChange.sigma_tectonic.m11 = sH;
        StressChange.sigma_tectonic.m22 = 1.0;
        float rot = azimsh;
        teta.rotZ((float)(1.5707963267948966 - (double)rot * PI8));
        Matrix3d tetaT = new Matrix3d(teta);
        tetaT.transpose();
        sigma_tectonic.mul(sigma_tectonic, tetaT);
        sigma_tectonic.mul(teta, sigma_tectonic);
        StressChange.press_coeff[0] = 0.1f;
        StressChange.press_coeff[1] = 0.0;
    }

    public static Vector3d getNormal(double azim, double dip) {
        Vector3d norm = new Vector3d();
        double ddip = 90.0 - dip;
        norm.z = Math.sin(ddip * PI8);
        double rh = Math.cos(ddip * PI8);
        double rotradians = 1.5707963267948966 - azim * PI8;
        norm.x = Math.cos(rotradians) * rh;
        norm.y = Math.sin(rotradians) * rh;
        return norm;
    }

    public static void vectors(double depth, double azim, double dip) {
        Vector3d norm = StressChange.getNormal(azim, dip);
        Vector3d t = StressChange.getStress(norm, depth, azim);
        sn = t.dot(norm);
        vperp.scale(sn, norm);
        vparalel.sub(t, vperp);
        ss = vparalel.length();
        Vector3d u = new Vector3d();
        double d = 1.0 / vparalel.length();
        u.scale(d, vparalel);
        StressChange.ColoumbStressChange(ss, sn);
    }

    public static void ColoumbStressChange(double ShearChange, double normChange) {
        Matrix3d stressTensor = new Matrix3d(stressChange);
        double skk = stressTensor.m00 + stressTensor.m11 + stressTensor.m22;
        double k_skel = DCCON2.E / (3.0 * (1.0 - 2.0 * DCCON2.MYU));
        double kw = 22000.0;
        double a = 1.0 - k_skel / kw;
        double B = 1.0 / k_skel / (1.0 / k_skel + DCCON2.phi / a * (1.0 / kw));
        double u = 0.9;
        CFF = ShearChange + u * (normChange - B * skk / 3.0);
    }

    public static Vector3d getStress(Vector3d norm, double depth, double azim) {
        StressChange.press_coeff[1] = 0.0;
        Matrix3d sigma = StressChange.calcSigma(depth, azim);
        Vector3d v = new Vector3d();
        int i = 0;
        while (i < 3) {
            Vector3d row = new Vector3d();
            sigma.getRow(i, row);
            double prod = row.dot(norm);
            switch (i) {
                case 0: {
                    v.x = prod;
                }
                case 1: {
                    v.y = prod;
                }
                case 2: {
                    v.z = prod;
                }
            }
            ++i;
        }
        return v;
    }

    public static Matrix3d calcSigma(double depth, double azim) {
        Matrix3d total_stress = new Matrix3d();
        Matrix3d ts = new Matrix3d(sigma_tectonic);
        StressChange.press_coeff[0] = 0.1;
        double p = -(press_coeff[0] * Math.abs(depth) * 1000.0 + press_coeff[1]);
        ts.mul(rockdens * Math.abs(depth) * 0.1 * 1000.0);
        total_stress.add(ts, new Matrix3d(p, 0.0, 0.0, 0.0, p, 0.0, 0.0, 0.0, p));
        Matrix3d internalStress = new Matrix3d();
        internalStress.m00 = DC3D.Sxx;
        internalStress.m11 = DC3D.Syy;
        internalStress.m22 = DC3D.Szz;
        internalStress.m01 = internalStress.m10 = DC3D.Sxy;
        internalStress.m02 = internalStress.m20 = DC3D.Sxz;
        internalStress.m12 = internalStress.m21 = DC3D.Syz;
        Matrix3d R = new Matrix3d();
        R.m00 = R.m11 = Math.cos(azim);
        R.m22 = 1.0;
        R.m01 = Math.sin(azim);
        R.m10 = -1.0 * R.m01;
        R.m21 = 0.0;
        R.m20 = 0.0;
        R.m12 = 0.0;
        R.m02 = 0.0;
        Matrix3d Rt = new Matrix3d();
        Rt.transpose(R);
        stressChange.mul(internalStress, R);
        stressChange.mul(Rt, stressChange);
        Matrix3d final_stress = new Matrix3d();
        final_stress.add(stressChange, total_stress);
        return final_stress;
    }
}

