/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import tno.geoenergy.data.ColoredObject;
import tno.geoenergy.data.Geodata;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.MapRect;
import tno.geoenergy.projection.UTM2RD;
import tno.geoenergy.util.AsciiStream;
import tno.geoenergy.util.ByteBufferHelper;
import tno.geoenergy.util.ProcessException;

public class BinIO {
    public static int nfillfirst = 0;
    public static int nfillother = 2;
    public static String modelPath = "d:\\3dmodelfiles";
    static final int PREPARECONVERTGRIDS = 1;
    static final int CREATE3DBIN = 2;
    static final int CREATE3DBINCUSTOM = 3;
    static final int EXPORTTVDSS = 4;
    public static boolean RD = true;

    public static int getNfillfirst() {
        return nfillfirst;
    }

    public static void setNfillfirst(int nfillfirst) {
        BinIO.nfillfirst = nfillfirst;
    }

    public static int getNfillother() {
        return nfillother;
    }

    public static void setNfillother(int nfillother) {
        BinIO.nfillother = nfillother;
    }

    public static void writeInsetofGrid(String modelPath, String GridName, Grid grid, MapRect mr, int iresx, int iresy, boolean depth, ByteBufferHelper buffer) throws IOException {
        int ixMin = 0;
        int ixMax = grid.nx;
        int iyMin = 0;
        int iyMax = grid.ny;
        ixMin = MapRect.getI(mr.getXymin().x, grid.originx, grid.dx, grid.nx, iresx);
        ixMax = MapRect.getI(mr.getXymax().x, grid.originx, grid.dx, grid.nx, iresx);
        iyMin = MapRect.getJ(mr.getXymin().y, grid.originy, grid.dy, grid.ny, iresy);
        iyMax = MapRect.getJ(mr.getXymax().y, grid.originy, grid.dy, grid.ny, iresy);
        int nx = ixMax - ixMin;
        int ny = iyMax - iyMin;
        FileInputStream is = new FileInputStream(String.valueOf(modelPath) + "/" + GridName);
        FileChannel channel = is.getChannel();
        ByteBufferHelper bufin = new ByteBufferHelper(channel);
        bufin.clearread();
        int gnx = bufin.getInt();
        int gny = bufin.getInt();
        float goriginx = bufin.getFloat();
        float goriginy = bufin.getFloat();
        float gdx = bufin.getFloat();
        float gdy = bufin.getFloat();
        float gunknown = bufin.getFloat();
        buffer.putInt(nx / iresx);
        buffer.putInt(ny / iresy);
        buffer.putFloat(grid.originx + (float)ixMin * grid.dx);
        buffer.putFloat(grid.originy + (float)iyMin * grid.dy);
        buffer.putFloat(grid.dx * (float)iresx);
        buffer.putFloat(grid.dy * (float)iresy);
        buffer.putFloat(grid.unknown);
        float value = 0.0f;
        bufin.skipFloat(ixMin * gny);
        boolean defined = true;
        boolean isthickness = GridName.contains("THICKINPUT");
        int ix = ixMin;
        while (ix < ixMax) {
            bufin.skipFloat(iyMin);
            int iy = iyMin;
            while (iy < iyMax) {
                value = bufin.getFloat();
                if (!grid.defined(ix, iy)) {
                    buffer.putFloat(grid.unknown);
                } else if (depth) {
                    if (!Grid.defined(value, gunknown)) {
                        value = grid.values[ix][iy];
                    } else {
                        if (isthickness) {
                            value = grid.values[ix][iy] + value;
                        }
                        value = Math.max(value, grid.values[ix][iy]);
                    }
                    buffer.putFloat(-value);
                    grid.values[ix][iy] = -value;
                } else {
                    if (!Grid.defined(value, gunknown)) {
                        value = grid.values[ix][iy];
                    } else {
                        if (isthickness) {
                            value = grid.values[ix][iy] - value;
                        }
                        value = Math.min(value, grid.values[ix][iy]);
                    }
                    buffer.putFloat(value);
                    grid.values[ix][iy] = value;
                }
                if (iresy > 1) {
                    bufin.skipFloat(iresy - 1);
                }
                iy += iresy;
            }
            bufin.skipFloat(gny - iyMax);
            if (iresx > 1) {
                bufin.skipFloat((iresx - 1) * gny);
            }
            ix += iresx;
        }
        buffer.flipwrite();
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeCustomlayers(String modelname, ColoredObject[] grids, String modelPath, float xMin, float xMax, float yMin, float yMax, float res, boolean depth) throws FileNotFoundException, IOException {
        File output = new File(String.valueOf(modelPath) + "/" + modelname);
        FileOutputStream outputStream = new FileOutputStream(output);
        FileChannel channel = outputStream.getChannel();
        ByteBufferHelper buffer = new ByteBufferHelper(channel);
        buffer.putInt(grids.length);
        Grid shrinkgrid = Grid.readBinGrid(String.valueOf(modelPath) + "/" + (String)grids[0].object);
        MapRect mr = new MapRect(xMin, yMin, xMax, yMax);
        mr.shrink2Grid(shrinkgrid, res);
        boolean ok = false;
        int i = 0;
        while (i < shrinkgrid.nx) {
            int j = 0;
            while (j < shrinkgrid.ny) {
                float x = shrinkgrid.getx(i);
                float y = shrinkgrid.gety(j);
                if (x >= mr.getXymin().x && y >= mr.getXymin().y && x <= mr.getXymax().x && y <= mr.getXymax().y && shrinkgrid.defined(i, j)) {
                    ok = true;
                }
                ++j;
            }
            ++i;
        }
        if (!ok) {
            return ok;
        }
        ok = true;
        i = 0;
        while (i < grids.length) {
            buffer.putString((String)grids[i].object);
            Color c = grids[i].color;
            buffer.putInt(c.getRGB());
            ++i;
        }
        buffer.putFloat(mr.getXymin().x);
        buffer.putFloat(mr.getXymin().y);
        buffer.putFloat(mr.getXymax().x);
        buffer.putFloat(mr.getXymax().y);
        buffer.flipwrite();
        int iresx = Math.round(res / shrinkgrid.dx);
        int iresy = Math.round(res / shrinkgrid.dy);
        int i2 = 0;
        while (i2 < grids.length) {
            String gridname = (String)grids[i2].object;
            BinIO.writeInsetofGrid(modelPath, gridname, shrinkgrid, mr, iresx, iresy, depth, buffer);
            ++i2;
        }
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    public static boolean create3DBIN(String modelname, String gridsdefinition, String modelPath, float xMin, float xMax, float yMin, float yMax, float res) throws FileNotFoundException, IOException {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        FileInputStream inputStream = new FileInputStream(file);
        AsciiStream ast = new AsciiStream(inputStream, 4098);
        ast.setSkipType(1);
        int ngrids = Math.round(ast.readFloat());
        int DEPTH = Math.round(ast.readFloat());
        ColoredObject[] grids = new ColoredObject[ngrids];
        int i = 0;
        while (i < ngrids) {
            String name = ast.readString();
            int r = Math.round(ast.readFloat());
            int g = Math.round(ast.readFloat());
            int b = Math.round(ast.readFloat());
            grids[i] = new ColoredObject(name, new Color(r, g, b));
            ++i;
        }
        return BinIO.writeCustomlayers(modelname, grids, modelPath, xMin, xMax, yMin, yMax, res, DEPTH == 1);
    }

    public static void merge3Dbin(String[] fbin, int[] imode, int[] ithick, String outputbin, String modelPath, float xmin, float xmax, float ymin, float ymax, float distance_error) {
        BinIO.modelPath = modelPath;
        int nbin = fbin.length;
        ColoredObject[][] co = null;
        int ngrids = 0;
        int niter_fillholes = 3000;
        int i = 0;
        while (i < fbin.length) {
            File f = new File(String.valueOf(modelPath) + "/" + fbin[i]);
            ColoredObject[] coread = BinIO.readCustomlayers(f);
            if (co == null) {
                ngrids = coread.length;
                co = new ColoredObject[fbin.length][ngrids];
            }
            if (co != null) {
                if (coread.length < ngrids) {
                    co[i] = new ColoredObject[ngrids];
                    int ic = 0;
                    while (ic < coread.length) {
                        ++ic;
                    }
                }
                co[i] = coread;
            }
            ++i;
        }
        Grid g = co[0][0].getGrid();
        float res = g.dx;
        ColoredObject[] co_result = new ColoredObject[ngrids];
        int nx = Math.round((xmax - xmin) / res) + 1;
        int ny = Math.round((ymax - ymin) / res) + 1;
        float unknown = -999999.0f;
        Grid master = new Grid(xmin, ymin, 0.0f, res, res, nx, ny, unknown);
        int i2 = 0;
        while (i2 < ngrids) {
            Color color = co[0][i2].getColor();
            master.setFileName(co[0][i2].getGrid().getFileName());
            co_result[i2] = new ColoredObject(master.getFileName(), color);
            ++i2;
        }
        Grid[] mask = new Grid[nbin];
        Grid allmask = null;
        Grid prev = null;
        int j = 0;
        while (j < ngrids) {
            boolean filledholes = false;
            Grid gmerge = new Grid(master);
            int i3 = 0;
            while (i3 < nbin) {
                if (co[i3].length > j) {
                    Grid gin = co[i3][j].getGrid();
                    if (j == 0) {
                        mask[i3] = gin;
                    }
                    if (j > 0) {
                        gin.mask(mask[i3]);
                    }
                    gmerge.concat(gin, imode[i3], distance_error);
                } else if (ithick != null && ithick[j] != 0) {
                    if (ithick[j] == 1) {
                        if (!filledholes) {
                            System.out.println("filling holes");
                            gmerge.fillHoles(niter_fillholes, niter_fillholes);
                            gmerge.mask(allmask);
                            filledholes = true;
                        }
                    } else if (ithick[j] == 2 && !filledholes) {
                        gmerge.add(prev, -1.0f);
                        System.out.println("filling holes");
                        gmerge.fillHoles(niter_fillholes, niter_fillholes);
                        gmerge.mask(allmask);
                        gmerge.add(prev, 1.0f);
                        filledholes = true;
                    }
                }
                ++i3;
            }
            if (j == 0) {
                allmask = gmerge;
            }
            prev = gmerge;
            try {
                gmerge.writeBinGrid(String.valueOf(BinIO.modelPath) + "/" + co[0][j].getGrid().getFileNameNoExtension() + ".bin");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++j;
        }
        try {
            BinIO.writeCustomlayers(outputbin, co_result, modelPath, xmin, xmax, ymin, ymax, res, false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void bin3DgetDepthFromSurface(String binname, String dataformat, boolean TVDSS, boolean clipdepth, int nfillclean, float cleanmatch, String thickgridsdir) {
        block38: {
            File f = new File(String.valueOf(modelPath) + "/" + binname);
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            float TINY = 0.001f;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    Grid gtop = null;
                    Geodata gold = null;
                    String[] gridnames = new String[n];
                    int i = 0;
                    while (i < n) {
                        String fileName = buffer.getString();
                        if (i == 0) {
                            gtop = new Grid();
                            gtop.setFileName(fileName);
                        }
                        gridnames[i] = fileName;
                        Color color = new Color(buffer.getInt());
                        ++i;
                    }
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    i = 0;
                    while (i < n) {
                        if (i == 0) {
                            BinIO.read(gtop, buffer);
                            String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gtop.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gtop.getFileNameNoExtension() + "_TOP" + ext);
                            gtop.setDataFormat(dataformat);
                            System.out.println("writing " + gtop.getFileName());
                            try {
                                gtop.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            gold = new Grid(gtop);
                        } else {
                            Grid g = new Grid();
                            BinIO.read(g, buffer);
                            g.setFileName(gridnames[i]);
                            boolean thickinput = gridnames[i].contains("THICKINPUT");
                            Grid gthick = new Grid(g);
                            int ii = 0;
                            while (ii < g.nx) {
                                int jj = 0;
                                while (jj < g.ny) {
                                    if (g.defined(ii, jj) && gtop.defined(ii, jj) && ((Grid)gold).defined(ii, jj)) {
                                        gthick.values[ii][jj] = !thickinput ? -(g.values[ii][jj] - ((Grid)gold).values[ii][jj]) : g.values[ii][jj];
                                        if (!clipdepth || Math.abs(gthick.values[ii][jj]) > TINY) {
                                            ((Grid)gold).values[ii][jj] = TVDSS ? -((Grid)gold).values[ii][jj] : -(((Grid)gold).values[ii][jj] - gtop.values[ii][jj]);
                                        } else {
                                            ((Grid)gold).values[ii][jj] = ((Grid)gold).unknown;
                                            gthick.values[ii][jj] = ((Grid)gold).unknown;
                                        }
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gold.setFileName(gridnames[i - 1]);
                            System.out.println("grid " + gridnames[i - 1] + " grid number " + i);
                            System.out.println("writing " + gold.getFileName());
                            if (TVDSS) {
                                gold.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gold.getFileNameNoExtension() + "_TVDSS" + ext);
                            } else {
                                gold.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gold.getFileNameNoExtension() + "_TVD" + ext);
                            }
                            gold.setDataFormat(dataformat);
                            gthick.setDataFormat(dataformat);
                            String thickname = gthick.getFileNameNoExtension();
                            gthick.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gthick.getFileNameNoExtension() + "_THICK3DBIN" + ext);
                            try {
                                ((Grid)gold).write();
                                if (nfillclean > 0) {
                                    gthick.fillParticularValues(cleanmatch, nfillclean);
                                    if (thickgridsdir != null) {
                                        BinIO.takemin(gthick, thickname, f, thickgridsdir);
                                    }
                                }
                                gthick.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            gold = new Grid(g);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block38;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void bin3DgetDepthFromSurfaceNEW(String binname, String dataformat, boolean TVDSS, boolean clipdepth, int nfillclean, float cleanmatch, String thickgridsdir) {
        block28: {
            File f = new File(String.valueOf(modelPath) + "/" + binname);
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            float TINY = 0.001f;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    Grid gtop = null;
                    Object gold = null;
                    String[] gridnames = new String[n];
                    int i = 0;
                    while (i < n) {
                        String fileName = buffer.getString();
                        if (i == 0) {
                            gtop = new Grid();
                            gtop.setFileName(fileName);
                        }
                        gridnames[i] = fileName;
                        Color color = new Color(buffer.getInt());
                        ++i;
                    }
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    i = 0;
                    while (i < n) {
                        Grid g = new Grid();
                        BinIO.read(g, buffer);
                        if (TVDSS) {
                            g.scale(-1.0);
                        }
                        g.setFileName(gridnames[i]);
                        g.setDataFormat(dataformat);
                        String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                        System.out.println("writing " + g.getFileName());
                        if (TVDSS) {
                            g.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + g.getFileNameNoExtension() + "_TVDSS" + ext);
                        } else {
                            g.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + g.getFileNameNoExtension() + "_TVDSS" + ext);
                        }
                        try {
                            g.write();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block28;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void takemin(Grid gthick, String thickname, File f, String thickgridsdir) {
        String dir = String.valueOf(f.getParent()) + "/" + thickgridsdir;
        String[] files = BinIO.dirlist(dir);
        int imatch = -1;
        File fnew = null;
        int i = 0;
        while (i < files.length) {
            String fname;
            String fmatch;
            if (imatch == -1 && thickname.indexOf(String.valueOf((fmatch = (fname = (fnew = new File(files[i])).getName()).substring(fname.lastIndexOf("_") + 1, fname.lastIndexOf("."))).toLowerCase()) + "_bot") >= 0) {
                imatch = i;
            }
            ++i;
        }
        if (imatch >= 0) {
            System.out.println(" correcting " + thickname + " with grid " + fnew.getName());
            try {
                Grid g = new Grid(1.0f, 1.0f, 1.0f, "ARC", String.valueOf(dir) + "/" + fnew.getName());
                int i2 = 0;
                while (i2 < gthick.nx) {
                    int j = 0;
                    while (j < gthick.ny) {
                        float x = gthick.getx(i2);
                        float y = gthick.gety(j);
                        if (gthick.defined(i2, j)) {
                            float v0 = gthick.values[i2][j];
                            float v1 = g.getValueAtxy(x, y);
                            if (g.defined(v1) && v1 < v0) {
                                gthick.values[i2][j] = v1;
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ProcessException e) {
                e.printStackTrace();
            }
        }
    }

    private static String[] dirlist(String directory) {
        File dir = new File(directory);
        String[] chld = dir.list();
        if (chld != null) {
            return chld;
        }
        System.out.println("BINIO Specified directory does not exist or is not a directory.");
        System.out.println(directory);
        System.exit(0);
        return chld;
    }

    public static void convertBin2orig(String gridsdefinition, String format, String modelPath) throws FileNotFoundException, IOException {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        FileInputStream inputStream = new FileInputStream(file);
        AsciiStream ast = new AsciiStream(inputStream, 4098);
        ast.setSkipType(1);
        int ngrids = Math.round(ast.readFloat());
        int DEPTH = Math.round(ast.readFloat());
        int i = 0;
        while (i < ngrids) {
            String gridname = ast.readString();
            try {
                int index = gridname.lastIndexOf(".");
                if (index >= 0) {
                    gridname = gridname.substring(0, index);
                }
                Grid g = Grid.readBinGrid(String.valueOf(modelPath) + "/" + gridname + ".bin");
                g.setDataFormat(format);
                g.setFileName(String.valueOf(modelPath) + "/" + gridname + ".asc");
                g.write();
            }
            catch (ProcessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void convert2Bin(String gridsdefinition, String format, String modelPath) throws FileNotFoundException, IOException {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        FileInputStream inputStream = new FileInputStream(file);
        AsciiStream ast = new AsciiStream(inputStream, 4098);
        ast.setSkipType(1);
        int ngrids = Math.round(ast.readFloat());
        int DEPTH = Math.round(ast.readFloat());
        int i = 0;
        while (i < ngrids) {
            String gridname = ast.readString();
            try {
                Grid g = new Grid(1.0f, 1.0f, 1.0f, format, String.valueOf(modelPath) + "/" + gridname);
                int index = gridname.lastIndexOf(".");
                if (index >= 0) {
                    gridname = gridname.substring(0, index);
                }
                g.writeBinGrid(String.valueOf(modelPath) + "/" + gridname + ".bin");
            }
            catch (ProcessException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void convertBin2RD(String gridsdefinition, String format, String modelPath) throws FileNotFoundException, IOException {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        FileInputStream inputStream = new FileInputStream(file);
        AsciiStream ast = new AsciiStream(inputStream, 4098);
        ast.setSkipType(1);
        int ngrids = Math.round(ast.readFloat());
        int DEPTH = Math.round(ast.readFloat());
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        int i = 0;
        while (i < ngrids) {
            int index;
            String gridname = ast.readString();
            Grid g = Grid.readBinGrid(gridname);
            Grid gtemplate = new Grid();
            if (i == 0) {
                double[] xyRD = UTM2RD.convert2RD(g.xlow, g.ylow);
                if (xyRD[0] < (double)minx) {
                    minx = (float)xyRD[0];
                }
                if (xyRD[0] > (double)maxx) {
                    maxx = (float)xyRD[0];
                }
                if (xyRD[1] < (double)miny) {
                    miny = (float)xyRD[1];
                }
                if (xyRD[1] > (double)maxy) {
                    maxy = (float)xyRD[1];
                }
                if ((xyRD = UTM2RD.convert2RD(g.xhigh, g.ylow))[0] < (double)minx) {
                    minx = (float)xyRD[0];
                }
                if (xyRD[0] > (double)maxx) {
                    maxx = (float)xyRD[0];
                }
                if (xyRD[1] < (double)miny) {
                    miny = (float)xyRD[1];
                }
                if (xyRD[1] > (double)maxy) {
                    maxy = (float)xyRD[1];
                }
                if ((xyRD = UTM2RD.convert2RD(g.xhigh, g.yhigh))[0] < (double)minx) {
                    minx = (float)xyRD[0];
                }
                if (xyRD[0] > (double)maxx) {
                    maxx = (float)xyRD[0];
                }
                if (xyRD[1] < (double)miny) {
                    miny = (float)xyRD[1];
                }
                if (xyRD[1] > (double)maxy) {
                    maxy = (float)xyRD[1];
                }
                if ((xyRD = UTM2RD.convert2RD(g.xlow, g.yhigh))[0] < (double)minx) {
                    minx = (float)xyRD[0];
                }
                if (xyRD[0] > (double)maxx) {
                    maxx = (float)xyRD[0];
                }
                if (xyRD[1] < (double)miny) {
                    miny = (float)xyRD[1];
                }
                if (xyRD[1] > (double)maxy) {
                    maxy = (float)xyRD[1];
                }
                gtemplate = new Grid();
                gtemplate.originx = minx - g.dx;
                gtemplate.originy = miny - g.dy;
                int nx = (int)((maxx - gtemplate.originx) / g.dx) + 1;
                int ny = (int)((maxy - gtemplate.originy) / g.dy) + 1;
                gtemplate.values = new float[nx][ny];
                gtemplate.nx = nx;
                gtemplate.ny = ny;
                gtemplate.unknown = g.unknown;
                int ii = 0;
                while (ii < gtemplate.nx) {
                    int jj = 0;
                    while (jj < gtemplate.ny) {
                        gtemplate.values[ii][jj] = gtemplate.unknown;
                        ++jj;
                    }
                    ++ii;
                }
            }
            if ((index = gridname.lastIndexOf(".")) >= 0) {
                gridname = gridname.substring(0, index);
            }
            Grid gnew = new Grid(gtemplate);
            int ii = 0;
            while (ii < gnew.nx) {
                int jj = 0;
                while (jj < gnew.ny) {
                    double xRD = gnew.getx(ii);
                    double yRD = gnew.gety(jj);
                    double[] xyUTM = UTM2RD.convert2UTM(xRD, yRD);
                    gnew.values[ii][jj] = g.getValueAtxy((float)xyUTM[0], (float)xyUTM[1]);
                    ++jj;
                }
                ++ii;
            }
            g.writeBinGrid(String.valueOf(modelPath) + "/" + gridname + ".binRD");
            ++i;
        }
    }

    public static void convert2BinIrregular(String gridsdefinition, String format, String modelPath) throws FileNotFoundException, IOException {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        FileInputStream inputStream = new FileInputStream(file);
        AsciiStream ast = new AsciiStream(inputStream, 4098);
        ast.setSkipType(1);
        int ngrids = Math.round(ast.readFloat());
        int DEPTH = Math.round(ast.readFloat());
        Grid guide = null;
        Geodata gmask = null;
        Grid gout = null;
        Grid gprev = null;
        float val = 0.0f;
        int i = 0;
        while (i < ngrids) {
            int jj;
            String gridname = ast.readString();
            System.out.println("grid input " + gridname);
            if (gridname.endsWith("asc") || gridname.endsWith("ASC")) {
                format = "ARC";
            }
            if (gridname.endsWith("dat") || gridname.endsWith("DAT")) {
                format = "ZYCOR";
            }
            if (gridname.endsWith("grd") || gridname.endsWith("GRD")) {
                format = "SURFER";
            }
            try {
                int index;
                Grid g;
                if (DEPTH == -1) {
                    g = new Grid(1.0f, 1.0f, 1.0f, format, String.valueOf(modelPath) + "/" + gridname);
                    g.scale(-1.0);
                    g.setFileName(String.valueOf(modelPath) + "/INPUT" + gridname);
                    try {
                        g.write();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    g = new Grid(1.0f, 1.0f, 1.0f, format, String.valueOf(modelPath) + "/" + gridname);
                }
                if ((index = gridname.lastIndexOf(".")) >= 0) {
                    gridname = gridname.substring(0, index);
                }
                if (i == 0) {
                    guide = g;
                    guide.fillHoles(nfillfirst, 0);
                    gmask = new Grid(guide);
                    int ii = 0;
                    while (ii < ((Grid)gmask).nx) {
                        jj = 0;
                        while (jj < ((Grid)gmask).ny) {
                            ((Grid)gmask).values[ii][jj] = ((Grid)gmask).unknown;
                            ++jj;
                        }
                        ++ii;
                    }
                    g.writeBinGrid(String.valueOf(modelPath) + "/" + gridname + ".bin");
                } else {
                    g.fillHoles(nfillother, 0);
                    gout = new Grid(guide);
                    System.out.println(" processing resampling of nx " + gout.nx + " - ny  " + gout.ny);
                    int ii = 0;
                    while (ii < gout.nx) {
                        if (ii % 10 == 0) {
                            System.out.print(" .. " + ii + "..");
                        }
                        jj = 0;
                        while (jj < gout.ny) {
                            val = g.getValueAtxy(gout.getx(ii), gout.gety(jj));
                            gout.values[ii][jj] = gout.unknown;
                            if (g.defined(val)) {
                                gout.values[ii][jj] = val;
                                if (guide.defined(ii, jj) && val < guide.values[ii][jj]) {
                                    ((Grid)gmask).values[ii][jj] = 1.0f;
                                }
                            }
                            ++jj;
                        }
                        ++ii;
                    }
                    System.out.println();
                    gout.writeBinGrid(String.valueOf(modelPath) + "/" + gridname + ".bin");
                    gout.setFileName(String.valueOf(modelPath) + "/" + gridname + ".grd");
                    gout.setDataFormat("SURFER");
                    try {
                        gout.write();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ProcessException e) {
                e.printStackTrace();
            }
            float TINY = 0.001f;
            if (i > 0) {
                int ii = 0;
                while (ii < gout.nx) {
                    jj = 0;
                    while (jj < gout.ny) {
                        if (gprev.defined(ii, jj) && gout.defined(ii, jj)) {
                            gprev.values[ii][jj] = Math.abs(gprev.values[ii][jj] - gout.values[ii][jj]) >= TINY ? gprev.values[ii][jj] - gout.values[ii][jj] : gprev.unknown;
                        }
                        ++jj;
                    }
                    ++ii;
                }
                gprev.writeBinGrid(String.valueOf(modelPath) + "/" + gridname + "_THICKINPUT.bin");
                gprev.setFileName(String.valueOf(modelPath) + "/" + gridname + "_THICKINPUT.grd");
                gprev.setDataFormat("SURFER");
                try {
                    gprev.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                gprev.setDataFormat("ARC");
                gprev.setFileName(String.valueOf(modelPath) + "/" + gridname + "_THICKINPUT.asc");
                try {
                    gprev.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gprev = i == 0 ? new Grid(guide) : new Grid(gout);
            ++i;
        }
        gmask.setFileName(String.valueOf(modelPath) + "/gmask.grd");
        gmask.setDataFormat("SURFER");
        try {
            ((Grid)gmask).write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void extendbingrids_notseabed(String gridsdefinition, String modelPath) {
        File file = new File(String.valueOf(modelPath) + "/" + gridsdefinition);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            AsciiStream ast = new AsciiStream(inputStream, 4098);
            ast.setSkipType(1);
            int ngrids = Math.round(ast.readFloat());
            int DEPTH = Math.round(ast.readFloat());
            int i = 0;
            while (i < ngrids) {
                String gridname = ast.readString();
                System.out.println("processing grid " + gridname);
                Grid g = Grid.readBinGrid(String.valueOf(modelPath) + "/" + gridname);
                if (i > 0) {
                    g.fillHoles(100, 0);
                }
                g.writeBinGrid(String.valueOf(modelPath) + "/" + gridname);
                ++i;
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ColoredObject[] readCustomlayers(File f) {
        FileInputStream is = null;
        AbstractInterruptibleChannel channel = null;
        try {
            is = new FileInputStream(f);
            channel = is.getChannel();
            int filesize = (int)((FileChannel)channel).size();
            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
            buffer.clearread();
            int n = buffer.getInt();
            ColoredObject[] grids = new ColoredObject[n];
            int i = 0;
            while (i < grids.length) {
                Grid g = new Grid();
                g.setFileName(buffer.getString());
                Color c = new Color(buffer.getInt());
                grids[i] = new ColoredObject(g, c);
                ++i;
            }
            buffer.getFloat();
            buffer.getFloat();
            buffer.getFloat();
            buffer.getFloat();
            i = 0;
            while (i < grids.length) {
                BinIO.read((Grid)grids[i].object, buffer);
                ++i;
            }
            ColoredObject[] coloredObjectArray = grids;
            return coloredObjectArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void bin3D2grids(String binname, String dataformat, boolean thickness) {
        block39: {
            File f = new File(binname);
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    ColoredObject[] grids = new ColoredObject[n];
                    int i = 0;
                    while (i < grids.length) {
                        Grid g = new Grid();
                        g.setFileName(buffer.getString());
                        Color c = new Color(buffer.getInt());
                        grids[i] = new ColoredObject(g, c);
                        ++i;
                    }
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    Grid gold = null;
                    Grid gsurface = null;
                    Grid gmdepth = null;
                    Grid gthickness = null;
                    Grid goldthickness = null;
                    int i2 = 0;
                    while (i2 < grids.length) {
                        Grid g = new Grid();
                        BinIO.read(g, buffer);
                        if (i2 == 0) {
                            gsurface = g;
                        }
                        String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                        String filename = ((Grid)grids[i2].object).getFileName();
                        int iend = filename.indexOf(".");
                        if (iend > 0) {
                            filename = filename.substring(0, iend);
                        }
                        g.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + filename + ext);
                        g.setDataFormat(dataformat);
                        try {
                            g.write();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (i2 > 0) {
                            gthickness = new Grid(gold);
                            gmdepth = new Grid(gold);
                            int ii = 0;
                            while (ii < g.nx) {
                                int jj = 0;
                                while (jj < g.ny) {
                                    if (g.defined(ii, jj)) {
                                        if (gold.defined(ii, jj)) {
                                            float d;
                                            gmdepth.values[ii][jj] = gsurface.values[ii][jj] - 0.5f * (gold.values[ii][jj] + g.values[ii][jj]);
                                            float g1 = gold.values[ii][jj];
                                            float g2 = g.values[ii][jj];
                                            gthickness.values[ii][jj] = d = g1 - g2;
                                        } else {
                                            gmdepth.values[ii][jj] = gsurface.values[ii][jj] - g.values[ii][jj];
                                        }
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Grid reducedthickness = new Grid(gthickness);
                            if (i2 > 1) {
                                int ii2 = 0;
                                while (ii2 < g.nx) {
                                    int jj = 0;
                                    while (jj < g.ny) {
                                        if (reducedthickness.defined(ii2, jj) && goldthickness.values[ii2][jj] < 3.0f) {
                                            reducedthickness.values[ii2][jj] = reducedthickness.unknown;
                                        }
                                        ++jj;
                                    }
                                    ++ii2;
                                }
                            }
                            String fname = String.valueOf(filename) + "_MDEPTH";
                            gmdepth.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + fname + ext);
                            gmdepth.setDataFormat(dataformat);
                            fname = String.valueOf(filename) + "_MTHICK";
                            gthickness.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + fname + ext);
                            gthickness.setDataFormat(dataformat);
                            fname = String.valueOf(filename) + "_MTHICKREDUCED";
                            reducedthickness.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + fname + ext);
                            reducedthickness.setDataFormat(dataformat);
                            try {
                                gmdepth.write();
                                if (thickness) {
                                    gthickness.write();
                                    reducedthickness.write();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        gold = g;
                        goldthickness = gthickness;
                        ++i2;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block39;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void bin3DgetDepthFromSurface(String binname, String dataformat, boolean TVDSS, boolean clipdepth, int nfillclean, float cleanmatch) {
        block37: {
            File f = new File(String.valueOf(modelPath) + "/" + binname);
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            float TINY = 0.001f;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    Grid gtop = null;
                    Geodata gold = null;
                    String[] gridnames = new String[n];
                    int i = 0;
                    while (i < n) {
                        String fileName = buffer.getString();
                        if (i == 0) {
                            gtop = new Grid();
                            gtop.setFileName(fileName);
                        }
                        gridnames[i] = fileName;
                        Color color = new Color(buffer.getInt());
                        ++i;
                    }
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    i = 0;
                    while (i < n) {
                        if (i == 0) {
                            BinIO.read(gtop, buffer);
                            String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gtop.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gtop.getFileNameNoExtension() + "_TOP" + ext);
                            gtop.setDataFormat(dataformat);
                            System.out.println("writing " + gtop.getFileName());
                            try {
                                gtop.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            gold = new Grid(gtop);
                        } else {
                            Grid g = new Grid();
                            BinIO.read(g, buffer);
                            g.setFileName(gridnames[i]);
                            Grid gthick = new Grid(g);
                            int ii = 0;
                            while (ii < g.nx) {
                                int jj = 0;
                                while (jj < g.ny) {
                                    if (g.defined(ii, jj) && gtop.defined(ii, jj) && ((Grid)gold).defined(ii, jj)) {
                                        gthick.values[ii][jj] = -(g.values[ii][jj] - ((Grid)gold).values[ii][jj]);
                                        if (!clipdepth || Math.abs(gthick.values[ii][jj]) > TINY) {
                                            ((Grid)gold).values[ii][jj] = TVDSS ? -((Grid)gold).values[ii][jj] : -(((Grid)gold).values[ii][jj] - gtop.values[ii][jj]);
                                        } else {
                                            ((Grid)gold).values[ii][jj] = ((Grid)gold).unknown;
                                            gthick.values[ii][jj] = ((Grid)gold).unknown;
                                        }
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            String ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gold.setFileName(gridnames[i - 1]);
                            System.out.println("grid " + gridnames[i - 1] + " grid number " + i);
                            System.out.println("writing " + gold.getFileName());
                            if (TVDSS) {
                                gold.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gold.getFileNameNoExtension() + "_TVDSS" + ext);
                            } else {
                                gold.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gold.getFileNameNoExtension() + "_TVD" + ext);
                            }
                            gold.setDataFormat(dataformat);
                            gthick.setDataFormat(dataformat);
                            gthick.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gthick.getFileNameNoExtension() + "_THICK3DBIN" + ext);
                            try {
                                ((Grid)gold).write();
                                if (nfillclean > 0) {
                                    gthick.fillParticularValues(cleanmatch, nfillclean);
                                }
                                gthick.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            gold = new Grid(g);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block37;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void bin3DgetThickness(String binname, String dataformat, String topgrid, String basegrid, String thick) {
        block32: {
            File f = new File(String.valueOf(modelPath) + "/" + binname);
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    Grid gtop = null;
                    Grid gbase = null;
                    int itop = -1;
                    int ibase = -1;
                    int i = 0;
                    while (i < n) {
                        String fileName = buffer.getString();
                        if (fileName.equals(topgrid)) {
                            gtop = new Grid();
                            gtop.setFileName(fileName);
                            itop = i;
                        }
                        if (fileName.equals(basegrid)) {
                            gbase = new Grid();
                            gbase.setFileName(fileName);
                            ibase = i;
                        }
                        Color color = new Color(buffer.getInt());
                        ++i;
                    }
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    buffer.getFloat();
                    i = 0;
                    while (i < n) {
                        String ext;
                        if (itop == i) {
                            BinIO.read(gtop, buffer);
                            ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gtop.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gtop.getFileName() + ext);
                            gtop.setDataFormat(dataformat);
                            try {
                                gtop.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (ibase == i) {
                            BinIO.read(gbase, buffer);
                            ext = dataformat.equals("SURFER") ? ".grd" : (dataformat.equals("ARC") ? ".asc" : (dataformat.equals("ZYCOR") ? ".dat" : ".notknown"));
                            gbase.setFileName(String.valueOf(new File(f.getParent()).getAbsolutePath()) + "/" + gbase.getFileName() + ext);
                            gbase.setDataFormat(dataformat);
                            try {
                                gbase.write();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            Grid g = new Grid();
                            BinIO.read(g, buffer);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block32;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static ColoredObject[] readCustomlayers(File dir, MapRect mr) {
        ColoredObject[] grids;
        boolean[] okfile;
        File[] files;
        AbstractInterruptibleChannel channel;
        FileInputStream is;
        block82: {
            is = null;
            channel = null;
            if (!dir.isDirectory()) {
                System.out.println("cannot read, no directory");
                return null;
            }
            files = null;
            okfile = null;
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            };
            files = dir.listFiles(fileFilter);
            okfile = new boolean[files.length];
            float gxmin = 1.0E30f;
            float gymin = 1.0E30f;
            float gxmax = -1.0E30f;
            float gymax = -1.0E30f;
            int ifile = 0;
            while (ifile < files.length) {
                block80: {
                    try {
                        try {
                            is = new FileInputStream(files[ifile]);
                            channel = is.getChannel();
                            int filesize = (int)((FileChannel)channel).size();
                            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                            buffer.clearread();
                            int n = buffer.getInt();
                            ColoredObject[] grids2 = new ColoredObject[n];
                            int i = 0;
                            while (i < grids2.length) {
                                Grid g = new Grid();
                                g.setFileName(buffer.getString());
                                Color c = new Color(buffer.getInt());
                                grids2[i] = new ColoredObject(g, c);
                                ++i;
                            }
                            float xmin = buffer.getFloat();
                            float ymin = buffer.getFloat();
                            float xmax = buffer.getFloat();
                            float ymax = buffer.getFloat();
                            okfile[ifile] = !(mr.getXymin().x > xmax || mr.getXymin().y > ymax || mr.getXymax().x < xmin || mr.getXymax().y < ymin);
                            if (xmin < gxmin) {
                                gxmin = xmin;
                            }
                            if (ymin < gymin) {
                                gymin = ymin;
                            }
                            if (xmax > gxmax) {
                                gxmax = xmax;
                            }
                            if (ymax > gymax) {
                                gymax = ymax;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                            break block80;
                        }
                    }
                    catch (Throwable throwable) {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++ifile;
            }
            MapRect mrtarget = new MapRect(gxmin, gymin, gxmax, gymax);
            float res = Float.parseFloat(dir.getName());
            mrtarget.shrink2target(mr, res);
            grids = null;
            try {
                try {
                    is = new FileInputStream(files[0]);
                    channel = is.getChannel();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    grids = new ColoredObject[n];
                    int i = 0;
                    while (i < grids.length) {
                        Grid g = mrtarget.getDefaultGrid(res);
                        g.setFileName(buffer.getString());
                        Color c = new Color(buffer.getInt());
                        grids[i] = new ColoredObject(g, c);
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e5) {
                            e5.printStackTrace();
                        }
                    }
                    break block82;
                }
            }
            catch (Throwable throwable) {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        int ifile = 0;
        while (ifile < files.length) {
            block84: {
                if (okfile[ifile]) {
                    try {
                        try {
                            is = new FileInputStream(files[ifile]);
                            channel = is.getChannel();
                            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                            buffer.clearread();
                            buffer.getInt();
                            int i = 0;
                            while (i < grids.length) {
                                buffer.getString();
                                buffer.getInt();
                                ++i;
                            }
                            buffer.getFloat();
                            buffer.getFloat();
                            buffer.getFloat();
                            buffer.getFloat();
                            i = 0;
                            while (i < grids.length) {
                                BinIO.readFill((Grid)grids[i].object, buffer);
                                ++i;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (IOException e6) {
                                    e6.printStackTrace();
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e7) {
                                    e7.printStackTrace();
                                }
                            }
                            break block84;
                        }
                    }
                    catch (Throwable throwable) {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++ifile;
        }
        int i = 0;
        while (i < grids.length) {
            ((Grid)grids[i].object).determine_low_high();
            ++i;
        }
        return grids;
    }

    public static void readFill(Grid grid, ByteBufferHelper buffer) throws IOException {
        int nx = buffer.getInt();
        int ny = buffer.getInt();
        float originx = buffer.getFloat();
        float originy = buffer.getFloat();
        float dx = buffer.getFloat();
        float dy = buffer.getFloat();
        int ioffset = Math.round((originx - grid.originx) / dx);
        int joffset = Math.round((originy - grid.originy) / dy);
        float unknown = buffer.getFloat();
        float valf = 0.0f;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                valf = buffer.getFloat();
                double valtest = Math.abs(valf / unknown - 1.0f);
                if (valtest > 1.0E-5 && i + ioffset >= 0 && i + ioffset < grid.nx && j + joffset >= 0 && j + joffset < grid.ny) {
                    grid.values[i + ioffset][j + joffset] = valf;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void read(Grid grid, ByteBufferHelper buffer) throws IOException {
        grid.nx = buffer.getInt();
        grid.ny = buffer.getInt();
        grid.originx = buffer.getFloat();
        grid.originy = buffer.getFloat();
        grid.dx = buffer.getFloat();
        grid.dy = buffer.getFloat();
        grid.unknown = buffer.getFloat();
        float[][] values = new float[grid.nx][grid.ny];
        int i = 0;
        while (i < grid.nx) {
            int j = 0;
            while (j < grid.ny) {
                values[i][j] = buffer.getFloat();
                ++j;
            }
            ++i;
        }
        grid.values = values;
        grid.determine_low_high();
    }

    public static Grid readGrid(File sourceDir, String fileName) {
        FileInputStream is = null;
        AbstractInterruptibleChannel channel = null;
        try {
            File f = new File(sourceDir, String.valueOf(fileName) + ".gridbin");
            is = new FileInputStream(f);
            channel = is.getChannel();
            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
            buffer.clearread();
            Grid grid = new Grid();
            grid.setFileName(fileName);
            BinIO.read(grid, buffer);
            Grid grid2 = grid;
            return grid2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void convert() {
        String gridnames = "inputconvert.txt";
        try {
            BinIO.convert2Bin(gridnames, "ARC", modelPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertIrregular() {
        String gridnames = "inputconvert.txt";
        try {
            BinIO.convert2BinIrregular(gridnames, "ARC", modelPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertIrregular(String gridnames) {
        try {
            BinIO.convert2BinIrregular(gridnames, "ARC", modelPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void create3DBIN(String modelname, String gridnames, float res) {
        try {
            if (RD) {
                BinIO.create3DBIN(modelname, gridnames, modelPath, 0.0f, 300000.0f, 300000.0f, 650000.0f, res);
            } else {
                BinIO.create3DBIN(modelname, gridnames, modelPath, 521000.0f, 783500.0f, 5626000.0f, 5948500.0f, res);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create3DBIN(String modelname, String gridnames, float xmin, float xmax, float ymin, float ymax, float res) {
        try {
            BinIO.create3DBIN(modelname, gridnames, modelPath, xmin, xmax, ymin, ymax, res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create3DBIN(String modelname, float res, String inputname, float xmin, float xmax, float ymin, float ymax) {
        String gridnames = inputname;
        try {
            BinIO.create3DBIN(modelname, gridnames, modelPath, xmin, xmax, ymin, ymax, res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create3DBIN(String modelname, float res, String inputname) {
        String gridnames = inputname;
        try {
            if (RD) {
                BinIO.create3DBIN(modelname, gridnames, modelPath, 0.0f, 300000.0f, 300000.0f, 650000.0f, res);
            } else {
                BinIO.create3DBIN(modelname, gridnames, modelPath, 521000.0f, 783500.0f, 5626000.0f, 5948500.0f, res);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

