/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.awt.Color;
import tno.geoenergy.data.Grid;

public class ColoredObject {
    final Color color;
    final Object object;

    public ColoredObject(Object object, Color color) {
        this.object = object;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Object getObject() {
        return this.object;
    }

    public Grid getGrid() {
        return (Grid)this.object;
    }

    public float getXmin() {
        if (this.object instanceof Grid) {
            return ((Grid)this.object).originx;
        }
        return 0.0f;
    }

    public float getYmin() {
        if (this.object instanceof Grid) {
            return ((Grid)this.object).originy;
        }
        return 0.0f;
    }

    public float getXmax() {
        if (this.object instanceof Grid) {
            Grid g = (Grid)this.object;
            return g.originx + (float)g.nx * g.dx;
        }
        return 0.0f;
    }

    public float getYmax() {
        if (this.object instanceof Grid) {
            Grid g = (Grid)this.object;
            return g.originy + (float)g.ny * g.dy;
        }
        return 0.0f;
    }

    public static Color[] getColorsArray(ColoredObject[] grids) {
        Color[] cols = new Color[grids.length - 1];
        int i = 1;
        while (i < grids.length) {
            cols[i - 1] = grids[i].getColor();
            ++i;
        }
        return cols;
    }

    public static String[] getLegendtexts(ColoredObject[] grids) {
        String[] s = new String[grids.length - 1];
        int i = 1;
        while (i < grids.length) {
            s[i - 1] = ((Grid)grids[i].getObject()).getFileName();
            ++i;
        }
        return s;
    }
}

