/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Vector3f;
import tno.geoenergy.data.CoordLine;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.data.ZcornLine;
import tno.geoenergy.util.EclipseAsciiStream;

public class EclipseGrid {
    public static String TOPGRID = "TOPGRID";
    public static String THICKNESS = "THICKNESS";
    public static String ACTNUM = "ACTNUM";
    public static String CONNECTXMIN = "CONNECTXMIN";
    public static String CONNECTXPLUS = "CONNECTXPLUS";
    public static String CONNECTYMIN = "CONNECTYMIN";
    public static String CONNECTYPLUS = "CONNECTYPLUS";
    public static String CONNECTZMIN = "CONNECTZMIN";
    public static String CONNECTZPLUS = "CONNECTZPLUS";
    public static String ACTNUMFLOW = "ACTNUMFLOW";
    public static String CONNECTXMINTEMP = "CONNECTXMINTEMP";
    public static String CONNECTXPLUSTEMP = "CONNECTXPLUSTEMP";
    public static String CONNECTYMINTEMP = "CONNECTYMINTEMP";
    public static String CONNECTYPLUSTEMP = "CONNECTYPLUSTEMP";
    public static String CONNECTZMINTEMP = "CONNECTZMINTEMP";
    public static String CONNECTZPLUSTEMP = "CONNECTZPLUSTEMP";
    public static String ACTNUMTEMP = "ACTNUMTEMP";
    public static final double THICKTRESHOLD = 1.0;
    public static final double PERMTRESHOLDMIN = 0.0;
    public static final double PERMTHRESHOLD = 0.0;
    public double originx;
    public double originy;
    public double originz;
    private double mapx;
    private double mapy;
    public int nx;
    public int ny;
    public int nz;
    public double dx;
    public double dy;
    public double dz;
    CoordLine[][] coordLine = null;
    ZcornLine[][] zcornLine = null;
    int[][][] actnum = null;
    float[][][] actnum_f = null;
    float[][] topgrid_f = null;
    float[][][] thickness_f = null;
    double[][][] connectxmin = null;
    double[][][] connectxplus = null;
    double[][][] connectymin = null;
    double[][][] connectyplus = null;
    double[][][] connectzmin = null;
    double[][][] connectzplus = null;
    double[][][] actnumflow = null;
    float[][][] connectxmin_f = null;
    float[][][] connectxplus_f = null;
    float[][][] connectymin_f = null;
    float[][][] connectyplus_f = null;
    float[][][] connectzmin_f = null;
    float[][][] connectzplus_f = null;
    float[][][] actnumflow_f = null;
    double[][][] connectxmin_temp = null;
    double[][][] connectxplus_temp = null;
    double[][][] connectymin_temp = null;
    double[][][] connectyplus_temp = null;
    double[][][] connectzmin_temp = null;
    double[][][] connectzplus_temp = null;
    double[][][] actnumtemp = null;
    float[][][] connectxmin_temp_f = null;
    float[][][] connectxplus_temp_f = null;
    float[][][] connectymin_temp_f = null;
    float[][][] connectyplus_temp_f = null;
    float[][][] connectzmin_temp_f = null;
    float[][][] connectzplus_temp_f = null;
    float[][][] actnumtemp_f = null;
    public String filename;
    public Vector<String> keywords;
    private boolean start_property_section = false;

    public EclipseGrid(String filename) {
        this.filename = filename;
        this.read_geometry();
        this.calcdxdyandtopgrid();
        this.constructActnumFlow();
        this.constructConnectivityMatrices();
    }

    public Grid getTopGrid() {
        Grid g = new Grid();
        g.nx = this.nx;
        g.ny = this.ny;
        g.originx = (float)(this.mapx + 0.5 * this.dx);
        g.originy = (float)(this.mapy - ((double)this.ny - 0.5) * this.dy);
        g.dx = (float)this.dx;
        g.dy = (float)this.dy;
        g.unknown = -999.25f;
        g.values = this.topgrid_f;
        return g;
    }

    public Voxet getPropertyVoxet(String propertyKey) {
        Voxet v = new Voxet();
        v.setNx(this.nx);
        v.setNy(this.ny);
        v.setNz(this.nz);
        v.setOriginx((float)(this.mapx + 0.5 * this.dx));
        v.setOriginy((float)(this.mapy - ((double)this.ny - 0.5) * this.dy));
        v.setOriginz(0.0f);
        v.setDx((float)this.dx);
        v.setDy((float)this.dy);
        v.setDz(1.0f);
        v.setValues(new float[this.nz][this.ny][this.nx]);
        if (propertyKey != null) {
            v.setPropName(propertyKey);
            if (propertyKey.equals(THICKNESS)) {
                v.setValues(this.thickness_f);
            } else if (propertyKey.equals(ACTNUM)) {
                v.setValues(this.actnum_f);
            } else if (propertyKey.equals(CONNECTXMIN)) {
                v.setValues(this.connectxmin_f);
            } else if (propertyKey.equals(CONNECTYMIN)) {
                v.setValues(this.connectymin_f);
            } else if (propertyKey.equals(CONNECTZMIN)) {
                v.setValues(this.connectzmin_f);
            } else if (propertyKey.equals(CONNECTXPLUS)) {
                v.setValues(this.connectxplus_f);
            } else if (propertyKey.equals(CONNECTYPLUS)) {
                v.setValues(this.connectyplus_f);
            } else if (propertyKey.equals(CONNECTZPLUS)) {
                v.setValues(this.connectzplus_f);
            } else if (propertyKey.equals(ACTNUMFLOW)) {
                v.setValues(this.actnumflow_f);
            } else if (propertyKey.equals(ACTNUMTEMP)) {
                v.setValues(this.actnumtemp_f);
            } else if (propertyKey.equals(CONNECTXMINTEMP)) {
                v.setValues(this.connectxmin_temp_f);
            } else if (propertyKey.equals(CONNECTYMINTEMP)) {
                v.setValues(this.connectymin_temp_f);
            } else if (propertyKey.equals(CONNECTZMINTEMP)) {
                v.setValues(this.connectzmin_temp_f);
            } else if (propertyKey.equals(CONNECTXPLUSTEMP)) {
                v.setValues(this.connectxplus_temp_f);
            } else if (propertyKey.equals(CONNECTYPLUSTEMP)) {
                v.setValues(this.connectyplus_temp_f);
            } else if (propertyKey.equals(CONNECTZPLUSTEMP)) {
                v.setValues(this.connectzplus_temp_f);
            } else {
                v.setValues(this.readSingleProperty(propertyKey));
            }
        }
        return v;
    }

    public Voxet getGeomVoxet() {
        return this.getPropertyVoxet(null);
    }

    private void constructConnectivityMatrices() {
        boolean iMinFound = false;
        boolean iPlusFound = false;
        boolean jMinFound = false;
        boolean jPlusFound = false;
        boolean kMinFound = false;
        boolean kPlusFound = false;
        boolean iMinFoundTemp = false;
        boolean iPlusFoundTemp = false;
        boolean jMinFoundTemp = false;
        boolean jPlusFoundTemp = false;
        boolean kMinFoundTemp = false;
        boolean kPlusFoundTemp = false;
        float iMin = -1.0f;
        float iPlus = -1.0f;
        float jMin = -1.0f;
        float jPlus = -1.0f;
        float kMin = -1.0f;
        float kPlus = -1.0f;
        float iMinTemp = -1.0f;
        float iPlusTemp = -1.0f;
        float jMinTemp = -1.0f;
        float jPlusTemp = -1.0f;
        float kMinTemp = -1.0f;
        float kPlusTemp = -1.0f;
        this.connectxmin = new double[this.nx][this.ny][this.nz];
        this.connectxplus = new double[this.nx][this.ny][this.nz];
        this.connectymin = new double[this.nx][this.ny][this.nz];
        this.connectyplus = new double[this.nx][this.ny][this.nz];
        this.connectzmin = new double[this.nx][this.ny][this.nz];
        this.connectzplus = new double[this.nx][this.ny][this.nz];
        this.connectxmin_f = new float[this.nz][this.ny][this.nx];
        this.connectxplus_f = new float[this.nz][this.ny][this.nx];
        this.connectymin_f = new float[this.nz][this.ny][this.nx];
        this.connectyplus_f = new float[this.nz][this.ny][this.nx];
        this.connectzmin_f = new float[this.nz][this.ny][this.nx];
        this.connectzplus_f = new float[this.nz][this.ny][this.nx];
        this.connectxmin_temp = new double[this.nx][this.ny][this.nz];
        this.connectxplus_temp = new double[this.nx][this.ny][this.nz];
        this.connectymin_temp = new double[this.nx][this.ny][this.nz];
        this.connectyplus_temp = new double[this.nx][this.ny][this.nz];
        this.connectzmin_temp = new double[this.nx][this.ny][this.nz];
        this.connectzplus_temp = new double[this.nx][this.ny][this.nz];
        this.connectxmin_temp_f = new float[this.nz][this.ny][this.nx];
        this.connectxplus_temp_f = new float[this.nz][this.ny][this.nx];
        this.connectymin_temp_f = new float[this.nz][this.ny][this.nx];
        this.connectyplus_temp_f = new float[this.nz][this.ny][this.nx];
        this.connectzmin_temp_f = new float[this.nz][this.ny][this.nx];
        this.connectzplus_temp_f = new float[this.nz][this.ny][this.nx];
        int k = 0;
        while (k < this.nz) {
            int j = 0;
            while (j < this.ny) {
                int i = 0;
                while (i < this.nx) {
                    int iBackward = i - 1;
                    iMinFound = false;
                    iMin = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && i > 0) {
                        while (!iMinFound && iBackward >= 0) {
                            if (this.actnumflow[iBackward][j][k] == 1.0) {
                                iMin = iBackward;
                                iMinFound = true;
                            }
                            --iBackward;
                        }
                    }
                    this.connectxmin[i][j][k] = iMin;
                    this.connectxmin_f[k][j][i] = (float)this.connectxmin[i][j][k];
                    int iBackwardTemp = i - 1;
                    iMinFoundTemp = false;
                    iMinTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && i > 0) {
                        while (!iMinFoundTemp && iBackwardTemp >= 0) {
                            if ((double)this.thickness_f[k][j][iBackwardTemp] > 1.0) {
                                iMinTemp = iBackwardTemp;
                                iMinFoundTemp = true;
                            }
                            --iBackwardTemp;
                        }
                    }
                    this.connectxmin_temp[i][j][k] = iMinTemp;
                    this.connectxmin_temp_f[k][j][i] = (float)this.connectxmin_temp[i][j][k];
                    int iForward = i + 1;
                    iPlusFound = false;
                    iPlus = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && i < this.nx - 1) {
                        while (!iPlusFound && iForward < this.nx) {
                            if (this.actnumflow[iForward][j][k] == 1.0) {
                                iPlus = iForward;
                                iPlusFound = true;
                            }
                            ++iForward;
                        }
                    }
                    this.connectxplus[i][j][k] = iPlus;
                    this.connectxplus_f[k][j][i] = (float)this.connectxplus[i][j][k];
                    int iForwardTemp = i + 1;
                    iPlusFoundTemp = false;
                    iPlusTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && i < this.nx - 1) {
                        while (!iPlusFoundTemp && iForwardTemp >= 0) {
                            if ((double)this.thickness_f[k][j][iForwardTemp] > 1.0) {
                                iPlusTemp = iForwardTemp;
                                iPlusFoundTemp = true;
                            }
                            --iForwardTemp;
                        }
                    }
                    this.connectxplus_temp[i][j][k] = iPlusTemp;
                    this.connectxplus_temp_f[k][j][i] = (float)this.connectxplus_temp[i][j][k];
                    int jBackward = j - 1;
                    jMinFound = false;
                    jMin = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && j > 0) {
                        while (!jMinFound && jBackward >= 0) {
                            if (this.actnumflow[i][jBackward][k] == 1.0) {
                                jMin = jBackward;
                                jMinFound = true;
                            }
                            --jBackward;
                        }
                    }
                    this.connectymin[i][j][k] = jMin;
                    this.connectymin_f[k][j][i] = (float)this.connectymin[i][j][k];
                    int jBackwardTemp = j - 1;
                    jMinFoundTemp = false;
                    jMinTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && j > 0) {
                        while (!jMinFoundTemp && jBackwardTemp >= 0) {
                            if ((double)this.thickness_f[k][jBackwardTemp][i] > 1.0) {
                                jMinTemp = jBackwardTemp;
                                jMinFoundTemp = true;
                            }
                            --jBackwardTemp;
                        }
                    }
                    this.connectymin_temp[i][j][k] = jMinTemp;
                    this.connectymin_temp_f[k][j][i] = (float)this.connectymin_temp[i][j][k];
                    int jForward = j + 1;
                    jPlusFound = false;
                    jPlus = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && j < this.ny - 1) {
                        while (!jPlusFound && jForward < this.ny) {
                            if (this.actnumflow[i][jForward][k] == 1.0) {
                                jPlus = jForward;
                                jPlusFound = true;
                            }
                            ++jForward;
                        }
                    }
                    this.connectyplus[i][j][k] = jPlus;
                    this.connectyplus_f[k][j][i] = (float)this.connectyplus[i][j][k];
                    int jForwardTemp = j + 1;
                    jPlusFoundTemp = false;
                    jPlusTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && j < this.ny - 1) {
                        while (!jPlusFoundTemp && jForwardTemp >= 0) {
                            if ((double)this.thickness_f[k][jForwardTemp][i] > 1.0) {
                                jPlusTemp = jForwardTemp;
                                jPlusFoundTemp = true;
                            }
                            --jForwardTemp;
                        }
                    }
                    this.connectyplus_temp[i][j][k] = jPlusTemp;
                    this.connectyplus_temp_f[k][j][i] = (float)this.connectyplus_temp[i][j][k];
                    int kBackward = k - 1;
                    kMinFound = false;
                    kMin = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && k > 0) {
                        while (!kMinFound && kBackward >= 0) {
                            if (this.actnumflow[i][j][kBackward] == 1.0) {
                                kMin = kBackward;
                                kMinFound = true;
                            }
                            --kBackward;
                        }
                    }
                    this.connectzmin[i][j][k] = kMin;
                    this.connectzmin_f[k][j][i] = (float)this.connectzmin[i][j][k];
                    int kBackwardTemp = k - 1;
                    kMinFoundTemp = false;
                    kMinTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && k > 0) {
                        while (!kMinFoundTemp && kBackwardTemp >= 0) {
                            if ((double)this.thickness_f[kBackwardTemp][j][i] > 1.0) {
                                kMinTemp = kBackwardTemp;
                                kMinFoundTemp = true;
                            }
                            --kBackwardTemp;
                        }
                    }
                    this.connectzmin_temp[i][j][k] = kMinTemp;
                    this.connectzmin_temp_f[k][j][i] = (float)this.connectzmin_temp[i][j][k];
                    int kForward = k + 1;
                    kPlusFound = false;
                    kPlus = -1.0f;
                    if (this.actnumflow[i][j][k] > 0.0 && k < this.nz - 1) {
                        while (!kPlusFound && kForward < this.nz) {
                            if (this.actnumflow[i][j][kForward] == 1.0) {
                                kPlus = kForward;
                                kPlusFound = true;
                            }
                            ++kForward;
                        }
                    }
                    this.connectzplus[i][j][k] = kPlus;
                    this.connectzplus_f[k][j][i] = (float)this.connectzplus[i][j][k];
                    int kForwardTemp = k + 1;
                    kPlusFoundTemp = false;
                    kPlusTemp = -1.0f;
                    if ((double)this.thickness_f[k][j][i] > 1.0 && k < this.nz - 1) {
                        while (!kPlusFoundTemp && kForwardTemp >= 0) {
                            if ((double)this.thickness_f[kForwardTemp][j][i] > 1.0) {
                                kPlusTemp = kForwardTemp;
                                kPlusFoundTemp = true;
                            }
                            --kForwardTemp;
                        }
                    }
                    this.connectzplus_temp[i][j][k] = kPlusTemp;
                    this.connectzplus_temp_f[k][j][i] = (float)this.connectzplus_temp[i][j][k];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        this.keywords.add(CONNECTXMIN);
        this.keywords.add(CONNECTXPLUS);
        this.keywords.add(CONNECTYMIN);
        this.keywords.add(CONNECTYPLUS);
        this.keywords.add(CONNECTZMIN);
        this.keywords.add(CONNECTZPLUS);
        this.keywords.add(CONNECTXMINTEMP);
        this.keywords.add(CONNECTXPLUSTEMP);
        this.keywords.add(CONNECTYMINTEMP);
        this.keywords.add(CONNECTYPLUSTEMP);
        this.keywords.add(CONNECTZMINTEMP);
        this.keywords.add(CONNECTZPLUSTEMP);
    }

    private void constructActnumFlow() {
        int k;
        int i;
        this.actnumflow = new double[this.nx][this.ny][this.nz];
        this.actnumflow_f = new float[this.nz][this.ny][this.nx];
        this.actnumtemp = new double[this.nx][this.ny][this.nz];
        this.actnumtemp_f = new float[this.nz][this.ny][this.nx];
        int j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                k = 0;
                while (k < this.nz) {
                    if ((double)this.thickness_f[k][j][i] > 1.0 && this.actnum_f[k][j][i] > 0.0f) {
                        this.actnumflow[i][j][k] = 1.0;
                        this.actnumflow_f[k][j][i] = (float)this.actnumflow[i][j][k];
                    } else {
                        this.actnumflow[i][j][k] = 0.0;
                        this.actnumflow_f[k][j][i] = (float)this.actnumflow[i][j][k];
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.keywords.add(ACTNUMFLOW);
        j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                k = 0;
                while (k < this.nz) {
                    if ((double)this.thickness_f[k][j][i] > 1.0) {
                        this.actnumtemp[i][j][k] = 1.0;
                        this.actnumtemp_f[k][j][i] = (float)this.actnumtemp[i][j][k];
                    } else {
                        this.actnumtemp[i][j][k] = 0.0;
                        this.actnumtemp_f[k][j][i] = (float)this.actnumtemp[i][j][k];
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.keywords.add(ACTNUMTEMP);
    }

    private void read_geometry() {
        this.keywords = new Vector();
        try {
            System.out.println("reading eclipse file " + this.filename);
            FileInputStream inputStream = new FileInputStream(this.filename);
            EclipseAsciiStream ast = new EclipseAsciiStream(inputStream, 4098);
            ast.setCommentType("--");
            ast.skipTag("NOECHO");
            ast.skipTag("/");
            String keyword = ast.readString();
            while (!keyword.equalsIgnoreCase("ECHO")) {
                if (keyword.equals("INCLUDE")) {
                    String path = ast.readString();
                    try {
                        File f = new File(this.filename);
                        FileInputStream inputStream2 = new FileInputStream(String.valueOf(f.getParent()) + "\\" + path.substring(1, path.length() - 1));
                        EclipseAsciiStream ast2 = new EclipseAsciiStream(inputStream2, 4098);
                        ast2.setCommentType("--");
                        String keyword2 = ast2.readString();
                        this.process_keywords(keyword2, ast2);
                        ast2.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(String.valueOf(path) + " not found");
                    }
                } else {
                    this.process_keywords(keyword, ast);
                }
                ast.skipTag("/");
                keyword = ast.readString();
            }
            ast.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process_keywords(String keyword, EclipseAsciiStream ast) throws IOException {
        int i;
        int k;
        if (keyword.equals("MAPAXES")) {
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
        }
        if (keyword.equals("SPECGRID")) {
            this.nx = Math.round(ast.readFloat());
            this.ny = Math.round(ast.readFloat());
            this.nz = Math.round(ast.readFloat());
        }
        if (keyword.equals("COORD")) {
            this.coordLine = new CoordLine[this.nx + 1][this.ny + 1];
            int j = 0;
            while (j < this.ny + 1) {
                int i2 = 0;
                while (i2 < this.nx + 1) {
                    double x1 = ast.readFloat();
                    double y1 = ast.readFloat();
                    double z1 = ast.readFloat();
                    double x2 = ast.readFloat();
                    double y2 = ast.readFloat();
                    double z2 = ast.readFloat();
                    this.coordLine[i2][j] = new CoordLine(x1, y1, z1, x2, y2, z2);
                    ++i2;
                }
                ++j;
            }
        }
        if (keyword.equals("ZCORN")) {
            this.zcornLine = new ZcornLine[this.nx][this.ny];
            double[][][] zcorn = new double[this.nx * 2][this.ny * 2][this.nz * 2];
            k = 0;
            while (k < 2 * this.nz) {
                int j = 0;
                while (j < 2 * this.ny) {
                    i = 0;
                    while (i < 2 * this.nx) {
                        zcorn[i][j][k] = ast.readFloat();
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            int j = 0;
            while (j < this.ny) {
                int i3 = 0;
                while (i3 < this.nx) {
                    this.zcornLine[i3][j] = new ZcornLine(this.nz, zcorn[2 * i3][2 * j], zcorn[2 * i3 + 1][2 * j], zcorn[2 * i3][2 * j + 1], zcorn[2 * i3 + 1][2 * j + 1]);
                    ++i3;
                }
                ++j;
            }
        }
        if (keyword.equals("ACTNUM")) {
            this.start_property_section = true;
            this.actnum = new int[this.nx][this.ny][this.nz];
            this.actnum_f = new float[this.nz][this.ny][this.nx];
            k = 0;
            while (k < this.nz) {
                int j = 0;
                while (j < this.ny) {
                    i = 0;
                    while (i < this.nx) {
                        float v = ast.readFloat();
                        this.actnum[i][j][k] = Math.round(v);
                        this.actnum_f[k][j][i] = v;
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            this.keywords.add(ACTNUM);
        } else if (this.start_property_section) {
            this.keywords.add(keyword);
        }
    }

    private void calcdxdyandtopgrid() {
        int k;
        int i;
        CoordLine zc0 = this.coordLine[0][0];
        CoordLine zcx = this.coordLine[this.nx][0];
        CoordLine zcy = this.coordLine[0][this.ny];
        zcx.p1.sub(zc0.p1);
        Vector3f t = new Vector3f(zcx.p1);
        this.dx = (double)t.length() / (1.0 * (double)this.nx);
        zcy.p1.sub(zc0.p1);
        t = new Vector3f(zcy.p1);
        this.dy = (double)t.length() / (1.0 * (double)this.ny);
        this.topgrid_f = new float[this.nx][this.ny];
        this.thickness_f = new float[this.nz][this.ny][this.nx];
        double z1 = 0.0;
        double z2 = 0.0;
        int j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                k = 0;
                while (k < this.nz) {
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    double th = z2 - z1;
                    if (th < 0.0) {
                        if (this.actnum[i][j][k] == 0) {
                            double[] zc1 = this.zcornLine[i][j].zc1;
                            double[] zc2 = this.zcornLine[i][j].zc2;
                            double[] zc3 = this.zcornLine[i][j].zc3;
                            double[] zc4 = this.zcornLine[i][j].zc4;
                            this.checkLine(zc1, i, j);
                            this.checkLine(zc2, i, j);
                            this.checkLine(zc3, i, j);
                            this.checkLine(zc4, i, j);
                        } else {
                            System.out.println("error illegal thickness for cell : " + th + "    i " + i + "  j " + j + "  k " + k);
                        }
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                this.topgrid_f[i][j] = (float)(0.25 * (this.zcornLine[i][j].zc1[0] + this.zcornLine[i][j].zc2[0] + this.zcornLine[i][j].zc3[0] + this.zcornLine[i][j].zc4[0]));
                k = 0;
                while (k < this.nz) {
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    this.thickness_f[k][j][i] = (float)(z2 - z1);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.keywords.add(THICKNESS);
    }

    private void checkLine(double[] zc1, int i, int j) {
        boolean found = false;
        boolean connecttotop = true;
        int k = 0;
        while (k < this.nz) {
            if (this.actnum[i][j][k] == 0) {
                if (connecttotop) {
                    int ifound = this.nz - 1;
                    int ki = k;
                    while (ki < this.nz - 1) {
                        if (this.actnum[i][j][++ki] != 1) continue;
                        ifound = ki;
                    }
                    zc1[2 * k + 1] = zc1[2 * ifound];
                    connecttotop = false;
                } else {
                    zc1[2 * k] = zc1[2 * (k - 1) + 1];
                    zc1[2 * k + 1] = zc1[2 * k];
                }
                found = true;
            } else {
                connecttotop = true;
            }
            ++k;
        }
        int ks = 2;
    }

    private float[][][] readSingleProperty(String key) {
        float[][][] propertyValues = new float[this.nz][this.ny][this.nx];
        try {
            FileInputStream inputStream = new FileInputStream(this.filename);
            EclipseAsciiStream ast = new EclipseAsciiStream(inputStream, 4098);
            ast.setCommentType("--");
            ast.skipTag("NOECHO");
            ast.skipTag("/");
            String keyword = ast.readString();
            while (!keyword.equalsIgnoreCase("ECHO")) {
                if (keyword.equals("INCLUDE")) {
                    String path = ast.readString();
                    try {
                        File f = new File(this.filename);
                        FileInputStream inputStream2 = new FileInputStream(String.valueOf(f.getParent()) + "\\" + path.substring(1, path.length() - 1));
                        EclipseAsciiStream ast2 = new EclipseAsciiStream(inputStream, 4098);
                        ast2.setCommentType("--");
                        String keyword2 = ast2.readString();
                        if (keyword2.equals(key)) {
                            int k = 0;
                            while (k < this.nz) {
                                int j = 0;
                                while (j < this.ny) {
                                    int i = 0;
                                    while (i < this.nx) {
                                        propertyValues[k][j][i] = ast.readFloat();
                                        ++i;
                                    }
                                    ++j;
                                }
                                ++k;
                            }
                        }
                        ast2.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(String.valueOf(path) + " not found");
                    }
                } else if (keyword.equals(key)) {
                    int k = 0;
                    while (k < this.nz) {
                        int j = 0;
                        while (j < this.ny) {
                            int i = 0;
                            while (i < this.nx) {
                                propertyValues[k][j][i] = ast.readFloat();
                                ++i;
                            }
                            ++j;
                        }
                        ++k;
                    }
                }
                ast.skipTag("/");
                keyword = ast.readString();
            }
            ast.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertyValues;
    }

    public static void main(String[] args) {
        String f = "R:\\_lilya\\pinch_out.GRDECL";
        EclipseGrid egr = new EclipseGrid(f);
        Vector<String> kws = egr.keywords;
        System.out.println(kws);
        for (String kw : kws) {
            Voxet v = egr.getPropertyVoxet(kw);
            v.setFileName("R:\\_lilya\\" + kw);
            v.setUnknown(-999.25f);
            VoxetWriter.write(v);
        }
    }
}

