/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Set;
import javax.vecmath.Vector3f;
import tno.geoenergy.data.CoordLine;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.ZcornLine;
import tno.geoenergy.util.EclipseAsciiStream;

public class EclipseGridReader {
    double mapx = 0.0;
    double mapy = 0.0;
    int nx = 0;
    int ny = 0;
    int nz = 0;
    CoordLine[][] coordLine = null;
    ZcornLine[][] zcornLine = null;
    double[][] topgrid = null;
    float[][] topgrid_f = null;
    double[][][] thickness = null;
    float[][][] thickness_f = null;
    int[][][] actnum = null;
    float[][][] actnum_f = null;
    HashMap<String, float[][][]> properties = new HashMap();
    private double dx;
    private double dy;

    public EclipseGridReader(String filename) {
        try {
            System.out.println("reading eclipse file " + filename);
            FileInputStream inputStream = new FileInputStream(filename);
            EclipseAsciiStream ast = new EclipseAsciiStream(inputStream, 4098);
            ast.setCommentType("--");
            ast.skipTag("MAPAXES");
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
            ast.skipTag("SPECGRID");
            this.nx = Math.round(ast.readFloat());
            this.ny = Math.round(ast.readFloat());
            this.nz = Math.round(ast.readFloat());
            this.coordLine = new CoordLine[this.nx + 1][this.ny + 1];
            ast.skipTag("COORD");
            ast.skipTag("COORD");
            int j = 0;
            while (j < this.ny + 1) {
                int i = 0;
                while (i < this.nx + 1) {
                    double x1 = ast.readFloat();
                    double y1 = ast.readFloat();
                    double z1 = ast.readFloat();
                    double x2 = ast.readFloat();
                    double y2 = ast.readFloat();
                    double z2 = ast.readFloat();
                    this.coordLine[i][j] = new CoordLine(x1, y1, z1, x2, y2, z2);
                    ++i;
                }
                ++j;
            }
            ast.skipTag("ZCORN");
            this.zcornLine = new ZcornLine[this.nx][this.ny];
            double[][][] zcorn = new double[this.nx * 2][this.ny * 2][this.nz * 2];
            int k = 0;
            while (k < 2 * this.nz) {
                int j2 = 0;
                while (j2 < 2 * this.ny) {
                    int i = 0;
                    while (i < 2 * this.nx) {
                        zcorn[i][j2][k] = ast.readFloat();
                        ++i;
                    }
                    ++j2;
                }
                ++k;
            }
            int j3 = 0;
            while (j3 < this.ny) {
                int i = 0;
                while (i < this.nx) {
                    this.zcornLine[i][j3] = new ZcornLine(this.nz, zcorn[2 * i][2 * j3], zcorn[2 * i + 1][2 * j3], zcorn[2 * i][2 * j3 + 1], zcorn[2 * i + 1][2 * j3 + 1]);
                    ++i;
                }
                ++j3;
            }
            ast.skipTag("ACTNUM");
            this.actnum = new int[this.nx][this.ny][this.nz];
            this.actnum_f = new float[this.nz][this.ny][this.nx];
            int k2 = 0;
            while (k2 < this.nz) {
                int j4 = 0;
                while (j4 < this.ny) {
                    int i = 0;
                    while (i < this.nx) {
                        float v = ast.readFloat();
                        this.actnum[i][j4][k2] = Math.round(v);
                        this.actnum_f[k2][j4][i] = v;
                        ++i;
                    }
                    ++j4;
                }
                ++k2;
            }
            this.properties.put("ACTNUM", this.actnum_f);
            ast.skipTag("/");
            String propertyName = ast.readString();
            while (!propertyName.equalsIgnoreCase("ECHO")) {
                float[][][] propertyValues = new float[this.nz][this.ny][this.nx];
                int k3 = 0;
                while (k3 < this.nz) {
                    int j5 = 0;
                    while (j5 < this.ny) {
                        int i = 0;
                        while (i < this.nx) {
                            propertyValues[k3][j5][i] = ast.readFloat();
                            ++i;
                        }
                        ++j5;
                    }
                    ++k3;
                }
                this.properties.put(propertyName, propertyValues);
                ast.skipTag("/");
                propertyName = ast.readString();
            }
            ast.close();
            this.getdxdyandtopgrid();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }

    public Grid getTopGrid() {
        Grid g = new Grid();
        g.nx = this.nx;
        g.ny = this.ny;
        g.originx = (float)(this.mapx + 0.5 * this.dx);
        g.originy = (float)(this.mapy - ((double)this.ny - 0.5) * this.dy);
        g.dx = (float)this.dx;
        g.dy = (float)this.dy;
        g.unknown = -999.25f;
        g.values = this.topgrid_f;
        return g;
    }

    public Voxet getThickness() {
        return this.getPropertyVoxet("THICKNESS");
    }

    public Voxet getActnum() {
        return this.getPropertyVoxet("ACTNUM");
    }

    public Voxet getPropertyVoxet(String propertyKey) {
        Voxet v = new Voxet();
        v.setNx(this.nx);
        v.setNy(this.ny);
        v.setNz(this.nz);
        v.setOriginx((float)(this.mapx + 0.5 * this.dx));
        v.setOriginy((float)(this.mapy - ((double)this.ny - 0.5) * this.dy));
        v.setOriginz(0.0f);
        v.setDx((float)this.dx);
        v.setDy((float)this.dy);
        v.setDz(1.0f);
        v.setValues(new float[this.nz][this.ny][this.nx]);
        if (propertyKey != null) {
            v.setPropName(propertyKey);
            v.setFileName("*" + propertyKey);
            v.setValues(this.properties.get(propertyKey));
        }
        return v;
    }

    public Voxet getGeomVoxet() {
        return this.getPropertyVoxet(null);
    }

    private void getdxdyandtopgrid() {
        int k;
        int i;
        CoordLine zc0 = this.coordLine[0][0];
        CoordLine zcx = this.coordLine[this.nx][0];
        CoordLine zcy = this.coordLine[0][this.ny];
        zcx.p1.sub(zc0.p1);
        Vector3f t = new Vector3f(zcx.p1);
        this.dx = (double)t.length() / (1.0 * (double)this.nx);
        zcy.p1.sub(zc0.p1);
        t = new Vector3f(zcy.p1);
        this.dy = (double)t.length() / (1.0 * (double)this.ny);
        this.topgrid = new double[this.nx][this.ny];
        this.topgrid_f = new float[this.nx][this.ny];
        this.thickness = new double[this.nx][this.ny][this.nz];
        this.thickness_f = new float[this.nz][this.ny][this.nx];
        double z1 = 0.0;
        double z2 = 0.0;
        int j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                k = 0;
                while (k < this.nz) {
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    double th = z2 - z1;
                    if (th < 0.0) {
                        if (this.actnum[i][j][k] == 0) {
                            double[] zc1 = this.zcornLine[i][j].zc1;
                            double[] zc2 = this.zcornLine[i][j].zc2;
                            double[] zc3 = this.zcornLine[i][j].zc3;
                            double[] zc4 = this.zcornLine[i][j].zc4;
                            this.checkLine(zc1, i, j);
                            this.checkLine(zc2, i, j);
                            this.checkLine(zc3, i, j);
                            this.checkLine(zc4, i, j);
                        } else {
                            System.out.println("error illegal thickness for cell : " + th + "    i " + i + "  j " + j + "  k " + k);
                        }
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                this.topgrid[i][j] = 0.25 * (this.zcornLine[i][j].zc1[0] + this.zcornLine[i][j].zc2[0] + this.zcornLine[i][j].zc3[0] + this.zcornLine[i][j].zc4[0]);
                this.topgrid_f[i][j] = (float)(0.25 * (this.zcornLine[i][j].zc1[0] + this.zcornLine[i][j].zc2[0] + this.zcornLine[i][j].zc3[0] + this.zcornLine[i][j].zc4[0]));
                k = 0;
                while (k < this.nz) {
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    this.thickness[i][j][k] = z2 - z1;
                    this.thickness_f[k][j][i] = (float)(z2 - z1);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.properties.put("THICKNESS", this.thickness_f);
    }

    private void checkLine(double[] zc1, int i, int j) {
        boolean found = false;
        boolean connecttotop = true;
        int k = 0;
        while (k < this.nz) {
            if (this.actnum[i][j][k] == 0) {
                if (connecttotop) {
                    int ifound = this.nz - 1;
                    int ki = k;
                    while (ki < this.nz - 1) {
                        if (this.actnum[i][j][++ki] != 1) continue;
                        ifound = ki;
                    }
                    zc1[2 * k + 1] = zc1[2 * ifound];
                    connecttotop = false;
                } else {
                    zc1[2 * k] = zc1[2 * (k - 1) + 1];
                    zc1[2 * k + 1] = zc1[2 * k];
                }
                found = true;
            } else {
                connecttotop = true;
            }
            ++k;
        }
        int ks = 2;
    }

    public void getGrid3D() {
    }

    public EclipseGridReader() {
    }

    public static void main(String[] args) {
        String f = "D:\\Projects\\DC2D3D\\export\\berkel_simple2.GRDECL";
        EclipseGridReader egr = new EclipseGridReader(f);
        System.out.println(egr.getPropertyNames());
        System.out.println(String.valueOf(egr.nx) + " " + egr.ny + " " + egr.nz);
        System.out.println(String.valueOf(egr.dx) + " " + egr.dy);
        double ox = egr.mapx + 0.5 * egr.dx;
        double oy = egr.mapy - ((double)egr.ny - 0.5) * egr.dy;
        double mx = ox + egr.dx * (double)egr.nx;
        double my = oy + egr.dy * (double)egr.ny;
        System.out.println(String.valueOf(ox) + " " + oy);
        System.out.println(String.valueOf(mx) + " " + my);
    }
}

