/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Vector3f;
import tno.geoenergy.data.CoordLine;
import tno.geoenergy.data.EclipseGrid;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.data.ZcornLine;
import tno.geoenergy.util.EclipseAsciiStream;

public class EclipseGrid_org {
    public static String TOPGRID = "TOPGRID";
    public static String THICKNESS = "THICKNESS";
    public static String ACTNUM = "ACTNUM";
    public double originx;
    public double originy;
    public double originz;
    private double mapx;
    private double mapy;
    public int nx;
    public int ny;
    public int nz;
    public double dx;
    public double dy;
    public double dz;
    CoordLine[][] coordLine = null;
    ZcornLine[][] zcornLine = null;
    int[][][] actnum = null;
    float[][][] actnum_f = null;
    float[][] topgrid_f = null;
    float[][][] thickness_f = null;
    public String filename;
    public Vector<String> keywords;
    private boolean start_property_section = false;

    public EclipseGrid_org(String filename) {
        this.filename = filename;
        this.read_geometry();
        this.calcdxdyandtopgrid();
    }

    public EclipseGrid_org(String filename, boolean readonlygeom) {
        this.filename = filename;
        this.read_geometry();
    }

    public Grid getTopGrid() {
        Grid g = new Grid();
        g.nx = this.nx;
        g.ny = this.ny;
        g.originx = (float)(this.mapx + 0.5 * this.dx);
        g.originy = (float)(this.mapy - ((double)this.ny - 0.5) * this.dy);
        g.dx = (float)this.dx;
        g.dy = (float)this.dy;
        g.unknown = -999.25f;
        g.values = this.topgrid_f;
        return g;
    }

    public Voxet getPropertyVoxet(String propertyKey) {
        Voxet v = new Voxet();
        v.setNx(this.nx);
        v.setNy(this.ny);
        v.setNz(this.nz);
        v.setOriginx((float)(this.mapx + 0.5 * this.dx));
        v.setOriginy((float)(this.mapy - ((double)this.ny - 0.5) * this.dy));
        v.setOriginz(0.0f);
        v.setDx((float)this.dx);
        v.setDy((float)this.dy);
        v.setDz(1.0f);
        v.setValues(new float[this.nz][this.ny][this.nx]);
        if (propertyKey != null) {
            v.setPropName(propertyKey);
            if (propertyKey.equals(THICKNESS)) {
                v.setValues(this.thickness_f);
            } else if (propertyKey.equals(ACTNUM)) {
                v.setValues(this.actnum_f);
            } else {
                v.setValues(this.readSingleProperty(propertyKey));
            }
        }
        return v;
    }

    public Voxet getGeomVoxet() {
        return this.getPropertyVoxet(null);
    }

    private void read_geometry() {
        this.keywords = new Vector();
        try {
            System.out.println("reading eclipse file " + this.filename);
            FileInputStream inputStream = new FileInputStream(this.filename);
            EclipseAsciiStream ast = new EclipseAsciiStream(inputStream, 4098);
            ast.setCommentType("--");
            ast.skipTag("NOECHO");
            ast.skipTag("/");
            String keyword = ast.readString();
            while (!keyword.equalsIgnoreCase("ECHO")) {
                if (keyword.equals("INCLUDE")) {
                    String path = ast.readString();
                    try {
                        File f = new File(this.filename);
                        FileInputStream inputStream2 = new FileInputStream(String.valueOf(f.getParent()) + "\\" + path.substring(1, path.length() - 1));
                        EclipseAsciiStream ast2 = new EclipseAsciiStream(inputStream2, 4098);
                        ast2.setCommentType("--");
                        String keyword2 = ast2.readString();
                        this.process_keywords(keyword2, ast2);
                        ast2.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(String.valueOf(path) + " not found");
                    }
                } else {
                    this.process_keywords(keyword, ast);
                }
                ast.skipTag("/");
                keyword = ast.readString();
            }
            ast.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process_keywords(String keyword, EclipseAsciiStream ast) throws IOException {
        int i;
        int k;
        if (keyword.equals("MAPAXIS")) {
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
            this.mapx = ast.readFloat();
            this.mapy = ast.readFloat();
        }
        if (keyword.equals("SPECGRID")) {
            this.nx = Math.round(ast.readFloat());
            this.ny = Math.round(ast.readFloat());
            this.nz = Math.round(ast.readFloat());
        }
        if (keyword.equals("COORD")) {
            this.coordLine = new CoordLine[this.nx + 1][this.ny + 1];
            int j = 0;
            while (j < this.ny + 1) {
                int i2 = 0;
                while (i2 < this.nx + 1) {
                    double x1 = ast.readFloat();
                    double y1 = ast.readFloat();
                    double z1 = ast.readFloat();
                    double x2 = ast.readFloat();
                    double y2 = ast.readFloat();
                    double z2 = ast.readFloat();
                    this.coordLine[i2][j] = new CoordLine(x1, y1, z1, x2, y2, z2);
                    ++i2;
                }
                ++j;
            }
        }
        if (keyword.equals("ZCORN")) {
            this.zcornLine = new ZcornLine[this.nx][this.ny];
            double[][][] zcorn = new double[this.nx * 2][this.ny * 2][this.nz * 2];
            k = 0;
            while (k < 2 * this.nz) {
                int j = 0;
                while (j < 2 * this.ny) {
                    i = 0;
                    while (i < 2 * this.nx) {
                        zcorn[i][j][k] = ast.readFloat();
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            int j = 0;
            while (j < this.ny) {
                int i3 = 0;
                while (i3 < this.nx) {
                    this.zcornLine[i3][j] = new ZcornLine(this.nz, zcorn[2 * i3][2 * j], zcorn[2 * i3 + 1][2 * j], zcorn[2 * i3][2 * j + 1], zcorn[2 * i3 + 1][2 * j + 1]);
                    ++i3;
                }
                ++j;
            }
        }
        if (keyword.equals("ACTNUM")) {
            this.start_property_section = true;
            this.actnum = new int[this.nx][this.ny][this.nz];
            this.actnum_f = new float[this.nz][this.ny][this.nx];
            k = 0;
            while (k < this.nz) {
                int j = 0;
                while (j < this.ny) {
                    i = 0;
                    while (i < this.nx) {
                        float v = ast.readFloat();
                        this.actnum[i][j][k] = Math.round(v);
                        this.actnum_f[k][j][i] = v;
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            this.keywords.add(ACTNUM);
        } else if (this.start_property_section) {
            this.keywords.add(keyword);
        }
    }

    private void calcdxdyandtopgrid() {
        int k;
        int i;
        CoordLine zc0 = this.coordLine[0][0];
        CoordLine zcx = this.coordLine[this.nx][0];
        CoordLine zcy = this.coordLine[0][this.ny];
        zcx.p1.sub(zc0.p1);
        Vector3f t = new Vector3f(zcx.p1);
        this.dx = (double)t.length() / (1.0 * (double)this.nx);
        zcy.p1.sub(zc0.p1);
        t = new Vector3f(zcy.p1);
        this.dy = (double)t.length() / (1.0 * (double)this.ny);
        this.topgrid_f = new float[this.nx][this.ny];
        this.thickness_f = new float[this.nz][this.ny][this.nx];
        double z1 = 0.0;
        double z2 = 0.0;
        int j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                k = 0;
                while (k < this.nz) {
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    double th = z2 - z1;
                    if (th < 0.0) {
                        if (this.actnum[i][j][k] == 0) {
                            double[] zc1 = this.zcornLine[i][j].zc1;
                            double[] zc2 = this.zcornLine[i][j].zc2;
                            double[] zc3 = this.zcornLine[i][j].zc3;
                            double[] zc4 = this.zcornLine[i][j].zc4;
                            this.checkLine(zc1, i, j);
                            this.checkLine(zc2, i, j);
                            this.checkLine(zc3, i, j);
                            this.checkLine(zc4, i, j);
                        } else {
                            System.out.println("error illegal thickness for cell : " + th + "    i " + i + "  j " + j + "  k " + k);
                        }
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                this.topgrid_f[i][j] = (float)(0.25 * (this.zcornLine[i][j].zc1[0] + this.zcornLine[i][j].zc2[0] + this.zcornLine[i][j].zc3[0] + this.zcornLine[i][j].zc4[0]));
                k = 0;
                while (k < this.nz) {
                    z1 = 0.25 * (this.zcornLine[i][j].zc1[2 * k] + this.zcornLine[i][j].zc2[2 * k] + this.zcornLine[i][j].zc3[2 * k] + this.zcornLine[i][j].zc4[2 * k]);
                    z2 = 0.25 * (this.zcornLine[i][j].zc1[2 * k + 1] + this.zcornLine[i][j].zc2[2 * k + 1] + this.zcornLine[i][j].zc3[2 * k + 1] + this.zcornLine[i][j].zc4[2 * k + 1]);
                    this.thickness_f[k][j][i] = (float)(z2 - z1);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        this.keywords.add(THICKNESS);
    }

    private void checkLine(double[] zc1, int i, int j) {
        boolean found = false;
        boolean connecttotop = true;
        int k = 0;
        while (k < this.nz) {
            if (this.actnum[i][j][k] == 0) {
                if (connecttotop) {
                    int ifound = this.nz - 1;
                    int ki = k;
                    while (ki < this.nz - 1) {
                        if (this.actnum[i][j][++ki] != 1) continue;
                        ifound = ki;
                    }
                    zc1[2 * k + 1] = zc1[2 * ifound];
                    connecttotop = false;
                } else {
                    zc1[2 * k] = zc1[2 * (k - 1) + 1];
                    zc1[2 * k + 1] = zc1[2 * k];
                }
                found = true;
            } else {
                connecttotop = true;
            }
            ++k;
        }
        int ks = 2;
    }

    private float[][][] readSingleProperty(String key) {
        float[][][] propertyValues = new float[this.nz][this.ny][this.nx];
        try {
            FileInputStream inputStream = new FileInputStream(this.filename);
            EclipseAsciiStream ast = new EclipseAsciiStream(inputStream, 4098);
            ast.setCommentType("--");
            ast.skipTag("NOECHO");
            ast.skipTag("/");
            String keyword = ast.readString();
            while (!keyword.equalsIgnoreCase("ECHO")) {
                if (keyword.equals("INCLUDE")) {
                    String path = ast.readString();
                    try {
                        File f = new File(this.filename);
                        FileInputStream inputStream2 = new FileInputStream(String.valueOf(f.getParent()) + "\\" + path.substring(1, path.length() - 1));
                        EclipseAsciiStream ast2 = new EclipseAsciiStream(inputStream, 4098);
                        ast2.setCommentType("--");
                        String keyword2 = ast2.readString();
                        if (keyword2.equals(key)) {
                            int k = 0;
                            while (k < this.nz) {
                                int j = 0;
                                while (j < this.ny) {
                                    int i = 0;
                                    while (i < this.nx) {
                                        propertyValues[k][j][i] = ast.readFloat();
                                        ++i;
                                    }
                                    ++j;
                                }
                                ++k;
                            }
                        }
                        ast2.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(String.valueOf(path) + " not found");
                    }
                } else if (keyword.equals(key)) {
                    int k = 0;
                    while (k < this.nz) {
                        int j = 0;
                        while (j < this.ny) {
                            int i = 0;
                            while (i < this.nx) {
                                propertyValues[k][j][i] = ast.readFloat();
                                ++i;
                            }
                            ++j;
                        }
                        ++k;
                    }
                }
                ast.skipTag("/");
                keyword = ast.readString();
            }
            ast.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertyValues;
    }

    public static void main(String[] args) {
        String f = "R:\\_lilya\\pinch_out.GRDECL";
        EclipseGrid egr = new EclipseGrid(f);
        Vector<String> kws = egr.keywords;
        System.out.println(kws);
        for (String kw : kws) {
            Voxet v = egr.getPropertyVoxet(kw);
            v.setFileName("R:\\_lilya\\" + kw);
            v.setUnknown(-999.25f);
            VoxetWriter.write(v);
        }
    }

    public CoordLine[][] getCoordLine() {
        return this.coordLine;
    }

    public ZcornLine[][] getZcornLine() {
        return this.zcornLine;
    }
}

