/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Point3f;
import tno.geoenergy.util.ProcessException;

public abstract class Geodata {
    private float unitX;
    private float unitY;
    private float unitZ;
    public float xlow;
    public float xhigh;
    public float ylow;
    public float yhigh;
    public float zlow;
    public float zhigh;
    private String fileName;
    private String dataFormat;
    int SKIPZYCORLINES = 4;

    public Geodata(float ux, float uy, float uz) {
        this.setUnitX(ux);
        this.setUnitY(uy);
        this.setUnitZ(uz);
        this.xlow = Float.MAX_VALUE;
        this.ylow = Float.MAX_VALUE;
        this.zlow = Float.MAX_VALUE;
        this.xhigh = Float.MIN_VALUE;
        this.yhigh = Float.MIN_VALUE;
        this.zhigh = Float.MIN_VALUE;
    }

    public Geodata() {
        this(1.0f, 1.0f, 1.0f);
    }

    public Geodata(float ux, float uy, float uz, String format) {
        this(ux, uy, uz);
        this.setDataFormat(format);
    }

    public Geodata(float ux, float uy, float uz, String format, InputStream inputStream) throws ProcessException {
        this(ux, uy, uz, format);
        this.read(inputStream);
    }

    public Geodata(float ux, float uy, float uz, String format, String file) throws ProcessException, FileNotFoundException {
        this(ux, uy, uz, format);
        this.setFileName(file);
        this.read(file);
    }

    public Geodata(float ux, float uy, float uz, String format, String file, Object o) throws ProcessException, FileNotFoundException {
        this(ux, uy, uz, format);
        this.setFileName(file);
        this.preRead(o);
        this.read(file);
    }

    public Geodata(float ux, float uy, float uz, String format, InputStream inputStream, Object o) throws ProcessException {
        this(ux, uy, uz, format);
        this.preRead(o);
        this.read(inputStream);
    }

    public Geodata(float ux, float uy, float uz, String format, InputStream inputStream, String file, Object o) throws ProcessException {
        this(ux, uy, uz, format);
        this.setFileName(file);
        this.preRead(o);
        this.read(inputStream);
    }

    protected void preRead(Object o) {
    }

    public abstract void determine_low_high();

    public void setUnitX(float ux) {
        if (ux <= 0.0f) {
            System.err.println("setunitX ( " + ux + " ): ignored! argument should be > 0");
        } else {
            this.unitX = ux;
        }
    }

    public void setUnitY(float uy) {
        if (uy <= 0.0f) {
            System.err.println("setunitX ( " + uy + " ): ignored! argument should be > 0");
        } else {
            this.unitY = uy;
        }
    }

    public void setUnitZ(float uz) {
        this.unitZ = uz;
    }

    public float getUnitX() {
        return this.unitX;
    }

    public float getUnitY() {
        return this.unitY;
    }

    public float getUnitZ() {
        return this.unitZ;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameNoExtension() {
        String gridname = this.fileName;
        int index = gridname.lastIndexOf(".");
        if (index >= 0) {
            gridname = gridname.substring(0, index);
        }
        return gridname;
    }

    public void setDataFormat(String f) {
        this.dataFormat = f;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public float x2si(float x) {
        return x * this.unitX;
    }

    public float y2si(float y) {
        return y * this.unitY;
    }

    public float z2si(float z) {
        return z * this.unitZ;
    }

    public float si2x(float x) {
        return x / this.unitX;
    }

    public float si2y(float y) {
        return y / this.unitY;
    }

    public float si2z(float z) {
        return z / this.unitZ;
    }

    public double si2x(double x) {
        return x / (double)this.unitX;
    }

    public double si2y(double y) {
        return y / (double)this.unitY;
    }

    public double si2z(double z) {
        return z / (double)this.unitZ;
    }

    public Point3f minXyz() {
        return new Point3f(this.xlow, this.ylow, this.zlow);
    }

    public Point3f maxXyz() {
        return new Point3f(this.xhigh, this.yhigh, this.zhigh);
    }

    protected void read(String file) throws FileNotFoundException, ProcessException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            try {
                this.SKIPZYCORLINES = 4;
                this.read(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.SKIPZYCORLINES = 6;
                inputStream = new FileInputStream(file);
                this.read(inputStream);
            }
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        this.setFileName(file);
    }

    public abstract void read(InputStream var1) throws ProcessException;
}

