/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import com.jhlabs.map.proj.Projection;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import tno.geoenergy.data.Geodata;
import tno.geoenergy.projection.ProjectionConverter;
import tno.geoenergy.projection.TnoProjectionFactory;
import tno.geoenergy.projection.UTM2RD;
import tno.geoenergy.util.AsciiOut;
import tno.geoenergy.util.AsciiStream;
import tno.geoenergy.util.ByteBufferHelper;
import tno.geoenergy.util.ProcessException;

public class Grid
extends Geodata {
    public float originx;
    public float originy;
    public float azimuth;
    public float dx;
    public float dy;
    public int nx;
    public int ny;
    public float unknown;
    public float[][] values;
    public static float[][] zlevel = null;

    public Grid() {
    }

    public Grid(String filename) {
        Grid m_Grid = null;
        if (filename.endsWith("asc") || filename.endsWith("ASC") || filename.endsWith("arc") || filename.endsWith("ARC")) {
            try {
                try {
                    System.out.println("reading ARC");
                    m_Grid = new Grid(1.0f, 1.0f, 1.0f, "ARC", filename);
                }
                catch (FileNotFoundException e) {
                    System.err.println("ARC Exception  " + e);
                }
            }
            catch (Exception e2) {
                m_Grid = null;
                System.err.println("Exception  " + e2);
            }
        }
        if (filename.endsWith("grd") || filename.endsWith("GRD")) {
            try {
                try {
                    m_Grid = new Grid(1.0f, 1.0f, 1.0f, "SURFER", filename);
                }
                catch (FileNotFoundException e) {
                    m_Grid = null;
                    System.err.println("SURFER Exception  " + e);
                }
            }
            catch (Exception e2) {
                System.err.println("Exception  " + e2);
            }
        }
        if (filename.endsWith("bin") || filename.endsWith("BIN")) {
            try {
                System.out.println("reading BIN");
                m_Grid = Grid.readBinGrid(filename);
            }
            catch (Exception e2) {
                System.err.println("BIN reader Exception  " + e2);
            }
        }
        if (m_Grid == null) {
            try {
                try {
                    System.out.println("reading ZYCOR");
                    m_Grid = new Grid(1.0f, 1.0f, 1.0f, "ZYCOR", filename);
                }
                catch (FileNotFoundException e) {
                    System.err.println("ZYCOR Exception  " + e);
                }
            }
            catch (ProcessException e2) {
                System.err.println("Exception  " + e2);
            }
        }
        this.setFileName(m_Grid.getFileName());
        this.setDataFormat(m_Grid.getDataFormat());
        this.values = m_Grid.values;
        this.nx = m_Grid.nx;
        this.ny = m_Grid.ny;
        this.unknown = m_Grid.unknown;
        this.originx = m_Grid.originx;
        this.originy = m_Grid.originy;
        this.dx = m_Grid.dx;
        this.dy = m_Grid.dy;
    }

    public Grid(float ux, float uy, float uz) {
        super(ux, uy, uz);
    }

    public Grid(float ux, float uy, float uz, String format, String file) throws FileNotFoundException, ProcessException {
        super(ux, uy, uz, format, file);
    }

    public Grid(float ux, float uy, float uz, String format, InputStream inputStream) throws ProcessException {
        super(ux, uy, uz, format, inputStream);
    }

    public Grid(float voriginx, float voriginy, float vazimuth, float vdx, float vdy, int vnx, int vny, float vunknown) {
        this.originx = voriginx;
        this.originy = voriginy;
        this.azimuth = vazimuth;
        this.dx = vdx;
        this.dy = vdy;
        this.nx = vnx;
        this.ny = vny;
        this.unknown = vunknown;
        this.values = new float[vnx][vny];
        this.valuesToUnknown();
    }

    public Grid(Grid s) {
        this.setUnitX(s.getUnitX());
        this.setUnitY(s.getUnitY());
        this.setUnitZ(s.getUnitZ());
        this.setFileName(s.getFileName());
        this.setDataFormat(s.getDataFormat());
        this.originx = s.originx;
        this.originy = s.originy;
        this.azimuth = s.azimuth;
        this.dx = s.dx;
        this.dy = s.dy;
        this.nx = s.nx;
        this.ny = s.ny;
        this.unknown = s.unknown;
        this.xlow = s.xlow;
        this.xhigh = s.xhigh;
        this.ylow = s.ylow;
        this.yhigh = s.yhigh;
        this.zlow = s.zlow;
        this.zhigh = s.zhigh;
        this.values = new float[this.nx][this.ny];
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                this.values[i][j] = s.values[i][j];
                ++i;
            }
            ++j;
        }
    }

    public void interpolateUndefined(int niter, int lod, Grid mask) {
        if (niter > 0) {
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    defined[i][j] = this.defined(i, j);
                    if (!defined[i][j]) {
                        this.values[i][j] = 0.0f;
                    }
                    ++j;
                }
                ++i;
            }
            int k = lod;
            while (k >= 0) {
                int kstep = (int)Math.pow(2.0, k);
                int iter = 0;
                while (iter < niter / kstep) {
                    int i2 = 0;
                    while (i2 < this.nx) {
                        int j = 0;
                        while (j < this.ny) {
                            if (!(defined[i2][j] || mask != null && mask.values[i2][j] == 1.0f)) {
                                int ncount = 0;
                                float sum = 0.0f;
                                if (i2 < this.nx - kstep) {
                                    sum += this.values[i2 + kstep][j];
                                    ++ncount;
                                }
                                if (j < this.ny - kstep) {
                                    sum += this.values[i2][j + kstep];
                                    ++ncount;
                                }
                                if (i2 > kstep) {
                                    sum += this.values[i2 - kstep][j];
                                    ++ncount;
                                }
                                if (j > kstep) {
                                    sum += this.values[i2][j - kstep];
                                    ++ncount;
                                }
                                if (ncount > 0) {
                                    this.values[i2][j] = sum / (float)ncount;
                                    ++icountall;
                                }
                            }
                            j += kstep;
                        }
                        i2 += kstep;
                    }
                    ++iter;
                }
                --k;
            }
        }
    }

    public void interpolateUndefined(int niter, int lod, Grid mask, float defaultval) {
        if (niter > 0) {
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    defined[i][j] = this.defined(i, j);
                    if (!defined[i][j]) {
                        this.values[i][j] = defaultval;
                    }
                    ++j;
                }
                ++i;
            }
            int k = lod;
            while (k >= 0) {
                int kstep = (int)Math.pow(2.0, k);
                int iter = 0;
                while (iter < niter / kstep) {
                    int i2 = 0;
                    while (i2 < this.nx) {
                        int j = 0;
                        while (j < this.ny) {
                            if (!(defined[i2][j] || mask != null && mask.values[i2][j] == 1.0f)) {
                                int ncount = 0;
                                float sum = 0.0f;
                                if (i2 < this.nx - kstep) {
                                    sum += this.values[i2 + kstep][j];
                                    ++ncount;
                                }
                                if (j < this.ny - kstep) {
                                    sum += this.values[i2][j + kstep];
                                    ++ncount;
                                }
                                if (i2 > kstep) {
                                    sum += this.values[i2 - kstep][j];
                                    ++ncount;
                                }
                                if (j > kstep) {
                                    sum += this.values[i2][j - kstep];
                                    ++ncount;
                                }
                                if (ncount > 0) {
                                    this.values[i2][j] = sum / (float)ncount;
                                    ++icountall;
                                }
                            }
                            j += kstep;
                        }
                        i2 += kstep;
                    }
                    ++iter;
                }
                --k;
            }
        }
    }

    public static Grid convertLL2WebMercartor(Grid g) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        float LL2UTMSCALE = 100000.0f;
        double[] xc = new double[]{g.xlow, g.xhigh, g.xhigh, g.xlow};
        double[] yc = new double[]{g.ylow, g.ylow, g.yhigh, g.yhigh};
        ProjectionConverter pcCorners = ProjectionConverter.LL2WebMercartor(xc, yc);
        pcCorners.getTransformedCoords();
        int length = xc.length;
        int i = 0;
        while (i < length) {
            double[] xyWeb = pcCorners.getCoordinates(i);
            if (xyWeb[0] < (double)minx) {
                minx = (float)xyWeb[0];
            }
            if (xyWeb[0] > (double)maxx) {
                maxx = (float)xyWeb[0];
            }
            if (xyWeb[1] < (double)miny) {
                miny = (float)xyWeb[1];
            }
            if (xyWeb[1] > (double)maxy) {
                maxy = (float)xyWeb[1];
            }
            ++i;
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - g.dx * LL2UTMSCALE;
        gtemplate.originy = miny - g.dy * LL2UTMSCALE;
        int nx = (int)((maxx - gtemplate.originx) / (g.dx * LL2UTMSCALE)) + 1;
        int ny = (int)((maxy - gtemplate.originy) / (g.dy * LL2UTMSCALE)) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = g.dx * LL2UTMSCALE;
        gtemplate.dy = g.dy * LL2UTMSCALE;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        ProjectionConverter gridConverter = ProjectionConverter.webMercartor2LL(null, null);
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xWeb = gnew.getx(ii2);
                double yWeb = gnew.gety(jj);
                float[] utmCoords = gridConverter.transformCoordinates(xWeb, yWeb);
                gnew.values[ii2][jj] = g.getValueAtxy(utmCoords[0], utmCoords[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertUTM2WebMercartor(Grid g) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        double[] xc = new double[]{g.xlow, g.xhigh, g.xhigh, g.xlow};
        double[] yc = new double[]{g.ylow, g.ylow, g.yhigh, g.yhigh};
        ProjectionConverter pcCorners = ProjectionConverter.utm31n2WebMercartor(xc, yc);
        pcCorners.getTransformedCoords();
        int length = xc.length;
        int i = 0;
        while (i < length) {
            double[] xyWeb = pcCorners.getCoordinates(i);
            if (xyWeb[0] < (double)minx) {
                minx = (float)xyWeb[0];
            }
            if (xyWeb[0] > (double)maxx) {
                maxx = (float)xyWeb[0];
            }
            if (xyWeb[1] < (double)miny) {
                miny = (float)xyWeb[1];
            }
            if (xyWeb[1] > (double)maxy) {
                maxy = (float)xyWeb[1];
            }
            ++i;
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - g.dx;
        gtemplate.originy = miny - g.dy;
        int nx = (int)((maxx - gtemplate.originx) / g.dx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / g.dy) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = g.dx;
        gtemplate.dy = g.dy;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        ProjectionConverter gridConverter = ProjectionConverter.webMercartor2utm31n(null, null);
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xWeb = gnew.getx(ii2);
                double yWeb = gnew.gety(jj);
                float[] utmCoords = gridConverter.transformCoordinates(xWeb, yWeb);
                gnew.values[ii2][jj] = g.getValueAtxy(utmCoords[0], utmCoords[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertUTM2LL84(Grid g) throws Exception {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        double[] xyRD = UTM2RD.convertUTM2WebMercator(g.xlow, g.ylow);
        if (xyRD[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convertUTM2WebMercator(g.xhigh, g.ylow))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convertUTM2WebMercator(g.xhigh, g.yhigh))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convertUTM2WebMercator(g.xlow, g.yhigh))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        System.out.println(String.valueOf(minx) + " " + maxx + " " + miny + " " + maxy);
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - g.dx;
        gtemplate.originy = miny - g.dy;
        int nx = (int)((maxx - gtemplate.originx) / g.dx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / g.dy) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = g.dx;
        gtemplate.dy = g.dy;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                float val;
                double xRD = gnew.getx(ii2);
                double yRD = gnew.gety(jj);
                double[] xyUTM = UTM2RD.convertWebMercator2UTM(xRD, yRD);
                gnew.values[ii2][jj] = val = g.getValueAtxy((float)xyUTM[0], (float)xyUTM[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertUTM2RD(Grid g, boolean utm2rd) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        double[] xyRD = UTM2RD.convert2RD(g.xlow, g.ylow, utm2rd);
        if (xyRD[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convert2RD(g.xhigh, g.ylow, utm2rd))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convert2RD(g.xhigh, g.yhigh, utm2rd))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        if ((xyRD = UTM2RD.convert2RD(g.xlow, g.yhigh, utm2rd))[0] < (double)minx) {
            minx = (float)xyRD[0];
        }
        if (xyRD[0] > (double)maxx) {
            maxx = (float)xyRD[0];
        }
        if (xyRD[1] < (double)miny) {
            miny = (float)xyRD[1];
        }
        if (xyRD[1] > (double)maxy) {
            maxy = (float)xyRD[1];
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - g.dx;
        gtemplate.originy = miny - g.dy;
        int nx = (int)((maxx - gtemplate.originx) / g.dx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / g.dy) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = g.dx;
        gtemplate.dy = g.dy;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xRD = gnew.getx(ii2);
                double yRD = gnew.gety(jj);
                double[] xyUTM = UTM2RD.convert2RD(xRD, yRD, !utm2rd);
                gnew.values[ii2][jj] = g.getValueAtxy((float)xyUTM[0], (float)xyUTM[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertProjection(int ESPGsource, int ESPGtarget, Grid g) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        double[] xc = new double[]{g.xlow, g.xhigh, g.xhigh, g.xlow};
        double[] yc = new double[]{g.ylow, g.ylow, g.yhigh, g.yhigh};
        ProjectionConverter pcCorners = new ProjectionConverter(ESPGsource, ESPGtarget, xc, yc);
        pcCorners.getTransformedCoords();
        int length = xc.length;
        int i = 0;
        while (i < length) {
            double[] xyWeb = pcCorners.getCoordinates(i);
            if (xyWeb[0] < (double)minx) {
                minx = (float)xyWeb[0];
            }
            if (xyWeb[0] > (double)maxx) {
                maxx = (float)xyWeb[0];
            }
            if (xyWeb[1] < (double)miny) {
                miny = (float)xyWeb[1];
            }
            if (xyWeb[1] > (double)maxy) {
                maxy = (float)xyWeb[1];
            }
            ++i;
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - g.dx;
        gtemplate.originy = miny - g.dy;
        int nx = (int)((maxx - gtemplate.originx) / g.dx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / g.dy) + 1;
        float scalex = ((float)nx * 1.0f + 1.0f) / ((float)g.nx * 1.0f + 1.0f);
        float scaley = ((float)ny * 1.0f + 1.0f) / ((float)g.ny * 1.0f + 1.0f);
        gtemplate.values = new float[g.nx][g.ny];
        gtemplate.nx = g.nx;
        gtemplate.ny = g.ny;
        gtemplate.dx = g.dx * scalex;
        gtemplate.dy = g.dy * scaley;
        gtemplate.dy = gtemplate.dx = Math.max(gtemplate.dx, gtemplate.dy);
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        ProjectionConverter gridConverter = new ProjectionConverter(ESPGtarget, ESPGsource, xc, yc);
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xWeb = gnew.getx(ii2);
                double yWeb = gnew.gety(jj);
                float[] utmCoords = gridConverter.transformCoordinates(xWeb, yWeb);
                gnew.values[ii2][jj] = g.getValueAtxy(utmCoords[0], utmCoords[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertProjection(int ESPGsource, int ESPGtarget, Grid g, float dxdynew) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        double[] xc = new double[]{g.xlow, g.xhigh, g.xhigh, g.xlow};
        double[] yc = new double[]{g.ylow, g.ylow, g.yhigh, g.yhigh};
        ProjectionConverter pcCorners = new ProjectionConverter(ESPGsource, ESPGtarget, xc, yc);
        pcCorners.getTransformedCoords();
        int length = xc.length;
        int i = 0;
        while (i < length) {
            double[] xyWeb = pcCorners.getCoordinates(i);
            if (xyWeb[0] < (double)minx) {
                minx = (float)xyWeb[0];
            }
            if (xyWeb[0] > (double)maxx) {
                maxx = (float)xyWeb[0];
            }
            if (xyWeb[1] < (double)miny) {
                miny = (float)xyWeb[1];
            }
            if (xyWeb[1] > (double)maxy) {
                maxy = (float)xyWeb[1];
            }
            ++i;
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - dxdynew;
        gtemplate.originy = miny - dxdynew;
        int nx = (int)((maxx - gtemplate.originx) / dxdynew) + 1;
        int ny = (int)((maxy - gtemplate.originy) / dxdynew) + 1;
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.values = new float[gtemplate.nx][gtemplate.ny];
        gtemplate.dx = dxdynew;
        gtemplate.dy = dxdynew;
        gtemplate.dx = Math.max(gtemplate.dx, gtemplate.dy);
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        ProjectionConverter gridConverter = new ProjectionConverter(ESPGtarget, ESPGsource, xc, yc);
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xWeb = gnew.getx(ii2);
                double yWeb = gnew.gety(jj);
                float[] utmCoords = gridConverter.transformCoordinates(xWeb, yWeb);
                gnew.values[ii2][jj] = g.getValueAtxy(utmCoords[0], utmCoords[1]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertLL2UTM(Grid g, float dydx) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        Projection projection = ProjectionConverter.getProjection(ProjectionConverter.UTM31N);
        float LL2UTMSCALE = 100000.0f;
        double[] x = new double[1];
        double[] y = new double[1];
        Grid.fillxy(g.xlow, g.ylow, x, y);
        double[][] xyRD = TnoProjectionFactory.convert(projection, x, y, false);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xhigh, g.ylow, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, false);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xhigh, g.yhigh, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, false);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xlow, g.yhigh, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, false);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - dydx;
        gtemplate.originy = miny - dydx;
        int nx = (int)((maxx - gtemplate.originx) / dydx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / dydx) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = dydx;
        gtemplate.dy = dydx;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xRD = gnew.getx(ii2);
                double yRD = gnew.gety(jj);
                Grid.fillxy(xRD, yRD, x, y);
                xyRD = TnoProjectionFactory.convert(projection, x, y, true);
                Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
                gnew.values[ii2][jj] = g.getValueAtxy((float)x[0], (float)y[0]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    public static Grid convertUTM2LL(Grid g, float dydx) {
        float minx = 1.0E30f;
        float maxx = -1.0E30f;
        float miny = 1.0E30f;
        float maxy = -1.0E30f;
        Projection projection = ProjectionConverter.getProjection(ProjectionConverter.UTM31N);
        double[] x = new double[1];
        double[] y = new double[1];
        Grid.fillxy(g.xlow, g.ylow, x, y);
        double[][] xyRD = TnoProjectionFactory.convert(projection, x, y, true);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xhigh, g.ylow, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, true);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xhigh, g.yhigh, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, true);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid.fillxy(g.xlow, g.yhigh, x, y);
        xyRD = TnoProjectionFactory.convert(projection, x, y, true);
        Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
        if (x[0] < (double)minx) {
            minx = (float)x[0];
        }
        if (x[0] > (double)maxx) {
            maxx = (float)x[0];
        }
        if (y[0] < (double)miny) {
            miny = (float)y[0];
        }
        if (y[0] > (double)maxy) {
            maxy = (float)y[0];
        }
        Grid gtemplate = new Grid();
        gtemplate.originx = minx - dydx;
        gtemplate.originy = miny - dydx;
        int nx = (int)((maxx - gtemplate.originx) / dydx) + 1;
        int ny = (int)((maxy - gtemplate.originy) / dydx) + 1;
        gtemplate.values = new float[nx][ny];
        gtemplate.nx = nx;
        gtemplate.ny = ny;
        gtemplate.dx = dydx;
        gtemplate.dy = dydx;
        gtemplate.unknown = g.unknown;
        int ii = 0;
        while (ii < gtemplate.nx) {
            int jj = 0;
            while (jj < gtemplate.ny) {
                gtemplate.values[ii][jj] = gtemplate.unknown;
                ++jj;
            }
            ++ii;
        }
        Grid gnew = gtemplate;
        int ii2 = 0;
        while (ii2 < gnew.nx) {
            int jj = 0;
            while (jj < gnew.ny) {
                double xRD = gnew.getx(ii2);
                double yRD = gnew.gety(jj);
                Grid.fillxy(xRD, yRD, x, y);
                xyRD = TnoProjectionFactory.convert(projection, x, y, false);
                Grid.fillxy(xyRD[0][0], xyRD[1][0], x, y);
                gnew.values[ii2][jj] = g.getValueAtxy((float)x[0], (float)y[0]);
                ++jj;
            }
            ++ii2;
        }
        return gnew;
    }

    private static void fillxy(double xlow, double ylow, double[] x, double[] y) {
        x[0] = xlow;
        y[0] = ylow;
    }

    public void valuesToUnknown() {
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                this.values[i][j] = this.unknown;
                ++i;
            }
            ++j;
        }
    }

    public void shrink(int ntimes) {
        while (ntimes > 0) {
            int j;
            boolean[][] todelete = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                j = 0;
                while (j < this.ny) {
                    todelete[i][j] = false;
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.nx - 1) {
                j = 1;
                while (j < this.ny - 1) {
                    if (!(!this.defined(i, j) || this.defined(i + 1, j) && this.defined(i - 1, j) && this.defined(i, j - 1) && this.defined(i, j + 1))) {
                        todelete[i][j] = true;
                    }
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.nx - 1) {
                j = 1;
                while (j < this.ny - 1) {
                    if (todelete[i][j]) {
                        this.values[i][j] = this.unknown;
                    }
                    ++j;
                }
                ++i;
            }
            --ntimes;
        }
    }

    @Override
    public void read(InputStream inputStream) throws ProcessException {
        String format = this.getDataFormat();
        try {
            AsciiStream ast = new AsciiStream(inputStream, 4098);
            long timer = System.currentTimeMillis();
            if (format.equals("SURFER")) {
                this.readSurfer(ast);
            } else if (format.equals("ARC")) {
                this.readArc(ast);
            } else if (format.equals("GMT")) {
                this.readGmt(ast);
            } else if (format.equals("ZYCOR")) {
                this.readZycor(ast);
            }
            this.determine_low_high();
            timer = System.currentTimeMillis() - timer;
        }
        catch (IOException e) {
            boolean stillok;
            boolean bl = stillok = format.equals("ZYCOR") && this.SKIPZYCORLINES == 4;
            if (!stillok) {
                e.printStackTrace();
            }
            throw new ProcessException("Interrupted or read error occured");
        }
    }

    public void write() throws Exception {
        long timer = System.currentTimeMillis();
        timer = System.currentTimeMillis() - timer;
        long timer2 = System.currentTimeMillis();
        if (this.getDataFormat().equals("SURFER")) {
            try {
                this.writeSurfer();
            }
            catch (IOException e) {
                System.err.println("IOException\n  " + e);
            }
        }
        if (this.getDataFormat().equals("ARC")) {
            try {
                this.writeArc();
            }
            catch (IOException e) {
                System.err.println("IOException\n  " + e);
            }
        }
        if (this.getDataFormat().equals("GMT")) {
            try {
                this.writeGmt();
            }
            catch (IOException e) {
                System.err.println("IOException\n  " + e);
            }
        }
        if (this.getDataFormat().equals("ZYCOR")) {
            try {
                this.writeZycor();
            }
            catch (IOException e) {
                System.err.println("IOException\n  " + e);
            }
        }
        timer2 = System.currentTimeMillis() - timer2;
    }

    public void sample(Grid s) {
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                if (!this.defined(i, j)) {
                    this.values[i][j] = s.getValueAtxy(this.getx(i), this.gety(j));
                }
                ++i;
            }
            ++j;
        }
    }

    public void sampleFillunknown(Grid s) {
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                float v;
                if (!this.defined(i, j) && s.defined(v = s.getValueAtxy(this.getx(i), this.gety(j)))) {
                    this.values[i][j] = v;
                }
                ++i;
            }
            ++j;
        }
    }

    public void mask(Grid s) {
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                float v;
                if (this.defined(i, j) && !s.defined(v = s.getValueAtxy(this.getx(i), this.gety(j)))) {
                    this.values[i][j] = this.unknown;
                }
                ++i;
            }
            ++j;
        }
    }

    public float getx(int i) {
        return this.originx + (float)i * this.dx;
    }

    public float gety(int j) {
        return this.originy + (float)j * this.dy;
    }

    @Override
    public void determine_low_high() {
        this.xlow = Float.MAX_VALUE;
        this.ylow = Float.MAX_VALUE;
        this.zlow = Float.MAX_VALUE;
        this.xhigh = Float.MIN_VALUE;
        this.yhigh = Float.MIN_VALUE;
        this.zhigh = Float.MIN_VALUE;
        this.xlow = this.originx;
        this.ylow = this.originy;
        this.xhigh = this.xlow + this.dx * (float)(this.nx - 1);
        this.yhigh = this.ylow + this.dy * (float)(this.ny - 1);
        int j = 0;
        while (j < this.ny) {
            int i = 0;
            while (i < this.nx) {
                if (this.defined(i, j)) {
                    if (this.values[i][j] < this.zlow) {
                        this.zlow = this.values[i][j];
                    }
                    if (this.values[i][j] > this.zhigh) {
                        this.zhigh = this.values[i][j];
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public float bilinearAtXy(int ioff, int joff, int iplus, int jplus, float x, float y) {
        float r = 2.0f * (((x - this.originx) / this.dx - (float)ioff) / (float)(iplus - ioff)) - 1.0f;
        float s = 2.0f * (((y - this.originy) / this.dy - (float)joff) / (float)(jplus - joff)) - 1.0f;
        if ((double)r < -1.001) {
            r = -1.0f;
        }
        if ((double)r > 1.001) {
            r = 1.0f;
        }
        if ((double)s < -1.001) {
            s = -1.0f;
        }
        if ((double)s > 1.001) {
            s = 1.0f;
        }
        float[] rr = new float[]{0.0f, -1.0f, 1.0f, 1.0f, -1.0f};
        float[] ss = new float[]{0.0f, -1.0f, -1.0f, 1.0f, 1.0f};
        float[] weights = new float[4];
        if (r < -1.0f) {
            r = -1.0f;
        } else if (r > 1.0f) {
            r = 1.0f;
        }
        if (s < -1.0f) {
            s = -1.0f;
        } else if (s > 1.0f) {
            s = 1.0f;
        }
        weights[0] = (1.0f + rr[1] * r) * (1.0f + ss[1] * s);
        weights[1] = (1.0f + rr[2] * r) * (1.0f + ss[2] * s);
        weights[2] = (1.0f + rr[3] * r) * (1.0f + ss[3] * s);
        weights[3] = (1.0f + rr[4] * r) * (1.0f + ss[4] * s);
        float value = 0.0f;
        if ((double)weights[0] > 0.001 && this.defined(ioff, joff)) {
            value += this.values[ioff][joff] * 0.25f * weights[0];
        } else if ((double)weights[0] > 0.001) {
            return this.unknown;
        }
        if ((double)weights[1] > 0.001 && this.defined(iplus, joff)) {
            value += this.values[iplus][joff] * 0.25f * weights[1];
        } else if ((double)weights[1] > 0.001) {
            return this.unknown;
        }
        if ((double)weights[2] > 0.001 && this.defined(iplus, jplus)) {
            value += this.values[iplus][jplus] * 0.25f * weights[2];
        } else if ((double)weights[2] > 0.001) {
            return this.unknown;
        }
        if ((double)weights[3] > 0.001 && this.defined(ioff, jplus)) {
            value += this.values[ioff][jplus] * 0.25f * weights[3];
        } else if ((double)weights[3] > 0.001) {
            return this.unknown;
        }
        return value;
    }

    public float getValueAtxy(float x, float y) {
        int ioff = (int)Math.floor((x - this.originx) / this.dx);
        int joff = (int)Math.floor((y - this.originy) / this.dy);
        if (ioff < 0) {
            if (ioff < -1) {
                return this.unknown;
            }
            ioff = 0;
        } else if (ioff > this.nx - 2) {
            if (ioff > this.nx) {
                return this.unknown;
            }
            ioff = this.nx - 2;
        }
        if (joff < 0) {
            if (joff < -1) {
                return this.unknown;
            }
            joff = 0;
        } else if (joff > this.ny - 2) {
            if (joff > this.ny) {
                return this.unknown;
            }
            joff = this.ny - 2;
        }
        return this.bilinearAtXy(ioff, joff, ioff + 1, joff + 1, x, y);
    }

    public float getValueAtxy(float x, float y, int lod) {
        int iofflod = (int)Math.floor((x - this.originx) / (this.dx * (float)lod));
        int jofflod = (int)Math.floor((y - this.originy) / (this.dy * (float)lod));
        int lodnx = (this.nx - 1) / lod + 1;
        if ((this.nx - 1) % lod > 0) {
            ++lodnx;
        }
        int lodny = (this.ny - 1) / lod + 1;
        if ((this.ny - 1) % lod > 0) {
            ++lodny;
        }
        if (iofflod < 0) {
            iofflod = 0;
        } else if (iofflod > lodnx - 2) {
            iofflod = lodnx - 2;
        }
        if (jofflod < 0) {
            jofflod = 0;
        } else if (jofflod > lodny - 2) {
            jofflod = lodny - 2;
        }
        int ioff = this.ilod2i(iofflod, lod);
        int joff = this.jlod2j(jofflod, lod);
        int iplus = this.ilod2i(iofflod + 1, lod);
        int jplus = this.jlod2j(jofflod + 1, lod);
        return this.bilinearAtXy(ioff, joff, iplus, jplus, x, y);
    }

    private int ilod2i(int ilod, int lod) {
        int ii = ilod * lod;
        if (ii < this.nx) {
            return ii;
        }
        return this.nx - 1;
    }

    private int jlod2j(int jlod, int lod) {
        int jj = jlod * lod;
        if (jj < this.ny) {
            return jj;
        }
        return this.ny - 1;
    }

    public boolean defined(int i, int j) {
        if (i >= this.nx) {
            return false;
        }
        if (i < 0) {
            return false;
        }
        if (j >= this.ny) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        return this.defined(this.values[i][j]);
    }

    public boolean defined(float value) {
        if (Math.abs(this.unknown) < 100.0f) {
            return (double)Math.abs(value - this.unknown) > 1.0E-5;
        }
        float test = Math.abs(value / this.unknown - 1.0f);
        return (double)test > 1.0E-5;
    }

    public static boolean defined(float value, float unknown) {
        if (Math.abs(unknown) < 100.0f) {
            return (double)Math.abs(value - unknown) > 1.0E-5;
        }
        float test = Math.abs(value / unknown - 1.0f);
        return (double)test > 1.0E-5;
    }

    protected void checkDimension(int nx, int ny) throws ProcessException {
        if (nx > 10000 || ny > 10000) {
            throw new ProcessException("Maximum grid dimension exceeded");
        }
    }

    public boolean checkForAllow2repair(int i, int j, boolean[][] defined, float value) {
        boolean ok = false;
        boolean bl = ok = (double)Math.abs(this.values[i][j] - value) < 0.01;
        if (ok) {
            ok = false;
            if (i > 0 && defined[i - 1][j] && (double)Math.abs(this.values[i - 1][j] - value) > 0.01) {
                ok = true;
            }
            if (j > 0 && defined[i][j - 1] && (double)Math.abs(this.values[i][j - 1] - value) > 0.01) {
                ok = true;
            }
            if (i < this.nx - 1 && defined[i + 1][j] && (double)Math.abs(this.values[i + 1][j] - value) > 0.01) {
                ok = true;
            }
            if (j < this.ny - 1 && defined[i][j + 1] && (double)Math.abs(this.values[i][j + 1] - value) > 0.01) {
                ok = true;
            }
        }
        return ok;
    }

    public void fillParticularValues(float value, int niter) {
        if (niter > 0) {
            int j;
            int i;
            int j2;
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            boolean[][] allowed = new boolean[this.nx][this.ny];
            boolean[][] allowedorig = new boolean[this.nx][this.ny];
            int i2 = 0;
            while (i2 < this.nx) {
                j2 = 0;
                while (j2 < this.ny) {
                    defined[i2][j2] = this.defined(i2, j2);
                    ++j2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nx) {
                j2 = 0;
                while (j2 < this.ny) {
                    allowedorig[i2][j2] = false;
                    if (defined[i2][j2]) {
                        allowedorig[i2][j2] = this.checkForAllow2repair(i2, j2, defined, value);
                        if (!allowedorig[i2][j2]) {
                            boolean ok;
                            boolean bl = ok = i2 < this.nx - 1 && j2 < this.ny - 1 && i2 > 0 && j2 > 0 && defined[i2][j2 - 1] && defined[i2][j2 + 1] && defined[i2 + 1][j2] && defined[i2 - 1][j2];
                            if (ok) {
                                double s = this.values[i2][j2];
                                double minjump = 10.0;
                                if (Math.abs((double)this.values[i2][j2 - 1] - s) > minjump) {
                                    allowedorig[i2][j2] = true;
                                }
                                if (Math.abs((double)this.values[i2 + 1][j2] - s) > minjump) {
                                    allowedorig[i2][j2] = true;
                                }
                                if (Math.abs((double)this.values[i2 - 1][j2] - s) > minjump) {
                                    allowedorig[i2][j2] = true;
                                }
                                if (Math.abs((double)this.values[i2][j2 + 1] - s) > minjump) {
                                    allowedorig[i2][j2] = true;
                                }
                            }
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            int k = 0;
            while (k < 2) {
                i = 0;
                while (i < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        if (defined[i][j]) {
                            allowed[i][j] = allowedorig[i][j];
                            if (!allowedorig[i][j]) {
                                if (i < this.nx - 1 && allowedorig[i + 1][j]) {
                                    allowed[i][j] = true;
                                }
                                if (j < this.ny - 1 && allowedorig[i][j + 1]) {
                                    allowed[i][j] = true;
                                }
                                if (i > 0 && allowedorig[i - 1][j]) {
                                    allowed[i][j] = true;
                                }
                                if (j > 0 && allowedorig[i][j - 1]) {
                                    allowed[i][j] = true;
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        allowedorig[i][j] = allowed[i][j];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            int iter = 0;
            while (iter < niter) {
                i = 0;
                while (i < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        if (allowed[i][j]) {
                            int ncount = 0;
                            float sum = 0.0f;
                            if (i < this.nx - 1 && this.defined(this.values[i + 1][j])) {
                                sum += this.values[i + 1][j];
                                ++ncount;
                            }
                            if (j < this.ny - 1 && this.defined(this.values[i][j + 1])) {
                                sum += this.values[i][j + 1];
                                ++ncount;
                            }
                            if (i > 1 && this.defined(this.values[i - 1][j])) {
                                sum += this.values[i - 1][j];
                                ++ncount;
                            }
                            if (j > 1 && this.defined(this.values[i][j - 1])) {
                                sum += this.values[i][j - 1];
                                ++ncount;
                            }
                            if (ncount > 0) {
                                this.values[i][j] = sum / (float)ncount;
                                ++icountall;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                ++iter;
            }
        }
    }

    public void fillHoles(int niter, int niter2) {
        if (niter > 0) {
            float sum;
            int ncount;
            int icountall = 0;
            boolean[][] defined = new boolean[this.nx][this.ny];
            boolean[][] allowed = new boolean[this.nx][this.ny];
            int i = 0;
            while (i < this.nx) {
                int j = 0;
                while (j < this.ny) {
                    defined[i][j] = this.defined(i, j);
                    ++j;
                }
                ++i;
            }
            int iter = 0;
            while (iter < niter) {
                int j;
                boolean ok = false;
                int i2 = 0;
                while (i2 < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        boolean bl = allowed[i2][j] = !this.defined(i2, j);
                        if (allowed[i2][j]) {
                            ok = false;
                            if (!ok && i2 > 0) {
                                ok = this.defined(i2 - 1, j);
                            }
                            if (!ok && i2 < this.nx - 1) {
                                ok = this.defined(i2 + 1, j);
                            }
                            if (!ok && j > 0) {
                                ok = this.defined(i2, j - 1);
                            }
                            if (!ok && j < this.ny - 1) {
                                ok = this.defined(i2, j + 1);
                            }
                            allowed[i2][j] = ok;
                        }
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.nx) {
                    j = 0;
                    while (j < this.ny) {
                        if (allowed[i2][j]) {
                            ncount = 0;
                            sum = 0.0f;
                            if (i2 < this.nx - 1 && this.defined(this.values[i2 + 1][j])) {
                                sum += this.values[i2 + 1][j];
                                ++ncount;
                            }
                            if (j < this.ny - 1 && this.defined(this.values[i2][j + 1])) {
                                sum += this.values[i2][j + 1];
                                ++ncount;
                            }
                            if (i2 > 1 && this.defined(this.values[i2 - 1][j])) {
                                sum += this.values[i2 - 1][j];
                                ++ncount;
                            }
                            if (j > 1 && this.defined(this.values[i2][j - 1])) {
                                sum += this.values[i2][j - 1];
                                ++ncount;
                            }
                            if (ncount > 0) {
                                this.values[i2][j] = sum / (float)ncount;
                                ++icountall;
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
                ++iter;
            }
            iter = 0;
            while (iter < niter2) {
                int i3 = 0;
                while (i3 < this.nx) {
                    int j = 0;
                    while (j < this.ny) {
                        if (!defined[i3][j] && this.defined(i3, j)) {
                            ncount = 0;
                            sum = 0.0f;
                            if (i3 < this.nx - 1 && this.defined(this.values[i3 + 1][j])) {
                                sum += this.values[i3 + 1][j];
                                ++ncount;
                            }
                            if (j < this.ny - 1 && this.defined(this.values[i3][j + 1])) {
                                sum += this.values[i3][j + 1];
                                ++ncount;
                            }
                            if (i3 > 1 && this.defined(this.values[i3 - 1][j])) {
                                sum += this.values[i3 - 1][j];
                                ++ncount;
                            }
                            if (j > 1 && this.defined(this.values[i3][j - 1])) {
                                sum += this.values[i3][j - 1];
                                ++ncount;
                            }
                            if (ncount > 0) {
                                this.values[i3][j] = sum / (float)ncount;
                                ++icountall;
                            }
                        }
                        ++j;
                    }
                    ++i3;
                }
                ++iter;
            }
        }
    }

    void readGmt(AsciiStream ast) throws IOException, ProcessException {
        float UNKNOWN = 1.71E38f;
    }

    void readSurfer(AsciiStream ast) throws IOException, ProcessException {
        float UNKNOWN = 1.70141E38f;
        ast.skipTag("\n");
        float hix = 0.0f;
        float hiy = 0.0f;
        this.nx = Math.round(ast.readFloat());
        this.ny = Math.round(ast.readFloat());
        this.checkDimension(this.nx, this.ny);
        this.originx = this.x2si(ast.readFloat());
        hix = this.x2si(ast.readFloat());
        this.originy = this.y2si(ast.readFloat());
        hiy = this.y2si(ast.readFloat());
        this.dx = (hix - this.originx) / (float)(this.nx - 1);
        this.dy = (hiy - this.originy) / (float)(this.ny - 1);
        this.zlow = this.z2si(ast.readFloat());
        this.zhigh = this.z2si(ast.readFloat());
        if (this.zlow > this.zhigh) {
            float tmp = this.zlow;
            this.zlow = this.zhigh;
            this.zhigh = tmp;
        }
        this.unknown = UNKNOWN;
        this.values = new float[this.nx][this.ny];
        int i = 0;
        int j = 0;
        j = 0;
        while (j < this.ny) {
            i = 0;
            while (i < this.nx) {
                this.values[i][j] = ast.readFloat();
                if (this.defined(i, j)) {
                    this.values[i][j] = this.z2si(this.values[i][j]);
                }
                ++i;
            }
            ++j;
        }
    }

    void readArc(AsciiStream ast) throws IOException, ProcessException {
        float UNKNOWN = -9999.0f;
        ast.setSkipType(2);
        this.nx = Math.round(ast.readFloat());
        this.ny = Math.round(ast.readFloat());
        this.checkDimension(this.nx, this.ny);
        this.originx = this.x2si(ast.readFloat());
        this.originy = this.y2si(ast.readFloat());
        this.dy = this.dx = this.x2si(ast.readFloat());
        this.originx += 0.5f * this.dx;
        this.originy += 0.5f * this.dy;
        this.unknown = ast.readFloat();
        this.values = new float[this.nx][this.ny];
        int i = 0;
        int j = 0;
        j = this.ny - 1;
        while (j >= 0) {
            i = 0;
            while (i < this.nx) {
                this.values[i][j] = ast.readFloat();
                if (this.defined(i, j)) {
                    this.values[i][j] = this.z2si(this.values[i][j]);
                }
                ++i;
            }
            --j;
        }
    }

    void readZycor(AsciiStream ast) throws IOException, ProcessException {
        float UNKNOWN = -9999.0f;
        ast.setSkipType(1);
        int i = 0;
        while (i < this.SKIPZYCORLINES - 1) {
            ast.skipTag("\n");
            ++i;
        }
        int ncolumn = 5;
        ast.skipTag(",");
        ast.skipTag(",");
        ncolumn = Math.round(ast.readFloat());
        float hix = 0.0f;
        float hiy = 0.0f;
        boolean dummy = false;
        int fieldlength = 0;
        fieldlength = Math.round(ast.readFloat());
        this.unknown = ast.readFloat();
        ast.skipTag("\n");
        this.ny = Math.round(ast.readFloat());
        this.nx = Math.round(ast.readFloat());
        this.originx = this.x2si(ast.readFloat());
        hix = this.x2si(ast.readFloat());
        this.originy = this.y2si(ast.readFloat());
        hiy = this.y2si(ast.readFloat());
        this.dx = (hix - this.originx) / (float)(this.nx - 1);
        this.dy = (hiy - this.originy) / (float)(this.ny - 1);
        this.checkDimension(this.nx, this.ny);
        ast.skipTag("\n");
        ast.skipTag("\n");
        this.values = new float[this.nx][this.ny];
        int i2 = 0;
        int j = 0;
        int icount = 0;
        i2 = 0;
        while (i2 < this.nx) {
            j = this.ny - 1;
            while (j >= 0) {
                String s = ast.readString(fieldlength, false);
                if (++icount % ncolumn == 0) {
                    ast.skipTag("\n");
                }
                this.values[i2][j] = Float.parseFloat(s);
                if (this.defined(i2, j)) {
                    this.values[i2][j] = this.z2si(this.values[i2][j]);
                }
                --j;
            }
            if (icount % ncolumn != 0) {
                icount = 0;
                ast.skipTag("\n");
            }
            ++i2;
        }
    }

    void readZycorOld(AsciiStream ast) throws IOException, ProcessException {
        float UNKNOWN = -9999.0f;
        ast.setSkipType(1);
        int i = 0;
        while (i < this.SKIPZYCORLINES) {
            ast.skipTag("\n");
            ++i;
        }
        float hix = 0.0f;
        float hiy = 0.0f;
        int dummy = 0;
        dummy = Math.round(ast.readFloat());
        this.unknown = ast.readFloat();
        ast.skipTag("\n");
        this.ny = Math.round(ast.readFloat());
        this.nx = Math.round(ast.readFloat());
        this.originx = this.x2si(ast.readFloat());
        hix = this.x2si(ast.readFloat());
        this.originy = this.y2si(ast.readFloat());
        hiy = this.y2si(ast.readFloat());
        this.dx = (hix - this.originx) / (float)(this.nx - 1);
        this.dy = (hiy - this.originy) / (float)(this.ny - 1);
        this.checkDimension(this.nx, this.ny);
        ast.skipTag("\n");
        ast.skipTag("\n");
        this.values = new float[this.nx][this.ny];
        int i2 = 0;
        int j = 0;
        i2 = 0;
        while (i2 < this.nx) {
            j = this.ny - 1;
            while (j >= 0) {
                this.values[i2][j] = ast.readFloat();
                if (this.defined(i2, j)) {
                    this.values[i2][j] = this.z2si(this.values[i2][j]);
                }
                --j;
            }
            ++i2;
        }
    }

    void writeSurfer() throws IOException {
        PrintStream pos = null;
        this.determine_low_high();
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFileName())));
            float UNKNOWN = 1.70141E38f;
            pos.println("DSAA");
            pos.println(String.valueOf(this.nx) + " " + this.ny);
            float hix = this.originx + (float)(this.nx - 1) * this.dx;
            float hiy = this.originy + (float)(this.ny - 1) * this.dy;
            pos.println(String.valueOf(this.si2x(this.originx)) + " " + this.si2x(hix));
            pos.println(String.valueOf(this.si2y(this.originy)) + " " + this.si2y(hiy));
            if (this.si2z(this.zlow) < this.si2z(this.zhigh)) {
                pos.println(String.valueOf(this.si2z(this.zlow)) + " " + this.si2z(this.zhigh));
            } else {
                pos.println(String.valueOf(this.si2z(this.zhigh)) + " " + this.si2z(this.zlow));
            }
            int icount = 0;
            int j = 0;
            while (j < this.ny) {
                icount = 0;
                int i = 0;
                while (i < this.nx) {
                    ++icount;
                    if (!this.defined(i, j)) {
                        pos.print(String.valueOf(UNKNOWN) + " ");
                    } else {
                        pos.print(String.valueOf(this.si2z(this.values[i][j])) + " ");
                    }
                    if (icount % 10 == 0) {
                        pos.println();
                    }
                    ++i;
                }
                pos.println();
                pos.println();
                ++j;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    void writeGmt() throws IOException {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFileName())));
            int j = 0;
            while (j < this.ny) {
                int i = 0;
                while (i < this.nx) {
                    if (this.defined(i, j)) {
                        pos.println(String.valueOf(this.si2x(this.getx(i))) + " " + this.si2y(this.gety(j)) + " " + this.si2z(this.values[i][j]));
                    }
                    ++i;
                }
                ++j;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    void writeArc() throws IOException {
        PrintStream pos = null;
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFileName())));
            float originxx = this.originx - 0.5f * this.dx;
            float originyy = this.originy - 0.5f * this.dy;
            pos.println("ncols  " + this.nx);
            pos.println("nrows  " + this.ny);
            pos.println("xllcorner  " + this.si2x(originxx));
            pos.println("yllcorner  " + this.si2y(originyy));
            pos.println("cellsize  " + this.si2x(this.dx));
            pos.println("NODATA_value  " + this.unknown);
            int icount = 0;
            int j = this.ny - 1;
            while (j >= 0) {
                icount = 0;
                int i = 0;
                while (i < this.nx) {
                    ++icount;
                    if (!this.defined(i, j)) {
                        pos.print(String.valueOf(this.unknown) + " ");
                    } else {
                        pos.print(String.valueOf(this.si2z(this.values[i][j])) + " ");
                    }
                    if (icount % this.nx == 0) {
                        pos.println();
                    }
                    ++i;
                }
                --j;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    void writeZycor() throws IOException {
        PrintStream pos = null;
        int fieldwidth = 15;
        int nodesperline = 5;
        try {
            AsciiOut fout = new AsciiOut("0.00000E00", fieldwidth);
            AsciiOut foutfloat = new AsciiOut("0.00000E00", fieldwidth);
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFileName())));
            pos.println("!");
            pos.println("! ZIMS FILE NAME : ");
            pos.println("! FORMATTED FILE CREATION DATE: ");
            pos.println("! FORMATTED FILE CREATION TIME: ");
            pos.println("!");
            pos.println("@" + this.getFileName() + " HEADER   ,   GRID  ," + nodesperline);
            float UNKNOWN = this.unknown;
            pos.println(fieldwidth + "," + foutfloat.format(UNKNOWN) + ",  , 1 , 1");
            float hix = this.originx + (float)(this.nx - 1) * this.dx;
            float hiy = this.originy + (float)(this.ny - 1) * this.dy;
            pos.println("   " + this.ny + ",   " + this.nx + "," + fout.format(this.si2x(this.originx)) + "," + fout.format(this.si2x(hix)) + "," + fout.format(this.si2y(this.originy)) + "," + fout.format(this.si2y(hiy)));
            pos.println(String.valueOf(this.dx) + ",  0.0,  0.0    ");
            pos.println("@");
            int i = 0;
            while (i < this.nx) {
                int icount = 0;
                int j = this.ny - 1;
                while (j >= 0) {
                    ++icount;
                    if (!this.defined(i, j)) {
                        pos.print(foutfloat.format(UNKNOWN));
                    } else {
                        pos.print(foutfloat.format(this.si2z(this.values[i][j])));
                    }
                    if (icount % nodesperline == 0) {
                        pos.println();
                    }
                    --j;
                }
                if (icount % nodesperline != 0) {
                    pos.println();
                }
                ++i;
            }
            pos.close();
        }
        catch (Exception e) {
            System.err.println("Exception\n  " + e);
        }
    }

    public static Grid readBinGrid(String fileName) {
        FileInputStream is = null;
        AbstractInterruptibleChannel channel = null;
        try {
            File f = new File(fileName);
            is = new FileInputStream(f);
            channel = is.getChannel();
            ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
            buffer.clearread();
            Grid grid = new Grid();
            grid.setFileName(fileName);
            grid.readBinValues(buffer);
            Grid grid2 = grid;
            return grid2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void readBinValues(ByteBufferHelper buffer) throws IOException {
        this.nx = buffer.getInt();
        this.ny = buffer.getInt();
        this.originx = buffer.getFloat();
        this.originy = buffer.getFloat();
        this.dx = buffer.getFloat();
        this.dy = buffer.getFloat();
        this.unknown = buffer.getFloat();
        this.values = new float[this.nx][this.ny];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                this.values[i][j] = buffer.getFloat();
                ++j;
            }
            ++i;
        }
        this.determine_low_high();
    }

    public void writeBinGrid(String fileName) throws IOException {
        block22: {
            File output = new File(fileName);
            FileOutputStream outputStream = null;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    outputStream = new FileOutputStream(output);
                    channel = outputStream.getChannel();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.putInt(this.nx);
                    buffer.putInt(this.ny);
                    buffer.putFloat(this.originx);
                    buffer.putFloat(this.originy);
                    buffer.putFloat(this.dx);
                    buffer.putFloat(this.dy);
                    buffer.putFloat(this.unknown);
                    int ix = 0;
                    while (ix < this.nx) {
                        float[] valuesX = this.values[ix];
                        int iy = 0;
                        while (iy < this.ny) {
                            buffer.putFloat(valuesX[iy]);
                            ++iy;
                        }
                        ++ix;
                    }
                    buffer.flipwrite();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (outputStream == null) break block22;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void windowMax(int nwindow) {
        int j;
        float[][] newval = new float[this.nx][this.ny];
        int i = 0;
        while (i < this.nx) {
            j = 0;
            while (j < this.ny) {
                newval[i][j] = this.values[i][j];
                ++j;
            }
            ++i;
        }
        i = nwindow / 2;
        while (i < this.nx) {
            j = nwindow / 2;
            while (j < this.ny) {
                int jj;
                float sum = 0.0f;
                int ncount = 0;
                float max = this.unknown;
                int ii = i - nwindow / 2;
                while (ii < i + nwindow / 2) {
                    jj = j - nwindow / 2;
                    while (jj < j + nwindow / 2) {
                        if (this.defined(ii, jj)) {
                            ++ncount;
                            sum += this.values[ii][jj];
                            max = this.defined(max) ? Math.max(this.values[ii][jj], max) : this.values[ii][jj];
                        }
                        ++jj;
                    }
                    ++ii;
                }
                ii = i - nwindow / 2;
                while (ii < i + nwindow / 2) {
                    jj = j - nwindow / 2;
                    while (jj < j + nwindow / 2) {
                        if (!this.defined(ii, jj) && ii < this.nx && jj < this.ny) {
                            newval[ii][jj] = max;
                        }
                        ++jj;
                    }
                    ++ii;
                }
                j += nwindow;
            }
            i += nwindow;
        }
        this.values = newval;
    }

    public void scale(double scale) {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.defined(i, j)) {
                    float[] fArray = this.values[i];
                    int n = j;
                    fArray[n] = (float)((double)fArray[n] * scale);
                }
                ++j;
            }
            ++i;
        }
    }

    public void add(Grid gadd, float scale) {
        float v = 0.0f;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.defined(i, j) && gadd.defined(v = gadd.getValueAtxy(this.getx(i), this.gety(j)))) {
                    float[] fArray = this.values[i];
                    int n = j;
                    fArray[n] = fArray[n] + v * scale;
                }
                ++j;
            }
            ++i;
        }
    }

    public void add(float val) {
        float v = 0.0f;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.defined(i, j)) {
                    float[] fArray = this.values[i];
                    int n = j;
                    fArray[n] = fArray[n] + val;
                }
                ++j;
            }
            ++i;
        }
    }

    public void findsteepgradient(float stepmin) {
        float[][] grad = new float[this.nx][this.ny];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                grad[i][j] = this.unknown;
                ++j;
            }
            ++i;
        }
        boolean okii = true;
        boolean okjj = true;
        int i2 = 0;
        while (i2 < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.defined(i2, j)) {
                    float min = 1.0E38f;
                    float max = -1.0E38f;
                    boolean okpass = false;
                    int ii = -1;
                    while (ii < 1) {
                        int jj = -1;
                        while (jj < 1) {
                            int iii = i2 + ii;
                            int jjj = j + jj;
                            okii = iii >= 0 && iii < this.nx;
                            boolean bl = okjj = jjj >= 0 && jjj < this.ny;
                            if (okii && okjj && (iii != i2 || jjj != j) && this.defined(iii, jjj)) {
                                okpass = true;
                                if (this.values[iii][jjj] < min) {
                                    min = this.values[iii][jjj];
                                }
                                if (this.values[iii][jjj] > max) {
                                    max = this.values[iii][jjj];
                                }
                            }
                            ++jj;
                        }
                        ++ii;
                    }
                    if (okpass && max - min > stepmin) {
                        System.out.println(" gradient found " + (max - min));
                        grad[i2][j] = max - min;
                    }
                }
                ++j;
            }
            ++i2;
        }
        this.values = grad;
    }

    public void concat(Grid gin, int imode, double distance_error) {
        if (imode == 1) {
            int i;
            Grid error = new Grid(this);
            int j = 0;
            while (j < this.ny) {
                int i2 = 0;
                while (i2 < this.nx) {
                    if (this.defined(this.values[i2][j]) && gin.defined(this.values[i2][j])) {
                        error.values[i2][j] = this.getValueAtxy(this.getx(i2), this.gety(j)) - gin.getValueAtxy(this.getx(i2), this.gety(j));
                    }
                    ++i2;
                }
                ++j;
            }
            Grid m = new Grid(error);
            m.fillHoles((int)Math.round(distance_error / (double)this.dx), (int)Math.round(distance_error / (double)this.dx));
            int j2 = 0;
            while (j2 < this.ny) {
                i = 0;
                while (i < this.nx) {
                    if (!m.defined(i, j2) && !error.defined(i, j2)) {
                        error.values[i][j2] = 0.0f;
                    }
                    ++i;
                }
                ++j2;
            }
            error.fillHoles(10000, 10000);
            j2 = 0;
            while (j2 < this.ny) {
                i = 0;
                while (i < this.nx) {
                    float[] fArray = gin.values[i];
                    int n = j2;
                    fArray[n] = fArray[n] + error.values[i][j2];
                    ++i;
                }
                ++j2;
            }
        } else {
            this.sampleFillunknown(gin);
        }
    }

    public static float[][] getZlevel() {
        return zlevel;
    }

    public static void setZlevel(float[][] zlevel) {
        Grid.zlevel = zlevel;
    }

    public float getAverage() {
        float sum = 0.0f;
        int n = 0;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.defined(i, j)) {
                    sum += this.values[i][j];
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        return sum / (float)n;
    }
}

