/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.File;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.SmartGrid;

public class GridFunctions {
    public static final double UNDEFINED = (double)-1.2345E37f;
    SmartGrid[] grids = null;
    int[] isgrid = null;
    double[] values = null;

    public String[] initGridOrValue(String[] names, boolean ignore_error) throws Exception {
        String[] s = new String[names.length];
        int nnames = names.length;
        if (this.grids == null) {
            System.out.println("grids should be filled with all available grids");
        }
        if (this.isgrid == null || this.isgrid.length != nnames) {
            this.isgrid = new int[nnames];
            this.values = new double[nnames];
        }
        int i = 0;
        while (i < nnames) {
            block6: {
                try {
                    this.values[i] = Double.parseDouble(names[i]);
                    s[i] = null;
                    this.isgrid[i] = -1;
                }
                catch (Exception e) {
                    this.isgrid[i] = -1;
                    this.isgrid[i] = GridFunctions.gridsIndexOf(this.grids, names[i]);
                    s[i] = null;
                    if (this.isgrid[i] >= 0) break block6;
                    if (!ignore_error) {
                        throw new Exception("GridFunctions   checkGridOrValue  could not find name : " + names[i] + "\n" + " in the list of grid names");
                    }
                    s[i] = names[i];
                }
            }
            ++i;
        }
        return s;
    }

    private static int gridsIndexOf(SmartGrid[] grids, String name) {
        int i = 0;
        while (i < grids.length) {
            if (grids[i].getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double[] getGridOrValue(double x, double y) {
        double ret = 0.1;
        boolean rejectwell = false;
        double[] retval = new double[this.isgrid.length];
        int k = 0;
        while (k < this.isgrid.length) {
            if (!rejectwell) {
                if (this.isgrid[k] < 0) {
                    ret = this.values[k];
                } else {
                    SmartGrid g = this.grids[this.isgrid[k]];
                    ret = g.m_Grid.getValueAtxy((float)x, (float)y);
                    boolean bl = rejectwell = !this.grids[this.isgrid[k]].m_Grid.defined((float)ret);
                    if (rejectwell) {
                        ret = -1.2345E37f;
                    }
                }
            }
            retval[k] = ret;
            ++k;
        }
        return retval;
    }

    private void writeAsciiGrids(SmartGrid grid, String powername) {
        Grid outputgrid = grid.getAsGrid();
        outputgrid.determine_low_high();
        outputgrid.setDataFormat("SURFER");
        outputgrid.setFileName(String.valueOf(powername) + ".grd");
        try {
            outputgrid.write();
            outputgrid.setDataFormat("ARC");
            outputgrid.setFileName(String.valueOf(powername) + ".asc");
            outputgrid.write();
            outputgrid.setDataFormat("ZYCOR");
            outputgrid.setFileName(String.valueOf(powername) + ".dat");
            outputgrid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write_clippedinput(String clippeddir, SmartGrid gclip, SmartGrid active) {
        SmartGrid g = null;
        System.out.println(" number of grids " + this.isgrid.length);
        int k = 0;
        while (k < this.grids.length) {
            g = this.grids[k];
            gclip.unknown = g.m_Grid.unknown;
            int i = 0;
            while (i < gclip.nx) {
                int j = 0;
                while (j < gclip.ny) {
                    float x = gclip.originx + (float)i * gclip.dx;
                    float y = gclip.originy + (float)j * gclip.dy;
                    if (Math.abs(active.values[i][j] - 1.0f) < 0.001f) {
                        float v = g.m_Grid.getValueAtxy(x, y);
                        if (g.m_Grid.defined(v)) {
                            gclip.values[i][j] = g.m_Grid.getValueAtxy(x, y);
                        } else {
                            gclip.values[i][j] = gclip.unknown;
                            System.out.println("WRITE CLIPPED GRIDS UNEXPECTED UNDEFINED VALUE FOR " + g.getName());
                        }
                    } else {
                        gclip.values[i][j] = gclip.unknown;
                    }
                    ++j;
                }
                ++i;
            }
            String fname1 = g.getName();
            File f = new File(fname1);
            String fname = f.getName();
            int ioff = fname.indexOf(".");
            if (ioff > 0) {
                fname = fname.substring(0, ioff);
            }
            this.writeAsciiGrids(gclip, String.valueOf(clippeddir) + "/" + fname);
            ++k;
        }
    }

    public SmartGrid[] getGrids() {
        return this.grids;
    }

    public void setGrids(SmartGrid[] grids) {
        this.grids = grids;
    }
}

