/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import tno.geoenergy.data.Grid;

public class GridTools {
    public static final int NINT = 1000;

    public static String getMinMaxString(Grid inputGrid, float[] xpol, float[] ypol) {
        float[] minmax = new float[]{1.0E38f, -1.0E38f};
        minmax = GridTools.getMinMax(inputGrid, xpol, ypol, minmax);
        return "MIN: " + minmax[0] + "  MAX: " + minmax[1];
    }

    public static float[] getMinMax(Grid inputGrid, float[] xpol, float[] ypol, float[] minmax) {
        int i = 0;
        while (i < xpol.length) {
            int inext = (i + 1) % xpol.length;
            minmax = GridTools.getMinMax(inputGrid, xpol[i], ypol[i], xpol[inext], ypol[inext], minmax);
            ++i;
        }
        return minmax;
    }

    private static float[] getMinMax(Grid inputGrid, float x1, float y1, float x2, float y2, float[] minmax) {
        float dxstep = (x2 - x1) / 999.0f;
        float dystep = (y2 - y1) / 999.0f;
        int i = 0;
        while (i < 1000) {
            float x = x1 + (float)i * dxstep;
            float y = y1 + (float)i * dystep;
            float val = inputGrid.getValueAtxy(x, y);
            if (inputGrid.defined(val)) {
                if (val < minmax[0]) {
                    minmax[0] = val;
                }
                if (val > minmax[1]) {
                    minmax[1] = val;
                }
            }
            ++i;
        }
        return minmax;
    }
}

