/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.Serializable;
import javax.vecmath.Point2f;
import tno.geoenergy.data.Grid;

public class MapRect
implements Serializable {
    private static final long serialVersionUID = 4121132550036074545L;
    Point2f xymin = null;
    Point2f xymax = null;

    public MapRect(float xMin, float yMin, float xMax, float yMax) {
        this.xymin = new Point2f(xMin, yMin);
        this.xymax = new Point2f(xMax, yMax);
    }

    static int getI(float min, float orx, float dx, int nx, int iresx) {
        int i = iresx * Math.round((min - orx) / (dx * (float)iresx));
        if (i < 0) {
            return 0;
        }
        if (i > nx) {
            return iresx * (nx / iresx);
        }
        return i;
    }

    static int getJ(float min, float ory, float dy, int ny, int iresy) {
        int i = iresy * Math.round((min - ory) / (dy * (float)iresy));
        if (i < 0) {
            return 0;
        }
        if (i > ny) {
            return iresy * (ny / iresy);
        }
        return i;
    }

    public void shrink2Grid(Grid grid) {
        int ixMin = 0;
        int iyMin = 0;
        int ixMax = 0;
        int iyMax = 0;
        ixMin = MapRect.getI(this.xymin.x, grid.originx, grid.dx, grid.nx, 1);
        iyMin = MapRect.getJ(this.xymin.y, grid.originy, grid.dy, grid.ny, 1);
        ixMax = MapRect.getI(this.xymax.x, grid.originx, grid.dx, grid.nx, 1);
        iyMax = MapRect.getJ(this.xymax.y, grid.originy, grid.dy, grid.ny, 1);
        this.xymin.x = grid.originx + (float)ixMin * grid.dx;
        this.xymin.y = grid.originy + (float)iyMin * grid.dy;
        this.xymax.x = grid.originx + (float)ixMax * grid.dx;
        this.xymax.y = grid.originy + (float)ixMax * grid.dy;
    }

    public void shrink2Grid(Grid grid, float res) {
        int iresx = Math.round(res / grid.dx);
        int iresy = Math.round(res / grid.dy);
        int ixMin = 0;
        int iyMin = 0;
        int ixMax = 0;
        int iyMax = 0;
        ixMin = MapRect.getI(this.xymin.x, grid.originx, grid.dx, grid.nx, iresx);
        iyMin = MapRect.getJ(this.xymin.y, grid.originy, grid.dy, grid.ny, iresy);
        ixMax = MapRect.getI(this.xymax.x, grid.originx, grid.dx, grid.nx, iresx);
        iyMax = MapRect.getJ(this.xymax.y, grid.originy, grid.dy, grid.ny, iresy);
        this.xymin.x = grid.originx + (float)ixMin * grid.dx;
        this.xymin.y = grid.originy + (float)iyMin * grid.dy;
        this.xymax.x = grid.originx + (float)ixMax * grid.dx;
        this.xymax.y = grid.originy + (float)iyMax * grid.dy;
    }

    public Point2f getXymax() {
        return this.xymax;
    }

    public Point2f getXymin() {
        return this.xymin;
    }

    public void shrink2target(MapRect mr, float res) {
        this.xymin.x = res * (float)Math.round(Math.max(mr.getXymin().x, this.xymin.x) / res);
        this.xymin.y = res * (float)Math.round(Math.max(mr.getXymin().y, this.xymin.y) / res);
        this.xymax.x = res * (float)Math.round(Math.min(mr.getXymax().x, this.xymax.x) / res);
        this.xymax.y = res * (float)Math.round(Math.min(mr.getXymax().y, this.xymax.y) / res);
    }

    public Grid getDefaultGrid(float res) {
        Grid g = new Grid();
        g.dx = res;
        g.dy = res;
        g.nx = Math.round((this.xymax.x - this.xymin.x) / res) + 1;
        g.ny = Math.round((this.xymax.y - this.xymin.y) / res) + 1;
        g.originx = this.xymin.x;
        g.originy = this.xymin.y;
        g.unknown = 1.0E30f;
        g.values = new float[g.nx][g.ny];
        int i = 0;
        while (i < g.nx) {
            int j = 0;
            while (j < g.ny) {
                g.values[i][j] = g.unknown;
                ++j;
            }
            ++i;
        }
        return g;
    }
}

