/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import tno.geoenergy.data.PolygonData;
import tno.geoenergy.util.ByteBufferHelper;

public class PolygonCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    PolygonData[] pd = null;
    static String[] names = new String[]{"test_vergunningen"};

    public PolygonData[] getPd() {
        return this.pd;
    }

    PolygonCollection(File file, boolean binary, CoordSystem cs) {
        if (binary) {
            this.getBinary(file);
        }
    }

    public PolygonCollection(File f, float xminBox, float xmaxBox, float yminBox, float ymaxBox) {
        this.getBinary(f, xminBox, xmaxBox, yminBox, ymaxBox);
    }

    public void getBinary(File f) {
        block22: {
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    int filesize = (int)((FileChannel)channel).size();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    this.pd = new PolygonData[n];
                    String[] names = new String[n];
                    int i = 0;
                    while (i < n) {
                        float xmin = buffer.getFloat();
                        float ymin = buffer.getFloat();
                        float xmax = buffer.getFloat();
                        float ymax = buffer.getFloat();
                        names[i] = buffer.getString();
                        ++i;
                    }
                    i = 0;
                    while (i < n) {
                        this.pd[i] = PolygonData.read(buffer, names[i], true);
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block22;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void getBinary(File f, float xminBox, float xmaxBox, float yminBox, float ymaxBox) {
        block24: {
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int n = buffer.getInt();
                    PolygonData[] pdBuf = new PolygonData[n];
                    names = new String[n];
                    boolean[] add = new boolean[n];
                    int i = 0;
                    while (i < n) {
                        float xmin = buffer.getFloat();
                        float ymin = buffer.getFloat();
                        float xmax = buffer.getFloat();
                        float ymax = buffer.getFloat();
                        add[i] = PolygonData.inBox(xmin, xmax, ymin, ymax, xminBox, xmaxBox, yminBox, ymaxBox);
                        PolygonCollection.names[i] = buffer.getString();
                        ++i;
                    }
                    i = 0;
                    while (i < n) {
                        pdBuf[i] = PolygonData.read(buffer, names[i], add[i]);
                        ++i;
                    }
                    ArrayList<PolygonData> pdList = new ArrayList<PolygonData>();
                    int i2 = 0;
                    while (i2 < n) {
                        if (add[i2]) {
                            pdList.add(pdBuf[i2]);
                        }
                        ++i2;
                    }
                    this.pd = pdList.toArray(new PolygonData[pdList.size()]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block24;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void writeBin(String modelname) throws IOException {
        File output = new File(modelname);
        FileOutputStream outputStream = new FileOutputStream(output);
        FileChannel channel = outputStream.getChannel();
        ByteBufferHelper buffer = new ByteBufferHelper(channel);
        buffer.flipwrite();
        buffer.putInt(this.pd.length);
        int i = 0;
        while (i < this.pd.length) {
            this.pd[i].writeHeader(buffer);
            ++i;
        }
        i = 0;
        while (i < this.pd.length) {
            this.pd[i].writeBody(buffer);
            ++i;
        }
        buffer.flipwrite();
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String rundrive = "C:\\modeldata\\vectormaps_kml\\";
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            File file = new File(String.valueOf(rundrive) + name + ".xml");
            System.out.println("processing:" + file.getPath());
            PolygonCollection pcutm = new PolygonCollection(file, false, CoordSystem.UTM);
            PolygonCollection pcrd = new PolygonCollection(file, false, CoordSystem.RD);
            PolygonCollection pcWebM = new PolygonCollection(file, false, CoordSystem.WEB_MERC);
            String binnameutm = "C:\\modeldata\\xml\\bin2\\UTM31N\\" + name + ".bis";
            String binnamerd = "C:\\modeldata\\xml\\bin2\\rd\\" + name + ".bis";
            String binnameWebMerc = "C:\\modeldata\\xml\\bin2\\wm\\" + name + ".bis";
            try {
                System.out.println("writing:" + binnameutm);
                pcutm.writeBin(binnameutm);
                pcrd.writeBin(binnamerd);
                pcWebM.writeBin(binnameWebMerc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PolygonCollection polygonCollection = new PolygonCollection(new File(binnameutm), true, CoordSystem.UTM);
            ++i;
        }
        System.out.println("====ready===");
    }

    public static enum CoordSystem {
        UTM,
        RD,
        WEB_MERC;

    }
}

