/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.data;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import tno.geoenergy.projection.UTM2RD;
import tno.geoenergy.util.ByteBufferHelper;

public class PolygonData
implements Serializable {
    private static final long serialVersionUID = 1L;
    int ncoor = 0;
    float[] xcoor = null;
    float[] ycoor = null;
    float[] zcoor = null;
    Color lineColor = Color.BLACK;
    int lineWidth;
    Color fillColor = Color.BLACK;
    float xmin = 1.0E30f;
    float xmax = -1.0E30f;
    float ymin = 1.0E30f;
    float ymax = -1.0E30f;
    int filepos;
    static int nerror = 0;
    public String name = null;

    public PolygonData(float[] xcoor, float[] ycoor, float[] zcoor, Color lineColor, int lineWidth, Color fillColor, String name) {
        this.xcoor = xcoor;
        this.ycoor = ycoor;
        this.zcoor = zcoor;
        this.name = name;
        this.ncoor = xcoor.length;
        this.lineColor = lineColor;
        this.fillColor = fillColor;
        this.lineWidth = lineWidth;
        this.determineBoundingbox();
    }

    public PolygonData(float[] xcoor, float[] ycoor, String name) {
        this.xcoor = xcoor;
        this.ycoor = ycoor;
        this.name = name;
        this.ncoor = xcoor.length;
        this.determineBoundingbox();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        if (this.fillColor == Color.BLACK) {
            return null;
        }
        return this.fillColor;
    }

    public void determineBoundingbox() {
        int i = 0;
        while (i < this.ncoor) {
            if (this.xcoor[i] > this.xmax) {
                this.xmax = this.xcoor[i];
            }
            if (this.xcoor[i] < this.xmin) {
                this.xmin = this.xcoor[i];
            }
            if (this.ycoor[i] > this.ymax) {
                this.ymax = this.ycoor[i];
            }
            if (this.ycoor[i] < this.ymin) {
                this.ymin = this.ycoor[i];
            }
            ++i;
        }
    }

    public boolean inBox(float xminbox, float xmaxbox, float yminbox, float ymaxbox) {
        boolean ok = true;
        if (this.xmax < xminbox) {
            ok = false;
        }
        if (this.xmin > xmaxbox) {
            ok = false;
        }
        if (this.ymax < yminbox) {
            ok = false;
        }
        if (this.ymin > ymaxbox) {
            ok = false;
        }
        return ok;
    }

    public static PolygonData read(ByteBufferHelper buffer, String name, boolean read) throws IOException {
        PolygonData pd = null;
        int ncoor = buffer.getInt();
        if (read) {
            Color lc = new Color(buffer.getInt());
            int lstyle = buffer.getInt();
            int rgb = buffer.getInt();
            Color c = new Color(rgb);
            Color fill = new Color(c.getRed(), c.getGreen(), c.getBlue(), buffer.getInt());
            float[] x = new float[ncoor];
            float[] y = new float[ncoor];
            int i = 0;
            while (i < ncoor) {
                x[i] = buffer.getFloat();
                y[i] = buffer.getFloat();
                ++i;
            }
            pd = new PolygonData(x, y, y, lc, lstyle, fill, name);
        } else {
            buffer.skipInt(4);
            buffer.skipFloat(ncoor * 2);
        }
        return pd;
    }

    public void writeHeader(ByteBufferHelper buffer) throws IOException {
        buffer.putFloat(this.xmin);
        buffer.putFloat(this.ymin);
        buffer.putFloat(this.xmax);
        buffer.putFloat(this.ymax);
        try {
            buffer.putString(this.name);
        }
        catch (BufferOverflowException e) {
            e.printStackTrace();
            System.out.println("name: " + this.name + " " + ++nerror);
        }
    }

    public void writeBody(ByteBufferHelper buffer) throws IOException {
        buffer.putInt(this.ncoor);
        int rgb = this.lineColor.getRGB();
        buffer.putInt(rgb);
        buffer.putInt(this.lineWidth);
        rgb = this.fillColor.getRGB();
        buffer.putInt(rgb);
        int a = this.fillColor.getAlpha();
        buffer.putInt(a);
        int i = 0;
        while (i < this.ncoor) {
            buffer.putFloat(this.xcoor[i]);
            buffer.putFloat(this.ycoor[i]);
            ++i;
        }
    }

    public static boolean inBox(float xmin, float xmax, float ymin, float ymax, float xminBox, float xmaxBox, float yminBox, float ymaxBox) {
        boolean ok = true;
        if (xmax < xminBox) {
            ok = false;
        }
        if (xmin > xmaxBox) {
            ok = false;
        }
        if (ymax < yminBox) {
            ok = false;
        }
        if (ymin > ymaxBox) {
            ok = false;
        }
        return ok;
    }

    public void convertLL2UTM() {
        int i = 0;
        while (i < this.ncoor) {
            double[] utm = UTM2RD.convertLatLong2UTM(this.ycoor[i], this.xcoor[i]);
            this.xcoor[i] = (float)utm[0];
            this.ycoor[i] = (float)utm[1];
            ++i;
        }
    }

    public void convertLL2RD() {
        int i = 0;
        while (i < this.ncoor) {
            double[] utm = UTM2RD.convertLatLong2UTM(this.ycoor[i], this.xcoor[i]);
            double[] rd = UTM2RD.convert2RD(utm[0], utm[1]);
            this.xcoor[i] = (float)rd[0];
            this.ycoor[i] = (float)rd[1];
            ++i;
        }
    }

    public void convertLL2WebMercator() {
        double[] xc = new double[this.ncoor];
        double[] yc = new double[this.ncoor];
        int i = 0;
        while (i < this.ncoor) {
            xc[i] = this.xcoor[i];
            yc[i] = this.ycoor[i];
            ++i;
        }
    }

    public float[] getXcoor() {
        return this.xcoor;
    }

    public float[] getYcoor() {
        return this.ycoor;
    }

    public String getName() {
        return this.name;
    }
}

